/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ivb.log.ui;

import com.ibm.ivb.jface.Action;
import com.ibm.ivb.jface.BrowserFrame;
import com.ibm.ivb.jface.Tool;
import com.ibm.ivb.jface.parts.StatusLine;
import com.ibm.ivb.log.tree.Node;
import com.ibm.ivb.log.ui.LBUtilities;
import com.ibm.ivb.log.ui.LogChooser;
import com.sun.java.swing.JFrame;
import java.awt.Cursor;
import java.util.Vector;

public abstract class AbstractSaveAction
extends Action {
    private static final String kCBIBMCopyright = "\n\nLicensed Materials - Property of IBM\n5639-D57\n(c) Copyright IBM Corp. 1998. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    protected boolean singleSelection = true;

    protected AbstractSaveAction(Tool tool) {
        this.setTool(tool);
    }

    public synchronized void run() {
        boolean bl = false;
        String string = this.getTargetFile();
        BrowserFrame browserFrame = this.getBrowserFrame();
        browserFrame.setCursor(Cursor.getPredefinedCursor(3));
        StatusLine statusLine = browserFrame.getStatusLine();
        statusLine.startBusyIndicator();
        if (string != null) {
            if (this.singleSelection) {
                Node node = this.getTargetNode();
                if (node != null) {
                    bl = LBUtilities.saveToFile(string, node, (JFrame)browserFrame);
                }
            } else {
                Vector vector = this.getTargetNodes();
                if (vector != null) {
                    bl = vector.size() == 1 ? LBUtilities.saveToFile(string, (Node)vector.elementAt(0), (JFrame)browserFrame) : LBUtilities.saveToFile(string, vector, (JFrame)browserFrame);
                }
            }
        }
        if (!bl) {
            this.fixProblems();
        } else {
            this.completeAction(string);
        }
        statusLine.stopBusyIndicator();
        browserFrame.setCursor(Cursor.getDefaultCursor());
    }

    protected String getTargetFile() {
        return LogChooser.getSaveTargetFile((JFrame)this.getBrowserFrame());
    }

    protected abstract Node getTargetNode();

    protected abstract Vector getTargetNodes();

    protected void fixProblems() {
    }

    protected void completeAction(String string) {
    }

    private BrowserFrame getBrowserFrame() {
        return this.getTool().getParentFrame();
    }
}

