/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ivb.log.ui;

import com.ibm.ivb.jface.Application;
import com.ibm.ivb.log.ui.LogBrowser;
import com.ibm.ivb.log.ui.TranslatableConstants;
import com.ibm.ivb.log.ui.UIConstants;
import com.ibm.ivb.log.ui.util.PropertyHelper;
import com.sun.java.swing.JCheckBox;
import com.sun.java.swing.JFrame;
import com.sun.java.swing.JLabel;
import com.sun.java.swing.JPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.util.Properties;

public class AnalyzerOutputPreference
extends JPanel
implements UIConstants,
TranslatableConstants {
    private static final String kCBIBMCopyright = "(c) Copyright IBM Corporation 1998";
    private JCheckBox symWrap;
    private JCheckBox orbWrap;
    private JCheckBox gpfWrap;
    private JLabel wrapTitle;
    private boolean wrap = false;

    public AnalyzerOutputPreference() {
        super((LayoutManager)new GridBagLayout(), true);
        Application application = LogBrowser.getLBApplication();
        this.symWrap = new JCheckBox(application.getString("ComIbmIvbLogUiSettingSymLineWrap"));
        this.orbWrap = new JCheckBox(application.getString("ComIbmIvbLogUiSettingOrbLineWrap"));
        this.gpfWrap = new JCheckBox(application.getString("ComIbmIvbLogUiSettingGpfLineWrap"));
        this.symWrap.setSelected(AnalyzerOutputPreference.isWrapEnabledSym());
        this.orbWrap.setSelected(AnalyzerOutputPreference.isWrapEnabledOrb());
        this.gpfWrap.setSelected(AnalyzerOutputPreference.isWrapEnabledGpf());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        ((Container)((Object)this)).add((Component)this.symWrap, gridBagConstraints);
        ++gridBagConstraints.gridy;
        ((Container)((Object)this)).add((Component)this.orbWrap, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 1.0;
        ((Container)((Object)this)).add((Component)this.gpfWrap, gridBagConstraints);
    }

    public void displaySettings() {
        this.symWrap.setSelected(AnalyzerOutputPreference.isWrapEnabledSym());
        this.orbWrap.setSelected(AnalyzerOutputPreference.isWrapEnabledOrb());
        this.gpfWrap.setSelected(AnalyzerOutputPreference.isWrapEnabledGpf());
    }

    public void saveSettings() {
        Properties properties = LogBrowser.getLBProperties();
        PropertyHelper.setPropertyValue(properties, "LBPreferenceSymptomDataLineWrap", this.symWrap.isSelected());
        PropertyHelper.setPropertyValue(properties, "LBPreferenceOrbTraceDataLineWrap", this.orbWrap.isSelected());
        PropertyHelper.setPropertyValue(properties, "LBPreferenceGpfDataLineWrap", this.gpfWrap.isSelected());
    }

    public static boolean isWrapEnabledSym() {
        Properties properties = LogBrowser.getLBProperties();
        boolean bl = PropertyHelper.hasProperty(properties, "LBPreferenceSymptomDataLineWrap") ? PropertyHelper.getPropertyBoolean(properties, "LBPreferenceSymptomDataLineWrap") : true;
        return bl;
    }

    public static boolean isWrapEnabledOrb() {
        Properties properties = LogBrowser.getLBProperties();
        boolean bl = PropertyHelper.hasProperty(properties, "LBPreferenceOrbTraceDataLineWrap") ? PropertyHelper.getPropertyBoolean(properties, "LBPreferenceOrbTraceDataLineWrap") : true;
        return bl;
    }

    public static boolean isWrapEnabledGpf() {
        Properties properties = LogBrowser.getLBProperties();
        boolean bl = PropertyHelper.hasProperty(properties, "LBPreferenceGpfDataLineWrap") ? PropertyHelper.getPropertyBoolean(properties, "LBPreferenceGpfDataLineWrap") : true;
        return bl;
    }

    public static void main(String[] stringArray) {
        AnalyzerOutputPreference analyzerOutputPreference = new AnalyzerOutputPreference();
        analyzerOutputPreference.displaySettings();
        JFrame jFrame = new JFrame();
        jFrame.getContentPane().add((Component)((Object)analyzerOutputPreference));
        jFrame.pack();
        jFrame.show();
    }
}

