/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ivb.log.ui;

import com.ibm.ivb.jface.LinkEvent;
import com.ibm.ivb.jface.MenuContribution;
import com.ibm.ivb.jface.MenuData;
import com.ibm.ivb.jface.Tool;
import com.ibm.ivb.jface.ToolBarContribution;
import com.ibm.ivb.log.ui.EditMenu;
import com.ibm.ivb.log.ui.LogBrowser;
import com.ibm.ivb.log.ui.RecordMenu;
import com.ibm.ivb.log.ui.TranslatableConstants;
import com.ibm.ivb.log.ui.events.FocusEvent;
import com.ibm.ivb.log.ui.events.RefreshEditMenuEvent;
import com.ibm.ivb.log.ui.events.RefreshRecordMenuEvent;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Hashtable;

public class LBController
extends Tool
implements TranslatableConstants {
    private static final String kCBIBMCopyright = "\n\nLicensed Materials - Property of IBM\n5639-D57\n(c) Copyright IBM Corp. 1998. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private Hashtable eventTypes = new Hashtable();
    private RecordMenu record;
    private EditMenu edit;

    public LBController() {
        this.setSynchronousDispatch(true);
        this.record = new RecordMenu();
        this.edit = new EditMenu();
    }

    public MenuContribution getMenuContribution() {
        MenuContribution menuContribution = new MenuContribution((Tool)this);
        this.record.addMenuBarContribution(this.getParentContext());
        menuContribution.add((MenuData)this.record);
        this.edit.addMenuBarContribution(this.getParentContext());
        menuContribution.add((MenuData)this.edit);
        return menuContribution;
    }

    public ToolBarContribution getToolBarContribution() {
        ToolBarContribution toolBarContribution = new ToolBarContribution((Tool)this);
        toolBarContribution.setBorderStyle(2);
        this.record.getToolBarContribution(toolBarContribution, this.getParentContext());
        this.edit.getToolBarContribution(toolBarContribution, this.getParentContext());
        return toolBarContribution;
    }

    public void toolActive() {
        this.setName(LogBrowser.getLBString("ComIbmIvbLogUiCtrlGeneral"));
        super.toolActive();
    }

    public void handleLinkEvent(LinkEvent linkEvent) {
        if (linkEvent instanceof FocusEvent) {
            Tool tool = ((FocusEvent)linkEvent).getFocusedTool();
            this.record.enableActions(tool);
            this.edit.enableActions(tool);
            return;
        }
        if (linkEvent instanceof RefreshRecordMenuEvent) {
            Tool tool = (Tool)((EventObject)((Object)((RefreshRecordMenuEvent)linkEvent))).getSource();
            this.record.enableActions(tool);
            return;
        }
        if (linkEvent instanceof RefreshEditMenuEvent) {
            Tool tool = (Tool)((EventObject)((Object)((RefreshEditMenuEvent)linkEvent))).getSource();
            this.edit.enableActions(tool);
            return;
        }
        String string = linkEvent.getClass().getName();
        if (this.eventTypes.get(string) == null) {
            this.eventTypes.put(string, string);
            this.rebuildLinks();
        }
        this.fireLinkEvent(linkEvent);
    }

    public String[] getLinkEventNames() {
        if (this.eventTypes.size() == 0) {
            return null;
        }
        String[] stringArray = new String[this.eventTypes.size()];
        int n = 0;
        Enumeration enumeration = this.eventTypes.keys();
        while (enumeration.hasMoreElements()) {
            stringArray[n++] = (String)enumeration.nextElement();
        }
        return stringArray;
    }
}

