/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ivb.log.ui;

import com.ibm.ivb.jface.AbstractApplication;
import com.ibm.ivb.jface.Application;
import com.ibm.ivb.jface.BrowserFrame;
import com.ibm.ivb.jface.HelpHandler;
import com.ibm.ivb.jface.LinkEvent;
import com.ibm.ivb.jface.PaneFrame;
import com.ibm.ivb.jface.parts.SplashScreen;
import com.ibm.ivb.jface.parts.StatusLine;
import com.ibm.ivb.jface.util.ImageUtil;
import com.ibm.ivb.log.AnaFile;
import com.ibm.ivb.log.Analyzer;
import com.ibm.ivb.log.AppModel;
import com.ibm.ivb.log.constants.LBConstants;
import com.ibm.ivb.log.datamodel.AnaFileMetadata;
import com.ibm.ivb.log.datamodel.AnaRecMetadata;
import com.ibm.ivb.log.tree.LogTreeModel;
import com.ibm.ivb.log.ui.HTMLHelpHandler;
import com.ibm.ivb.log.ui.LBUtilities;
import com.ibm.ivb.log.ui.OpenLogAction;
import com.ibm.ivb.log.ui.TranslatableConstants;
import com.ibm.ivb.log.ui.UIConstants;
import com.ibm.ivb.log.ui.events.InitiationEvent;
import com.sun.java.swing.JFrame;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Hashtable;
import java.util.Properties;

public class LogBrowser
implements LBConstants,
UIConstants,
TranslatableConstants,
AbstractApplication {
    private static final String kCBIBMCopyright = "\n\nLicensed Materials - Property of IBM\n5639-D57\n(c) Copyright IBM Corp. 1998. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static String _appKey = "com.ibm.ivb.log.LogBrowser";
    private static Application _app = Application.getApplication((String)_appKey);
    static SplashScreen splashScreen;
    static /* synthetic */ Class class$com$ibm$ivb$log$ui$LogBrowser;

    public void setApplicationKey(String string) {
        _appKey = string;
        _app = Application.getApplication((String)_appKey);
    }

    public String getApplicationKey() {
        return _appKey;
    }

    public Application getApplication() {
        return Application.getApplication((String)_appKey);
    }

    public BrowserFrame createApplicationFrame() {
        PaneFrame paneFrame = new PaneFrame(this.getApplication().getString("ComIbmIvbLogUiTitleLogBrowser"));
        paneFrame.setApplicationKey(this.getApplicationKey());
        boolean bl = false;
        LogBrowser.showSplashScreen(true, null);
        bl = true;
        this.initializeData();
        paneFrame.removePredefinedMenu("MPage");
        paneFrame.removePredefinedMenu("MSelected");
        paneFrame.removePredefinedMenuItem("MiClose");
        paneFrame.buildPanesForPage("LogBrowser");
        paneFrame.buildMenuBar();
        paneFrame.buildToolBar();
        paneFrame.buildStatusLine();
        paneFrame.setIconImage(LBUtilities.loadImage("images/desktop.gif"));
        paneFrame.getStatusLine().setStatusIcon(StatusLine.okIcon);
        if (bl) {
            LogBrowser.showSplashScreen(false, (JFrame)paneFrame);
        }
        paneFrame.addWindowListener(new WindowHandler((BrowserFrame)paneFrame));
        return paneFrame;
    }

    public LogBrowser(String[] stringArray) {
    }

    public static Application getLBApplication() {
        return Application.getApplication((String)_appKey);
    }

    public static String getLBString(String string) {
        return Application.getApplication((String)_appKey).getString(string);
    }

    public static Properties getLBProperties() {
        return Application.getApplication((String)_appKey).getProfile();
    }

    private static Analyzer.Factory[] initializeAnalyzers(Hashtable hashtable, Hashtable hashtable2) {
        try {
            Object object;
            AnaRecMetadata anaRecMetadata;
            String string = System.getProperty("IVB_DRIVER_PATH");
            String string2 = null;
            string2 = string == null ? "analyzers.xml" : String.valueOf(string) + "/bin/analyzers.xml";
            AnaFile anaFile = new AnaFile(string2);
            AnaFileMetadata anaFileMetadata = anaFile.getAnaFileMetadata();
            Analyzer.Factory[] factoryArray = new Analyzer.Factory[anaFileMetadata.getAnaRecv().size()];
            int n = 0;
            while (n < anaFileMetadata.getAnaRecv().size()) {
                anaRecMetadata = (AnaRecMetadata)anaFileMetadata.getAnaRecv().elementAt(n);
                try {
                    Analyzer.Factory factory;
                    factoryArray[n] = factory = (Analyzer.Factory)Class.forName(anaRecMetadata.getFactoryClass()).newInstance();
                    factory.setAnalyzerName(anaRecMetadata.getAnalyzerName());
                    object = factory.make();
                    hashtable.put(anaRecMetadata.getAnalyzerName(), object);
                }
                catch (Exception exception) {
                    System.out.println("InitializeAnalyzers: Could not load analyzer factory class:" + anaRecMetadata.getFactoryClass());
                    System.out.flush();
                }
                ++n;
            }
            int n2 = 0;
            while (n2 < anaFileMetadata.getAdvAnaRecv().size()) {
                anaRecMetadata = (AnaRecMetadata)anaFileMetadata.getAdvAnaRecv().elementAt(n2);
                try {
                    object = (Analyzer.Factory)Class.forName(anaRecMetadata.getFactoryClass()).newInstance();
                    object.setAnalyzerName(anaRecMetadata.getAnalyzerName());
                    Analyzer analyzer = object.make();
                    hashtable2.put(anaRecMetadata.getAnalyzerName(), analyzer);
                }
                catch (Exception exception) {
                    System.out.println("InitializeAnalyzers: Could not load analyzer factory class:" + anaRecMetadata.getFactoryClass());
                    System.out.flush();
                }
                ++n2;
            }
            return factoryArray;
        }
        catch (IOException iOException) {
            System.out.println("Cannot load analyzers");
            System.out.flush();
            return null;
        }
    }

    private static void showSplashScreen(boolean bl, JFrame jFrame) {
        if (!bl) {
            splashScreen.setVisible(false);
            splashScreen.dispose();
            splashScreen = null;
            return;
        }
        splashScreen = new SplashScreen((Frame)jFrame);
        splashScreen.setIcon(ImageUtil.loadIcon((Class)(class$com$ibm$ivb$log$ui$LogBrowser != null ? class$com$ibm$ivb$log$ui$LogBrowser : (class$com$ibm$ivb$log$ui$LogBrowser = LogBrowser.class$("com.ibm.ivb.log.ui.LogBrowser"))), (String)"images/splash.gif"));
        splashScreen.setWaitCursor(true);
        splashScreen.setVisible(true);
    }

    private void initializeData() {
        String string;
        String string2;
        String string3;
        Application application = this.getApplication();
        application.setConfigurationVisible(false);
        application.setLAFSelectionVisible(true);
        String string4 = System.getProperty("TimeStampFormat", "M/d/yy H:mm:ss.");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string4);
        AppModel.setTimeStampFormat(simpleDateFormat);
        String string5 = System.getProperty("IVB_DRIVER_PATH");
        if (string5 != null) {
            AppModel.setAppHome(new String(string5));
        }
        if ((string3 = System.getProperty("VABHELP")) != null) {
            AppModel.setVabHelp(new String(string3));
        }
        if ((string2 = System.getProperty("TEMP")) != null) {
            AppModel.setTempDir(new String(string2));
        }
        if ((string = System.getProperty("CURRDIR")) != null) {
            AppModel.setCurrDir(new String(string));
        }
        HTMLHelpHandler hTMLHelpHandler = new HTMLHelpHandler();
        application.setHelpHandler((HelpHandler)hTMLHelpHandler);
        hTMLHelpHandler.setBaseName(LBUtilities.getHelpDirectory());
        hTMLHelpHandler.setHelpFileName("ivblogbrhlp");
    }

    private void frameInitializer(String[] stringArray, BrowserFrame browserFrame) {
        FrameInitializer frameInitializer = new FrameInitializer(stringArray, browserFrame);
        frameInitializer.start();
    }

    public static void main(String[] stringArray) {
        LogBrowser logBrowser = new LogBrowser(stringArray);
        BrowserFrame browserFrame = logBrowser.createApplicationFrame();
        browserFrame.activateAll();
        browserFrame.show();
        logBrowser.frameInitializer(stringArray, browserFrame);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        _app.setResourceFileName("ivblogbr");
        _app.setDefaultConfigFileName("ivblogbrsys");
        _app.setWorkingConfigFileName("ivblogbr");
        _app.setHome(LBConstants.LB_HOME);
        _app.setProfileName("ivblogbr.ini");
        _app.setProtectedHome(LBConstants.LB_SYS_HOME);
        _app.setSystemProfileName("ivblogbrsys.ini");
        _app.initialize();
    }

    class WindowHandler
    extends WindowAdapter
    implements Runnable {
        BrowserFrame frame;

        public WindowHandler(BrowserFrame browserFrame) {
            LogBrowser.this = LogBrowser.this;
            this.frame = browserFrame;
        }

        public void windowOpened(WindowEvent windowEvent) {
            Thread thread = new Thread(this);
            thread.start();
        }

        public synchronized void run() {
            this.frame.activateAll();
        }
    }

    class FrameInitializer
    extends Thread {
        private BrowserFrame frame;
        private String[] args;

        FrameInitializer(String[] stringArray, BrowserFrame browserFrame) {
            LogBrowser.this = LogBrowser.this;
            this.frame = browserFrame;
            this.args = stringArray;
        }

        public synchronized void run() {
            Hashtable hashtable = new Hashtable();
            Hashtable hashtable2 = new Hashtable();
            LogBrowser.initializeAnalyzers(hashtable, hashtable2);
            if (this.args != null && this.args.length > 0) {
                AppModel.setCurrLogFileName(this.args[0]);
            }
            OpenLogAction openLogAction = new OpenLogAction(this.frame, this.args);
            openLogAction.run();
            LogTreeModel logTreeModel = openLogAction.getModel();
            LogTreeModel.setAnalyzers(hashtable);
            LogTreeModel.setAdvanceAnalyzers(hashtable2);
            this.frame.fireLinkEvent((LinkEvent)new InitiationEvent(this.frame, logTreeModel));
        }
    }
}

