/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ivb.log.ui;

import com.ibm.ivb.jface.BrowserFrame;
import com.ibm.ivb.jface.LinkEvent;
import com.ibm.ivb.log.tree.LogTreeModel;
import com.ibm.ivb.log.tree.Node;
import com.ibm.ivb.log.ui.AdvAnalyzeSelectedAction;
import com.ibm.ivb.log.ui.AnalyzeSelectedAction;
import com.ibm.ivb.log.ui.FindAndReplaceDialog;
import com.ibm.ivb.log.ui.LBUtilities;
import com.ibm.ivb.log.ui.LogTree;
import com.ibm.ivb.log.ui.LogTreeCellRenderer;
import com.ibm.ivb.log.ui.SaveSelectedAction;
import com.ibm.ivb.log.ui.SearchableInformation;
import com.ibm.ivb.log.ui.TranslatableConstants;
import com.ibm.ivb.log.ui.events.TreeSelectionChangeEvent;
import com.ibm.ivb.log.ui.util.FindAndReplace;
import com.sun.java.swing.Action;
import com.sun.java.swing.JFrame;
import com.sun.java.swing.JPopupMenu;
import com.sun.java.swing.JScrollPane;
import com.sun.java.swing.JSeparator;
import com.sun.java.swing.JTree;
import com.sun.java.swing.SwingUtilities;
import com.sun.java.swing.event.TreeExpansionEvent;
import com.sun.java.swing.event.TreeExpansionListener;
import com.sun.java.swing.event.TreeSelectionEvent;
import com.sun.java.swing.event.TreeSelectionListener;
import com.sun.java.swing.tree.TreeCellRenderer;
import com.sun.java.swing.tree.TreeModel;
import com.sun.java.swing.tree.TreePath;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

public class LogTree
extends JScrollPane
implements SearchableInformation,
TranslatableConstants {
    private static final String kCBIBMCopyright = "\n\nLicensed Materials - Property of IBM\n5639-D57\n(c) Copyright IBM Corp. 1998. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private JTree tree = new JTree(null);
    private Node[] allNodes;
    private JPopupMenu popup;
    private static AnalyzeSelectedAction actAnalyze;
    private static AdvAnalyzeSelectedAction actAdvAnalyze;
    private static SaveSelectedAction actSave;

    public LogTree() {
        super(20, 30);
        this.tree.setCellRenderer((TreeCellRenderer)new LogTreeCellRenderer());
        this.getViewport().add((Component)this.tree);
        this.tree.addTreeSelectionListener((TreeSelectionListener)new TreeSelectionMonitor());
        this.tree.addMouseListener(new MouseMonitor());
        this.tree.addTreeExpansionListener((TreeExpansionListener)new TreeExpansionMonitor());
        this.tree.setRowHeight(18);
    }

    public JTree getJTree() {
        return this.tree;
    }

    public LogTreeModel getTreeModel() {
        return (LogTreeModel)this.tree.getModel();
    }

    public void resetTreeModel(LogTreeModel logTreeModel) {
        this.tree.setModel((TreeModel)logTreeModel);
        this.allNodes = null;
    }

    public boolean hasUnsavedChange() {
        return this.tree.getModel().getChildCount(this.tree.getModel().getRoot()) > 0;
    }

    public Node[] getSelectedNodes() {
        TreePath[] treePathArray = this.tree.getSelectionPaths();
        if (treePathArray != null) {
            Node[] nodeArray = new Node[treePathArray.length];
            int n = 0;
            while (n < treePathArray.length) {
                nodeArray[n] = (Node)treePathArray[n].getLastPathComponent();
                ++n;
            }
            return nodeArray;
        }
        return null;
    }

    public boolean isEditable() {
        return false;
    }

    public boolean hasSelection() {
        return !this.tree.isSelectionEmpty();
    }

    public String getSelection() {
        return this.tree.getSelectionPath().getLastPathComponent().toString();
    }

    public int search(String string, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        Object[] objectArray = this.getPreorderTreeNodes();
        return FindAndReplace.find(objectArray, string, n, bl, bl2, bl3, bl4);
    }

    public void processSearchResult(int n, String string) {
        if (n == -1) {
            FindAndReplaceDialog.handleNoMatch((Component)this.tree);
            return;
        }
        this.processSuccessfulSearch(n);
    }

    public int getSearchStart(boolean bl) {
        if (this.hasSelection()) {
            int n = this.nodeIndexInPreorderedArray((Node)this.tree.getSelectionPath().getLastPathComponent());
            if (bl) {
                return n + 1;
            }
            return n - 1;
        }
        return 0;
    }

    public int getReplaceStart() {
        return 0;
    }

    public void processRepeatSearchResult(int n, String string) {
        if (n == -1) {
            FindAndReplaceDialog.handleNoMatch();
            return;
        }
        this.processSuccessfulSearch(n);
    }

    public void searchAndReplace(String string, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4, String string2) {
    }

    public void processReplace(int n, int n2, String string) {
    }

    private int getTotalNumberOfDescendants(Node node) {
        int n;
        int n2 = n = node.getChildCount();
        int n3 = 0;
        while (n3 < n) {
            n2 += this.getTotalNumberOfDescendants(node.getChild(n3));
            ++n3;
        }
        return n2;
    }

    private Node[] fillNodeArray(Node[] nodeArray, Node node) {
        int n = 0;
        while (nodeArray[n] != null) {
            ++n;
        }
        nodeArray[n++] = node;
        int n2 = node.getChildCount();
        int n3 = 0;
        while (n3 < n2) {
            nodeArray = this.fillNodeArray(nodeArray, node.getChild(n3));
            ++n3;
        }
        return nodeArray;
    }

    private Node[] getPreorderTreeNodes() {
        if (this.allNodes == null) {
            Node node = (Node)this.tree.getModel().getRoot();
            Node[] nodeArray = new Node[1 + this.getTotalNumberOfDescendants(node)];
            this.allNodes = this.fillNodeArray(nodeArray, node);
        }
        return this.allNodes;
    }

    private int nodeIndexInPreorderedArray(Node node) {
        if (node == null) {
            return 0;
        }
        Node[] nodeArray = this.getPreorderTreeNodes();
        int n = 0;
        while (!node.equals(nodeArray[n])) {
            ++n;
        }
        return n;
    }

    private void processSuccessfulSearch(int n) {
        int n2 = this.convertIndexToRow(n);
        this.tree.setSelectionRow(n2);
        this.tree.scrollRowToVisible(n2);
    }

    private int convertIndexToRow(int n) {
        int n2 = -1;
        int n3 = 0;
        Node node = null;
        int n4 = 0;
        while (n3 < n) {
            if (this.tree.isExpanded(++n2)) {
                ++n3;
                continue;
            }
            node = (Node)this.tree.getPathForRow(n2).getLastPathComponent();
            n4 = this.getTotalNumberOfDescendants(node);
            n3 += n4 + 1;
        }
        if (n3 > n) {
            this.tree.expandRow(n2);
            n3 -= n4;
            while (n3 < n) {
                if (++n2 < this.tree.getRowCount() && !this.tree.isExpanded(n2)) {
                    node = (Node)this.tree.getPathForRow(n2).getLastPathComponent();
                    n4 = this.getTotalNumberOfDescendants(node);
                    if (n3 + n4 + 1 > n) {
                        this.tree.expandRow(n2);
                        ++n3;
                        continue;
                    }
                    n3 += n4 + 1;
                    continue;
                }
                ++n3;
            }
            ++n2;
        } else {
            ++n2;
        }
        return n2;
    }

    private boolean handlePopup(JPopupMenu jPopupMenu) {
        this.createPopupActions();
        jPopupMenu.add((Action)actAnalyze);
        jPopupMenu.add((Action)actAdvAnalyze);
        jPopupMenu.add((Component)new JSeparator());
        jPopupMenu.add((Action)actSave);
        return true;
    }

    private void createPopupActions() {
        Node[] nodeArray = this.getSelectedNodes();
        actAnalyze = new AnalyzeSelectedAction((Component)this.tree, nodeArray);
        actAdvAnalyze = new AdvAnalyzeSelectedAction((Component)this.tree, nodeArray);
        actSave = new SaveSelectedAction((Component)this.tree, nodeArray);
        if (Node.isAnalysisDone(nodeArray)) {
            actAnalyze.setEnabled(false);
        }
        if (Node.isAdvanceAnalysisDone(nodeArray)) {
            actAdvAnalyze.setEnabled(false);
        }
    }

    public void find() {
        new FindAndReplaceDialog((JFrame)LBUtilities.getBrowserFrame((Component)((Object)this)), this, false);
    }

    public void findAgain() {
        FindAndReplaceDialog.findAgain(this);
    }

    class TreeSelectionMonitor
    implements TreeSelectionListener {
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            if (LogTree.this.getJTree().getCursor().getType() != 3) {
                BrowserFrame browserFrame = LBUtilities.getBrowserFrame((Component)((Object)LogTree.this));
                browserFrame.fireLinkEvent((LinkEvent)new TreeSelectionChangeEvent(browserFrame, LogTree.this.tree.getSelectionPaths()));
            }
        }

        TreeSelectionMonitor() {
            LogTree.this = LogTree.this;
        }
    }

    class MouseMonitor
    extends MouseAdapter
    implements Runnable {
        private Point location;

        public void mousePressed(MouseEvent mouseEvent) {
            if (LogTree.this.getJTree().getCursor().getType() != 3 && mouseEvent.isPopupTrigger()) {
                this.createPopup(mouseEvent.getPoint());
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (LogTree.this.getJTree().getCursor().getType() != 3 && mouseEvent.isPopupTrigger()) {
                this.createPopup(mouseEvent.getPoint());
            }
        }

        private void createPopup(Point point) {
            int n = LogTree.this.tree.getRowForLocation(point.x, point.y);
            if (n == -1) {
                return;
            }
            TreePath treePath = LogTree.this.tree.getPathForRow(n);
            if (LogTree.this.popup == null) {
                LogTree.this.popup = new JPopupMenu();
            }
            LogTree.this.popup.removeAll();
            Object object = treePath.getLastPathComponent();
            if (object != null) {
                Point point2 = LogTree.this.getViewport().getViewPosition();
                point.translate(-point2.x, -point2.y);
                if (LogTree.this.handlePopup(LogTree.this.popup)) {
                    this.location = point;
                    SwingUtilities.invokeLater((Runnable)this);
                }
            }
        }

        public synchronized void run() {
            LogTree.this.popup.show((Component)((Object)LogTree.this), this.location.x, this.location.y);
        }

        MouseMonitor() {
            LogTree.this = LogTree.this;
        }
    }

    class TreeExpansionMonitor
    implements TreeExpansionListener {
        public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
            this.shiftBack();
        }

        public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
            this.shiftBack();
        }

        private void shiftBack() {
            SwingUtilities.invokeLater((Runnable)new 1(this));
        }

        TreeExpansionMonitor() {
            LogTree.this = LogTree.this;
        }

        static /* synthetic */ LogTree access$0(TreeExpansionMonitor treeExpansionMonitor) {
            return treeExpansionMonitor.LogTree.this;
        }
    }
}

