/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ivb.log.ui;

import com.ibm.ivb.log.Record;
import com.ibm.ivb.log.tree.RecordNode;
import com.ibm.ivb.log.tree.Severity;
import com.ibm.ivb.log.ui.LBUtilities;
import com.ibm.ivb.log.ui.SeverityPreference;
import com.ibm.ivb.log.ui.UIConstants;
import com.sun.java.swing.Icon;
import com.sun.java.swing.JTree;
import com.sun.java.swing.plaf.basic.BasicTreeCellRenderer;
import java.awt.Color;
import java.awt.Component;
import java.util.Hashtable;

public class LogTreeCellRenderer
extends BasicTreeCellRenderer
implements UIConstants {
    private static Icon icOpen;
    private static Icon icClose;
    private static Icon icCascade;
    private static Icon icDiagnosed;
    private static Icon icMystery;
    private static Icon icNothing;
    private Color defaultBackgroundSelectionColor;
    private Color defaultBackgroundNonSelectionColor;
    private static Hashtable statusIcons;

    public LogTreeCellRenderer() {
        LogTreeCellRenderer.loadIcons();
        this.defaultBackgroundSelectionColor = this.getBackgroundSelectionColor();
        this.defaultBackgroundNonSelectionColor = this.getBackgroundNonSelectionColor();
    }

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        if (SeverityPreference.isSevirityColored()) {
            int n2 = 3;
            if (object instanceof Severity) {
                n2 = ((Severity)object).getSeverity();
            }
            switch (n2) {
                case 1: {
                    this.setBackgroundNonSelectionColor(SeverityPreference.getSeverityColor(SeverityPreference.CATEGORY_UNSELECTED_BACKGROUND, SeverityPreference.SEVERITY_1));
                    this.setBackgroundSelectionColor(SeverityPreference.getSeverityColor(SeverityPreference.CATEGORY_SELECTED_BACKGROUND, SeverityPreference.SEVERITY_1));
                    break;
                }
                case 2: {
                    this.setBackgroundNonSelectionColor(SeverityPreference.getSeverityColor(SeverityPreference.CATEGORY_UNSELECTED_BACKGROUND, SeverityPreference.SEVERITY_2));
                    this.setBackgroundSelectionColor(SeverityPreference.getSeverityColor(SeverityPreference.CATEGORY_SELECTED_BACKGROUND, SeverityPreference.SEVERITY_2));
                    break;
                }
                case 3: {
                    this.setBackgroundNonSelectionColor(SeverityPreference.getSeverityColor(SeverityPreference.CATEGORY_UNSELECTED_BACKGROUND, SeverityPreference.SEVERITY_3));
                    this.setBackgroundSelectionColor(SeverityPreference.getSeverityColor(SeverityPreference.CATEGORY_SELECTED_BACKGROUND, SeverityPreference.SEVERITY_3));
                    break;
                }
                default: {
                    this.setBackgroundNonSelectionColor(this.defaultBackgroundNonSelectionColor);
                    this.setBackgroundSelectionColor(this.defaultBackgroundSelectionColor);
                    break;
                }
            }
        } else {
            this.setBackgroundNonSelectionColor(this.defaultBackgroundNonSelectionColor);
            this.setBackgroundSelectionColor(this.defaultBackgroundSelectionColor);
        }
        if (object instanceof RecordNode) {
            this.setLeafIcon(this.getIconForStatus(((RecordNode)object).getRecord().getStatus()));
        }
        return super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
    }

    private Icon getIconForStatus(Record.Status status) {
        return (Icon)statusIcons.get(status);
    }

    private static void loadIcons() {
        icOpen = LBUtilities.loadIcon("images/folderOpened.gif");
        icClose = LBUtilities.loadIcon("images/folderClosed.gif");
        icCascade = LBUtilities.loadIcon("images/cascade.gif");
        icDiagnosed = LBUtilities.loadIcon("images/diagnosed.gif");
        icMystery = LBUtilities.loadIcon("images/mystery.gif");
        icNothing = LBUtilities.loadIcon("images/nothing.gif");
        statusIcons.put(Record.Status.cascade, icCascade);
        statusIcons.put(Record.Status.diagnosed, icDiagnosed);
        statusIcons.put(Record.Status.mystery, icMystery);
        statusIcons.put(Record.Status.nothing, icNothing);
    }

    static {
        statusIcons = new Hashtable();
    }
}

