/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ivb.log.ui;

import com.ibm.ivb.jface.BrowserFrame;
import com.ibm.ivb.jface.parts.TaskIndicator;
import com.ibm.ivb.log.Progress;
import com.ibm.ivb.log.tree.LogTreeModel;
import com.ibm.ivb.log.ui.LogBrowser;
import com.ibm.ivb.log.ui.LogView;
import com.ibm.ivb.log.ui.OpenLogExecution;
import com.ibm.ivb.log.ui.ProgressiveExecution;
import com.ibm.ivb.log.ui.TranslatableConstants;
import com.ibm.ivb.log.ui.util.FindAndReplace;
import com.sun.java.swing.JOptionPane;
import com.sun.java.swing.SwingUtilities;
import java.awt.Component;
import java.io.File;
import java.io.IOException;

public class OpenLogExecution
extends ProgressiveExecution
implements TranslatableConstants {
    private static final String kCBIBMCopyright = "\n\nLicensed Materials - Property of IBM\n5639-D57\n(c) Copyright IBM Corp. 1998. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    protected File[] logFiles;
    protected LogTreeModel model;
    protected LogView logView;

    public OpenLogExecution(BrowserFrame browserFrame, File[] fileArray, LogTreeModel logTreeModel, LogView logView) {
        super(browserFrame);
        this.logFiles = fileArray;
        this.model = logTreeModel;
        this.logView = logView;
    }

    protected int getTotalNumberOfSteps() {
        return this.logFiles.length;
    }

    protected boolean performStep(int n) {
        boolean bl = true;
        try {
            ProgressRefresher progressRefresher = new ProgressRefresher(this.frame.getJFaceContext().getStatusLine().getTaskIndicator(), n, this.getTotalNumberOfSteps());
            progressRefresher.start();
            this.model.merge(this.logFiles[n]);
        }
        catch (IOException iOException) {
            String string = LogBrowser.getLBString("ComIbmIvbLogUiMsgLoadLogFail");
            string = FindAndReplace.replace(string, "%1", this.logFiles[n].getPath());
            JOptionPane.showMessageDialog((Component)this.frame, (Object)(String.valueOf(string) + "\n" + iOException), (String)LogBrowser.getLBString("ComIbmIvbLogUiTitleErrorMsgBox"), (int)0);
            bl = false;
        }
        return bl;
    }

    protected boolean actionCompletion() {
        SwingUtilities.invokeLater((Runnable)new 1());
        return true;
    }

    protected void actionFinalize() {
        super.actionFinalize();
    }

    private final class 1
    implements Runnable {
        public void run() {
            if (OpenLogExecution.this.logView != null) {
                OpenLogExecution.this.logView.resetTree(OpenLogExecution.this.model);
            }
        }

        /* synthetic */ 1() {
        }
    }

    class ProgressRefresher
    extends Thread {
        private TaskIndicator task;
        private int minPercentage;
        private double range;

        ProgressRefresher(TaskIndicator taskIndicator, int n, int n2) {
            OpenLogExecution.this = OpenLogExecution.this;
            Progress.setIdle();
            this.task = taskIndicator;
            this.minPercentage = 100 * n / n2;
            this.range = 1.0 / (double)n2;
        }

        public synchronized void run() {
            while (Progress.isIdle()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            while (!Progress.isDone()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
                int n = this.minPercentage + (int)((double)Progress.getPercentageCompleted() * this.range);
                SwingUtilities.invokeLater((Runnable)new 2(n, this));
            }
        }

        static /* synthetic */ TaskIndicator access$0(ProgressRefresher progressRefresher) {
            return progressRefresher.task;
        }
    }
}

