/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ivb.log.ui;

import com.ibm.ivb.jface.BrowserFrame;
import com.ibm.ivb.log.ui.LogBrowser;
import com.ibm.ivb.log.ui.ProgressiveExecution;
import com.ibm.ivb.log.ui.TranslatableConstants;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.PrintJob;
import java.awt.Toolkit;
import java.util.StringTokenizer;

public class PrintExecution
extends ProgressiveExecution
implements TranslatableConstants {
    private static final String kCBIBMCopyright = "\n\nLicensed Materials - Property of IBM\n5639-D57\n(c) Copyright IBM Corp. 1998. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    protected static Font font;
    protected static FontMetrics fm;
    protected static int fontHeight;
    protected static int fontAscent;
    protected static int tabGap;
    protected static int topMargin;
    protected static int leftMargin;
    private PrintJob pj;
    private Dimension pageSize;
    private StringTokenizer tokenizer;
    private Graphics g;
    private int line;
    private int column;
    private int maxLine;

    protected PrintExecution(BrowserFrame browserFrame, PrintJob printJob, String string, int n, Font font, int n2) {
        super(browserFrame);
        this.pj = printJob;
        topMargin = n;
        leftMargin = n2;
        PrintExecution.font = font;
        this.doneText = LogBrowser.getLBString("ComIbmIvbLogUiStatusPrintCompleted");
        fm = Toolkit.getDefaultToolkit().getFontMetrics(font);
        fontHeight = fm.getHeight();
        fontAscent = fm.getAscent();
        tabGap = 8 * fm.stringWidth(" ");
        this.pageSize = new Dimension(printJob.getPageDimension());
        this.pageSize.width -= 2 * n2;
        this.pageSize.height -= 2 * n;
        this.line = fontAscent;
        this.column = 0;
        this.maxLine = this.pageSize.height - fontHeight;
        this.g = this.initializeGraphics(this.pageSize, printJob);
        this.tokenizer = new StringTokenizer(string, " \t\n", true);
    }

    protected int getTotalNumberOfSteps() {
        return this.tokenizer.countTokens();
    }

    protected boolean performStep(int n) {
        String string = this.tokenizer.nextToken();
        if (string.equals("\n")) {
            this.line += fontHeight;
            this.column = 0;
            if (this.line > this.maxLine) {
                this.g.dispose();
                this.g = this.initializeGraphics(this.pageSize, this.pj);
                this.line = fontAscent;
            }
        } else {
            int n2;
            boolean bl = string.equals("\t");
            if (bl) {
                int n3 = (this.column + tabGap) / tabGap * tabGap;
                n2 = n3 - this.column;
            } else {
                n2 = fm.stringWidth(string);
            }
            if (this.column + n2 > this.pageSize.width) {
                this.line += fontHeight;
                this.column = 0;
                if (bl) {
                    n2 = tabGap;
                }
                if (this.line > this.maxLine) {
                    this.g.dispose();
                    this.g = this.initializeGraphics(this.pageSize, this.pj);
                    this.line = fontAscent;
                    if (bl) {
                        n2 = tabGap;
                    }
                }
            }
            if (!bl) {
                this.g.drawString(string, this.column, this.line);
            }
            this.column += n2;
        }
        return true;
    }

    protected boolean actionCompletion() {
        if (this.g != null) {
            this.g.dispose();
        }
        return true;
    }

    protected void actionFinalize() {
        this.pj.end();
        super.actionFinalize();
    }

    private Graphics initializeGraphics(Dimension dimension, PrintJob printJob) {
        Graphics graphics = printJob.getGraphics();
        graphics.translate(leftMargin, topMargin);
        graphics.clipRect(0, 0, dimension.width, dimension.height);
        graphics.setFont(font);
        return graphics;
    }
}

