/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ivb.log.ui;

import com.ibm.ivb.jface.Action;
import com.ibm.ivb.jface.LinkEvent;
import com.ibm.ivb.jface.Tool;
import com.ibm.ivb.log.tree.RecordNode;
import com.ibm.ivb.log.ui.ActionManager;
import com.ibm.ivb.log.ui.AdvAnalyzeAction;
import com.ibm.ivb.log.ui.AnalyzeAction;
import com.ibm.ivb.log.ui.FindAndReplaceDialog;
import com.ibm.ivb.log.ui.InformationPanel;
import com.ibm.ivb.log.ui.LBUtilities;
import com.ibm.ivb.log.ui.PrintTextAction;
import com.ibm.ivb.log.ui.SaveRecordAction;
import com.ibm.ivb.log.ui.SymptomPage;
import com.ibm.ivb.log.ui.TextSelectionManager;
import com.ibm.ivb.log.ui.TranslatableConstants;
import com.ibm.ivb.log.ui.UIConstants;
import com.ibm.ivb.log.ui.events.AnalysisEvent;
import com.ibm.ivb.log.ui.events.ClearRecordEvent;
import com.ibm.ivb.log.ui.events.FocusEvent;
import com.ibm.ivb.log.ui.events.TreeSelectionChangeEvent;

public abstract class RecordTool
extends Tool
implements ActionManager,
TranslatableConstants,
UIConstants {
    private static final String kCBIBMCopyright = "\n\nLicensed Materials - Property of IBM\n5639-D57\n(c) Copyright IBM Corp. 1998. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    protected InformationPanel record = this.getRecordPanel();
    protected AnalyzeAction actAnalyze = new AnalyzeAction(this);
    protected AdvAnalyzeAction actAdvAnalyze = new AdvAnalyzeAction(this);
    protected SaveRecordAction actSaveRecord = new SaveRecordAction(this);
    protected PrintTextAction actPrint = new PrintTextAction(this);
    protected CutAction actCut = new CutAction();
    protected CopyAction actCopy = new CopyAction();
    protected PasteAction actPaste = new PasteAction();
    protected FindAction actFind = new FindAction();
    protected FindAgainAction actFindAgain = new FindAgainAction();
    protected ReplaceAction actReplace = new ReplaceAction();
    protected SelectAllAction actSelectAll = new SelectAllAction();

    public RecordTool() {
        new TextSelectionManager(this.record.getTextComponent(), this);
    }

    public RecordNode getNode() {
        return this.record.getNode();
    }

    public void toolActive() {
        super.toolActive();
    }

    public void focusGained() {
        this.getParentFrame().fireLinkEvent((LinkEvent)new FocusEvent(this));
        TextSelectionManager.clearRecord();
    }

    public void handleLinkEvent(ClearRecordEvent clearRecordEvent) {
        this.record.setNode(null);
        this.handleClearRecordEvent();
        this.turnToDefaultPage();
    }

    public void handleLinkEvent(TreeSelectionChangeEvent treeSelectionChangeEvent) {
        this.turnToDefaultPage();
        RecordNode recordNode = (RecordNode)treeSelectionChangeEvent.getSelectedTreePath().getLastPathComponent();
        this.record.setNode(recordNode);
        this.setTitle(recordNode.toString());
        this.handleTreeSelectionChangeEvent();
        this.addToPaneHistory(treeSelectionChangeEvent.makeCopy());
        this.actAnalyze.setEnabled(!recordNode.isAnalysisDone());
        this.actAdvAnalyze.setEnabled(!recordNode.isAdvanceAnalysisDone());
    }

    public void handleLinkEvent(AnalysisEvent analysisEvent) {
        this.turnToDefaultPage();
        this.handleAnalysisEvent(analysisEvent);
    }

    protected abstract InformationPanel getRecordPanel();

    protected abstract void handleClearRecordEvent();

    protected abstract void handleTreeSelectionChangeEvent();

    protected void handleAnalysisEvent(AnalysisEvent analysisEvent) {
    }

    public Action getActionFor(String string) {
        if (string.equals("analyze")) {
            return this.actAnalyze;
        }
        if (string.equals("advAnalyze")) {
            return this.actAdvAnalyze;
        }
        if (string.equals("saveInFile")) {
            return this.actSaveRecord;
        }
        if (string.equals("print")) {
            return this.actPrint;
        }
        if (string.equals("cut")) {
            return this.actCut;
        }
        if (string.equals("copy")) {
            return this.actCopy;
        }
        if (string.equals("paste")) {
            return this.actPaste;
        }
        if (string.equals("find")) {
            return this.actFind;
        }
        if (string.equals("findAgain")) {
            return this.actFindAgain;
        }
        if (string.equals("replace")) {
            return this.actReplace;
        }
        if (string.equals("selectAll")) {
            return this.actSelectAll;
        }
        return null;
    }

    public boolean isActionEnabled(String string) {
        if (string.equals("analyze")) {
            return this.getNode() != null && !this.getNode().isAnalysisDone();
        }
        if (string.equals("advAnalyze")) {
            return this.getNode() != null && !this.getNode().isAdvanceAnalysisDone();
        }
        if (string.equals("saveInFile")) {
            return this.getNode() != null;
        }
        if (string.equals("cut")) {
            return this.record.isEditable() && this.record.hasSelection();
        }
        if (string.equals("copy")) {
            return this.record.hasSelection();
        }
        if (string.equals("paste")) {
            return this.record.isEditable() && !LBUtilities.isClipboardEmpty();
        }
        if (string.equals("find")) {
            return true;
        }
        if (string.equals("findAgain")) {
            return FindAndReplaceDialog.canFindAgain();
        }
        if (string.equals("replace")) {
            return this.record.isEditable();
        }
        return string.equals("selectAll");
    }

    private void turnToDefaultPage() {
        if (this instanceof SymptomPage) {
            this.turnToPage(this.getParentPage());
        }
    }

    class CutAction
    extends Action {
        public synchronized void run() {
            RecordTool.this.record.cut();
        }

        CutAction() {
            RecordTool.this = RecordTool.this;
        }
    }

    class CopyAction
    extends Action {
        public synchronized void run() {
            RecordTool.this.record.copy();
        }

        CopyAction() {
            RecordTool.this = RecordTool.this;
        }
    }

    class PasteAction
    extends Action {
        public synchronized void run() {
            RecordTool.this.record.paste();
        }

        PasteAction() {
            RecordTool.this = RecordTool.this;
        }
    }

    class FindAction
    extends Action {
        public synchronized void run() {
            RecordTool.this.record.find();
        }

        FindAction() {
            RecordTool.this = RecordTool.this;
        }
    }

    class FindAgainAction
    extends Action {
        public synchronized void run() {
            RecordTool.this.record.findAgain();
        }

        FindAgainAction() {
            RecordTool.this = RecordTool.this;
        }
    }

    class ReplaceAction
    extends Action {
        public synchronized void run() {
            RecordTool.this.record.replace();
        }

        ReplaceAction() {
            RecordTool.this = RecordTool.this;
        }
    }

    class SelectAllAction
    extends Action {
        public synchronized void run() {
            RecordTool.this.record.selectAll();
        }

        SelectAllAction() {
            RecordTool.this = RecordTool.this;
        }
    }
}

