/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ivb.log.ui;

import com.ibm.ivb.jface.Application;
import com.ibm.ivb.log.ui.LogBrowser;
import com.ibm.ivb.log.ui.TranslatableConstants;
import com.ibm.ivb.log.ui.UIConstants;
import com.ibm.ivb.log.ui.util.PropertyHelper;
import com.sun.java.swing.AbstractButton;
import com.sun.java.swing.ButtonGroup;
import com.sun.java.swing.Icon;
import com.sun.java.swing.JButton;
import com.sun.java.swing.JCheckBox;
import com.sun.java.swing.JFrame;
import com.sun.java.swing.JLabel;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.JRadioButton;
import com.sun.java.swing.JTree;
import com.sun.java.swing.border.Border;
import com.sun.java.swing.border.TitledBorder;
import com.sun.java.swing.plaf.basic.BasicTreeCellRenderer;
import com.sun.java.swing.preview.JColorChooser;
import com.sun.java.swing.tree.DefaultMutableTreeNode;
import com.sun.java.swing.tree.DefaultTreeModel;
import com.sun.java.swing.tree.MutableTreeNode;
import com.sun.java.swing.tree.TreeCellRenderer;
import com.sun.java.swing.tree.TreeModel;
import com.sun.java.swing.tree.TreeNode;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class SeverityPreference
extends JPanel
implements UIConstants,
TranslatableConstants {
    private static final String kCBIBMCopyright = "(c) Copyright IBM Corporation 1998";
    private JCheckBox cbColoring;
    private JLabel lbBackground;
    private JRadioButton rbSelected;
    private JRadioButton rbUnselected;
    private ButtonGroup bgBackground = new ButtonGroup();
    private JLabel lbSeverity;
    private JRadioButton rbSev1;
    private JRadioButton rbSev2;
    private JRadioButton rbSev3;
    private ButtonGroup bgSeverity = new ButtonGroup();
    private JButton btDefault;
    private JButton btChange;
    private JTree sample;
    private SampleTreeNode ndRoot;
    private SampleTreeNode ndSev1;
    private SampleTreeNode ndSev2;
    private SampleTreeNode ndSev3;
    private JColorChooser color;
    private static Hashtable severityColors = new Hashtable();
    private static Hashtable draftSeverityColors = new Hashtable();
    private static boolean severityColorsLoaded;
    private static final boolean DEF_PREF_COLOR_SEVERITY = true;
    private static final Color DEF_PREF_COLOR_SELECTED_SEV_1;
    private static final Color DEF_PREF_COLOR_SELECTED_SEV_2;
    private static final Color DEF_PREF_COLOR_SELECTED_SEV_3;
    private static final Color DEF_PREF_COLOR_UNSELECTED_SEV_1;
    private static final Color DEF_PREF_COLOR_UNSELECTED_SEV_2;
    private static final Color DEF_PREF_COLOR_UNSELECTED_SEV_3;
    public static final String CATEGORY_SELECTED_BACKGROUND;
    public static final String CATEGORY_UNSELECTED_BACKGROUND;
    public static final String SEVERITY_1;
    public static final String SEVERITY_2;
    public static final String SEVERITY_3;

    public SeverityPreference() {
        super((LayoutManager)new GridBagLayout(), true);
        Application application = LogBrowser.getLBApplication();
        this.cbColoring = new JCheckBox(application.getString("ComIbmIvbLogUiSettingColorSeverities"));
        this.lbBackground = new JLabel(application.getString("ComIbmIvbLogUiSettingBackground"));
        this.rbSelected = new JRadioButton(application.getString("ComIbmIvbLogUiSettingSelectedNode"));
        this.rbUnselected = new JRadioButton(application.getString("ComIbmIvbLogUiSettingNoneSelectedNode"));
        this.bgBackground.add((AbstractButton)this.rbSelected);
        this.bgBackground.add((AbstractButton)this.rbUnselected);
        this.lbSeverity = new JLabel(application.getString("ComIbmIvbLogUiSettingSeverity"));
        this.rbSev1 = new JRadioButton(application.getString("ComIbmIvbLogUiSettingSev1"));
        this.rbSev2 = new JRadioButton(application.getString("ComIbmIvbLogUiSettingSev2"));
        this.rbSev3 = new JRadioButton(application.getString("ComIbmIvbLogUiSettingSev3"));
        this.bgSeverity.add((AbstractButton)this.rbSev1);
        this.bgSeverity.add((AbstractButton)this.rbSev2);
        this.bgSeverity.add((AbstractButton)this.rbSev3);
        this.btDefault = new JButton(application.getString("ComIbmIvbLogUiSettingSetDefault"));
        this.btChange = new JButton(application.getString("ComIbmIvbLogUiSettingApply"));
        this.color = new JColorChooser();
        this.ndRoot = new SampleTreeNode(application.getString("ComIbmIvbLogUiSettingSampleParent"), SEVERITY_1);
        this.ndSev1 = new SampleTreeNode(application.getString("ComIbmIvbLogUiSettingSampleSev1"), SEVERITY_1);
        this.ndSev2 = new SampleTreeNode(application.getString("ComIbmIvbLogUiSettingSampleSev2"), SEVERITY_2);
        this.ndSev3 = new SampleTreeNode(application.getString("ComIbmIvbLogUiSettingSampleSev3"), SEVERITY_3);
        this.ndRoot.add((MutableTreeNode)this.ndSev1);
        this.ndRoot.add((MutableTreeNode)this.ndSev2);
        this.ndRoot.add((MutableTreeNode)this.ndSev3);
        this.sample = new JTree((TreeModel)new DefaultTreeModel((TreeNode)this.ndRoot));
        this.sample.setCellRenderer((TreeCellRenderer)new SampleTreeCellRenderer());
        SeverityPreference.fillSeverityColorTable();
        draftSeverityColors = severityColors;
        ColorMonitor colorMonitor = new ColorMonitor();
        this.cbColoring.addActionListener((ActionListener)colorMonitor);
        this.rbSelected.addActionListener((ActionListener)colorMonitor);
        this.rbUnselected.addActionListener((ActionListener)colorMonitor);
        this.rbSev1.addActionListener((ActionListener)colorMonitor);
        this.rbSev2.addActionListener((ActionListener)colorMonitor);
        this.rbSev3.addActionListener((ActionListener)colorMonitor);
        this.btDefault.addActionListener((ActionListener)colorMonitor);
        this.btChange.addActionListener((ActionListener)colorMonitor);
        JPanel jPanel = new JPanel((LayoutManager)new FlowLayout(0, 10, 0));
        jPanel.add((Component)this.lbBackground);
        jPanel.add((Component)this.rbSelected);
        jPanel.add((Component)this.rbUnselected);
        JPanel jPanel2 = new JPanel((LayoutManager)new FlowLayout(0, 10, 0));
        jPanel2.add((Component)this.lbSeverity);
        jPanel2.add((Component)this.rbSev1);
        jPanel2.add((Component)this.rbSev2);
        jPanel2.add((Component)this.rbSev3);
        JPanel jPanel3 = new JPanel((LayoutManager)new BorderLayout());
        JPanel jPanel4 = new JPanel((LayoutManager)new FlowLayout());
        jPanel4.add((Component)this.btChange);
        jPanel4.add((Component)this.btDefault);
        jPanel3.add((Component)jPanel4, "North");
        jPanel3.add((Component)this.color);
        JPanel jPanel5 = new JPanel((LayoutManager)new BorderLayout());
        jPanel5.setBorder((Border)new TitledBorder(application.getString("ComIbmIvbLogUiSettingSample")));
        jPanel5.add((Component)this.sample);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        ((Container)((Object)this)).add((Component)this.cbColoring, gridBagConstraints);
        gridBagConstraints.insets = new Insets(2, 10, 0, 0);
        ++gridBagConstraints.gridy;
        ((Container)((Object)this)).add((Component)jPanel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        ((Container)((Object)this)).add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.insets = new Insets(2, 0, 0, 3);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        ((Container)((Object)this)).add((Component)jPanel3, gridBagConstraints);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        ++gridBagConstraints.gridx;
        gridBagConstraints.weighty = 1.0;
        ((Container)((Object)this)).add((Component)jPanel5, gridBagConstraints);
    }

    public void displaySettings() {
        this.cbColoring.setSelected(SeverityPreference.isSevirityColored());
        this.setColorChoiceEnabled(this.cbColoring.isSelected());
        this.rbSelected.setSelected(true);
        this.rbSev1.setSelected(true);
        this.color.setColor((Color)severityColors.get(this.getSeverityColorKey()));
        this.btDefault.setIcon((Icon)new DefaultIcon(this.getDefaultColor()));
    }

    public void saveSettings() {
        Properties properties = LogBrowser.getLBProperties();
        PropertyHelper.setPropertyValue(properties, "LBPreferenceColorSeverities", this.cbColoring.isSelected());
        severityColors = draftSeverityColors;
        Enumeration enumeration = severityColors.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            PropertyHelper.setPropertyValue(properties, (String)k, (Color)severityColors.get(k));
        }
    }

    public static boolean isSevirityColored() {
        Properties properties = LogBrowser.getLBProperties();
        boolean bl = PropertyHelper.hasProperty(properties, "LBPreferenceColorSeverities") ? PropertyHelper.getPropertyBoolean(properties, "LBPreferenceColorSeverities") : true;
        return bl;
    }

    public static Color getSeverityColor(String string, String string2) {
        SeverityPreference.fillSeverityColorTable();
        return (Color)severityColors.get("LBPreferenceColor" + string + string2);
    }

    private static void fillSeverityColorTable() {
        if (!severityColorsLoaded) {
            String string;
            String string2;
            Properties properties = LogBrowser.getLBProperties();
            Color color = PropertyHelper.hasProperty(properties, string2 = String.valueOf(string = "LBPreferenceColor" + CATEGORY_SELECTED_BACKGROUND) + SEVERITY_1) ? PropertyHelper.getPropertyColor(properties, string2) : DEF_PREF_COLOR_SELECTED_SEV_1;
            severityColors.put(string2, color);
            string2 = String.valueOf(string) + SEVERITY_2;
            color = PropertyHelper.hasProperty(properties, string2) ? PropertyHelper.getPropertyColor(properties, string2) : DEF_PREF_COLOR_SELECTED_SEV_2;
            severityColors.put(string2, color);
            string2 = String.valueOf(string) + SEVERITY_3;
            color = PropertyHelper.hasProperty(properties, string2) ? PropertyHelper.getPropertyColor(properties, string2) : DEF_PREF_COLOR_SELECTED_SEV_3;
            severityColors.put(string2, color);
            string = "LBPreferenceColor" + CATEGORY_UNSELECTED_BACKGROUND;
            string2 = String.valueOf(string) + SEVERITY_1;
            color = PropertyHelper.hasProperty(properties, string2) ? PropertyHelper.getPropertyColor(properties, string2) : DEF_PREF_COLOR_UNSELECTED_SEV_1;
            severityColors.put(string2, color);
            string2 = String.valueOf(string) + SEVERITY_2;
            color = PropertyHelper.hasProperty(properties, string2) ? PropertyHelper.getPropertyColor(properties, string2) : DEF_PREF_COLOR_UNSELECTED_SEV_2;
            severityColors.put(string2, color);
            string2 = String.valueOf(string) + SEVERITY_3;
            color = PropertyHelper.hasProperty(properties, string2) ? PropertyHelper.getPropertyColor(properties, string2) : DEF_PREF_COLOR_UNSELECTED_SEV_3;
            severityColors.put(string2, color);
            severityColorsLoaded = true;
        }
    }

    private String getSeverityColorKey() {
        String string = this.rbSelected.isSelected() ? CATEGORY_SELECTED_BACKGROUND : CATEGORY_UNSELECTED_BACKGROUND;
        String string2 = this.rbSev1.isSelected() ? SEVERITY_1 : (this.rbSev2.isSelected() ? SEVERITY_2 : SEVERITY_3);
        return "LBPreferenceColor" + string + string2;
    }

    private Color getDefaultColor() {
        Color color = this.rbSelected.isSelected() ? (this.rbSev1.isSelected() ? DEF_PREF_COLOR_SELECTED_SEV_1 : (this.rbSev2.isSelected() ? DEF_PREF_COLOR_SELECTED_SEV_2 : DEF_PREF_COLOR_SELECTED_SEV_3)) : (this.rbSev1.isSelected() ? DEF_PREF_COLOR_UNSELECTED_SEV_1 : (this.rbSev2.isSelected() ? DEF_PREF_COLOR_UNSELECTED_SEV_2 : DEF_PREF_COLOR_UNSELECTED_SEV_3));
        return color;
    }

    private void setColorChoiceEnabled(boolean bl) {
        this.rbSelected.setEnabled(bl);
        this.rbUnselected.setEnabled(bl);
        this.rbSev1.setEnabled(bl);
        this.rbSev2.setEnabled(bl);
        this.rbSev3.setEnabled(bl);
        this.btDefault.setEnabled(bl);
        this.btChange.setEnabled(bl);
    }

    public static void main(String[] stringArray) {
        SeverityPreference severityPreference = new SeverityPreference();
        severityPreference.displaySettings();
        JFrame jFrame = new JFrame();
        jFrame.getContentPane().add((Component)((Object)severityPreference));
        jFrame.pack();
        jFrame.show();
    }

    static {
        DEF_PREF_COLOR_SELECTED_SEV_1 = new Color(224, 75, 75);
        DEF_PREF_COLOR_SELECTED_SEV_2 = new Color(0, 164, 109);
        DEF_PREF_COLOR_SELECTED_SEV_3 = new Color(51, 51, 204);
        DEF_PREF_COLOR_UNSELECTED_SEV_1 = new Color(255, 175, 175);
        DEF_PREF_COLOR_UNSELECTED_SEV_2 = new Color(255, 255, 145);
        DEF_PREF_COLOR_UNSELECTED_SEV_3 = new Color(255, 255, 255);
        CATEGORY_SELECTED_BACKGROUND = new String("Selected");
        CATEGORY_UNSELECTED_BACKGROUND = new String("NoneSelected");
        SEVERITY_1 = new String("Sev1");
        SEVERITY_2 = new String("Sev2");
        SEVERITY_3 = new String("Sev3");
    }

    class ColorMonitor
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == SeverityPreference.this.cbColoring) {
                boolean bl = SeverityPreference.this.cbColoring.isSelected();
                SeverityPreference.this.setColorChoiceEnabled(bl);
                ((SampleTreeCellRenderer)SeverityPreference.this.sample.getCellRenderer()).enableColoring(bl);
                SeverityPreference.this.sample.repaint();
                return;
            }
            if (object == SeverityPreference.this.rbSelected || object == SeverityPreference.this.rbUnselected || object == SeverityPreference.this.rbSev1 || object == SeverityPreference.this.rbSev2 || object == SeverityPreference.this.rbSev3) {
                SeverityPreference.this.btDefault.setIcon((Icon)new DefaultIcon(SeverityPreference.this.getDefaultColor()));
                SeverityPreference.this.color.setColor((Color)draftSeverityColors.get(SeverityPreference.this.getSeverityColorKey()));
                return;
            }
            if (object == SeverityPreference.this.btDefault) {
                Color color = SeverityPreference.this.getDefaultColor();
                draftSeverityColors.put(SeverityPreference.this.getSeverityColorKey(), color);
                SeverityPreference.this.color.setColor(color);
                SeverityPreference.this.sample.repaint();
                return;
            }
            if (object == SeverityPreference.this.btChange) {
                draftSeverityColors.put(SeverityPreference.this.getSeverityColorKey(), SeverityPreference.this.color.getColor());
                SeverityPreference.this.sample.repaint();
            }
        }

        ColorMonitor() {
            SeverityPreference.this = SeverityPreference.this;
        }
    }

    static class DefaultIcon
    implements Icon {
        Color color;

        DefaultIcon(Color color) {
            this.color = color;
        }

        Color getColor() {
            return this.color;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Color color = graphics.getColor();
            graphics.setColor(this.color);
            graphics.fill3DRect(n, n2, this.getIconWidth(), this.getIconHeight(), true);
            graphics.setColor(color);
        }

        public int getIconWidth() {
            return 40;
        }

        public int getIconHeight() {
            return 12;
        }
    }

    class SampleTreeCellRenderer
    extends BasicTreeCellRenderer {
        private boolean colorize = true;

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            if (this.colorize && object instanceof SampleTreeNode) {
                String string = ((SampleTreeNode)((Object)object)).getSeverity();
                this.setBackgroundNonSelectionColor((Color)draftSeverityColors.get("LBPreferenceColor" + CATEGORY_UNSELECTED_BACKGROUND + string));
                this.setBackgroundSelectionColor((Color)draftSeverityColors.get("LBPreferenceColor" + CATEGORY_SELECTED_BACKGROUND + string));
            }
            return super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
        }

        void enableColoring(boolean bl) {
            this.colorize = bl;
        }

        SampleTreeCellRenderer() {
            SeverityPreference.this = SeverityPreference.this;
        }
    }

    class SampleTreeNode
    extends DefaultMutableTreeNode {
        String severity;
        String name;

        SampleTreeNode(String string, String string2) {
            SeverityPreference.this = SeverityPreference.this;
            this.name = string;
            this.severity = string2;
        }

        String getSeverity() {
            return this.severity;
        }

        public String toString() {
            return this.name;
        }
    }
}

