/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ivb.log.ui.util;

import com.ibm.ivb.log.ui.util.FileHelper;
import com.sun.java.swing.preview.filechooser.FileFilter;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;

public class GenericFileFilter
extends FileFilter {
    private Hashtable filters;
    private String description;
    private String fullDescription;
    private boolean useExtensionsInDescription = true;

    public GenericFileFilter() {
        this((String)null, (String)null);
    }

    public GenericFileFilter(String string) {
        this(string, null);
    }

    public GenericFileFilter(String string, String string2) {
        this(new String[]{string}, string2);
    }

    public GenericFileFilter(String[] stringArray) {
        this(stringArray, null);
    }

    public GenericFileFilter(String[] stringArray, String string) {
        this.filters = new Hashtable(stringArray.length);
        int n = 0;
        while (n < stringArray.length) {
            this.addExtension(stringArray[n]);
            ++n;
        }
        this.setDescription(string);
    }

    public boolean accept(File file) {
        if (file != null) {
            if (file.isDirectory()) {
                return true;
            }
            String string = FileHelper.getExtension(file);
            if (string != null && this.filters.get(string) != null) {
                return true;
            }
        }
        return false;
    }

    public void addExtension(String string) {
        if (this.filters == null) {
            this.filters = new Hashtable(5);
        }
        this.filters.put(string.toLowerCase(), this);
        this.fullDescription = null;
    }

    public String getDescription() {
        if (this.fullDescription == null) {
            if (this.description == null || this.isExtensionListInDescription()) {
                if (this.description != null) {
                    this.fullDescription = this.description;
                }
                this.fullDescription = String.valueOf(this.fullDescription) + " (";
                Enumeration enumeration = this.filters.keys();
                if (enumeration != null) {
                    this.fullDescription = String.valueOf(this.fullDescription) + "." + (String)enumeration.nextElement();
                    while (enumeration.hasMoreElements()) {
                        this.fullDescription = String.valueOf(this.fullDescription) + ", " + (String)enumeration.nextElement();
                    }
                }
                this.fullDescription = String.valueOf(this.fullDescription) + ")";
            } else {
                this.fullDescription = this.description;
            }
        }
        return this.fullDescription;
    }

    public void setDescription(String string) {
        this.description = string;
        this.fullDescription = null;
    }

    public void setExtensionListInDescription(boolean bl) {
        this.useExtensionsInDescription = bl;
        this.fullDescription = null;
    }

    public boolean isExtensionListInDescription() {
        return this.useExtensionsInDescription;
    }

    public String[] getExtensions() {
        String[] stringArray = new String[this.filters.size()];
        int n = 0;
        Enumeration enumeration = this.filters.keys();
        while (enumeration.hasMoreElements()) {
            stringArray[n++] = (String)enumeration.nextElement();
        }
        return stringArray;
    }
}

