/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ivb.log.ui.util;

import com.sun.java.swing.JDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;

public class LocationHelper {
    private static final String kCBIBMCopyright = "\n\nLicensed Materials - Property of IBM\n5639-D57\n(c) Copyright IBM Corp. 1998. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n\n";

    public static Point centerComponentOnScreen(Dimension dimension) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        return LocationHelper.centerComponentOnReference(dimension, new Point(0, 0), toolkit.getScreenSize());
    }

    public static Point centerComponentOnReference(Dimension dimension, Point point, Dimension dimension2) {
        return new Point(point.x + (dimension2.width - dimension.width) / 2, point.y + (dimension2.height - dimension.height) / 2);
    }

    public static Point centerComponentOnReferenceInScreen(Dimension dimension, Point point, Dimension dimension2) {
        Dimension dimension3 = Toolkit.getDefaultToolkit().getScreenSize();
        int n = point.x + (dimension2.width - dimension.width) / 2;
        if (n < 0) {
            n = 0;
        } else if (n + dimension.width > dimension3.width) {
            n = dimension3.width - dimension.width;
        }
        int n2 = point.y + (dimension2.height - dimension.height) / 2;
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 + dimension.height > dimension3.height) {
            n2 = dimension3.height - dimension.height;
        }
        return new Point(n, n2);
    }

    public static void centerDialog(JDialog jDialog, Component component) {
        jDialog.setLocation(LocationHelper.centerComponentOnReferenceInScreen(jDialog.getSize(), component.getLocation(), component.getSize()));
    }

    public static void main(String[] stringArray) {
        System.out.println("Screen size is " + Toolkit.getDefaultToolkit().getScreenSize().toString());
        System.out.println("To center a component with size (200, 500) on screen, it should be placed at " + LocationHelper.centerComponentOnScreen(new Dimension(200, 500)).toString());
        System.out.println("To center a component with size (200, 500) on another component with (100, 300) at (40, 50), it should be placed at " + LocationHelper.centerComponentOnReference(new Dimension(200, 500), new Point(40, 50), new Dimension(100, 300)).toString());
        System.out.println("To center a component with size (200, 500) on another component with (100, 300) at (40, 50), it should be placed at " + LocationHelper.centerComponentOnReferenceInScreen(new Dimension(200, 500), new Point(40, 50), new Dimension(100, 300)).toString());
        System.out.println("To center a component with size (200, 500) on another component with (100, 300) at (30, 50), it should be placed at " + LocationHelper.centerComponentOnReferenceInScreen(new Dimension(200, 500), new Point(1000, 700), new Dimension(100, 300)).toString());
    }
}

