/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.format;

import com.ibm.jvm.format.TraceFormat;
import com.ibm.jvm.format.TraceRecord;
import com.ibm.jvm.format.TraceThread;
import com.ibm.jvm.format.Util;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;

public final class Merge {
    private Vector threads;
    private TraceRecord currentTraceRecord = null;
    private BigInteger nextOldest;
    private LinkedList traceRecordList = new LinkedList();
    private boolean oneThreadLeft = false;
    private int numberOfRecordsProcessed = 0;

    protected Merge(Vector vector) throws IOException {
        this.threads = vector;
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            TraceThread traceThread = (TraceThread)iterator.next();
            TraceRecord traceRecord = (TraceRecord)traceThread.firstElement();
            traceRecord.prime();
            this.traceRecordList.add(traceRecord);
        }
        TraceFormat.outStream.println("Number of Trace Buffers Processed:");
        TraceFormat.outStream.print("     0 ");
        this.getCurrentTraceRecordAndUpdateNextOldest();
        Util.Debug.println("Merge: nextOldest after constructor " + this.nextOldest);
    }

    protected final void getCurrentTraceRecordAndUpdateNextOldest() {
        Collections.sort(this.traceRecordList);
        this.currentTraceRecord = (TraceRecord)this.traceRecordList.get(0);
        if (this.traceRecordList.size() > 1) {
            this.nextOldest = ((TraceRecord)this.traceRecordList.get(1)).getCurrentTimeStamp();
        } else {
            this.nextOldest = BigInteger.ZERO;
            this.oneThreadLeft = true;
        }
    }

    protected final String getNextEntry() throws IOException {
        while (this.currentTraceRecord.getNextEntry() == 0) {
            Util.Debug.println("Merge: no more entries in this Record");
            ++this.numberOfRecordsProcessed;
            if (this.numberOfRecordsProcessed % 10 == 0 || this.numberOfRecordsProcessed == TraceFormat.expectedRecords) {
                StringBuffer stringBuffer = new StringBuffer(new Integer(this.numberOfRecordsProcessed).toString());
                Util.padBuffer(stringBuffer, 6, ' ', false);
                TraceFormat.outStream.print(stringBuffer + " ");
            }
            if ((this.numberOfRecordsProcessed + 10) % 100 == 0) {
                TraceFormat.outStream.println("");
            }
            this.currentTraceRecord.release();
            this.traceRecordList.remove(this.currentTraceRecord);
            TraceRecord traceRecord = this.currentTraceRecord.getNextRecord();
            if (traceRecord != null) {
                Util.Debug.println("Merge: priming next Record on this thread");
                traceRecord.prime();
                this.traceRecordList.add(traceRecord);
            }
            if (this.traceRecordList.size() == 0) {
                Util.Debug.println("Merge: Finished");
                TraceFormat.outStream.println(" ");
                return null;
            }
            this.getCurrentTraceRecordAndUpdateNextOldest();
        }
        BigInteger bigInteger = this.currentTraceRecord.getCurrentTimeStamp();
        if (bigInteger.compareTo(this.nextOldest) != -1 && !this.oneThreadLeft) {
            this.getCurrentTraceRecordAndUpdateNextOldest();
            this.currentTraceRecord.getNextEntry();
        }
        return this.currentTraceRecord.formatCurrentEntry();
    }
}

