/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import java.beans.IdentityHashtable;
import java.util.HashMap;

class NameGenerator {
    private static HashMap valueToName;
    private static HashMap instanceCountsByClassName;

    NameGenerator() {
    }

    private static void init() {
        valueToName = new IdentityHashtable();
        instanceCountsByClassName = new HashMap();
    }

    static void clear() {
        NameGenerator.init();
    }

    private static String unqualifiedClassName(Class clazz) {
        if (clazz.isArray()) {
            return NameGenerator.unqualifiedClassName(clazz.getComponentType()) + "Array";
        }
        String string = clazz.getName();
        return string.substring(string.lastIndexOf(46) + 1);
    }

    static String replace(String string, char c, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != c) {
                stringBuffer.append(string.charAt(i));
                continue;
            }
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    static String instanceName(Object object) {
        if (object == null) {
            return "null";
        }
        if (object instanceof Class) {
            return NameGenerator.unqualifiedClassName((Class)object);
        }
        String string = (String)valueToName.get(object);
        if (string != null) {
            return string;
        }
        Class clazz = object.getClass();
        String string2 = NameGenerator.unqualifiedClassName(clazz);
        Object object2 = instanceCountsByClassName.get(string2);
        int n = object2 == null ? 0 : (Integer)object2 + 1;
        instanceCountsByClassName.put(string2, new Integer(n));
        string = string2 + n;
        valueToName.put(object, string);
        return string;
    }

    static {
        NameGenerator.init();
    }
}

