/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs10;

import com.ibm.misc.BASE64Decoder;
import com.ibm.misc.BASE64Encoder;
import com.ibm.misc.CharacterEncoder;
import com.ibm.misc.Debug;
import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.pkcs10.CertificationRequestInfo;
import com.ibm.security.pkcsutil.PKCSAttributes;
import com.ibm.security.pkcsutil.PKCSDerObject;
import com.ibm.security.pkcsutil.PKCSException;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgorithmId;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;

public final class CertificationRequest
extends PKCSDerObject
implements Cloneable {
    private static String BEGIN_REQUEST = "-----BEGIN NEW CERTIFICATE REQUEST-----";
    private static String END_REQUEST = "-----END NEW CERTIFICATE REQUEST-----";
    private CertificationRequestInfo certReqInfo;
    private AlgorithmId sigAlg;
    private byte[] signature;
    private String provider = null;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs10.CertificationRequest";

    public CertificationRequest(byte[] byArray) throws IOException {
        super(byArray);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "CertificationRequest", (Object)byArray);
            debug.exit(16384L, className, "CertificationRequest");
        }
    }

    public CertificationRequest(byte[] byArray, String string) throws IOException {
        super(byArray, string);
        if (debug != null) {
            debug.entry(16384L, className, "CertificationRequest", byArray, string);
            debug.exit(16384L, className, "CertificationRequest");
        }
    }

    public CertificationRequest(CertificationRequestInfo certificationRequestInfo, PrivateKey privateKey, String string) throws NoSuchAlgorithmException, IOException, PKCSException {
        if (debug != null) {
            Object[] objectArray = new Object[]{certificationRequestInfo, privateKey, string};
            debug.entry(16384L, (Object)className, "CertificationRequest", objectArray);
        }
        this.certReqInfo = certificationRequestInfo;
        try {
            this.signThis(string, privateKey);
        }
        catch (SignatureException signatureException) {
            if (debug != null) {
                debug.exception(16384L, className, "CertificationRequest", signatureException);
            }
            throw new PKCSException(signatureException, "Error signing CertificateRequest: " + signatureException.toString());
        }
        if (debug != null) {
            debug.exit(16384L, className, "CertificationRequest");
        }
    }

    public CertificationRequest(CertificationRequestInfo certificationRequestInfo, PrivateKey privateKey, String string, String string2) throws NoSuchAlgorithmException, IOException, PKCSException {
        this(certificationRequestInfo, privateKey, string);
        if (debug != null) {
            Object[] objectArray = new Object[]{certificationRequestInfo, privateKey, string, string2};
            debug.entry(16384L, (Object)className, "CertificationRequest", objectArray);
        }
        if (string2 != null) {
            ((PKCSDerObject)this).provider = new String(string2);
        }
        if (debug != null) {
            debug.exit(16384L, className, "CertificationRequest");
        }
    }

    public CertificationRequest(CertificationRequestInfo certificationRequestInfo) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "CertificationRequest", certificationRequestInfo);
            debug.exit(16384L, className, "CertificationRequest");
        }
        this.certReqInfo = certificationRequestInfo;
    }

    public CertificationRequest(CertificationRequestInfo certificationRequestInfo, String string) {
        super(string);
        if (debug != null) {
            debug.entry(16384L, className, "CertificationRequest", certificationRequestInfo, string);
            debug.exit(16384L, className, "CertificationRequest");
        }
        this.certReqInfo = certificationRequestInfo;
    }

    public CertificationRequest(String string, boolean bl) throws IOException {
        super(string, bl);
        if (debug != null) {
            Object[] objectArray = new Object[]{string, new Boolean(bl)};
            debug.entry(16384L, (Object)className, "CertificationRequest", objectArray);
            debug.exit(16384L, className, "CertificationRequest");
        }
    }

    public CertificationRequest(String string, boolean bl, String string2) throws IOException {
        super(string, bl, string2);
        if (debug != null) {
            Object[] objectArray = new Object[]{string, new Boolean(bl), string2};
            debug.entry(16384L, (Object)className, "CertificationRequest", objectArray);
            debug.exit(16384L, className, "CertificationRequest");
        }
    }

    public void encode(OutputStream outputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", outputStream);
        }
        if (this.sigAlg == null || this.signature == null) {
            if (debug != null) {
                debug.text(16384L, className, "encode", "Cannot encode unsigned certification request.");
            }
            throw new IOException("Cannot encode unsigned certification request.");
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        this.certReqInfo.encode(derOutputStream);
        this.sigAlg.encode(derOutputStream);
        derOutputStream.putBitString(this.signature);
        derOutputStream2.write((byte)48, derOutputStream);
        outputStream.write(derOutputStream2.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public CertificationRequest sign(String string, PrivateKey privateKey) throws PKCSException, SignatureException {
        if (debug != null) {
            debug.entry(16384L, className, "sign", string, privateKey);
        }
        if (string == null) {
            if (debug != null) {
                debug.text(16384L, className, "sign", "digest must be specified.");
            }
            throw new IllegalArgumentException("digest must be specified.");
        }
        if (privateKey == null) {
            if (debug != null) {
                debug.text(16384L, className, "sign", "key must be specified.");
            }
            throw new IllegalArgumentException("key must be specified.");
        }
        if (this.signature != null) {
            if (debug != null) {
                debug.text(16384L, className, "sign", "Request is already signed.");
            }
            throw new SignatureException("Request is already signed.");
        }
        CertificationRequest certificationRequest = new CertificationRequest(this.certReqInfo, ((PKCSDerObject)this).provider);
        certificationRequest.signThis(string, privateKey);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "sign", certificationRequest);
        }
        return certificationRequest;
    }

    public void verify() throws IOException, SignatureException, NoSuchAlgorithmException {
        Signature signature = null;
        if (debug != null) {
            debug.entry(16384L, className, "verify");
        }
        try {
            if (((PKCSDerObject)this).provider != null) {
                try {
                    signature = Signature.getInstance(this.sigAlg.getName(), ((PKCSDerObject)this).provider);
                }
                catch (NoSuchProviderException noSuchProviderException) {
                    if (debug != null) {
                        debug.exception(16384L, className, "verify", noSuchProviderException);
                    }
                    throw new IOException("provider " + ((PKCSDerObject)this).provider + " not found " + noSuchProviderException);
                }
            } else {
                signature = Signature.getInstance(this.sigAlg.getName());
            }
            PublicKey publicKey = this.certReqInfo.getSubjectPublicKeyInfo();
            signature.initVerify(publicKey);
            byte[] byArray = this.getEncodedInfo();
            signature.update(byArray);
            if (!signature.verify(this.signature)) {
                if (debug != null) {
                    debug.text(16384L, className, "verify", "Invalid PKCS #10 signature");
                }
                throw new SignatureException("Invalid PKCS #10 signature");
            }
        }
        catch (InvalidKeyException invalidKeyException) {
            if (debug != null) {
                debug.exception(16384L, className, "verify", invalidKeyException);
            }
            throw new SignatureException("Invalid key");
        }
        if (debug != null) {
            debug.exit(16384L, className, "verify");
        }
    }

    public boolean equals(Object object) {
        DerValue derValue;
        DerValue derValue2;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", object);
        }
        if (this == object) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals", new Boolean(true));
            }
            return true;
        }
        if (!(object instanceof CertificationRequest)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals", new Boolean(false));
            }
            return false;
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encode(derOutputStream);
            derValue2 = new DerValue(derOutputStream.toByteArray());
            ((CertificationRequest)object).encode(derOutputStream2);
            derValue = new DerValue(derOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.text(16384L, className, "equals", "exception " + exception.toString());
            }
            return false;
        }
        if (!derValue2.equals(derValue)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals", new Boolean(false));
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals", new Boolean(true));
        }
        return true;
    }

    public int hashCode() {
        int n = 0;
        if (debug != null) {
            debug.entry(16384L, className, "hashCode");
        }
        if (this.signature != null) {
            for (int i = 1; i < this.signature.length; ++i) {
                n += this.signature[i] * i;
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "hashCode", new Integer(n));
        }
        return n;
    }

    public Object clone() {
        if (this.sigAlg == null || this.signature == null) {
            return new CertificationRequest(this.certReqInfo, ((PKCSDerObject)this).provider);
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            this.encode(derOutputStream);
            return new CertificationRequest(derOutputStream.toByteArray());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public CertificationRequestInfo getCertRequestInfo() {
        if (debug != null) {
            debug.entry(16384L, className, "getCertRequestInfo");
            debug.exit(16384L, (Object)className, "getCertRequestInfo", this.certReqInfo);
        }
        return this.certReqInfo;
    }

    public AlgorithmId getSignatureAlgorithm() {
        AlgorithmId algorithmId = null;
        if (debug != null) {
            debug.entry(16384L, className, "getSignatureAlgorithm");
        }
        algorithmId = new AlgorithmId(this.sigAlg.getOID(), ((PKCSDerObject)this).provider);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getSignatureAlgorithm", algorithmId);
        }
        return algorithmId;
    }

    public byte[] getSignature() {
        if (debug != null) {
            debug.entry(16384L, className, "getSignature");
        }
        if (this.signature == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getSignature", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getSignature", this.signature.clone());
        }
        return (byte[])this.signature.clone();
    }

    public void print(PrintStream printStream) throws IOException, SignatureException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "print", printStream);
        }
        if (this.signature == null) {
            if (debug != null) {
                debug.text(16384L, className, "print", "CertificationRequest was not signed.");
            }
            throw new SignatureException("CertificationRequest was not signed.");
        }
        byte[] byArray = this.encode();
        BASE64Encoder bASE64Encoder = new BASE64Encoder();
        try {
            printStream.write((BEGIN_REQUEST + "\r\n").getBytes("8859_1"));
        }
        catch (Exception exception) {
            printStream.write((BEGIN_REQUEST + "\r\n").getBytes());
        }
        bASE64Encoder.encodeBuffer(byArray, (OutputStream)printStream);
        try {
            printStream.write(END_REQUEST.getBytes("8859_1"));
        }
        catch (Exception exception) {
            printStream.write(END_REQUEST.getBytes());
        }
        if (debug != null) {
            debug.exit(16384L, className, "print");
        }
    }

    public String toString() {
        Object object;
        String string = null;
        try {
            string = this.certReqInfo.getSubjectPublicKeyInfo().toString();
        }
        catch (Exception exception) {
            string = "<UNAVAILABLE>";
        }
        String string2 = null;
        if (this.signature != null) {
            object = new HexDumpEncoder();
            string2 = ((CharacterEncoder)object).encodeBuffer(this.signature);
        }
        object = this.certReqInfo.getAttributes();
        return "[PKCS #10 certification request:\r\n\tsubject: <" + this.certReqInfo.getSubjectName() + ">" + "\r\n" + "\tpublic key info: " + string + "\r\n" + "\tattributes: " + ((PKCSAttributes)object).toString() + "\r\n" + "\talgorithm id: " + this.sigAlg + "\r\n" + "\tsignature:\r\n" + string2 + "\r\n]";
    }

    public void writeBASE64(String string) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        PrintStream printStream = new PrintStream(fileOutputStream);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "writeBASE64", string);
        }
        try {
            this.print(printStream);
            printStream.close();
        }
        catch (Exception exception) {
            printStream.close();
        }
        if (debug != null) {
            debug.exit(16384L, className, "writeBASE64");
        }
    }

    protected void decode(DerValue derValue) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", derValue);
        }
        if (derValue.getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "CertificationRequest parsing error");
            }
            throw new IOException("CertificationRequest parsing error");
        }
        DerInputStream derInputStream = new DerInputStream(derValue.toByteArray());
        DerValue[] derValueArray = derInputStream.getSequence(3);
        if (derValueArray.length != 3) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "CertificationRequest length error");
            }
            throw new IOException("CertificationRequest parsing error");
        }
        byte[] byArray = derValueArray[0].toByteArray();
        this.certReqInfo = new CertificationRequestInfo(byArray, ((PKCSDerObject)this).provider);
        this.sigAlg = AlgorithmId.parse(derValueArray[1]);
        this.signature = derValueArray[2].getBitString();
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    private byte[] getEncodedInfo() throws IOException {
        if (debug != null) {
            debug.entry(8192L, className, "getEncodedInfo");
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        this.certReqInfo.encode(derOutputStream);
        if (debug != null) {
            debug.exit(8192L, className, "getEncodedInfo");
        }
        return derOutputStream.toByteArray();
    }

    private void signThis(String string, PrivateKey privateKey) throws PKCSException, SignatureException {
        if (debug != null) {
            debug.entry(8192L, className, "signThis", string, privateKey);
        }
        if (string == null) {
            if (debug != null) {
                debug.text(8192L, className, "signThis", "digest must be specified.");
            }
            throw new IllegalArgumentException("digest must be specified.");
        }
        if (privateKey == null) {
            if (debug != null) {
                debug.text(8192L, className, "signThis", "key must be specified.");
            }
            throw new IllegalArgumentException("key must be specified.");
        }
        if (this.signature != null) {
            if (debug != null) {
                debug.text(8192L, className, "signThis", "Request is already signed.");
            }
            throw new SignatureException("Request is already signed.");
        }
        try {
            Object object;
            String string2 = null;
            int n = string.toUpperCase().indexOf("WITH");
            if (n == -1) {
                object = privateKey.getAlgorithm();
                string2 = string + "with" + (String)object;
            } else {
                string2 = string;
            }
            object = ((PKCSDerObject)this).provider != null ? Signature.getInstance(string2, ((PKCSDerObject)this).provider) : Signature.getInstance(string2);
            this.sigAlg = AlgorithmId.get(((Signature)object).getAlgorithm());
            ((Signature)object).initSign(privateKey);
            DerOutputStream derOutputStream = new DerOutputStream();
            this.certReqInfo.encode(derOutputStream);
            byte[] byArray = derOutputStream.toByteArray();
            ((Signature)object).update(byArray);
            this.signature = ((Signature)object).sign();
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(8192L, className, "signThis", exception);
            }
            throw new PKCSException(exception, "Error signing CertificateRequestInfo: " + exception.toString());
        }
        if (debug != null) {
            debug.exit(8192L, className, "signThis");
        }
    }

    protected void readBASE64(String string) throws IOException {
        FileInputStream fileInputStream;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "readBASE64", string);
        }
        try {
            fileInputStream = new FileInputStream(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (debug != null) {
                debug.exception(16384L, className, "readBASE64", fileNotFoundException);
            }
            throw new IOException("File " + string + " not found.");
        }
        int n = fileInputStream.available();
        byte[] byArray = new byte[n];
        fileInputStream.read(byArray);
        fileInputStream.close();
        String string2 = "\r\n";
        byte[] byArray2 = null;
        String string3 = null;
        try {
            byArray2 = string2.getBytes("8859_1");
            string3 = new String(byArray, "8859_1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray2 = string2.getBytes();
            string3 = new String(byArray);
        }
        StringReader stringReader = new StringReader(string3);
        BufferedReader bufferedReader = new BufferedReader(stringReader);
        String string4 = null;
        boolean bl = false;
        boolean bl2 = false;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
        while ((string4 = bufferedReader.readLine()) != null) {
            try {
                byteArrayOutputStream2.write(string4.getBytes("8859_1"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                byteArrayOutputStream2.write(string4.getBytes());
            }
            if (string4.equals(BEGIN_REQUEST)) {
                bl = true;
                continue;
            }
            if (string4.equals(END_REQUEST)) {
                bl2 = true;
                break;
            }
            if (!bl) continue;
            try {
                byteArrayOutputStream.write(string4.getBytes("8859_1"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                byteArrayOutputStream.write(string4.getBytes());
            }
            byteArrayOutputStream.write(byArray2);
        }
        ByteArrayInputStream byteArrayInputStream = null;
        if (!bl && !bl2) {
            byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream2.toByteArray());
        } else {
            if (!bl) {
                if (debug != null) {
                    debug.text(16384L, className, "readBASE64", "File did not include the following header: " + BEGIN_REQUEST);
                }
                throw new IOException("File did not include the following header: " + BEGIN_REQUEST);
            }
            if (!bl2) {
                if (debug != null) {
                    debug.text(16384L, className, "readBASE64", "File did not include the following footer: " + END_REQUEST);
                }
                throw new IOException("File did not include the following footer: " + END_REQUEST);
            }
            byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        }
        BASE64Decoder bASE64Decoder = new BASE64Decoder();
        byte[] byArray3 = bASE64Decoder.decodeBuffer(byteArrayInputStream);
        this.decode(byArray3);
        if (debug != null) {
            debug.exit(16384L, className, "readBASE64");
        }
    }
}

