/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs9;

import com.ibm.misc.Debug;
import com.ibm.security.pkcs9.PKCS9DerObject;
import com.ibm.security.pkcsutil.PKCSOID;
import com.ibm.security.pkcsutil.SmudgedChars;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import java.io.IOException;
import java.io.OutputStream;

public final class ChallengePassword
extends PKCS9DerObject
implements Cloneable {
    private SmudgedChars pwd;
    private byte type = (byte)19;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs9.ChallengePassWord";

    public ChallengePassword(byte[] byArray) throws IOException {
        super(byArray);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "ChallengePassword", (Object)byArray);
            debug.exit(16384L, className, "ChallengePassword");
        }
    }

    public ChallengePassword(byte[] byArray, String string) throws IOException {
        super(byArray, string);
        if (debug != null) {
            debug.entry(16384L, className, "ChallengePassword", byArray, string);
            debug.exit(16384L, className, "ChallengePassword");
        }
    }

    public ChallengePassword(char[] cArray) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "ChallengePassword", (Object)cArray);
        }
        this.setPasswordValue((char[])cArray.clone());
        this.type = (byte)19;
        if (debug != null) {
            debug.exit(16384L, className, "ChallengePassword");
        }
    }

    public ChallengePassword(char[] cArray, String string) {
        super(string);
        if (debug != null) {
            debug.entry(16384L, className, "ChallengePassword", cArray, string);
        }
        this.setPasswordValue((char[])cArray.clone());
        this.type = (byte)19;
        if (debug != null) {
            debug.exit(16384L, className, "ChallengePassword");
        }
    }

    public ChallengePassword(char[] cArray, byte by) {
        if (debug != null) {
            debug.entry(16384L, className, "ChallengePassword", cArray, new Byte(by));
        }
        this.setPasswordValue((char[])this.getPasswordValue().clone());
        if (by != 20 || by != 19) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "ChallengePassword", "tag " + by + " not valid.");
            }
            throw new IllegalArgumentException("tag " + by + " not valid.");
        }
        this.type = by;
        if (debug != null) {
            debug.exit(16384L, className, "ChallengePassword");
        }
    }

    public ChallengePassword(char[] cArray, byte by, String string) {
        super(string);
        if (debug != null) {
            Object[] objectArray = new Object[]{cArray, new Byte(by), string};
            debug.entry(16384L, (Object)className, "ChallengePassword", objectArray);
        }
        this.setPasswordValue((char[])this.getPasswordValue().clone());
        if (by != 20 || by != 19) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "ChallengePassword", "tag " + by + " not valid.");
            }
            throw new IllegalArgumentException("tag " + by + " not valid.");
        }
        this.type = by;
        if (debug != null) {
            debug.exit(16384L, className, "ChallengePassword");
        }
    }

    public ChallengePassword(String string, boolean bl) throws IOException {
        super(string, bl);
        if (debug != null) {
            debug.entry(16384L, className, "ChallengePassword", string, new Boolean(bl));
            debug.exit(16384L, className, "ChallengePassword");
        }
    }

    public ChallengePassword(String string, boolean bl, String string2) throws IOException {
        super(string, bl, string2);
        if (debug != null) {
            Object[] objectArray = new Object[]{string, new Boolean(bl), string2};
            debug.entry(16384L, (Object)className, "ChallengePassword", objectArray);
            debug.exit(16384L, className, "ChallengePassword");
        }
    }

    public Object clone() {
        if (debug != null) {
            debug.entry(16384L, className, "clone");
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            this.encode(derOutputStream);
            ChallengePassword challengePassword = new ChallengePassword(derOutputStream.toByteArray(), this.provider);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone", challengePassword);
            }
            return challengePassword;
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone", null);
            }
            return null;
        }
    }

    public boolean equals(Object object) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", object);
        }
        if (object instanceof ChallengePassword) {
            boolean bl = this.equals((ChallengePassword)object);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals", new Boolean(bl));
            }
            return bl;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals", new Boolean(false));
        }
        return false;
    }

    public ObjectIdentifier getObjectIdentifier() {
        if (debug != null) {
            debug.entry(16384L, className, "getObjectIdentifier");
            debug.exit(16384L, (Object)className, "getObjectIdentifier", PKCSOID.CHALLENGE_PASSWORD_OID);
        }
        return PKCSOID.CHALLENGE_PASSWORD_OID;
    }

    public void encode(OutputStream outputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", outputStream);
        }
        if (this.getPasswordValue() == null) {
            if (debug != null) {
                debug.text(16384L, className, "encode", "Password not specified.");
            }
            throw new IOException("Password not specified.");
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream.putOID(this.getObjectIdentifier());
        if (this.type == 20) {
            derOutputStream2.putPrintableString(this.getPasswordValue());
        } else {
            derOutputStream2.putPrintableString(this.getPasswordValue());
        }
        derOutputStream.write((byte)49, derOutputStream2.toByteArray());
        DerOutputStream derOutputStream3 = new DerOutputStream();
        derOutputStream3.write((byte)48, derOutputStream.toByteArray());
        outputStream.write(derOutputStream3.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public char[] getPassword() {
        if (debug != null) {
            debug.entry(16384L, className, "getPassword");
            debug.exit(16384L, (Object)className, "getPassword", this.getPasswordValue().clone());
        }
        return (char[])this.getPasswordValue().clone();
    }

    public byte getType() {
        if (debug != null) {
            debug.entry(16384L, className, "getType");
            debug.exit(16384L, (Object)className, "getType", new Byte(this.type));
        }
        return this.type;
    }

    public Object getValue() {
        if (debug != null) {
            debug.entry(16384L, className, "getPasswordValue");
            debug.exit(16384L, (Object)className, "getPasswordValue", this.getPasswordValue());
        }
        return this.getPasswordValue();
    }

    public boolean isTagValid(byte by) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "isTagValid", new Byte(by));
        }
        if (by == 19 || by == 20) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "isTagValid", new Boolean(true));
            }
            return true;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "isTagValid", new Boolean(false));
        }
        return false;
    }

    public boolean isSingleValued() {
        if (debug != null) {
            debug.entry(16384L, className, "isSingleValued");
            debug.exit(16384L, (Object)className, "isSingleValued", new Boolean(true));
        }
        return true;
    }

    public String getAttributeName() {
        if (debug != null) {
            debug.entry(16384L, className, "getAttributeName");
            debug.exit(16384L, (Object)className, "getAttributeName", "ChallengePassword");
        }
        return "ChallengePassword";
    }

    public String toString() {
        String string = "PKCS9 ChallengePassword:\r\n";
        string = this.getPasswordValue() != null ? string + "\t<NOT SHOWN>\r\n" : string + "\tnull\r\n";
        string = this.type == 20 ? string + "\tEncoded in T61String\r\n" : string + "\tEncoded in PrintableString\r\n";
        return string;
    }

    protected void decode(DerValue derValue) throws IOException {
        super.decode(derValue);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", derValue);
        }
        DerValue[] derValueArray = null;
        if (derValue.getTag() == 48) {
            DerInputStream derInputStream = new DerInputStream(derValue.toByteArray());
            DerValue[] derValueArray2 = derInputStream.getSequence(2);
            derValueArray = new DerInputStream(derValueArray2[1].toByteArray()).getSet(1);
        } else {
            derValueArray = new DerInputStream(derValue.toByteArray()).getSet(1);
        }
        if (derValueArray[0].getTag() == 20) {
            this.setPasswordValue(derValueArray[0].getAsString().toCharArray());
            this.type = (byte)20;
            if (debug != null) {
                debug.exit(16384L, className, "decode");
            }
            return;
        }
        if (derValueArray[0].getTag() == 19) {
            this.setPasswordValue(derValueArray[0].getAsString().toCharArray());
            this.type = (byte)19;
            if (debug != null) {
                debug.exit(16384L, className, "decode");
            }
            return;
        }
        if (debug != null) {
            debug.text(16384L, className, "decode", "tag " + derValueArray[0].getTag() + " not valid.");
        }
        throw new IOException("tag " + derValueArray[0].getTag() + " not valid.");
    }

    private void setPasswordValue(char[] cArray) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setPasswordValue", (Object)cArray);
            debug.exit(8192L, className, "setPasswordValue");
        }
        this.pwd = new SmudgedChars(cArray, this.provider);
    }

    private char[] getPasswordValue() {
        if (debug != null) {
            debug.entry(8192L, className, "getPasswordValue");
        }
        if (this.pwd == null) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "getPasswordValue", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "getPasswordValue", "password in clear text");
        }
        return this.pwd.getClearText();
    }

    protected void finalize() {
        this.pwd = null;
    }

    private boolean equals(ChallengePassword challengePassword) {
        DerValue derValue;
        DerValue derValue2;
        if (debug != null) {
            debug.entry(8192L, (Object)className, "equals", challengePassword);
        }
        if (challengePassword == this) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "equals", new Boolean(true));
            }
            return true;
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encode(derOutputStream);
            derValue2 = new DerValue(derOutputStream.toByteArray());
            challengePassword.encode(derOutputStream2);
            derValue = new DerValue(derOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(8192L, className, "equals", exception);
                debug.exit(8192L, (Object)className, "equals", new Boolean(false));
            }
            return false;
        }
        if (!derValue2.equals(derValue)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "equals", new Boolean(false));
            }
            return false;
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "equals", new Boolean(true));
        }
        return true;
    }
}

