/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.tools;

import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.pkcs12.CertBag;
import com.ibm.security.pkcs12.KeyBag;
import com.ibm.security.pkcs12.PKCS12PFX;
import com.ibm.security.pkcs12.SafeBag;
import com.ibm.security.pkcs12.ShroudedKeyBag;
import com.ibm.security.pkcs8.EncryptedPrivateKeyInfo;
import com.ibm.security.pkcs8.PrivateKeyInfo;
import com.ibm.security.pkcsutil.PKCSAttribute;
import com.ibm.security.pkcsutil.PKCSDerObject;
import com.ibm.security.pkcsutil.PKCSOID;
import com.ibm.security.x509.X509CertImpl;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.cert.Certificate;
import java.util.Vector;

public class genPKCS12PFX {
    static final int CERT = 1;
    static final int KEY = 2;
    static final int SKEY = 3;
    static final int PWD = 4;
    static final int MAC = 5;

    public static void main(String[] stringArray) {
        String string = "40BitRC2";
        char[] cArray = null;
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        boolean bl4 = true;
        boolean bl5 = false;
        String string2 = "genPKCS12PFX.p12";
        HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
        System.out.println("Creating PFX from input files.");
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        if (stringArray.length < 4) {
            genPKCS12PFX.usage();
            System.exit(1);
        }
        try {
            PKCSDerObject[] pKCSDerObjectArray;
            PKCSDerObject pKCSDerObject;
            Object object;
            Object object2;
            Object object3;
            Object object4;
            String string3;
            Object object5;
            Object object6;
            int n;
            X509CertImpl x509CertImpl = null;
            int n2 = 1;
            block15: for (n = 0; n < stringArray.length; ++n) {
                object6 = stringArray[n];
                if (((String)object6).equals("-c")) {
                    n2 = 1;
                    ++n;
                }
                if (((String)object6).equals("-k")) {
                    n2 = 2;
                    ++n;
                }
                if (((String)object6).equals("-s")) {
                    n2 = 3;
                    ++n;
                }
                if (((String)object6).equals("-p")) {
                    n2 = 4;
                    ++n;
                }
                if (((String)object6).equals("-m")) {
                    n2 = 5;
                    ++n;
                }
                switch (n2) {
                    case 1: {
                        System.out.println("Adding " + stringArray[n] + " to cert files");
                        vector.add(stringArray[n]);
                        bl2 = false;
                        continue block15;
                    }
                    case 2: {
                        System.out.println("Adding " + stringArray[n] + " to key files");
                        vector2.add(stringArray[n]);
                        bl3 = false;
                        continue block15;
                    }
                    case 3: {
                        System.out.println("Adding " + stringArray[n] + " to shrouded key files");
                        vector3.add(stringArray[n]);
                        bl4 = false;
                        continue block15;
                    }
                    case 4: {
                        string = stringArray[n];
                        object5 = "PBEWithSHAAnd" + string;
                        System.out.println("Algorithm to protect PFX is " + (String)object5);
                        bl5 = true;
                        continue block15;
                    }
                    case 5: {
                        cArray = stringArray[n].toCharArray();
                        bl = false;
                        System.out.println("Using password \"" + stringArray[n] + "\" for PFX integrity and protection");
                    }
                }
            }
            if (bl5 && bl) {
                System.out.println("ERROR: Password must be specified!");
                genPKCS12PFX.usage();
                System.exit(1);
            }
            if (bl2 && bl3 && bl4) {
                System.out.println("ERROR: Must specify at least one certificate, key or shrouded key file!");
                genPKCS12PFX.usage();
                System.exit(1);
            }
            System.out.print("Got the following cert files: ");
            for (n = 0; n < vector.size(); ++n) {
                object6 = (String)vector.elementAt(n);
                System.out.print((String)object6 + " ");
            }
            System.out.println("\r\n");
            System.out.print("Got the following key files: ");
            for (n = 0; n < vector2.size(); ++n) {
                object6 = (String)vector2.elementAt(n);
                System.out.print((String)object6 + " ");
            }
            System.out.println("\r\n");
            System.out.print("Got the following shrouded key files: ");
            for (n = 0; n < vector3.size(); ++n) {
                object6 = (String)vector3.elementAt(n);
                System.out.print((String)object6 + " ");
            }
            System.out.println("\r\n");
            object6 = new Vector();
            object5 = new Vector();
            Vector<byte[]> vector4 = new Vector<byte[]>();
            if (vector.size() > 0) {
                System.out.println("Creating CertBags");
            }
            for (n = 0; n < vector.size(); ++n) {
                string3 = (String)vector.elementAt(n);
                try {
                    object4 = new FileInputStream(string3);
                    x509CertImpl = new X509CertImpl((InputStream)object4);
                    object3 = new CertBag(x509CertImpl);
                    ((Vector)object6).add(object3);
                    continue;
                }
                catch (Exception exception) {
                    System.out.println("Couldn't create CertBag from " + string3);
                    exception.printStackTrace();
                }
            }
            if (vector2.size() > 0) {
                System.out.println("Creating KeyBags");
            }
            for (n = 0; n < vector2.size(); ++n) {
                string3 = (String)vector2.elementAt(n);
                try {
                    object4 = new FileInputStream(string3);
                    object3 = new byte[((FileInputStream)object4).available()];
                    ((FileInputStream)object4).read((byte[])object3);
                    object2 = new PrivateKeyInfo((byte[])object3);
                    object = new KeyBag((PrivateKeyInfo)object2);
                    ((Vector)object5).add(object);
                    continue;
                }
                catch (Exception exception) {
                    System.out.println("Couldn't create KeyBag from " + string3);
                    exception.printStackTrace();
                }
            }
            if (vector3.size() > 0) {
                System.out.println("Creating ShroudedKeyBags");
            }
            for (n = 0; n < vector3.size(); ++n) {
                string3 = (String)vector3.elementAt(n);
                try {
                    object4 = new FileInputStream(string3);
                    object3 = new byte[((FileInputStream)object4).available()];
                    ((FileInputStream)object4).read((byte[])object3);
                    object2 = new EncryptedPrivateKeyInfo((byte[])object3);
                    object = new ShroudedKeyBag((EncryptedPrivateKeyInfo)object2);
                    vector4.add((byte[])object);
                    continue;
                }
                catch (Exception exception) {
                    System.out.println("Couldn't create ShroudedKeyBag from " + string3);
                    exception.printStackTrace();
                }
            }
            object3 = MessageDigest.getInstance("SHA1");
            object2 = ((Certificate)x509CertImpl).getPublicKey();
            ((MessageDigest)object3).update(object2.getEncoded());
            object = ((MessageDigest)object3).digest();
            Vector<PKCSDerObject> vector5 = new Vector<PKCSDerObject>();
            for (n = 0; n < ((Vector)object6).size(); ++n) {
                pKCSDerObject = new SafeBag((CertBag)((Vector)object6).elementAt(n), null);
                pKCSDerObjectArray = new PKCSAttribute[2];
                object4 = "IBM test cert " + n;
                pKCSDerObjectArray[0] = new PKCSAttribute(PKCSOID.FRIENDLY_NAME_OID, object4);
                pKCSDerObjectArray[1] = new PKCSAttribute(PKCSOID.LOCAL_KEY_ID_OID, object);
                ((SafeBag)pKCSDerObject).addAttributes((PKCSAttribute[])pKCSDerObjectArray);
                vector5.add(pKCSDerObject);
            }
            for (n = 0; n < ((Vector)object5).size(); ++n) {
                pKCSDerObject = new SafeBag((KeyBag)((Vector)object5).elementAt(n), null);
                pKCSDerObjectArray = new PKCSAttribute[2];
                object4 = "IBM test key " + n;
                pKCSDerObjectArray[0] = new PKCSAttribute(PKCSOID.FRIENDLY_NAME_OID, object4);
                pKCSDerObjectArray[1] = new PKCSAttribute(PKCSOID.LOCAL_KEY_ID_OID, object);
                ((SafeBag)pKCSDerObject).addAttributes((PKCSAttribute[])pKCSDerObjectArray);
                vector5.add(pKCSDerObject);
            }
            for (n = 0; n < vector4.size(); ++n) {
                pKCSDerObject = new SafeBag((ShroudedKeyBag)vector4.elementAt(n), null);
                vector5.add(pKCSDerObject);
            }
            pKCSDerObject = new PKCS12PFX();
            for (n = 0; n < vector5.size(); ++n) {
                pKCSDerObjectArray = new SafeBag[]{(SafeBag)vector5.elementAt(n)};
                if (bl5) {
                    ((PKCS12PFX)pKCSDerObject).addSafeBagsWithPasswordPrivacy((SafeBag[])pKCSDerObjectArray, string, cArray);
                    continue;
                }
                ((PKCS12PFX)pKCSDerObject).addSafeBags((SafeBag[])pKCSDerObjectArray);
            }
            if (bl) {
                System.out.println("No data integrity applied.");
            } else {
                System.out.println("Applying HMAC (password integrity)");
                ((PKCS12PFX)pKCSDerObject).applyMac(cArray);
            }
            System.out.println("Writing PFX to file " + string2);
            pKCSDerObject.write(string2, false);
        }
        catch (Exception exception) {
            System.out.println("ERROR: " + exception.toString());
            exception.printStackTrace();
        }
    }

    private static void usage() {
        System.out.println("Usage: genPKCS12PFX [-m mac_pwd] [-c cf1 cf2...] [-k kf1 kf2...] [-s skf1 skf2...] [-p alg]");
        System.out.println("  where -m is followed by the HMAC password");
        System.out.println("        -c is followed by one or more cert files");
        System.out.println("        -k is followed by one or more key files");
        System.out.println("        -s is followed by one or more shrouded key files");
        System.out.println("        -p is followed by the algorithm used for bag privacy, e.g. 40BitRC2,");
        System.out.println("           128BitRC2, 40BitRC4, 128BitRC4, 2KeyTripleDES or 3KeyTripleDES.");
        System.out.println("           If not specified, no bag privacy is used.");
        System.out.println("  at least one of -c, -s or -k must be specified");
        System.out.println("  if -p is specified, then -m must be specified");
    }
}

