/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.tools;

import com.ibm.security.pkcs7.Content;
import com.ibm.security.pkcs7.ContentInfo;
import com.ibm.security.pkcs7.SignedData;
import com.ibm.security.x509.X509CRLImpl;
import java.io.FileInputStream;
import java.security.cert.CRL;
import java.security.cert.CRLException;

public class parseCRLs {
    public static void main(String[] stringArray) throws Throwable {
        if (stringArray.length < 1) {
            System.out.println("usage: parseCRLs CRLFile [CRLFile CRLFile ...]");
        }
        for (int i = 0; i < stringArray.length; ++i) {
            X509CRLImpl x509CRLImpl = null;
            try {
                FileInputStream fileInputStream = new FileInputStream(stringArray[i]);
                x509CRLImpl = new X509CRLImpl(fileInputStream);
                fileInputStream.close();
                System.out.println(x509CRLImpl);
                continue;
            }
            catch (CRLException cRLException) {
                cRLException.printStackTrace();
                ContentInfo contentInfo = new ContentInfo(stringArray[i], false);
                if (contentInfo.isSignedData()) {
                    Content content = contentInfo.getContent();
                    SignedData signedData = (SignedData)content;
                    CRL[] cRLArray = signedData.getCRLs();
                    if (cRLArray != null && cRLArray.length != 0) {
                        for (int j = 0; j < cRLArray.length; ++j) {
                            CRL cRL = cRLArray[j];
                            System.out.println(cRL);
                        }
                        continue;
                    }
                    System.out.println("No CRLs in object");
                    continue;
                }
                System.out.println("Unknown format");
            }
        }
    }
}

