/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.PKIXExtensions;
import com.ibm.security.x509.Qualifier;
import java.io.IOException;
import java.io.OutputStream;

public final class CPSuri
implements Qualifier,
Cloneable {
    private ObjectIdentifier oid = PKIXExtensions.CPSuri_Id;
    private String value;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.X509.CPSuri";

    public CPSuri(String string) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "CPSuri", string);
            debug.exit(16384L, className, "CPSuri");
        }
        this.value = string;
    }

    public CPSuri(byte[] byArray) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "CPSuri", (Object)byArray);
        }
        DerInputStream derInputStream = new DerInputStream(byArray);
        DerValue derValue = derInputStream.getDerValue();
        this.decode(derValue);
        if (debug != null) {
            debug.exit(16384L, className, "CPSuri");
        }
    }

    public void encode(OutputStream outputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", outputStream);
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        derOutputStream.putIA5String(this.value);
        outputStream.write(derOutputStream.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public ObjectIdentifier getObjectIdentifier() {
        if (debug != null) {
            debug.entry(16384L, className, "getObjectIdentifier");
            debug.exit(16384L, (Object)className, "getObjectIdentifier", PKIXExtensions.CPSuri_Id);
        }
        return PKIXExtensions.CPSuri_Id;
    }

    public String getName() {
        if (debug != null) {
            debug.entry(16384L, className, "getName");
            debug.exit(16384L, (Object)className, "getName", "CPSuri");
        }
        return "CPSuri";
    }

    public Object clone() {
        try {
            if (debug != null) {
                debug.entry(16384L, className, "clone");
            }
            DerOutputStream derOutputStream = new DerOutputStream();
            this.encode(derOutputStream);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone_1", new CPSuri(derOutputStream.toByteArray()));
            }
            return new CPSuri(derOutputStream.toByteArray());
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "clone", exception);
                debug.exit(16384L, (Object)className, "clone_2", null);
            }
            return null;
        }
    }

    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        String string = "CPSuri: [";
        string = string + "\r\n\tobject identifier: " + this.oid;
        string = string + "\r\n\turi: " + this.value.toString();
        string = string + "]\r\n";
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", string);
        }
        return string;
    }

    public boolean equals(Object object) {
        DerValue derValue;
        DerValue derValue2;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", object);
        }
        if (!(object instanceof CPSuri)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", false);
            }
            return false;
        }
        if (object == this) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_2", true);
            }
            return true;
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encode(derOutputStream);
            derValue2 = new DerValue(derOutputStream.toByteArray());
            ((CPSuri)object).encode(derOutputStream2);
            derValue = new DerValue(derOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "equals", exception);
                debug.exit(16384L, (Object)className, "equals_3", false);
            }
            return false;
        }
        if (!derValue2.equals(derValue)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_4", false);
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals_5", true);
        }
        return true;
    }

    protected void decode(DerValue derValue) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", derValue);
        }
        this.value = derValue.getIA5String();
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }
}

