/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AttributeNameEnumeration;
import com.ibm.security.x509.CertAttrSet;
import com.ibm.security.x509.UniqueIdentity;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;

public final class CertificateIssuerUniqueIdentity
implements CertAttrSet {
    private UniqueIdentity id;
    public static final String IDENT = "x509.info.issuerID";
    public static final String NAME = "issuerID";
    public static final String ID = "id";
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.CertificateIssuerUniqueIdentity";

    public CertificateIssuerUniqueIdentity(UniqueIdentity uniqueIdentity) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "CertificateIssuerUniqueIdentity", uniqueIdentity);
            debug.exit(16384L, className, "CertificateIssuerUniqueIdentity");
        }
        this.id = uniqueIdentity;
    }

    public CertificateIssuerUniqueIdentity(DerInputStream derInputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "CertificateIssuerUniqueIdentity", derInputStream);
        }
        this.id = new UniqueIdentity(derInputStream);
        if (debug != null) {
            debug.exit(16384L, className, "CertificateIssuerUniqueIdentity");
        }
    }

    public CertificateIssuerUniqueIdentity(InputStream inputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "CertificateIssuerUniqueIdentity", inputStream);
        }
        DerValue derValue = new DerValue(inputStream);
        this.id = new UniqueIdentity(derValue);
        if (debug != null) {
            debug.exit(16384L, className, "CertificateIssuerUniqueIdentity");
        }
    }

    public CertificateIssuerUniqueIdentity(DerValue derValue) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "CertificateIssuerUniqueIdentity", derValue);
        }
        this.id = new UniqueIdentity(derValue);
        if (debug != null) {
            debug.exit(16384L, className, "CertificateIssuerUniqueIdentity");
        }
    }

    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        if (this.id == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "toString_1", "");
            }
            return "";
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString_2", this.id.toString());
        }
        return this.id.toString();
    }

    public void decode(InputStream inputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", inputStream);
            debug.text(16384L, className, "decode", "Method not to be called directly.");
        }
        throw new IOException("Method not to be called directly.");
    }

    public void encode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", outputStream);
        }
        this.id.encode(derOutputStream, DerValue.createTag((byte)-128, false, (byte)1));
        outputStream.write(derOutputStream.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public void set(String string, Object object) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "set", string, object);
        }
        if (!(object instanceof UniqueIdentity)) {
            if (debug != null) {
                debug.text(16384L, className, "set", "Attribute must be of type UniqueIdentity.");
            }
            throw new IOException("Attribute must be of type UniqueIdentity.");
        }
        if (!string.equalsIgnoreCase(ID)) {
            if (debug != null) {
                debug.text(16384L, className, "set", "Attribute name not recognized by CertAttrSet: CertificateIssuerUniqueIdentity.");
            }
            throw new IOException("Attribute name not recognized by CertAttrSet: CertificateIssuerUniqueIdentity.");
        }
        this.id = (UniqueIdentity)object;
        if (debug != null) {
            debug.exit(16384L, className, "set");
        }
    }

    public Object get(String string) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "get", string);
        }
        if (string.equalsIgnoreCase(ID)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "get", this.id);
            }
            return this.id;
        }
        if (debug != null) {
            debug.text(16384L, className, "get", "Attribute name not recognized by CertAttrSet: CertificateIssuerUniqueIdentity.");
        }
        throw new IOException("Attribute name not recognized by CertAttrSet: CertificateIssuerUniqueIdentity.");
    }

    public void delete(String string) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "delete", string);
        }
        if (!string.equalsIgnoreCase(ID)) {
            if (debug != null) {
                debug.text(16384L, className, "delete", "Attribute name not recognized by CertAttrSet: CertificateIssuerUniqueIdentity.");
            }
            throw new IOException("Attribute name not recognized by CertAttrSet: CertificateIssuerUniqueIdentity.");
        }
        this.id = null;
        if (debug != null) {
            debug.exit(16384L, className, "delete");
        }
    }

    public Enumeration getElements() {
        if (debug != null) {
            debug.entry(16384L, className, "getElements");
        }
        AttributeNameEnumeration attributeNameEnumeration = new AttributeNameEnumeration();
        attributeNameEnumeration.addElement(ID);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getElements", attributeNameEnumeration.elements());
        }
        return attributeNameEnumeration.elements();
    }

    public String getName() {
        if (debug != null) {
            debug.entry(16384L, className, "getName");
            debug.exit(16384L, (Object)className, "getName", NAME);
        }
        return NAME;
    }
}

