/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.CPSuri;
import com.ibm.security.x509.PKIXExtensions;
import com.ibm.security.x509.Qualifier;
import com.ibm.security.x509.UserNotice;
import java.io.IOException;
import java.io.OutputStream;

public final class PolicyQualifierInfo
implements Cloneable {
    private Qualifier qualifier;
    private ObjectIdentifier oid;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.PolicyQualifierInfo";

    public PolicyQualifierInfo(byte[] byArray) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "PolicyQualifierInfo", (Object)byArray);
        }
        DerInputStream derInputStream = new DerInputStream(byArray);
        DerValue derValue = derInputStream.getDerValue();
        this.decode(derValue);
        if (debug != null) {
            debug.exit(16384L, className, "PolicyQualifierInfo");
        }
    }

    public PolicyQualifierInfo(Qualifier qualifier) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "PolicyQualifierInfo", qualifier);
        }
        if (qualifier == null) {
            if (debug != null) {
                debug.text(16384L, className, "PolicyQualifierInfo", "qualifier not specified.");
            }
            throw new IllegalArgumentException("qualifier not specified.");
        }
        this.qualifier = qualifier;
        this.oid = qualifier.getObjectIdentifier();
        if (debug != null) {
            debug.exit(16384L, className, "PolicyQualifierInfo");
        }
    }

    public void encode(OutputStream outputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", outputStream);
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream.putOID(this.oid);
        if (this.qualifier instanceof CPSuri) {
            ((CPSuri)this.qualifier).encode(derOutputStream);
        } else {
            ((UserNotice)this.qualifier).encode(derOutputStream);
        }
        derOutputStream2.write((byte)48, derOutputStream);
        outputStream.write(derOutputStream2.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public ObjectIdentifier getObjectIdentifier() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "getObjectIdentifier");
            debug.exit(16384L, (Object)className, "getObjectIdentifier", this.oid);
        }
        return this.oid;
    }

    public Qualifier getQualifier() {
        if (debug != null) {
            debug.entry(16384L, className, "getQualifier");
            debug.exit(16384L, (Object)className, "getQualifier", this.qualifier);
        }
        return this.qualifier;
    }

    public Object clone() {
        try {
            if (debug != null) {
                debug.entry(16384L, className, "clone");
            }
            DerOutputStream derOutputStream = new DerOutputStream();
            this.encode(derOutputStream);
            PolicyQualifierInfo policyQualifierInfo = new PolicyQualifierInfo(derOutputStream.toByteArray());
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone_1", policyQualifierInfo);
            }
            return policyQualifierInfo;
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "clone", exception);
                debug.exit(16384L, (Object)className, "clone_2", null);
            }
            return null;
        }
    }

    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        String string = "";
        HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
        string = string + "PolicyQualifierInfo: [\r\n";
        if (this.qualifier != null) {
            string = string + this.qualifier.toString();
        }
        string = string + "]\r\n";
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", string);
        }
        return string;
    }

    public boolean equals(Object object) {
        DerValue derValue;
        DerValue derValue2;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", object);
        }
        if (!(object instanceof PolicyQualifierInfo)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", false);
            }
            return false;
        }
        if (object == this) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_2", true);
            }
            return true;
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encode(derOutputStream);
            derValue2 = new DerValue(derOutputStream.toByteArray());
            ((PolicyQualifierInfo)object).encode(derOutputStream2);
            derValue = new DerValue(derOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "equals", exception);
                debug.exit(16384L, (Object)className, "equals_3", false);
            }
            return false;
        }
        if (!derValue2.equals(derValue)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_4", false);
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals_5", true);
        }
        return true;
    }

    protected void decode(DerValue derValue) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", derValue);
        }
        if (derValue.getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "PolicyQualifierInfo parsing error, not a SEQUENCE");
            }
            throw new IOException("PolicyQualifierInfo parsing error, not a SEQUENCE");
        }
        this.oid = derValue.getData().getOID();
        DerValue derValue2 = derValue.getData().getDerValue();
        byte[] byArray = derValue2.toByteArray();
        this.qualifier = this.oid.equals(PKIXExtensions.CPSuri_Id) ? new CPSuri(byArray) : (this.oid.equals(PKIXExtensions.UserNotice_Id) ? new UserNotice(byArray) : null);
        if (derValue.getData().available() != 0) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "PolicyQualifierInfo parsing error - data overrun, bytes = " + derValue.getData().available());
            }
            throw new IOException("PolicyQualifierInfo parsing error - data overrun, bytes = " + derValue.getData().available());
        }
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }
}

