/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import com.sun.java.swing.plaf.gtk.Region;
import com.sun.java.swing.plaf.gtk.SynthContext;
import com.sun.java.swing.plaf.gtk.SynthLookAndFeel;
import com.sun.java.swing.plaf.gtk.SynthStyle;
import com.sun.java.swing.plaf.gtk.SynthUI;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.TransferHandler;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.colorchooser.ColorChooserComponentFactory;
import javax.swing.colorchooser.ColorSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ColorChooserUI;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;

class SynthColorChooserUI
extends ColorChooserUI
implements SynthUI {
    private static final LayoutManager PANEL_LAYOUT = new CenterLayout();
    private SynthStyle style;
    JColorChooser chooser;
    JTabbedPane tabbedPane;
    JPanel singlePanel;
    JPanel previewPanelHolder;
    JComponent previewPanel;
    MouseListener previewMouseListener;
    boolean isMultiPanel = false;
    private static TransferHandler defaultTransferHandler = new ColorTransferHandler();
    protected AbstractColorChooserPanel[] defaultChoosers;
    protected ChangeListener previewListener;
    protected PropertyChangeListener propertyChangeListener;

    SynthColorChooserUI() {
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new SynthColorChooserUI();
    }

    protected AbstractColorChooserPanel[] createDefaultChoosers(SynthContext synthContext) {
        AbstractColorChooserPanel[] abstractColorChooserPanelArray = (AbstractColorChooserPanel[])synthContext.getStyle().get(synthContext, "ColorChooser.panels");
        if (abstractColorChooserPanelArray == null) {
            abstractColorChooserPanelArray = ColorChooserComponentFactory.getDefaultChooserPanels();
        }
        return abstractColorChooserPanelArray;
    }

    protected void uninstallDefaultChoosers() {
        for (int i = 0; i < this.defaultChoosers.length; ++i) {
            this.chooser.removeChooserPanel(this.defaultChoosers[i]);
        }
    }

    public void installUI(JComponent jComponent) {
        this.chooser = (JColorChooser)jComponent;
        super.installUI(jComponent);
        this.installDefaults();
        this.installListeners();
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.setName("ColorChooser.tabPane");
        this.singlePanel = new JPanel(new CenterLayout());
        this.singlePanel.setName("ColorChooser.panel");
        this.chooser.setLayout(PANEL_LAYOUT);
        SynthContext synthContext = this.getContext(jComponent, 1);
        this.defaultChoosers = this.createDefaultChoosers(synthContext);
        synthContext.dispose();
        this.chooser.setChooserPanels(this.defaultChoosers);
        this.previewPanelHolder = new JPanel(PANEL_LAYOUT);
        this.previewPanelHolder.setName("ColorChooser.previewPanelHolder");
        this.chooser.add((Component)this.previewPanelHolder, "South");
        this.previewMouseListener = new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (SynthColorChooserUI.this.chooser.getDragEnabled()) {
                    TransferHandler transferHandler = SynthColorChooserUI.this.chooser.getTransferHandler();
                    transferHandler.exportAsDrag(SynthColorChooserUI.this.chooser, mouseEvent, 1);
                }
            }
        };
        this.installPreviewPanel();
        this.chooser.applyComponentOrientation(jComponent.getComponentOrientation());
    }

    public void uninstallUI(JComponent jComponent) {
        this.chooser.remove(this.tabbedPane);
        this.chooser.remove(this.singlePanel);
        this.chooser.remove(this.previewPanelHolder);
        this.uninstallListeners();
        this.uninstallDefaultChoosers();
        this.uninstallDefaults();
        this.previewPanelHolder.remove(this.previewPanel);
        if (this.previewPanel instanceof UIResource) {
            this.chooser.setPreviewPanel(null);
        }
        this.previewPanelHolder = null;
        this.previewPanel = null;
        this.defaultChoosers = null;
        this.chooser = null;
        this.tabbedPane = null;
    }

    protected void installPreviewPanel() {
        if (this.previewPanel != null) {
            this.previewPanelHolder.remove(this.previewPanel);
            this.previewPanel.removeMouseListener(this.previewMouseListener);
        }
        this.previewPanel = this.chooser.getPreviewPanel();
        if (this.previewPanel != null && this.previewPanelHolder != null && this.chooser != null && this.previewPanel.getSize().getHeight() + this.previewPanel.getSize().getWidth() == 0.0) {
            this.chooser.remove(this.previewPanelHolder);
            return;
        }
        if (this.previewPanel == null || this.previewPanel instanceof UIResource) {
            this.previewPanel = ColorChooserComponentFactory.getPreviewPanel();
            this.chooser.setPreviewPanel(this.previewPanel);
        }
        this.previewPanel.setForeground(this.chooser.getColor());
        this.previewPanelHolder.add(this.previewPanel);
        this.previewPanel.addMouseListener(this.previewMouseListener);
    }

    protected void installDefaults() {
        this.fetchStyle(this.chooser);
        TransferHandler transferHandler = this.chooser.getTransferHandler();
        if (transferHandler == null || transferHandler instanceof UIResource) {
            this.chooser.setTransferHandler(defaultTransferHandler);
        }
    }

    private void fetchStyle(JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent, 1);
        this.style = SynthLookAndFeel.updateStyle(synthContext, this);
        synthContext.dispose();
    }

    protected void uninstallDefaults() {
        SynthContext synthContext = this.getContext(this.chooser, 1);
        this.style.uninstallDefaults(synthContext);
        synthContext.dispose();
        if (this.chooser.getTransferHandler() instanceof UIResource) {
            this.chooser.setTransferHandler(null);
        }
        this.style = null;
    }

    protected void installListeners() {
        this.propertyChangeListener = this.createPropertyChangeListener();
        this.chooser.addPropertyChangeListener(this.propertyChangeListener);
        this.previewListener = new PreviewListener();
        this.chooser.getSelectionModel().addChangeListener(this.previewListener);
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyHandler();
    }

    protected void uninstallListeners() {
        this.chooser.removePropertyChangeListener(this.propertyChangeListener);
        this.chooser.getSelectionModel().removeChangeListener(this.previewListener);
        this.previewPanel.removeMouseListener(this.previewMouseListener);
    }

    public SynthContext getContext(JComponent jComponent) {
        return this.getContext(jComponent, this.getComponentState(jComponent));
    }

    private SynthContext getContext(JComponent jComponent, int n) {
        return SynthContext.getContext(SynthContext.class, jComponent, SynthLookAndFeel.getRegion(jComponent), this.style, n);
    }

    private Region getRegion(JComponent jComponent) {
        return SynthLookAndFeel.getRegion(jComponent);
    }

    private int getComponentState(JComponent jComponent) {
        return SynthLookAndFeel.getComponentState(jComponent);
    }

    public void update(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        SynthLookAndFeel.update(synthContext, graphics);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    protected void paint(SynthContext synthContext, Graphics graphics) {
    }

    static class CenterLayout
    implements LayoutManager,
    Serializable {
        CenterLayout() {
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension preferredLayoutSize(Container container) {
            Component component = container.getComponent(0);
            if (component != null) {
                Dimension dimension = component.getPreferredSize();
                Insets insets = container.getInsets();
                return new Dimension(dimension.width + insets.left + insets.right, dimension.height + insets.top + insets.bottom);
            }
            return new Dimension(0, 0);
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        public void layoutContainer(Container container) {
            if (container.getComponentCount() > 0) {
                Component component = container.getComponent(0);
                Dimension dimension = component.getPreferredSize();
                int n = container.getWidth();
                int n2 = container.getHeight();
                Insets insets = container.getInsets();
                int n3 = ((n -= insets.left + insets.right) - dimension.width) / 2 + insets.left;
                int n4 = ((n2 -= insets.top + insets.bottom) - dimension.height) / 2 + insets.top;
                component.setBounds(n3, n4, dimension.width, dimension.height);
            }
        }
    }

    static class ColorTransferHandler
    extends TransferHandler
    implements UIResource {
        ColorTransferHandler() {
            super("color");
        }
    }

    class PropertyHandler
    implements PropertyChangeListener {
        PropertyHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object object;
            Object object2;
            if (SynthLookAndFeel.shouldUpdateStyle(propertyChangeEvent)) {
                SynthColorChooserUI.this.fetchStyle((JColorChooser)propertyChangeEvent.getSource());
            }
            if (propertyChangeEvent.getPropertyName().equals("chooserPanels")) {
                Container container;
                Container container2;
                int n;
                object2 = (AbstractColorChooserPanel[])propertyChangeEvent.getOldValue();
                object = (AbstractColorChooserPanel[])propertyChangeEvent.getNewValue();
                for (n = 0; n < ((AbstractColorChooserPanel[])object2).length; ++n) {
                    container2 = object2[n].getParent();
                    if (container2 == null) continue;
                    container = container2.getParent();
                    if (container != null) {
                        container.remove(container2);
                    }
                    object2[n].uninstallChooserPanel(SynthColorChooserUI.this.chooser);
                }
                n = ((AbstractColorChooserPanel[])object).length;
                if (n == 0) {
                    SynthColorChooserUI.this.chooser.remove(SynthColorChooserUI.this.tabbedPane);
                    return;
                }
                if (n == 1) {
                    SynthColorChooserUI.this.chooser.remove(SynthColorChooserUI.this.tabbedPane);
                    container2 = new JPanel(new CenterLayout());
                    container2.add((Component)object[0]);
                    SynthColorChooserUI.this.singlePanel.add((Component)container2, "Center");
                    SynthColorChooserUI.this.chooser.add(SynthColorChooserUI.this.singlePanel);
                } else {
                    if (((AbstractColorChooserPanel[])object2).length < 2) {
                        SynthColorChooserUI.this.chooser.remove(SynthColorChooserUI.this.singlePanel);
                        SynthColorChooserUI.this.chooser.add((Component)SynthColorChooserUI.this.tabbedPane, "Center");
                    }
                    for (int i = 0; i < ((Object)object).length; ++i) {
                        container = new JPanel(new CenterLayout());
                        String string = ((AbstractColorChooserPanel)object[i]).getDisplayName();
                        int n2 = ((AbstractColorChooserPanel)object[i]).getMnemonic();
                        container.add((Component)object[i]);
                        SynthColorChooserUI.this.tabbedPane.addTab(string, container);
                        if (n2 <= 0) continue;
                        SynthColorChooserUI.this.tabbedPane.setMnemonicAt(i, n2);
                        SynthColorChooserUI.this.tabbedPane.setDisplayedMnemonicIndexAt(i, ((AbstractColorChooserPanel)object[i]).getDisplayedMnemonicIndex());
                    }
                }
                SynthColorChooserUI.this.chooser.applyComponentOrientation(SynthColorChooserUI.this.chooser.getComponentOrientation());
                for (int i = 0; i < ((Object)object).length; ++i) {
                    ((AbstractColorChooserPanel)object[i]).installChooserPanel(SynthColorChooserUI.this.chooser);
                }
            }
            if (propertyChangeEvent.getPropertyName().equals("previewPanel") && propertyChangeEvent.getNewValue() != SynthColorChooserUI.this.previewPanel) {
                SynthColorChooserUI.this.installPreviewPanel();
            }
            if (propertyChangeEvent.getPropertyName().equals("componentOrientation")) {
                object2 = (ComponentOrientation)propertyChangeEvent.getNewValue();
                object = (JColorChooser)propertyChangeEvent.getSource();
                if (object2 != (ComponentOrientation)propertyChangeEvent.getOldValue()) {
                    ((Container)object).applyComponentOrientation((ComponentOrientation)object2);
                    ((JColorChooser)object).updateUI();
                }
            }
        }
    }

    class PreviewListener
    implements ChangeListener {
        PreviewListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            ColorSelectionModel colorSelectionModel = (ColorSelectionModel)changeEvent.getSource();
            if (SynthColorChooserUI.this.previewPanel != null) {
                SynthColorChooserUI.this.previewPanel.setForeground(colorSelectionModel.getSelectedColor());
                SynthColorChooserUI.this.previewPanel.repaint();
            }
        }
    }
}

