/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import com.sun.java.swing.plaf.gtk.ColorType;
import com.sun.java.swing.plaf.gtk.LazyActionMap;
import com.sun.java.swing.plaf.gtk.Region;
import com.sun.java.swing.plaf.gtk.SynthContext;
import com.sun.java.swing.plaf.gtk.SynthLookAndFeel;
import com.sun.java.swing.plaf.gtk.SynthStyle;
import com.sun.java.swing.plaf.gtk.SynthUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentInputMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.InputMapUIResource;
import javax.swing.plaf.LabelUI;
import javax.swing.plaf.basic.BasicHTML;

class SynthLabelUI
extends LabelUI
implements PropertyChangeListener,
SynthUI {
    private SynthStyle style;

    SynthLabelUI() {
    }

    public static void loadActionMap(ActionMap actionMap) {
        actionMap.put("press", new PressAction());
        actionMap.put("release", new ReleaseAction());
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new SynthLabelUI();
    }

    public void installUI(JComponent jComponent) {
        this.installDefaults((JLabel)jComponent);
        this.installComponents((JLabel)jComponent);
        this.installListeners((JLabel)jComponent);
        this.installKeyboardActions((JLabel)jComponent);
    }

    protected void installDefaults(JLabel jLabel) {
        this.fetchStyle(jLabel);
    }

    void forceFetchStyle(JLabel jLabel) {
        this.style = null;
        this.fetchStyle(jLabel);
    }

    private void fetchStyle(JLabel jLabel) {
        SynthContext synthContext = this.getContext(jLabel, 1);
        this.style = SynthLookAndFeel.updateStyle(synthContext, this);
        synthContext.dispose();
    }

    protected void installListeners(JLabel jLabel) {
        jLabel.addPropertyChangeListener(this);
    }

    protected void installComponents(JLabel jLabel) {
        BasicHTML.updateRenderer(jLabel, jLabel.getText());
    }

    protected void installKeyboardActions(JLabel jLabel) {
        int n = jLabel.getDisplayedMnemonic();
        Component component = jLabel.getLabelFor();
        if (n != 0 && component != null) {
            InputMap inputMap;
            ActionMap actionMap = SwingUtilities.getUIActionMap(jLabel);
            if (actionMap == null) {
                LazyActionMap.installLazyActionMap(jLabel, SynthLabelUI.class, "Label.actionMap");
            }
            if ((inputMap = SwingUtilities.getUIInputMap(jLabel, 2)) == null) {
                inputMap = new ComponentInputMapUIResource(jLabel);
                SwingUtilities.replaceUIInputMap(jLabel, 2, inputMap);
            }
            inputMap.clear();
            inputMap.put(KeyStroke.getKeyStroke(n, 8, false), "press");
        } else {
            InputMap inputMap = SwingUtilities.getUIInputMap(jLabel, 2);
            if (inputMap != null) {
                inputMap.clear();
            }
        }
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallDefaults((JLabel)jComponent);
        this.uninstallComponents((JLabel)jComponent);
        this.uninstallListeners((JLabel)jComponent);
        this.uninstallKeyboardActions((JLabel)jComponent);
    }

    protected void uninstallDefaults(JLabel jLabel) {
        SynthContext synthContext = this.getContext(jLabel, 1);
        this.style.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.style = null;
    }

    protected void uninstallListeners(JLabel jLabel) {
        jLabel.removePropertyChangeListener(this);
    }

    protected void uninstallComponents(JLabel jLabel) {
        BasicHTML.updateRenderer(jLabel, "");
    }

    protected void uninstallKeyboardActions(JLabel jLabel) {
        SwingUtilities.replaceUIInputMap(jLabel, 0, null);
        SwingUtilities.replaceUIInputMap(jLabel, 2, null);
        SwingUtilities.replaceUIActionMap(jLabel, null);
    }

    public SynthContext getContext(JComponent jComponent) {
        return this.getContext(jComponent, this.getComponentState(jComponent));
    }

    private SynthContext getContext(JComponent jComponent, int n) {
        return SynthContext.getContext(SynthContext.class, jComponent, SynthLookAndFeel.getRegion(jComponent), this.style, n);
    }

    private Region getRegion(JComponent jComponent) {
        return SynthLookAndFeel.getRegion(jComponent);
    }

    private int getComponentState(JComponent jComponent) {
        return SynthLookAndFeel.getComponentState(jComponent);
    }

    public void update(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        SynthLookAndFeel.update(synthContext, graphics);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    protected void paint(SynthContext synthContext, Graphics graphics) {
        JLabel jLabel = (JLabel)synthContext.getComponent();
        Icon icon = jLabel.isEnabled() ? jLabel.getIcon() : jLabel.getDisabledIcon();
        graphics.setColor(synthContext.getStyle().getColor(synthContext, ColorType.TEXT_FOREGROUND));
        graphics.setFont(this.style.getFont(synthContext));
        synthContext.getStyle().getSynthGraphics(synthContext).paintText(synthContext, graphics, jLabel.getText(), icon, jLabel.getHorizontalAlignment(), jLabel.getVerticalAlignment(), jLabel.getHorizontalTextPosition(), jLabel.getVerticalTextPosition(), jLabel.getIconTextGap(), jLabel.getDisplayedMnemonicIndex(), 0);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        JLabel jLabel = (JLabel)jComponent;
        Icon icon = jLabel.isEnabled() ? jLabel.getIcon() : jLabel.getDisabledIcon();
        SynthContext synthContext = this.getContext(jComponent);
        Dimension dimension = synthContext.getStyle().getSynthGraphics(synthContext).getPreferredSize(synthContext, synthContext.getStyle().getFont(synthContext), jLabel.getText(), icon, jLabel.getHorizontalAlignment(), jLabel.getVerticalAlignment(), jLabel.getHorizontalTextPosition(), jLabel.getVerticalTextPosition(), jLabel.getIconTextGap(), jLabel.getDisplayedMnemonicIndex());
        synthContext.dispose();
        return dimension;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        JLabel jLabel = (JLabel)jComponent;
        Icon icon = jLabel.isEnabled() ? jLabel.getIcon() : jLabel.getDisabledIcon();
        SynthContext synthContext = this.getContext(jComponent);
        Dimension dimension = synthContext.getStyle().getSynthGraphics(synthContext).getMinimumSize(synthContext, synthContext.getStyle().getFont(synthContext), jLabel.getText(), icon, jLabel.getHorizontalAlignment(), jLabel.getVerticalAlignment(), jLabel.getHorizontalTextPosition(), jLabel.getVerticalTextPosition(), jLabel.getIconTextGap(), jLabel.getDisplayedMnemonicIndex());
        synthContext.dispose();
        return dimension;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        JLabel jLabel = (JLabel)jComponent;
        Icon icon = jLabel.isEnabled() ? jLabel.getIcon() : jLabel.getDisabledIcon();
        SynthContext synthContext = this.getContext(jComponent);
        Dimension dimension = synthContext.getStyle().getSynthGraphics(synthContext).getMaximumSize(synthContext, synthContext.getStyle().getFont(synthContext), jLabel.getText(), icon, jLabel.getHorizontalAlignment(), jLabel.getVerticalAlignment(), jLabel.getHorizontalTextPosition(), jLabel.getVerticalTextPosition(), jLabel.getIconTextGap(), jLabel.getDisplayedMnemonicIndex());
        synthContext.dispose();
        return dimension;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (SynthLookAndFeel.shouldUpdateStyle(propertyChangeEvent)) {
            this.fetchStyle((JLabel)propertyChangeEvent.getSource());
        }
        if (string.equals("text") || "font".equals(string) || "foreground".equals(string)) {
            JLabel jLabel = (JLabel)propertyChangeEvent.getSource();
            String string2 = jLabel.getText();
            BasicHTML.updateRenderer(jLabel, string2);
        } else if (string.equals("labelFor") || string.equals("displayedMnemonic")) {
            this.installKeyboardActions((JLabel)propertyChangeEvent.getSource());
        }
    }

    static class ReleaseAction
    extends AbstractAction {
        ReleaseAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JLabel jLabel = (JLabel)actionEvent.getSource();
            Component component = jLabel.getLabelFor();
            if (component != null && component.isEnabled()) {
                InputMap inputMap = SwingUtilities.getUIInputMap(jLabel, 0);
                if (inputMap != null) {
                    inputMap.remove(KeyStroke.getKeyStroke(jLabel.getDisplayedMnemonic(), 8, true));
                    inputMap.remove(KeyStroke.getKeyStroke(0, 8, true));
                }
                jLabel.getLabelFor().requestFocus();
            }
        }
    }

    static class PressAction
    extends AbstractAction {
        PressAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JLabel jLabel = (JLabel)actionEvent.getSource();
            Component component = jLabel.getLabelFor();
            if (component != null && component.isEnabled()) {
                InputMap inputMap = SwingUtilities.getUIInputMap(jLabel, 0);
                if (inputMap == null) {
                    inputMap = new InputMapUIResource();
                    SwingUtilities.replaceUIInputMap(jLabel, 0, inputMap);
                }
                int n = jLabel.getDisplayedMnemonic();
                inputMap.put(KeyStroke.getKeyStroke(n, 8, true), "release");
                inputMap.put(KeyStroke.getKeyStroke(0, 8, true), "release");
                Component component2 = jLabel.getLabelFor();
                jLabel.requestFocus();
            }
        }
    }
}

