/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.DefaultSecurity;
import com.sun.media.sound.IESecurity;
import com.sun.media.sound.JDK12Security;
import com.sun.media.sound.JSSecurity;
import com.sun.media.sound.NetscapeSecurity;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

class JSSecurityManager {
    private static JSSecurity security = null;
    private static SecurityManager securityManager;

    JSSecurityManager() {
    }

    private static void initSecurity() {
        securityManager = System.getSecurityManager();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            String string;
            String string2 = System.getProperty("java.version");
            if (!string2.equals("")) {
                if (string2.startsWith("1.1")) {
                    bl2 = true;
                } else {
                    bl = true;
                }
            }
            if ((string = System.getProperty("java.vendor", "Sun").toLowerCase()).indexOf("icrosoft") > 0) {
                bl3 = true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (securityManager != null) {
            if (securityManager.toString().indexOf("netscape") != -1) {
                security = NetscapeSecurity.security;
            } else if (securityManager.toString().indexOf("com.ms.security") != -1 || bl3) {
                security = IESecurity.security;
            } else if (securityManager.toString().indexOf("sun.applet.AppletSecurity") != -1 || securityManager.toString().indexOf("sun.plugin.ActivatorSecurityManager") != -1) {
                if (bl2) {
                    security = DefaultSecurity.security;
                }
                if (bl) {
                    security = JDK12Security.security;
                }
            } else if (securityManager.toString().indexOf("java.lang.SecurityManager") != -1) {
                if (bl) {
                    security = JDK12Security.security;
                }
            } else {
                security = bl ? JDK12Security.security : DefaultSecurity.security;
            }
        }
    }

    static JSSecurity getJSSecurity() throws SecurityException {
        if (securityManager != System.getSecurityManager()) {
            JSSecurityManager.initSecurity();
        }
        return security;
    }

    static void checkRecord() throws SecurityException {
        JSSecurity jSSecurity = JSSecurityManager.getJSSecurity();
        if (jSSecurity == null) {
            return;
        }
        try {
            Class<?> clazz = Class.forName("com.sun.media.util.Registry");
            Method method = clazz.getMethod("get", String.class);
            Object[] objectArray = new Object[]{"secure.allowCaptureFromApplets"};
            Object object = method.invoke(clazz, objectArray);
            if (object == null || !(object instanceof Boolean) || !((Boolean)object).booleanValue()) {
                throw new SecurityException("record permission denied");
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SecurityException("record permission denied");
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new SecurityException("record permission denied");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SecurityException("record permission denied");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new SecurityException("record permission denied");
        }
    }

    static boolean isLinkPermissionEnabled() {
        JSSecurity jSSecurity = JSSecurityManager.getJSSecurity();
        if (jSSecurity == null) {
            return true;
        }
        return jSSecurity.isLinkPermissionEnabled();
    }

    static void loadLibrary(String string) throws UnsatisfiedLinkError {
        try {
            JSSecurity jSSecurity = JSSecurityManager.getJSSecurity();
            if (jSSecurity != null) {
                jSSecurity.loadLibrary(string);
            } else {
                System.loadLibrary(string);
            }
        }
        catch (Throwable throwable) {
            throw new UnsatisfiedLinkError("JSSecurityManager: " + throwable);
        }
    }

    static {
        JSSecurityManager.initSecurity();
    }
}

