/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AbstractMidiDevice;
import com.sun.media.sound.AbstractMidiDeviceProvider;
import com.sun.media.sound.FastShortMessage;
import com.sun.media.sound.FastSysexMessage;
import com.sun.media.sound.MidiInDeviceProvider;
import java.util.Vector;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Transmitter;

class MidiInDevice
extends AbstractMidiDevice
implements Runnable {
    private Thread midiInThread = null;
    private Vector transmitters = new Vector();

    MidiInDevice(AbstractMidiDeviceProvider.Info info) {
        super(info);
    }

    synchronized void implOpen() throws MidiUnavailableException {
        this.id = this.nOpen(((MidiInDeviceProvider.MidiInDeviceInfo)this.getDeviceInfo()).getIndex());
        if (this.id == 0L) {
            throw new MidiUnavailableException("Unable to open native device");
        }
        if (this.midiInThread == null) {
            this.midiInThread = new Thread(this);
            this.midiInThread.start();
        }
        this.nStart(this.id);
    }

    synchronized void implClose() {
        long l = this.id;
        this.id = 0L;
        for (int i = 0; i < this.transmitters.size(); ++i) {
            ((Transmitter)this.transmitters.elementAt(i)).close();
        }
        this.transmitters.removeAllElements();
        this.nStop(l);
        this.nClose(l);
    }

    public int getMaxTransmitters() {
        return -1;
    }

    public synchronized Transmitter getTransmitter() throws MidiUnavailableException {
        MidiInTransmitter midiInTransmitter = new MidiInTransmitter();
        this.transmitters.addElement(midiInTransmitter);
        return midiInTransmitter;
    }

    public void run() {
        while (this.id != 0L) {
            this.nGetMessages(this.id);
            if (this.id == 0L) continue;
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.midiInThread = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void callbackShortMessage(int n, long l) {
        if (n == 0 || this.id == 0L) {
            return;
        }
        try {
            Vector vector = this.transmitters;
            synchronized (vector) {
                for (int i = 0; i < this.transmitters.size(); ++i) {
                    Receiver receiver = ((Transmitter)this.transmitters.elementAt(i)).getReceiver();
                    if (receiver == null) continue;
                    receiver.send(new FastShortMessage(n), l);
                }
            }
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void callbackLongMessage(byte[] byArray, long l) {
        if (this.id == 0L || byArray == null) {
            return;
        }
        try {
            Vector vector = this.transmitters;
            synchronized (vector) {
                for (int i = 0; i < this.transmitters.size(); ++i) {
                    Receiver receiver = ((Transmitter)this.transmitters.elementAt(i)).getReceiver();
                    if (receiver == null) continue;
                    receiver.send(new FastSysexMessage(byArray), l);
                }
            }
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            return;
        }
    }

    private native long nOpen(int var1) throws MidiUnavailableException;

    private native void nClose(long var1);

    private native void nStart(long var1) throws MidiUnavailableException;

    private native void nStop(long var1);

    private native void nGetMessages(long var1);

    class MidiInTransmitter
    implements Transmitter {
        private Receiver receiver = null;

        MidiInTransmitter() {
        }

        public void setReceiver(Receiver receiver) {
            this.receiver = receiver;
        }

        public Receiver getReceiver() {
            return this.receiver;
        }

        public void close() {
            MidiInDevice.this.transmitters.removeElement(this);
        }
    }
}

