/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.SunCodec;
import java.io.IOException;
import java.util.Vector;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;

public class PCMtoPCMCodec
extends SunCodec {
    private static final AudioFormat.Encoding[] inputEncodings = new AudioFormat.Encoding[]{AudioFormat.Encoding.PCM_SIGNED, AudioFormat.Encoding.PCM_UNSIGNED};
    private static final AudioFormat.Encoding[] outputEncodings = new AudioFormat.Encoding[]{AudioFormat.Encoding.PCM_SIGNED, AudioFormat.Encoding.PCM_UNSIGNED};
    private static final int tempBufferSize = 64;
    private byte[] tempBuffer = null;

    public PCMtoPCMCodec() {
        super(inputEncodings, outputEncodings);
    }

    public AudioFormat.Encoding[] getTargetEncodings(AudioFormat audioFormat) {
        if (audioFormat.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED) || audioFormat.getEncoding().equals(AudioFormat.Encoding.PCM_UNSIGNED)) {
            AudioFormat.Encoding[] encodingArray = new AudioFormat.Encoding[]{AudioFormat.Encoding.PCM_SIGNED, AudioFormat.Encoding.PCM_UNSIGNED};
            return encodingArray;
        }
        return new AudioFormat.Encoding[0];
    }

    public AudioFormat[] getTargetFormats(AudioFormat.Encoding encoding, AudioFormat audioFormat) {
        AudioFormat[] audioFormatArray = this.getOutputFormats(audioFormat);
        Vector<AudioFormat> vector = new Vector<AudioFormat>();
        for (int i = 0; i < audioFormatArray.length; ++i) {
            if (!audioFormatArray[i].getEncoding().equals(encoding)) continue;
            vector.addElement(audioFormatArray[i]);
        }
        AudioFormat[] audioFormatArray2 = new AudioFormat[vector.size()];
        for (int i = 0; i < audioFormatArray2.length; ++i) {
            audioFormatArray2[i] = (AudioFormat)vector.elementAt(i);
        }
        return audioFormatArray2;
    }

    public AudioInputStream getAudioInputStream(AudioFormat.Encoding encoding, AudioInputStream audioInputStream) {
        if (this.isConversionSupported(encoding, audioInputStream.getFormat())) {
            AudioFormat audioFormat = audioInputStream.getFormat();
            AudioFormat audioFormat2 = new AudioFormat(encoding, audioFormat.getSampleRate(), audioFormat.getSampleSizeInBits(), audioFormat.getChannels(), audioFormat.getFrameSize(), audioFormat.getFrameRate(), audioFormat.isBigEndian());
            return this.getAudioInputStream(audioFormat2, audioInputStream);
        }
        throw new IllegalArgumentException("Unsupported conversion: " + audioInputStream.getFormat().toString() + " to " + encoding.toString());
    }

    public AudioInputStream getAudioInputStream(AudioFormat audioFormat, AudioInputStream audioInputStream) {
        return this.getConvertedStream(audioFormat, audioInputStream);
    }

    private AudioInputStream getConvertedStream(AudioFormat audioFormat, AudioInputStream audioInputStream) {
        AudioInputStream audioInputStream2 = null;
        AudioFormat audioFormat2 = audioInputStream.getFormat();
        if (audioFormat2.matches(audioFormat)) {
            audioInputStream2 = audioInputStream;
        } else {
            audioInputStream2 = new PCMtoPCMCodecStream(audioInputStream, audioFormat);
            this.tempBuffer = new byte[64];
        }
        return audioInputStream2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AudioFormat[] getOutputFormats(AudioFormat audioFormat) {
        AudioFormat[] audioFormatArray;
        AudioFormat audioFormat2;
        Vector<AudioFormat> vector = new Vector<AudioFormat>();
        int n = audioFormat.getSampleSizeInBits();
        boolean bl = audioFormat.isBigEndian();
        if (n == 8) {
            if (audioFormat.getEncoding() == AudioFormat.Encoding.PCM_SIGNED) {
                audioFormat2 = new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, audioFormat.getSampleRate(), audioFormat.getSampleSizeInBits(), audioFormat.getChannels(), audioFormat.getFrameSize(), audioFormat.getFrameRate(), false);
                vector.addElement(audioFormat2);
            }
            if (audioFormat.getEncoding() == AudioFormat.Encoding.PCM_UNSIGNED) {
                audioFormat2 = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, audioFormat.getSampleRate(), audioFormat.getSampleSizeInBits(), audioFormat.getChannels(), audioFormat.getFrameSize(), audioFormat.getFrameRate(), false);
                vector.addElement(audioFormat2);
            }
        } else if (n == 16) {
            if (audioFormat.getEncoding() == AudioFormat.Encoding.PCM_SIGNED && bl) {
                audioFormat2 = new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, audioFormat.getSampleRate(), audioFormat.getSampleSizeInBits(), audioFormat.getChannels(), audioFormat.getFrameSize(), audioFormat.getFrameRate(), true);
                vector.addElement(audioFormat2);
                audioFormat2 = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, audioFormat.getSampleRate(), audioFormat.getSampleSizeInBits(), audioFormat.getChannels(), audioFormat.getFrameSize(), audioFormat.getFrameRate(), false);
                vector.addElement(audioFormat2);
                audioFormat2 = new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, audioFormat.getSampleRate(), audioFormat.getSampleSizeInBits(), audioFormat.getChannels(), audioFormat.getFrameSize(), audioFormat.getFrameRate(), false);
                vector.addElement(audioFormat2);
            }
            if (audioFormat.getEncoding() == AudioFormat.Encoding.PCM_UNSIGNED && bl) {
                audioFormat2 = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, audioFormat.getSampleRate(), audioFormat.getSampleSizeInBits(), audioFormat.getChannels(), audioFormat.getFrameSize(), audioFormat.getFrameRate(), true);
                vector.addElement(audioFormat2);
                audioFormat2 = new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, audioFormat.getSampleRate(), audioFormat.getSampleSizeInBits(), audioFormat.getChannels(), audioFormat.getFrameSize(), audioFormat.getFrameRate(), false);
                vector.addElement(audioFormat2);
                audioFormat2 = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, audioFormat.getSampleRate(), audioFormat.getSampleSizeInBits(), audioFormat.getChannels(), audioFormat.getFrameSize(), audioFormat.getFrameRate(), false);
                vector.addElement(audioFormat2);
            }
            if (audioFormat.getEncoding() == AudioFormat.Encoding.PCM_SIGNED && !bl) {
                audioFormat2 = new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, audioFormat.getSampleRate(), audioFormat.getSampleSizeInBits(), audioFormat.getChannels(), audioFormat.getFrameSize(), audioFormat.getFrameRate(), false);
                vector.addElement(audioFormat2);
                audioFormat2 = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, audioFormat.getSampleRate(), audioFormat.getSampleSizeInBits(), audioFormat.getChannels(), audioFormat.getFrameSize(), audioFormat.getFrameRate(), true);
                vector.addElement(audioFormat2);
                audioFormat2 = new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, audioFormat.getSampleRate(), audioFormat.getSampleSizeInBits(), audioFormat.getChannels(), audioFormat.getFrameSize(), audioFormat.getFrameRate(), true);
                vector.addElement(audioFormat2);
            }
            if (audioFormat.getEncoding() == AudioFormat.Encoding.PCM_UNSIGNED && !bl) {
                audioFormat2 = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, audioFormat.getSampleRate(), audioFormat.getSampleSizeInBits(), audioFormat.getChannels(), audioFormat.getFrameSize(), audioFormat.getFrameRate(), false);
                vector.addElement(audioFormat2);
                audioFormat2 = new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, audioFormat.getSampleRate(), audioFormat.getSampleSizeInBits(), audioFormat.getChannels(), audioFormat.getFrameSize(), audioFormat.getFrameRate(), true);
                vector.addElement(audioFormat2);
                audioFormat2 = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, audioFormat.getSampleRate(), audioFormat.getSampleSizeInBits(), audioFormat.getChannels(), audioFormat.getFrameSize(), audioFormat.getFrameRate(), true);
                vector.addElement(audioFormat2);
            }
        }
        Vector<AudioFormat> vector2 = vector;
        synchronized (vector2) {
            audioFormatArray = new AudioFormat[vector.size()];
            for (int i = 0; i < audioFormatArray.length; ++i) {
                audioFormatArray[i] = (AudioFormat)vector.elementAt(i);
            }
        }
        return audioFormatArray;
    }

    class PCMtoPCMCodecStream
    extends AudioInputStream {
        private final int PCM_SWITCH_SIGNED_8BIT = 1;
        private final int PCM_SWITCH_ENDIAN = 2;
        private final int PCM_SWITCH_SIGNED_LE = 3;
        private final int PCM_SWITCH_SIGNED_BE = 4;
        private final int PCM_UNSIGNED_LE2SIGNED_BE = 5;
        private final int PCM_SIGNED_LE2UNSIGNED_BE = 6;
        private final int PCM_UNSIGNED_BE2SIGNED_LE = 7;
        private final int PCM_SIGNED_BE2UNSIGNED_LE = 8;
        private int sampleSizeInBytes;
        private int conversionType;

        PCMtoPCMCodecStream(AudioInputStream audioInputStream, AudioFormat audioFormat) {
            super(audioInputStream, audioFormat, -1L);
            this.PCM_SWITCH_SIGNED_8BIT = 1;
            this.PCM_SWITCH_ENDIAN = 2;
            this.PCM_SWITCH_SIGNED_LE = 3;
            this.PCM_SWITCH_SIGNED_BE = 4;
            this.PCM_UNSIGNED_LE2SIGNED_BE = 5;
            this.PCM_SIGNED_LE2UNSIGNED_BE = 6;
            this.PCM_UNSIGNED_BE2SIGNED_LE = 7;
            this.PCM_SIGNED_BE2UNSIGNED_LE = 8;
            this.sampleSizeInBytes = 0;
            this.conversionType = 0;
            int n = 0;
            AudioFormat.Encoding encoding = null;
            AudioFormat.Encoding encoding2 = null;
            AudioFormat audioFormat2 = audioInputStream.getFormat();
            if (!PCMtoPCMCodec.this.isConversionSupported(audioFormat2, audioFormat)) {
                throw new IllegalArgumentException("Unsupported conversion: " + audioFormat2.toString() + " to " + audioFormat.toString());
            }
            encoding = audioFormat2.getEncoding();
            encoding2 = audioFormat.getEncoding();
            boolean bl = audioFormat2.isBigEndian();
            boolean bl2 = audioFormat.isBigEndian();
            n = audioFormat2.getSampleSizeInBits();
            this.sampleSizeInBytes = n / 8;
            if (n == 8) {
                if (encoding == AudioFormat.Encoding.PCM_UNSIGNED && encoding2 == AudioFormat.Encoding.PCM_SIGNED) {
                    this.conversionType = 1;
                } else if (encoding == AudioFormat.Encoding.PCM_SIGNED && encoding2 == AudioFormat.Encoding.PCM_UNSIGNED) {
                    this.conversionType = 1;
                }
            } else if (encoding == encoding2 && bl != bl2) {
                this.conversionType = 2;
            } else if (encoding == AudioFormat.Encoding.PCM_UNSIGNED && !bl && encoding2 == AudioFormat.Encoding.PCM_SIGNED && bl2) {
                this.conversionType = 5;
            } else if (encoding == AudioFormat.Encoding.PCM_SIGNED && !bl && encoding2 == AudioFormat.Encoding.PCM_UNSIGNED && bl2) {
                this.conversionType = 6;
            } else if (encoding == AudioFormat.Encoding.PCM_UNSIGNED && bl && encoding2 == AudioFormat.Encoding.PCM_SIGNED && !bl2) {
                this.conversionType = 7;
            } else if (encoding == AudioFormat.Encoding.PCM_SIGNED && bl && encoding2 == AudioFormat.Encoding.PCM_UNSIGNED && !bl2) {
                this.conversionType = 8;
            }
            this.frameSize = audioFormat2.getFrameSize();
            if (this.frameSize == -1) {
                this.frameSize = 1;
            }
            this.frameLength = audioInputStream instanceof AudioInputStream ? audioInputStream.getFrameLength() : -1L;
            this.framePos = 0L;
        }

        public int read() throws IOException {
            if (this.frameSize == 1) {
                if (this.conversionType == 1) {
                    int n = super.read();
                    if (n < 0) {
                        return n;
                    }
                    byte by = (byte)(n & 0xF);
                    by = by >= 0 ? (byte)(0x80 | by) : (byte)(0x7F & by);
                    n = by & 0xF;
                    return n;
                }
                throw new IOException("cannot read a single byte if frame size > 1");
            }
            throw new IOException("cannot read a single byte if frame size > 1");
        }

        public int read(byte[] byArray) throws IOException {
            return this.read(byArray, 0, byArray.length);
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3;
            if (n2 % this.frameSize != 0) {
                n2 -= n2 % this.frameSize;
            }
            if (this.frameLength != -1L && (long)(n2 / this.frameSize) > this.frameLength - this.framePos) {
                n2 = (int)(this.frameLength - this.framePos) * this.frameSize;
            }
            if ((n3 = super.read(byArray, n, n2)) < 0) {
                return n3;
            }
            switch (this.conversionType) {
                case 1: {
                    this.switchSigned8bit(byArray, n, n2, n3);
                    break;
                }
                case 2: {
                    this.switchEndian(byArray, n, n2, n3);
                    break;
                }
                case 3: {
                    this.switchSignedLE(byArray, n, n2, n3);
                    break;
                }
                case 4: {
                    this.switchSignedBE(byArray, n, n2, n3);
                    break;
                }
                case 5: 
                case 6: {
                    this.switchSignedLE(byArray, n, n2, n3);
                    this.switchEndian(byArray, n, n2, n3);
                    break;
                }
                case 7: 
                case 8: {
                    this.switchSignedBE(byArray, n, n2, n3);
                    this.switchEndian(byArray, n, n2, n3);
                    break;
                }
            }
            return n3;
        }

        private void switchSigned8bit(byte[] byArray, int n, int n2, int n3) {
            for (int i = n; i < n + n3; ++i) {
                byArray[i] = byArray[i] >= 0 ? (byte)(0x80 | byArray[i]) : (byte)(0x7F & byArray[i]);
            }
        }

        private void switchSignedBE(byte[] byArray, int n, int n2, int n3) {
            for (int i = n; i < n + n3; i += this.sampleSizeInBytes) {
                byArray[i] = byArray[i] >= 0 ? (byte)(0x80 | byArray[i]) : (byte)(0x7F & byArray[i]);
            }
        }

        private void switchSignedLE(byte[] byArray, int n, int n2, int n3) {
            for (int i = n + this.sampleSizeInBytes - 1; i < n + n3; i += this.sampleSizeInBytes) {
                byArray[i] = byArray[i] >= 0 ? (byte)(0x80 | byArray[i]) : (byte)(0x7F & byArray[i]);
            }
        }

        private void switchEndian(byte[] byArray, int n, int n2, int n3) {
            if (this.sampleSizeInBytes == 2) {
                for (int i = n; i < n + n3; i += this.sampleSizeInBytes) {
                    byte by = byArray[i];
                    byArray[i] = byArray[i + 1];
                    byArray[i + 1] = by;
                }
            }
        }
    }
}

