/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.SunCodec;
import java.io.IOException;
import java.util.Vector;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;

public class UlawCodec
extends SunCodec {
    static final byte[] ULAW_TABH = new byte[256];
    static final byte[] ULAW_TABL = new byte[256];
    private static final AudioFormat.Encoding[] ulawEncodings = new AudioFormat.Encoding[]{AudioFormat.Encoding.ULAW, AudioFormat.Encoding.PCM_SIGNED};
    private static final short[] seg_end = new short[]{255, 511, 1023, 2047, 4095, 8191, 16383, Short.MAX_VALUE};
    private static final int tempBufferSize = 64;
    private byte[] tempBuffer = null;

    public UlawCodec() {
        super(ulawEncodings, ulawEncodings);
    }

    public AudioFormat.Encoding[] getTargetEncodings(AudioFormat audioFormat) {
        if (audioFormat.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED)) {
            if (audioFormat.getSampleSizeInBits() == 16) {
                AudioFormat.Encoding[] encodingArray = new AudioFormat.Encoding[]{AudioFormat.Encoding.ULAW};
                return encodingArray;
            }
            return new AudioFormat.Encoding[0];
        }
        if (audioFormat.getEncoding().equals(AudioFormat.Encoding.ULAW)) {
            if (audioFormat.getSampleSizeInBits() == 8) {
                AudioFormat.Encoding[] encodingArray = new AudioFormat.Encoding[]{AudioFormat.Encoding.PCM_SIGNED};
                return encodingArray;
            }
            return new AudioFormat.Encoding[0];
        }
        return new AudioFormat.Encoding[0];
    }

    public AudioFormat[] getTargetFormats(AudioFormat.Encoding encoding, AudioFormat audioFormat) {
        if (encoding.equals(AudioFormat.Encoding.PCM_SIGNED) && audioFormat.getEncoding().equals(AudioFormat.Encoding.ULAW) || encoding.equals(AudioFormat.Encoding.ULAW) && audioFormat.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED)) {
            return this.getOutputFormats(audioFormat);
        }
        return new AudioFormat[0];
    }

    public AudioInputStream getAudioInputStream(AudioFormat.Encoding encoding, AudioInputStream audioInputStream) {
        AudioFormat audioFormat = audioInputStream.getFormat();
        AudioFormat.Encoding encoding2 = audioFormat.getEncoding();
        if (encoding2.equals(encoding)) {
            return audioInputStream;
        }
        AudioFormat audioFormat2 = null;
        if (!this.isConversionSupported(encoding, audioInputStream.getFormat())) {
            throw new IllegalArgumentException("Unsupported conversion: " + audioInputStream.getFormat().toString() + " to " + encoding.toString());
        }
        if (encoding2.equals(AudioFormat.Encoding.ULAW) && encoding.equals(AudioFormat.Encoding.PCM_SIGNED)) {
            audioFormat2 = new AudioFormat(encoding, audioFormat.getSampleRate(), 16, audioFormat.getChannels(), 2 * audioFormat.getChannels(), audioFormat.getSampleRate(), audioFormat.isBigEndian());
        } else if (encoding2.equals(AudioFormat.Encoding.PCM_SIGNED) && encoding.equals(AudioFormat.Encoding.ULAW)) {
            audioFormat2 = new AudioFormat(encoding, audioFormat.getSampleRate(), 8, audioFormat.getChannels(), audioFormat.getChannels(), audioFormat.getSampleRate(), false);
        } else {
            throw new IllegalArgumentException("Unsupported conversion: " + audioInputStream.getFormat().toString() + " to " + encoding.toString());
        }
        return this.getAudioInputStream(audioFormat2, audioInputStream);
    }

    public AudioInputStream getAudioInputStream(AudioFormat audioFormat, AudioInputStream audioInputStream) {
        return this.getConvertedStream(audioFormat, audioInputStream);
    }

    private AudioInputStream getConvertedStream(AudioFormat audioFormat, AudioInputStream audioInputStream) {
        AudioInputStream audioInputStream2 = null;
        AudioFormat audioFormat2 = audioInputStream.getFormat();
        if (audioFormat2.matches(audioFormat)) {
            audioInputStream2 = audioInputStream;
        } else {
            audioInputStream2 = new UlawCodecStream(audioInputStream, audioFormat);
            this.tempBuffer = new byte[64];
        }
        return audioInputStream2;
    }

    private AudioFormat[] getOutputFormats(AudioFormat audioFormat) {
        AudioFormat audioFormat2;
        Vector<AudioFormat> vector = new Vector<AudioFormat>();
        if (audioFormat.getSampleSizeInBits() == 16 && audioFormat.getEncoding() == AudioFormat.Encoding.PCM_SIGNED) {
            audioFormat2 = new AudioFormat(AudioFormat.Encoding.ULAW, audioFormat.getSampleRate(), 8, audioFormat.getChannels(), audioFormat.getChannels(), audioFormat.getSampleRate(), false);
            vector.addElement(audioFormat2);
        }
        if (audioFormat.getEncoding() == AudioFormat.Encoding.ULAW) {
            audioFormat2 = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, audioFormat.getSampleRate(), 16, audioFormat.getChannels(), audioFormat.getChannels() * 2, audioFormat.getSampleRate(), false);
            vector.addElement(audioFormat2);
            audioFormat2 = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, audioFormat.getSampleRate(), 16, audioFormat.getChannels(), audioFormat.getChannels() * 2, audioFormat.getSampleRate(), true);
            vector.addElement(audioFormat2);
        }
        AudioFormat[] audioFormatArray = new AudioFormat[vector.size()];
        for (int i = 0; i < audioFormatArray.length; ++i) {
            audioFormatArray[i] = (AudioFormat)vector.elementAt(i);
        }
        return audioFormatArray;
    }

    static {
        for (int i = 0; i < 256; ++i) {
            int n = ~i;
            int n2 = (((n &= 0xFF) & 0xF) << 3) + 132;
            n2 = (n & 0x80) != 0 ? 132 - n2 : (n2 <<= (n & 0x70) >> 4) - 132;
            UlawCodec.ULAW_TABL[i] = (byte)(n2 & 0xFF);
            UlawCodec.ULAW_TABH[i] = (byte)(n2 >> 8 & 0xFF);
        }
    }

    class UlawCodecStream
    extends AudioInputStream {
        boolean encode;
        AudioFormat encodeFormat;
        AudioFormat decodeFormat;
        byte[] tabByte1;
        byte[] tabByte2;
        int highByte;
        int lowByte;

        UlawCodecStream(AudioInputStream audioInputStream, AudioFormat audioFormat) {
            boolean bl;
            super(audioInputStream, audioFormat, -1L);
            this.encode = false;
            this.tabByte1 = null;
            this.tabByte2 = null;
            this.highByte = 0;
            this.lowByte = 1;
            AudioFormat audioFormat2 = audioInputStream.getFormat();
            if (!UlawCodec.this.isConversionSupported(audioFormat, audioFormat2)) {
                throw new IllegalArgumentException("Unsupported conversion: " + audioFormat2.toString() + " to " + audioFormat.toString());
            }
            if (audioFormat2.getEncoding() == AudioFormat.Encoding.ULAW) {
                this.encode = false;
                this.encodeFormat = audioFormat2;
                this.decodeFormat = audioFormat;
                bl = audioFormat.isBigEndian();
            } else {
                this.encode = true;
                this.encodeFormat = audioFormat;
                this.decodeFormat = audioFormat2;
                bl = audioFormat2.isBigEndian();
            }
            if (bl) {
                this.tabByte1 = ULAW_TABH;
                this.tabByte2 = ULAW_TABL;
                this.highByte = 0;
                this.lowByte = 1;
            } else {
                this.tabByte1 = ULAW_TABL;
                this.tabByte2 = ULAW_TABH;
                this.highByte = 1;
                this.lowByte = 0;
            }
            if (audioInputStream instanceof AudioInputStream) {
                this.frameLength = audioInputStream.getFrameLength();
            }
            this.framePos = 0L;
            this.frameSize = audioFormat2.getFrameSize();
            if (this.frameSize == -1) {
                this.frameSize = 1;
            }
        }

        private short search(short s, short[] sArray, short s2) {
            for (short s3 = 0; s3 < s2; s3 = (short)(s3 + 1)) {
                if (s > sArray[s3]) continue;
                return s3;
            }
            return s2;
        }

        public int read() throws IOException {
            byte[] byArray = new byte[1];
            if (this.read(byArray, 0, byArray.length) == 1) {
                return byArray[1] & 0xFF;
            }
            return -1;
        }

        public int read(byte[] byArray) throws IOException {
            return this.read(byArray, 0, byArray.length);
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3;
            if (n2 % this.frameSize != 0) {
                n2 -= n2 % this.frameSize;
            }
            if (this.encode) {
                int n4;
                int n5 = 132;
                int n6 = 0;
                int n7 = n;
                int n8 = n2 * 2;
                int n9 = n4 = n8 > 64 ? 64 : n8;
                while ((n6 = super.read(UlawCodec.this.tempBuffer, 0, n4)) > 0) {
                    for (int i = 0; i < n6; i += 2) {
                        byte by;
                        int n10;
                        short s = (short)(UlawCodec.this.tempBuffer[i + this.highByte] << 8 & 0xFF00);
                        if ((s = (short)(s | (short)((short)UlawCodec.this.tempBuffer[i + this.lowByte] & 0xFF))) < 0) {
                            s = (short)(n5 - s);
                            n10 = 127;
                        } else {
                            s = (short)(s + n5);
                            n10 = 255;
                        }
                        short s2 = this.search(s, seg_end, (short)8);
                        if (s2 >= 8) {
                            by = (byte)(0x7F ^ n10);
                        } else {
                            by = (byte)(s2 << 4 | s >> s2 + 3 & 0xF);
                            by = (byte)(by ^ n10);
                        }
                        byArray[n7] = by;
                        ++n7;
                    }
                    n4 = (n8 -= n6) > 64 ? 64 : n8;
                }
                if (n7 == n && n6 < 0) {
                    return n6;
                }
                return n7 - n;
            }
            int n11 = n + n2 / 2;
            int n12 = n2 / 2;
            int n13 = super.read(byArray, n11, n12);
            if (n13 < 0) {
                return n13;
            }
            for (n3 = n; n3 < n + n13 * 2; n3 += 2) {
                byArray[n3] = this.tabByte1[byArray[n11] & 0xFF];
                byArray[n3 + 1] = this.tabByte2[byArray[n11] & 0xFF];
                ++n11;
            }
            return n3 - n;
        }
    }
}

