/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio.stream;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;

class MemoryCache {
    private static final int BUFFER_LENGTH = 8192;
    private ArrayList cache = new ArrayList();
    private long cacheStart = 0L;
    private long length = 0L;

    MemoryCache() {
    }

    private byte[] getCacheBlock(long l) throws IOException {
        long l2 = l - this.cacheStart;
        if (l2 > Integer.MAX_VALUE) {
            throw new IOException("Cache addressing limit exceeded!");
        }
        return (byte[])this.cache.get((int)l2);
    }

    public long loadFromStream(InputStream inputStream, long l) throws IOException {
        if (l < this.length) {
            return l;
        }
        int n = (int)(this.length % 8192L);
        byte[] byArray = null;
        long l2 = l - this.length;
        if (n != 0) {
            byArray = this.getCacheBlock(this.length / 8192L);
        }
        while (l2 > 0L) {
            if (byArray == null) {
                try {
                    byArray = new byte[8192];
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    throw new IOException("No memory left for cache!");
                }
                n = 0;
            }
            int n2 = 8192 - n;
            int n3 = (int)Math.min(l2, (long)n2);
            if ((n3 = inputStream.read(byArray, n, n3)) == -1) {
                return this.length;
            }
            if (n == 0) {
                this.cache.add(byArray);
            }
            byArray = null;
            l2 -= (long)n3;
            this.length += (long)n3;
        }
        return l;
    }

    public void writeToStream(OutputStream outputStream, long l, long l2) throws IOException {
        if (l + l2 > this.length) {
            throw new IndexOutOfBoundsException("Argument out of cache");
        }
        if (l < 0L || l2 < 0L) {
            throw new IndexOutOfBoundsException("Negative pos or len");
        }
        if (l2 == 0L) {
            return;
        }
        long l3 = l / 8192L;
        if (l3 < this.cacheStart) {
            throw new IndexOutOfBoundsException("pos already disposed");
        }
        int n = (int)(l % 8192L);
        byte[] byArray = this.getCacheBlock(l3++);
        while (l2 > 0L) {
            if (byArray == null) {
                byArray = this.getCacheBlock(l3++);
                n = 0;
            }
            int n2 = (int)Math.min(l2, (long)(8192 - n));
            outputStream.write(byArray, n, n2);
            byArray = null;
            l2 -= (long)n2;
        }
    }

    private void pad(long l) throws IOException {
        long l2 = this.cacheStart + (long)this.cache.size() - 1L;
        long l3 = l / 8192L;
        long l4 = l3 - l2;
        for (long i = 0L; i < l4; ++i) {
            try {
                this.cache.add(new byte[8192]);
                continue;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                throw new IOException("No memory left for cache!");
            }
        }
    }

    public void write(byte[] byArray, int n, int n2, long l) throws IOException {
        if (byArray == null) {
            throw new NullPointerException("b == null!");
        }
        if (n < 0 || n2 < 0 || l < 0L || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        long l2 = l + (long)n2 - 1L;
        if (l2 >= this.length) {
            this.pad(l2);
            this.length = l2 + 1L;
        }
        int n3 = (int)(l % 8192L);
        while (n2 > 0) {
            byte[] byArray2 = this.getCacheBlock(l / 8192L);
            int n4 = Math.min(n2, 8192 - n3);
            System.arraycopy(byArray, n, byArray2, n3, n4);
            l += (long)n4;
            n += n4;
            n2 -= n4;
            n3 = 0;
        }
    }

    public void write(int n, long l) throws IOException {
        if (l < 0L) {
            throw new ArrayIndexOutOfBoundsException("pos < 0");
        }
        if (l >= this.length) {
            this.pad(l);
            this.length = l + 1L;
        }
        byte[] byArray = this.getCacheBlock(l / 8192L);
        int n2 = (int)(l % 8192L);
        byArray[n2] = (byte)n;
    }

    public long getLength() {
        return this.length;
    }

    public int read(long l) throws IOException {
        if (l >= this.length) {
            return -1;
        }
        byte[] byArray = this.getCacheBlock(l / 8192L);
        if (byArray == null) {
            return -1;
        }
        return byArray[(int)(l % 8192L)] & 0xFF;
    }

    public void read(byte[] byArray, int n, int n2, long l) throws IOException {
        if (byArray == null) {
            throw new NullPointerException("b == null!");
        }
        if (n < 0 || n2 < 0 || l < 0L || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (l + (long)n2 > this.length) {
            throw new IndexOutOfBoundsException();
        }
        long l2 = l / 8192L;
        int n3 = (int)l % 8192;
        while (n2 > 0) {
            int n4 = Math.min(n2, 8192 - n3);
            byte[] byArray2 = this.getCacheBlock(l2++);
            System.arraycopy(byArray2, n3, byArray, n, n4);
            n2 -= n4;
            n += n4;
            n3 = 0;
        }
    }

    public void disposeBefore(long l) {
        long l2 = l / 8192L;
        if (l2 < this.cacheStart) {
            throw new IndexOutOfBoundsException("pos already disposed");
        }
        long l3 = Math.min(l2 - this.cacheStart, (long)this.cache.size());
        for (long i = 0L; i < l3; ++i) {
            this.cache.remove(0);
        }
        this.cacheStart = l2;
    }

    public void reset() {
        this.cache.clear();
        this.cacheStart = 0L;
        this.length = 0L;
    }
}

