/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Graphics;
import java.io.IOException;
import java.io.ObjectOutputStream;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleValue;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.SwingGraphics;
import javax.swing.UIManager;
import javax.swing.plaf.SplitPaneUI;

public class JSplitPane
extends JComponent
implements Accessible {
    private static final String uiClassID = "SplitPaneUI";
    public static final int VERTICAL_SPLIT = 0;
    public static final int HORIZONTAL_SPLIT = 1;
    public static final String LEFT = "left";
    public static final String RIGHT = "right";
    public static final String TOP = "top";
    public static final String BOTTOM = "bottom";
    public static final String DIVIDER = "divider";
    public static final String ORIENTATION_PROPERTY = "orientation";
    public static final String CONTINUOUS_LAYOUT_PROPERTY = "continuousLayout";
    public static final String DIVIDER_SIZE_PROPERTY = "dividerSize";
    public static final String ONE_TOUCH_EXPANDABLE_PROPERTY = "oneTouchExpandable";
    public static final String LAST_DIVIDER_LOCATION_PROPERTY = "lastDividerLocation";
    public static final String DIVIDER_LOCATION_PROPERTY = "dividerLocation";
    public static final String RESIZE_WEIGHT_PROPERTY = "resizeWeight";
    protected int orientation;
    protected boolean continuousLayout;
    protected Component leftComponent;
    protected Component rightComponent;
    protected int dividerSize;
    protected boolean oneTouchExpandable;
    protected int lastDividerLocation;
    private double resizeWeight;
    private int dividerLocation = -1;

    public JSplitPane() {
        this(1, false, new JButton(UIManager.getString("SplitPane.leftButtonText")), new JButton(UIManager.getString("SplitPane.rightButtonText")));
    }

    public JSplitPane(int n) {
        this(n, false);
    }

    public JSplitPane(int n, boolean bl) {
        this(n, bl, null, null);
    }

    public JSplitPane(int n, Component component, Component component2) {
        this(n, false, component, component2);
    }

    public JSplitPane(int n, boolean bl, Component component, Component component2) {
        this.setLayout(null);
        this.setOpaque(true);
        this.orientation = n;
        if (this.orientation != 1 && this.orientation != 0) {
            throw new IllegalArgumentException("cannot create JSplitPane, orientation must be one of JSplitPane.HORIZONTAL_SPLIT or JSplitPane.VERTICAL_SPLIT");
        }
        this.continuousLayout = bl;
        if (component != null) {
            this.setLeftComponent(component);
        }
        if (component2 != null) {
            this.setRightComponent(component2);
        }
        this.updateUI();
    }

    public void setUI(SplitPaneUI splitPaneUI) {
        if ((SplitPaneUI)this.ui != splitPaneUI) {
            super.setUI(splitPaneUI);
            this.revalidate();
        }
    }

    public SplitPaneUI getUI() {
        return (SplitPaneUI)this.ui;
    }

    public void updateUI() {
        this.setUI((SplitPaneUI)UIManager.getUI(this));
        this.revalidate();
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public void setDividerSize(int n) {
        int n2 = this.dividerSize;
        if (n2 != n) {
            this.dividerSize = n;
            this.firePropertyChange(DIVIDER_SIZE_PROPERTY, n2, n);
        }
    }

    public int getDividerSize() {
        return this.dividerSize;
    }

    public void setLeftComponent(Component component) {
        if (component == null) {
            if (this.leftComponent != null) {
                this.remove(this.leftComponent);
                this.leftComponent = null;
            }
        } else {
            this.add(component, LEFT);
        }
    }

    public Component getLeftComponent() {
        return this.leftComponent;
    }

    public void setTopComponent(Component component) {
        this.setLeftComponent(component);
    }

    public Component getTopComponent() {
        return this.leftComponent;
    }

    public void setRightComponent(Component component) {
        if (component == null) {
            if (this.rightComponent != null) {
                this.remove(this.rightComponent);
                this.rightComponent = null;
            }
        } else {
            this.add(component, RIGHT);
        }
    }

    public Component getRightComponent() {
        return this.rightComponent;
    }

    public void setBottomComponent(Component component) {
        this.setRightComponent(component);
    }

    public Component getBottomComponent() {
        return this.rightComponent;
    }

    public void setOneTouchExpandable(boolean bl) {
        boolean bl2 = this.oneTouchExpandable;
        this.oneTouchExpandable = bl;
        this.firePropertyChange(ONE_TOUCH_EXPANDABLE_PROPERTY, bl2, bl);
        this.repaint();
    }

    public boolean isOneTouchExpandable() {
        return this.oneTouchExpandable;
    }

    public void setLastDividerLocation(int n) {
        int n2 = this.lastDividerLocation;
        this.lastDividerLocation = n;
        this.firePropertyChange(LAST_DIVIDER_LOCATION_PROPERTY, n2, n);
    }

    public int getLastDividerLocation() {
        return this.lastDividerLocation;
    }

    public void setOrientation(int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("JSplitPane: orientation must be one of JSplitPane.VERTICAL_SPLIT or JSplitPane.HORIZONTAL_SPLIT");
        }
        int n2 = this.orientation;
        this.orientation = n;
        this.firePropertyChange(ORIENTATION_PROPERTY, n2, n);
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setContinuousLayout(boolean bl) {
        boolean bl2 = this.continuousLayout;
        this.continuousLayout = bl;
        this.firePropertyChange(CONTINUOUS_LAYOUT_PROPERTY, bl2, bl);
    }

    public boolean isContinuousLayout() {
        return this.continuousLayout;
    }

    public void setResizeWeight(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("JSplitPane weight must be between 0 and 1");
        }
        double d2 = this.resizeWeight;
        this.resizeWeight = d;
        this.firePropertyChange(RESIZE_WEIGHT_PROPERTY, d2, d);
    }

    public double getResizeWeight() {
        return this.resizeWeight;
    }

    public void resetToPreferredSizes() {
        SplitPaneUI splitPaneUI = this.getUI();
        if (splitPaneUI != null) {
            splitPaneUI.resetToPreferredSizes(this);
        }
    }

    public void setDividerLocation(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("proportional location must be between 0.0 and 1.0.");
        }
        if (this.getOrientation() == 0) {
            this.setDividerLocation((int)((double)(this.getHeight() - this.getDividerSize()) * d));
        } else {
            this.setDividerLocation((int)((double)(this.getWidth() - this.getDividerSize()) * d));
        }
    }

    public void setDividerLocation(int n) {
        int n2 = this.dividerLocation;
        this.dividerLocation = n;
        SplitPaneUI splitPaneUI = this.getUI();
        if (splitPaneUI != null) {
            splitPaneUI.setDividerLocation(this, n);
        }
        this.firePropertyChange(DIVIDER_LOCATION_PROPERTY, n2, n);
        this.setLastDividerLocation(n2);
    }

    public int getDividerLocation() {
        return this.dividerLocation;
    }

    public int getMinimumDividerLocation() {
        SplitPaneUI splitPaneUI = this.getUI();
        if (splitPaneUI != null) {
            return splitPaneUI.getMinimumDividerLocation(this);
        }
        return -1;
    }

    public int getMaximumDividerLocation() {
        SplitPaneUI splitPaneUI = this.getUI();
        if (splitPaneUI != null) {
            return splitPaneUI.getMaximumDividerLocation(this);
        }
        return -1;
    }

    public void remove(Component component) {
        if (component == this.leftComponent) {
            this.leftComponent = null;
        } else if (component == this.rightComponent) {
            this.rightComponent = null;
        }
        super.remove(component);
        this.revalidate();
        this.repaint();
    }

    public void remove(int n) {
        Component component = this.getComponent(n);
        if (component == this.leftComponent) {
            this.leftComponent = null;
        } else if (component == this.rightComponent) {
            this.rightComponent = null;
        }
        super.remove(n);
        this.revalidate();
        this.repaint();
    }

    public void removeAll() {
        this.rightComponent = null;
        this.leftComponent = null;
        super.removeAll();
        this.revalidate();
        this.repaint();
    }

    public boolean isValidateRoot() {
        return true;
    }

    protected void addImpl(Component component, Object object, int n) {
        if (object != null && !(object instanceof String)) {
            throw new IllegalArgumentException("cannot add to layout: constraint must be a string (or null)");
        }
        if (object == null) {
            if (this.getLeftComponent() == null) {
                object = LEFT;
            } else if (this.getRightComponent() == null) {
                object = RIGHT;
            }
        }
        if (object != null && (object.equals(LEFT) || object.equals(TOP))) {
            Component component2 = this.getLeftComponent();
            if (component2 != null) {
                this.remove(component2);
            }
            this.leftComponent = component;
            n = -1;
        } else if (object != null && (object.equals(RIGHT) || object.equals(BOTTOM))) {
            Component component3 = this.getRightComponent();
            if (component3 != null) {
                this.remove(component3);
            }
            this.rightComponent = component;
            n = -1;
        } else if (object != null && object.equals(DIVIDER)) {
            n = -1;
        }
        super.addImpl(component, object, n);
        this.revalidate();
        this.repaint();
    }

    protected void paintChildren(Graphics graphics) {
        super.paintChildren(graphics);
        SplitPaneUI splitPaneUI = this.getUI();
        if (splitPaneUI != null) {
            Graphics graphics2 = SwingGraphics.createSwingGraphics(graphics);
            splitPaneUI.finishedPaintingChildren(this, graphics2);
            graphics2.dispose();
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.getUIClassID().equals(uiClassID)) {
            byte by = JComponent.getWriteObjCounter(this);
            by = (byte)(by - 1);
            JComponent.setWriteObjCounter(this, by);
            if (by == 0 && this.ui != null) {
                this.ui.installUI(this);
            }
        }
    }

    protected String paramString() {
        String string = this.orientation == 1 ? "HORIZONTAL_SPLIT" : "VERTICAL_SPLIT";
        String string2 = this.continuousLayout ? "true" : "false";
        String string3 = this.oneTouchExpandable ? "true" : "false";
        return super.paramString() + ",continuousLayout=" + string2 + ",dividerSize=" + this.dividerSize + ",lastDividerLocation=" + this.lastDividerLocation + ",oneTouchExpandable=" + string3 + ",orientation=" + string;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJSplitPane();
        }
        return this.accessibleContext;
    }

    protected class AccessibleJSplitPane
    extends JComponent.AccessibleJComponent
    implements AccessibleValue {
        protected AccessibleJSplitPane() {
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            if (JSplitPane.this.getOrientation() == 0) {
                accessibleStateSet.add(AccessibleState.VERTICAL);
            } else {
                accessibleStateSet.add(AccessibleState.HORIZONTAL);
            }
            return accessibleStateSet;
        }

        public AccessibleValue getAccessibleValue() {
            return this;
        }

        public Number getCurrentAccessibleValue() {
            return new Integer(JSplitPane.this.getDividerLocation());
        }

        public boolean setCurrentAccessibleValue(Number number) {
            if (number instanceof Integer) {
                JSplitPane.this.setDividerLocation(number.intValue());
                return true;
            }
            return false;
        }

        public Number getMinimumAccessibleValue() {
            return new Integer(JSplitPane.this.getUI().getMinimumDividerLocation(JSplitPane.this));
        }

        public Number getMaximumAccessibleValue() {
            return new Integer(JSplitPane.this.getUI().getMaximumDividerLocation(JSplitPane.this));
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.SPLIT_PANE;
        }
    }
}

