/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JViewport;
import javax.swing.MenuElement;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class MenuSelectionManager {
    private static final MenuSelectionManager instance = new MenuSelectionManager();
    private Vector selection = new Vector();
    private static final boolean TRACE = false;
    private static final boolean VERBOSE = false;
    private static final boolean DEBUG = false;
    protected transient ChangeEvent changeEvent = null;
    protected EventListenerList listenerList = new EventListenerList();

    public static MenuSelectionManager defaultManager() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedPath(MenuElement[] menuElementArray) {
        Object object;
        int n = 0;
        if (menuElementArray == null) {
            menuElementArray = new MenuElement[]{};
        }
        if (menuElementArray.length > 0) {
            if (menuElementArray[menuElementArray.length - 1] instanceof JMenuItem) {
                object = (JComponent)((Object)menuElementArray[menuElementArray.length - 1]);
                ((JComponent)object).scrollRectToVisible(new Rectangle(0, 0, ((JComponent)object).getWidth(), ((JComponent)object).getHeight()));
            } else if (menuElementArray.length > 1 && menuElementArray[menuElementArray.length - 1] instanceof JPopupMenu && menuElementArray[menuElementArray.length - 2] instanceof JMenuItem) {
                object = (JComponent)((Object)menuElementArray[menuElementArray.length - 2]);
                ((JComponent)object).scrollRectToVisible(new Rectangle(0, 0, ((JComponent)object).getWidth(), ((JComponent)object).getHeight()));
            }
        }
        object = this;
        synchronized (object) {
            int n2;
            int n3 = this.selection.size();
            int n4 = menuElementArray.length;
            for (n2 = 0; n2 < n4 && n2 < n3 && (MenuElement)this.selection.elementAt(n2) == menuElementArray[n2]; ++n2) {
                ++n;
            }
            for (n2 = n3 - 1; n2 >= n; --n2) {
                MenuElement menuElement = (MenuElement)this.selection.elementAt(n2);
                this.selection.removeElementAt(n2);
                menuElement.menuSelectionChanged(false);
            }
            n4 = menuElementArray.length;
            for (n2 = n; n2 < n4; ++n2) {
                if (menuElementArray[n2] == null) continue;
                this.selection.addElement(menuElementArray[n2]);
                menuElementArray[n2].menuSelectionChanged(true);
            }
        }
        this.fireStateChanged();
    }

    public MenuElement[] getSelectedPath() {
        MenuElement[] menuElementArray = new MenuElement[this.selection.size()];
        int n = this.selection.size();
        for (int i = 0; i < n; ++i) {
            menuElementArray[i] = (MenuElement)this.selection.elementAt(i);
        }
        return menuElementArray;
    }

    public void clearSelectedPath() {
        if (this.selection.size() > 0) {
            this.setSelectedPath(null);
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(ChangeListener.class, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(ChangeListener.class, changeListener);
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.listenerList.getListeners(ChangeListener.class);
    }

    protected void fireStateChanged() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$javax$swing$event$ChangeListener == null ? MenuSelectionManager.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener)) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)objectArray[i + 1]).stateChanged(this.changeEvent);
        }
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        Component component = (Component)mouseEvent.getSource();
        if (!component.isShowing()) {
            return;
        }
        int n = mouseEvent.getID();
        int n2 = mouseEvent.getModifiers();
        if ((n == 504 || n == 505) && (n2 & 0x1C) != 0) {
            return;
        }
        SwingUtilities.convertPointToScreen(point, component);
        int n3 = point.x;
        int n4 = point.y;
        Vector vector = (Vector)this.selection.clone();
        int n5 = vector.size();
        boolean bl = false;
        for (int i = n5 - 1; i >= 0 && !bl; --i) {
            Container container;
            MenuElement menuElement = (MenuElement)vector.elementAt(i);
            MenuElement[] menuElementArray = menuElement.getSubElements();
            JViewport jViewport = null;
            Container container2 = ((Component)((Object)menuElement)).getParent();
            if (container2 != null && container2 instanceof JPanel && (container = container2.getParent()) != null && container instanceof JViewport) {
                jViewport = (JViewport)container;
            }
            MenuElement[] menuElementArray2 = null;
            int n6 = menuElementArray.length;
            for (int j = 0; j < n6 && !bl; ++j) {
                Serializable serializable;
                int n7;
                int n8;
                Component component2;
                if (menuElementArray[j] == null || !(component2 = menuElementArray[j].getComponent()).isShowing() || jViewport != null && !jViewport.getViewRect().intersects(component2.getBounds())) continue;
                if (component2 instanceof JComponent) {
                    n8 = ((JComponent)component2).getWidth();
                    n7 = ((JComponent)component2).getHeight();
                } else {
                    Rectangle rectangle = component2.getBounds();
                    n8 = rectangle.width;
                    n7 = rectangle.height;
                }
                point.x = n3;
                point.y = n4;
                SwingUtilities.convertPointFromScreen(point, component2);
                if (point.x < 0 || point.x >= n8 || point.y < 0 || point.y >= n7) continue;
                if (menuElementArray2 == null) {
                    menuElementArray2 = new MenuElement[i + 2];
                    for (int k = 0; k <= i; ++k) {
                        menuElementArray2[k] = (MenuElement)vector.elementAt(k);
                    }
                }
                menuElementArray2[i + 1] = menuElementArray[j];
                MenuElement[] menuElementArray3 = this.getSelectedPath();
                if (menuElementArray3[menuElementArray3.length - 1] != menuElementArray2[i + 1] && (menuElementArray3.length < 2 || menuElementArray3[menuElementArray3.length - 2] != menuElementArray2[i + 1])) {
                    serializable = menuElementArray3[menuElementArray3.length - 1].getComponent();
                    MouseEvent mouseEvent2 = new MouseEvent((Component)serializable, 505, mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
                    menuElementArray3[menuElementArray3.length - 1].processMouseEvent(mouseEvent2, menuElementArray2, this);
                    MouseEvent mouseEvent3 = new MouseEvent(component2, 504, mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
                    menuElementArray[j].processMouseEvent(mouseEvent3, menuElementArray2, this);
                }
                serializable = new MouseEvent(component2, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
                menuElementArray[j].processMouseEvent((MouseEvent)serializable, menuElementArray2, this);
                bl = true;
                mouseEvent.consume();
            }
        }
    }

    private void printMenuElementArray(MenuElement[] menuElementArray) {
        this.printMenuElementArray(menuElementArray, false);
    }

    private void printMenuElementArray(MenuElement[] menuElementArray, boolean bl) {
        System.out.println("Path is(");
        int n = menuElementArray.length;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j <= i; ++j) {
                System.out.print("  ");
            }
            MenuElement menuElement = menuElementArray[i];
            if (menuElement instanceof JMenuItem) {
                System.out.println(((JMenuItem)menuElement).getText() + ", ");
                continue;
            }
            if (menuElement instanceof JMenuBar) {
                System.out.println("JMenuBar, ");
                continue;
            }
            if (menuElement instanceof JPopupMenu) {
                System.out.println("JPopupMenu, ");
                continue;
            }
            if (menuElement == null) {
                System.out.println("NULL , ");
                continue;
            }
            System.out.println("" + menuElement + ", ");
        }
        System.out.println(")");
        if (bl) {
            Thread.dumpStack();
        }
    }

    public Component componentForPoint(Component component, Point point) {
        Point point2 = point;
        SwingUtilities.convertPointToScreen(point2, component);
        int n = point2.x;
        int n2 = point2.y;
        Vector vector = (Vector)this.selection.clone();
        int n3 = vector.size();
        for (int i = n3 - 1; i >= 0; --i) {
            MenuElement menuElement = (MenuElement)vector.elementAt(i);
            MenuElement[] menuElementArray = menuElement.getSubElements();
            int n4 = menuElementArray.length;
            for (int j = 0; j < n4; ++j) {
                int n5;
                int n6;
                Component component2;
                if (menuElementArray[j] == null || !(component2 = menuElementArray[j].getComponent()).isShowing()) continue;
                if (component2 instanceof JComponent) {
                    n6 = ((JComponent)component2).getWidth();
                    n5 = ((JComponent)component2).getHeight();
                } else {
                    Rectangle rectangle = component2.getBounds();
                    n6 = rectangle.width;
                    n5 = rectangle.height;
                }
                point2.x = n;
                point2.y = n2;
                SwingUtilities.convertPointFromScreen(point2, component2);
                if (point2.x < 0 || point2.x >= n6 || point2.y < 0 || point2.y >= n5) continue;
                return component2;
            }
        }
        return null;
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        Vector vector = (Vector)this.selection.clone();
        int n = vector.size();
        for (int i = n - 1; i >= 0; --i) {
            MenuElement menuElement = (MenuElement)vector.elementAt(i);
            MenuElement[] menuElementArray = menuElement.getSubElements();
            MenuElement[] menuElementArray2 = null;
            int n2 = menuElementArray.length;
            for (int j = 0; j < n2; ++j) {
                Component component;
                if (menuElementArray[j] == null || !(component = menuElementArray[j].getComponent()).isShowing()) continue;
                if (menuElementArray2 == null) {
                    menuElementArray2 = new MenuElement[i + 2];
                    for (int k = 0; k <= i; ++k) {
                        menuElementArray2[k] = (MenuElement)vector.elementAt(k);
                    }
                }
                menuElementArray2[i + 1] = menuElementArray[j];
                menuElementArray[j].processKeyEvent(keyEvent, menuElementArray2, this);
                if (!keyEvent.isConsumed()) continue;
                return;
            }
        }
    }

    public boolean isComponentPartOfCurrentMenu(Component component) {
        if (this.selection.size() > 0) {
            MenuElement menuElement = (MenuElement)this.selection.elementAt(0);
            return this.isComponentPartOfCurrentMenu(menuElement, component);
        }
        return false;
    }

    private boolean isComponentPartOfCurrentMenu(MenuElement menuElement, Component component) {
        if (menuElement == null) {
            return false;
        }
        if (menuElement.getComponent() == component) {
            return true;
        }
        MenuElement[] menuElementArray = menuElement.getSubElements();
        int n = menuElementArray.length;
        for (int i = 0; i < n; ++i) {
            if (!this.isComponentPartOfCurrentMenu(menuElementArray[i], component)) continue;
            return true;
        }
        return false;
    }
}

