/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.filechooser.FileSystemView;
import sun.awt.shell.ShellFolder;

public class BasicDirectoryModel
extends AbstractListModel
implements PropertyChangeListener {
    private JFileChooser filechooser = null;
    private Vector fileCache = new Vector(50);
    private LoadFilesThread loadThread = null;
    private Vector files = null;
    private Vector directories = null;
    private int fetchID = 0;

    public BasicDirectoryModel(JFileChooser jFileChooser) {
        this.filechooser = jFileChooser;
        this.validateFileCache();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string == "directoryChanged" || string == "fileViewChanged" || string == "fileFilterChanged" || string == "FileHidingChanged" || string == "fileSelectionChanged") {
            this.validateFileCache();
        }
    }

    public void invalidateFileCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getDirectories() {
        Vector vector = this.fileCache;
        synchronized (vector) {
            if (this.directories != null) {
                return this.directories;
            }
            Vector vector2 = this.getFiles();
            return this.directories;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getFiles() {
        Vector vector = this.fileCache;
        synchronized (vector) {
            if (this.files != null) {
                return this.files;
            }
            this.files = new Vector();
            this.directories = new Vector();
            this.directories.addElement(this.filechooser.getFileSystemView().createFileObject(this.filechooser.getCurrentDirectory(), ".."));
            for (int i = 0; i < this.getSize(); ++i) {
                File file = (File)this.fileCache.get(i);
                if (this.filechooser.isTraversable(file)) {
                    this.directories.add(file);
                    continue;
                }
                this.files.add(file);
            }
            return this.files;
        }
    }

    public void validateFileCache() {
        File file = this.filechooser.getCurrentDirectory();
        if (file == null) {
            return;
        }
        if (this.loadThread != null) {
            this.loadThread.interrupt();
        }
        ++this.fetchID;
        this.loadThread = new LoadFilesThread(file, this.fetchID);
        this.loadThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean renameFile(File file, File file2) {
        Vector vector = this.fileCache;
        synchronized (vector) {
            if (file.renameTo(file2)) {
                this.validateFileCache();
                return true;
            }
            return false;
        }
    }

    public void fireContentsChanged() {
        this.fireContentsChanged(this, 0, this.getSize() - 1);
    }

    public int getSize() {
        return this.fileCache.size();
    }

    public boolean contains(Object object) {
        return this.fileCache.contains(object);
    }

    public int indexOf(Object object) {
        return this.fileCache.indexOf(object);
    }

    public Object getElementAt(int n) {
        return this.fileCache.get(n);
    }

    public void intervalAdded(ListDataEvent listDataEvent) {
    }

    public void intervalRemoved(ListDataEvent listDataEvent) {
    }

    protected void sort(Vector vector) {
        ShellFolder.sortFiles(vector);
    }

    protected boolean lt(File file, File file2) {
        int n = file.getName().toLowerCase().compareTo(file2.getName().toLowerCase());
        if (n != 0) {
            return n < 0;
        }
        return file.getName().compareTo(file2.getName()) < 0;
    }

    class DoChangeContents
    implements Runnable {
        private List addFiles;
        private List remFiles;
        private boolean doFire = true;
        private int fid;
        private int addStart = 0;
        private int remStart = 0;
        private int change;

        public DoChangeContents(List list, int n, List list2, int n2, int n3) {
            this.addFiles = list;
            this.addStart = n;
            this.remFiles = list2;
            this.remStart = n2;
            this.fid = n3;
        }

        synchronized void cancel() {
            this.doFire = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void run() {
            if (BasicDirectoryModel.this.fetchID == this.fid && this.doFire) {
                int n = this.remFiles == null ? 0 : this.remFiles.size();
                int n2 = this.addFiles == null ? 0 : this.addFiles.size();
                Vector vector = BasicDirectoryModel.this.fileCache;
                synchronized (vector) {
                    if (n > 0) {
                        BasicDirectoryModel.this.fileCache.removeAll(this.remFiles);
                    }
                    if (n2 > 0) {
                        BasicDirectoryModel.this.fileCache.addAll(this.addStart, this.addFiles);
                    }
                    BasicDirectoryModel.this.files = null;
                    BasicDirectoryModel.this.directories = null;
                }
                if (n > 0 && n2 == 0) {
                    BasicDirectoryModel.this.fireIntervalRemoved(BasicDirectoryModel.this, this.remStart, this.remStart + n - 1);
                } else if (n2 > 0 && n == 0 && BasicDirectoryModel.this.fileCache.size() > n2) {
                    BasicDirectoryModel.this.fireIntervalAdded(BasicDirectoryModel.this, this.addStart, this.addStart + n2 - 1);
                }
                BasicDirectoryModel.this.fireContentsChanged();
            }
        }
    }

    class LoadFilesThread
    extends Thread {
        File currentDirectory;
        int fid;
        Vector runnables;

        public LoadFilesThread(File file, int n) {
            super("Basic L&F File Loading Thread");
            this.currentDirectory = null;
            this.runnables = new Vector(10);
            this.currentDirectory = file;
            this.fid = n;
        }

        private void invokeLater(Runnable runnable) {
            this.runnables.addElement(runnable);
            SwingUtilities.invokeLater(runnable);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            int n;
            File[] fileArray;
            FileSystemView fileSystemView = BasicDirectoryModel.this.filechooser.getFileSystemView();
            Object object = fileSystemView;
            synchronized (object) {
                fileArray = fileSystemView.getFiles(this.currentDirectory, BasicDirectoryModel.this.filechooser.isFileHidingEnabled());
            }
            object = new Vector();
            if (this.isInterrupted()) {
                return;
            }
            for (int i = 0; i < fileArray.length; ++i) {
                if (!BasicDirectoryModel.this.filechooser.accept(fileArray[i])) continue;
                ((Vector)object).addElement(fileArray[i]);
            }
            if (this.isInterrupted()) {
                return;
            }
            BasicDirectoryModel.this.sort((Vector)object);
            Vector<File> vector = new Vector<File>(50);
            Vector<File> vector2 = new Vector<File>();
            for (int i = 0; i < ((Vector)object).size(); ++i) {
                File file = (File)((Vector)object).elementAt(i);
                n = BasicDirectoryModel.this.filechooser.isTraversable(file);
                if (n != 0) {
                    vector.addElement(file);
                } else if (n == 0 && BasicDirectoryModel.this.filechooser.isFileSelectionEnabled()) {
                    vector2.addElement(file);
                }
                if (!this.isInterrupted()) continue;
                return;
            }
            Vector<File> vector3 = new Vector<File>(vector);
            vector3.addAll(vector2);
            int n2 = vector3.size();
            n = BasicDirectoryModel.this.fileCache.size();
            if (n2 > n) {
                int n3 = n;
                int n4 = n2;
                block5: for (int i = 0; i < n; ++i) {
                    if (vector3.get(i).equals(BasicDirectoryModel.this.fileCache.get(i))) continue;
                    n3 = i;
                    for (int j = i; j < n2; ++j) {
                        if (!vector3.get(j).equals(BasicDirectoryModel.this.fileCache.get(i))) continue;
                        n4 = j;
                        break block5;
                    }
                    break;
                }
                if (n3 >= 0 && n4 > n3 && ((Object)vector3.subList(n4, n2)).equals(BasicDirectoryModel.this.fileCache.subList(n3, n))) {
                    this.invokeLater(new DoChangeContents(vector3.subList(n3, n4), n3, null, 0, this.fid));
                    vector3 = null;
                }
            } else if (n2 < n) {
                int n5 = -1;
                int n6 = -1;
                for (int i = 0; i < n2; ++i) {
                    if (vector3.get(i).equals(BasicDirectoryModel.this.fileCache.get(i))) continue;
                    n5 = i;
                    n6 = i + n - n2;
                    break;
                }
                if (n5 >= 0 && n6 > n5 && ((Object)BasicDirectoryModel.this.fileCache.subList(n6, n)).equals(vector3.subList(n5, n2))) {
                    this.invokeLater(new DoChangeContents(null, 0, new Vector(BasicDirectoryModel.this.fileCache.subList(n5, n6)), n5, this.fid));
                    vector3 = null;
                }
            }
            if (vector3 != null && !BasicDirectoryModel.this.fileCache.equals(vector3)) {
                this.invokeLater(new DoChangeContents(vector3, 0, BasicDirectoryModel.this.fileCache, 0, this.fid));
            }
            if (this.isInterrupted()) {
                this.cancelRunnables(this.runnables);
            }
        }

        public void cancelRunnables(Vector vector) {
            for (int i = 0; i < vector.size(); ++i) {
                ((DoChangeContents)vector.elementAt(i)).cancel();
            }
        }
    }
}

