/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToggleButtonUI;
import javax.swing.text.View;

public class BasicRadioButtonUI
extends BasicToggleButtonUI {
    private static final BasicRadioButtonUI radioButtonUI = new BasicRadioButtonUI();
    protected Icon icon;
    private boolean defaults_initialized = false;
    private static final String propertyPrefix = "RadioButton.";
    private static Dimension size = new Dimension();
    private static Rectangle viewRect = new Rectangle();
    private static Rectangle iconRect = new Rectangle();
    private static Rectangle textRect = new Rectangle();
    private static Rectangle prefViewRect = new Rectangle();
    private static Rectangle prefIconRect = new Rectangle();
    private static Rectangle prefTextRect = new Rectangle();
    private static Insets prefInsets = new Insets(0, 0, 0, 0);

    public static ComponentUI createUI(JComponent jComponent) {
        return radioButtonUI;
    }

    protected String getPropertyPrefix() {
        return propertyPrefix;
    }

    protected void installDefaults(AbstractButton abstractButton) {
        super.installDefaults(abstractButton);
        if (!this.defaults_initialized) {
            this.icon = UIManager.getIcon(this.getPropertyPrefix() + "icon");
            this.defaults_initialized = true;
        }
    }

    protected void uninstallDefaults(AbstractButton abstractButton) {
        super.uninstallDefaults(abstractButton);
        this.defaults_initialized = false;
    }

    public Icon getDefaultIcon() {
        return this.icon;
    }

    public synchronized void paint(Graphics graphics, JComponent jComponent) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        ButtonModel buttonModel = abstractButton.getModel();
        Font font = jComponent.getFont();
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Insets insets = jComponent.getInsets();
        size = abstractButton.getSize(size);
        BasicRadioButtonUI.viewRect.x = insets.left;
        BasicRadioButtonUI.viewRect.y = insets.top;
        BasicRadioButtonUI.viewRect.width = BasicRadioButtonUI.size.width - (insets.right + BasicRadioButtonUI.viewRect.x);
        BasicRadioButtonUI.viewRect.height = BasicRadioButtonUI.size.height - (insets.bottom + BasicRadioButtonUI.viewRect.y);
        BasicRadioButtonUI.iconRect.height = 0;
        BasicRadioButtonUI.iconRect.width = 0;
        BasicRadioButtonUI.iconRect.y = 0;
        BasicRadioButtonUI.iconRect.x = 0;
        BasicRadioButtonUI.textRect.height = 0;
        BasicRadioButtonUI.textRect.width = 0;
        BasicRadioButtonUI.textRect.y = 0;
        BasicRadioButtonUI.textRect.x = 0;
        Icon icon = abstractButton.getIcon();
        Object var9_9 = null;
        Object var10_10 = null;
        String string = SwingUtilities.layoutCompoundLabel(jComponent, fontMetrics, abstractButton.getText(), icon != null ? icon : this.getDefaultIcon(), abstractButton.getVerticalAlignment(), abstractButton.getHorizontalAlignment(), abstractButton.getVerticalTextPosition(), abstractButton.getHorizontalTextPosition(), viewRect, iconRect, textRect, abstractButton.getText() == null ? 0 : abstractButton.getIconTextGap());
        if (jComponent.isOpaque()) {
            graphics.setColor(abstractButton.getBackground());
            graphics.fillRect(0, 0, BasicRadioButtonUI.size.width, BasicRadioButtonUI.size.height);
        }
        if (icon != null) {
            if (!buttonModel.isEnabled()) {
                icon = buttonModel.isSelected() ? abstractButton.getDisabledSelectedIcon() : abstractButton.getDisabledIcon();
            } else if (buttonModel.isPressed() && buttonModel.isArmed()) {
                icon = abstractButton.getPressedIcon();
                if (icon == null) {
                    icon = abstractButton.getSelectedIcon();
                }
            } else if (buttonModel.isSelected()) {
                if (abstractButton.isRolloverEnabled() && buttonModel.isRollover()) {
                    icon = abstractButton.getRolloverSelectedIcon();
                    if (icon == null) {
                        icon = abstractButton.getSelectedIcon();
                    }
                } else {
                    icon = abstractButton.getSelectedIcon();
                }
            } else if (abstractButton.isRolloverEnabled() && buttonModel.isRollover()) {
                icon = abstractButton.getRolloverIcon();
            }
            if (icon == null) {
                icon = abstractButton.getIcon();
            }
            icon.paintIcon(jComponent, graphics, BasicRadioButtonUI.iconRect.x, BasicRadioButtonUI.iconRect.y);
        } else {
            this.getDefaultIcon().paintIcon(jComponent, graphics, BasicRadioButtonUI.iconRect.x, BasicRadioButtonUI.iconRect.y);
        }
        if (string != null) {
            View view = (View)jComponent.getClientProperty("html");
            if (view != null) {
                view.paint(graphics, textRect);
            } else {
                this.paintText(graphics, abstractButton, textRect, string);
            }
            if (abstractButton.hasFocus() && abstractButton.isFocusPainted() && BasicRadioButtonUI.textRect.width > 0 && BasicRadioButtonUI.textRect.height > 0) {
                this.paintFocus(graphics, textRect, size);
            }
        }
    }

    protected void paintFocus(Graphics graphics, Rectangle rectangle, Dimension dimension) {
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        if (jComponent.getComponentCount() > 0) {
            return null;
        }
        AbstractButton abstractButton = (AbstractButton)jComponent;
        String string = abstractButton.getText();
        Icon icon = abstractButton.getIcon();
        if (icon == null) {
            icon = this.getDefaultIcon();
        }
        Font font = abstractButton.getFont();
        FontMetrics fontMetrics = abstractButton.getToolkit().getFontMetrics(font);
        BasicRadioButtonUI.prefViewRect.y = 0;
        BasicRadioButtonUI.prefViewRect.x = 0;
        BasicRadioButtonUI.prefViewRect.width = Short.MAX_VALUE;
        BasicRadioButtonUI.prefViewRect.height = Short.MAX_VALUE;
        BasicRadioButtonUI.prefIconRect.height = 0;
        BasicRadioButtonUI.prefIconRect.width = 0;
        BasicRadioButtonUI.prefIconRect.y = 0;
        BasicRadioButtonUI.prefIconRect.x = 0;
        BasicRadioButtonUI.prefTextRect.height = 0;
        BasicRadioButtonUI.prefTextRect.width = 0;
        BasicRadioButtonUI.prefTextRect.y = 0;
        BasicRadioButtonUI.prefTextRect.x = 0;
        SwingUtilities.layoutCompoundLabel(jComponent, fontMetrics, string, icon, abstractButton.getVerticalAlignment(), abstractButton.getHorizontalAlignment(), abstractButton.getVerticalTextPosition(), abstractButton.getHorizontalTextPosition(), prefViewRect, prefIconRect, prefTextRect, string == null ? 0 : abstractButton.getIconTextGap());
        int n = Math.min(BasicRadioButtonUI.prefIconRect.x, BasicRadioButtonUI.prefTextRect.x);
        int n2 = Math.max(BasicRadioButtonUI.prefIconRect.x + BasicRadioButtonUI.prefIconRect.width, BasicRadioButtonUI.prefTextRect.x + BasicRadioButtonUI.prefTextRect.width);
        int n3 = Math.min(BasicRadioButtonUI.prefIconRect.y, BasicRadioButtonUI.prefTextRect.y);
        int n4 = Math.max(BasicRadioButtonUI.prefIconRect.y + BasicRadioButtonUI.prefIconRect.height, BasicRadioButtonUI.prefTextRect.y + BasicRadioButtonUI.prefTextRect.height);
        int n5 = n2 - n;
        int n6 = n4 - n3;
        prefInsets = abstractButton.getInsets(prefInsets);
        return new Dimension(n5 += BasicRadioButtonUI.prefInsets.left + BasicRadioButtonUI.prefInsets.right, n6 += BasicRadioButtonUI.prefInsets.top + BasicRadioButtonUI.prefInsets.bottom);
    }
}

