/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.awt.Container;
import java.awt.FontMetrics;
import java.awt.Shape;
import java.text.BreakIterator;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.LabelView;
import javax.swing.text.Segment;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;

public class InlineView
extends LabelView {
    private boolean nowrap;
    private AttributeSet attr;

    public InlineView(Element element) {
        super(element);
        StyleSheet styleSheet = this.getStyleSheet();
        this.attr = styleSheet.getViewAttributes(this);
    }

    public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        super.changedUpdate(documentEvent, shape, viewFactory);
        StyleSheet styleSheet = this.getStyleSheet();
        this.attr = styleSheet.getViewAttributes(this);
        this.preferenceChanged(null, true, true);
    }

    public AttributeSet getAttributes() {
        return this.attr;
    }

    public int getBreakWeight(int n, float f, float f2) {
        if (this.nowrap) {
            return 0;
        }
        return super.getBreakWeight(n, f, f2);
    }

    float getLongestWordSpan() {
        float f = 0.0f;
        try {
            Document document = this.getDocument();
            int n = this.getStartOffset();
            int n2 = this.getEndOffset();
            if (n2 > n) {
                Segment segment = new Segment();
                document.getText(n, n2 - n, segment);
                int n3 = n;
                int n4 = n;
                Container container = this.getContainer();
                BreakIterator breakIterator = container != null ? BreakIterator.getWordInstance(container.getLocale()) : BreakIterator.getWordInstance();
                breakIterator.setText(segment);
                int n5 = breakIterator.first();
                int n6 = breakIterator.next();
                while (n6 != -1) {
                    if (n6 - n5 > n4 - n3) {
                        n3 = n5;
                        n4 = n6;
                    }
                    n5 = n6;
                    n6 = breakIterator.next();
                }
                if (n4 - n3 > 0) {
                    FontMetrics fontMetrics = this.getFontMetrics();
                    int n7 = segment.offset + n3 - segment.getBeginIndex();
                    f = fontMetrics.charsWidth(segment.array, n7, n4 - n3);
                }
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return f;
    }

    protected void setPropertiesFromAttributes() {
        super.setPropertiesFromAttributes();
        AttributeSet attributeSet = this.getAttributes();
        Object object = attributeSet.getAttribute(CSS.Attribute.TEXT_DECORATION);
        boolean bl = object != null ? object.toString().indexOf("underline") >= 0 : false;
        this.setUnderline(bl);
        boolean bl2 = object != null ? object.toString().indexOf("line-through") >= 0 : false;
        this.setStrikeThrough(bl2);
        Object object2 = attributeSet.getAttribute(CSS.Attribute.VERTICAL_ALIGN);
        bl2 = object2 != null ? object2.toString().indexOf("sup") >= 0 : false;
        this.setSuperscript(bl2);
        bl2 = object2 != null ? object2.toString().indexOf("sub") >= 0 : false;
        this.setSubscript(bl2);
        Object object3 = attributeSet.getAttribute(CSS.Attribute.WHITE_SPACE);
        this.nowrap = object3 != null && object3.equals("nowrap");
    }

    protected StyleSheet getStyleSheet() {
        HTMLDocument hTMLDocument = (HTMLDocument)this.getDocument();
        return hTMLDocument.getStyleSheet();
    }
}

