/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;

class MuxingAttributeSet
implements AttributeSet,
Serializable {
    private AttributeSet[] attrs;

    public MuxingAttributeSet(AttributeSet[] attributeSetArray) {
        this.attrs = attributeSetArray;
    }

    protected MuxingAttributeSet() {
    }

    protected synchronized void setAttributes(AttributeSet[] attributeSetArray) {
        this.attrs = attributeSetArray;
    }

    protected synchronized AttributeSet[] getAttributes() {
        return this.attrs;
    }

    protected synchronized void insertAttributeSetAt(AttributeSet attributeSet, int n) {
        int n2 = this.attrs.length;
        AttributeSet[] attributeSetArray = new AttributeSet[n2 + 1];
        if (n < n2) {
            if (n > 0) {
                System.arraycopy(this.attrs, 0, attributeSetArray, 0, n);
                System.arraycopy(this.attrs, n, attributeSetArray, n + 1, n2 - n);
            } else {
                System.arraycopy(this.attrs, 0, attributeSetArray, 1, n2);
            }
        } else {
            System.arraycopy(this.attrs, 0, attributeSetArray, 0, n2);
        }
        attributeSetArray[n] = attributeSet;
        this.attrs = attributeSetArray;
    }

    protected synchronized void removeAttributeSetAt(int n) {
        int n2 = this.attrs.length;
        AttributeSet[] attributeSetArray = new AttributeSet[n2 - 1];
        if (n2 > 0) {
            if (n == 0) {
                System.arraycopy(this.attrs, 1, attributeSetArray, 0, n2 - 1);
            } else if (n < n2 - 1) {
                System.arraycopy(this.attrs, 0, attributeSetArray, 0, n);
                System.arraycopy(this.attrs, n + 1, attributeSetArray, n, n2 - n - 1);
            } else {
                System.arraycopy(this.attrs, 0, attributeSetArray, 0, n2 - 1);
            }
        }
        this.attrs = attributeSetArray;
    }

    public int getAttributeCount() {
        AttributeSet[] attributeSetArray = this.getAttributes();
        int n = 0;
        for (int i = 0; i < attributeSetArray.length; ++i) {
            n += attributeSetArray[i].getAttributeCount();
        }
        return n;
    }

    public boolean isDefined(Object object) {
        AttributeSet[] attributeSetArray = this.getAttributes();
        for (int i = 0; i < attributeSetArray.length; ++i) {
            if (!attributeSetArray[i].isDefined(object)) continue;
            return true;
        }
        return false;
    }

    public boolean isEqual(AttributeSet attributeSet) {
        return this.getAttributeCount() == attributeSet.getAttributeCount() && this.containsAttributes(attributeSet);
    }

    public AttributeSet copyAttributes() {
        AttributeSet[] attributeSetArray = this.getAttributes();
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        boolean bl = false;
        for (int i = attributeSetArray.length - 1; i >= 0; --i) {
            simpleAttributeSet.addAttributes(attributeSetArray[i]);
        }
        return simpleAttributeSet;
    }

    public Object getAttribute(Object object) {
        AttributeSet[] attributeSetArray = this.getAttributes();
        int n = attributeSetArray.length;
        for (int i = 0; i < n; ++i) {
            Object object2 = attributeSetArray[i].getAttribute(object);
            if (object2 == null) continue;
            return object2;
        }
        return null;
    }

    public Enumeration getAttributeNames() {
        return new MuxingAttributeNameEnumeration();
    }

    public boolean containsAttribute(Object object, Object object2) {
        return object2.equals(this.getAttribute(object));
    }

    public boolean containsAttributes(AttributeSet attributeSet) {
        boolean bl = true;
        Enumeration enumeration = attributeSet.getAttributeNames();
        while (bl && enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            bl = attributeSet.getAttribute(e).equals(this.getAttribute(e));
        }
        return bl;
    }

    public AttributeSet getResolveParent() {
        return null;
    }

    private class MuxingAttributeNameEnumeration
    implements Enumeration {
        private int attrIndex;
        private Enumeration currentEnum;

        MuxingAttributeNameEnumeration() {
            this.updateEnum();
        }

        public boolean hasMoreElements() {
            if (this.currentEnum == null) {
                return false;
            }
            return this.currentEnum.hasMoreElements();
        }

        public Object nextElement() {
            if (this.currentEnum == null) {
                throw new NoSuchElementException("No more names");
            }
            Object e = this.currentEnum.nextElement();
            if (!this.currentEnum.hasMoreElements()) {
                this.updateEnum();
            }
            return e;
        }

        void updateEnum() {
            AttributeSet[] attributeSetArray = MuxingAttributeSet.this.getAttributes();
            this.currentEnum = null;
            while (this.currentEnum == null && this.attrIndex < attributeSetArray.length) {
                this.currentEnum = attributeSetArray[this.attrIndex++].getAttributeNames();
                if (this.currentEnum.hasMoreElements()) continue;
                this.currentEnum = null;
            }
        }
    }
}

