/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html.parser;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.io.Serializable;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.DTD;
import javax.swing.text.html.parser.DocumentParser;
import javax.swing.text.html.parser.ResourceLoader;

public class ParserDelegator
extends HTMLEditorKit.Parser
implements Serializable {
    private static DTD dtd = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void setDefaultDTD() {
        if (dtd == null) {
            Class clazz = ParserDelegator.class;
            synchronized (clazz) {
                if (dtd == null) {
                    DTD dTD = null;
                    String string = "html32";
                    try {
                        dTD = DTD.getDTD(string);
                    }
                    catch (IOException iOException) {
                        System.out.println("Throw an exception: could not get default dtd: " + string);
                    }
                    dtd = dTD = ParserDelegator.createDTD(dTD, string);
                }
            }
        }
    }

    protected static DTD createDTD(DTD dTD, String string) {
        InputStream inputStream = null;
        boolean bl = true;
        try {
            String string2 = string + ".bdtd";
            inputStream = ParserDelegator.getResourceAsStream(string2);
            if (inputStream != null) {
                dTD.read(new DataInputStream(new BufferedInputStream(inputStream)));
                DTD.putDTDHash(string, dTD);
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        return dTD;
    }

    public ParserDelegator() {
        if (dtd == null) {
            ParserDelegator.setDefaultDTD();
        }
    }

    public void parse(Reader reader, HTMLEditorKit.ParserCallback parserCallback, boolean bl) throws IOException {
        new DocumentParser(dtd).parse(reader, parserCallback, bl);
    }

    static InputStream getResourceAsStream(String string) {
        try {
            return ResourceLoader.getResourceAsStream(string);
        }
        catch (Throwable throwable) {
            return ParserDelegator.class.getResourceAsStream(string);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        if (dtd == null) {
            ParserDelegator.setDefaultDTD();
        }
    }
}

