/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.im;

import java.awt.AWTException;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.im.spi.InputMethodDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.Locale;
import javax.swing.JApplet;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JWindow;
import sun.awt.im.AWTInputMethodMenu;
import sun.awt.im.ExecutableInputMethodManager;
import sun.awt.im.InputMethodLocator;
import sun.awt.im.InputMethodManager;
import sun.awt.im.SwingInputMethodMenu;

abstract class InputMethodMenu
implements ActionListener {
    private static boolean swingMenu = false;

    InputMethodMenu() {
    }

    static void showInputMethodMenu(Component component, Component component2) {
        if ((component instanceof JFrame || component instanceof JDialog || component instanceof JApplet || component instanceof JWindow) && !component.equals(component2)) {
            swingMenu = true;
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    public void run() {
                        ((ExecutableInputMethodManager)InputMethodManager.getInstance()).showInputMethodMenu();
                    }
                });
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
        } else {
            swingMenu = false;
            ((ExecutableInputMethodManager)InputMethodManager.getInstance()).showInputMethodMenu();
        }
    }

    static InputMethodMenu getMenu(String string) {
        if (swingMenu) {
            return new SwingInputMethodMenu(string);
        }
        return new AWTInputMethodMenu(string);
    }

    abstract void show(Component var1, int var2, int var3);

    abstract boolean isVisible();

    abstract void removeAll();

    abstract void addSeparator();

    abstract void addToComponent(Component var1);

    abstract void addMenuItem(String var1, String var2, String var3);

    abstract void addMenuItem(Object var1, String var2, String var3, String var4);

    abstract Object createSubMenu(String var1);

    abstract void addSubMenu(Object var1);

    void addOneInputMethodToMenu(InputMethodLocator inputMethodLocator, String string) {
        int n;
        InputMethodDescriptor inputMethodDescriptor = inputMethodLocator.getDescriptor();
        String string2 = inputMethodDescriptor.getInputMethodDisplayName(null, Locale.getDefault());
        String string3 = inputMethodLocator.getActionCommandString();
        Locale[] localeArray = null;
        try {
            localeArray = inputMethodDescriptor.getAvailableLocales();
            n = localeArray.length;
        }
        catch (AWTException aWTException) {
            n = 0;
        }
        if (n == 0) {
            this.addMenuItem(string2, null, string);
        } else if (n == 1) {
            if (inputMethodDescriptor.hasDynamicLocaleList()) {
                string2 = inputMethodDescriptor.getInputMethodDisplayName(localeArray[0], Locale.getDefault());
                string3 = inputMethodLocator.deriveLocator(localeArray[0]).getActionCommandString();
            }
            this.addMenuItem(string2, string3, string);
        } else {
            Object object = this.createSubMenu(string2);
            this.addSubMenu(object);
            for (int i = 0; i < n; ++i) {
                Locale locale = localeArray[i];
                String string4 = this.getLocaleName(locale);
                String string5 = inputMethodLocator.deriveLocator(locale).getActionCommandString();
                this.addMenuItem(object, string4, string5, string);
            }
        }
    }

    public synchronized void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        ((ExecutableInputMethodManager)InputMethodManager.getInstance()).changeInputMethod(string);
    }

    static boolean isSelected(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        if (string.equals(string2)) {
            return true;
        }
        int n = string2.indexOf(10);
        return n != -1 && string2.substring(0, n).equals(string);
    }

    private String getLocaleName(Locale locale) {
        String string = locale.toString();
        String string2 = Toolkit.getProperty("AWT.InputMethodLanguage." + string, null);
        if (string2 == null && ((string2 = locale.getDisplayName()) == null || string2.length() == 0)) {
            string2 = string;
        }
        return string2;
    }
}

