/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth;

import com.ibm.security.util.ResourcesMgr;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Principal;
import java.text.Format;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;

public final class PrivateCredentialPermission
extends Permission {
    private static final long serialVersionUID = 5284372143517237068L;
    private String credentialClass;
    private Set principals;
    private boolean testing = false;

    static String buildTarget(String string, Set set) {
        if (string == null || set == null || set.size() == 0) {
            throw new IllegalArgumentException(ResourcesMgr.getString("invalid null input(s)"));
        }
        String string2 = string;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Principal principal = (Principal)iterator.next();
            string2 = string2 + " " + principal.getClass().getName() + " \"" + principal.getName() + "\"";
        }
        return string2;
    }

    Set getPrincipalSet() {
        return this.principals;
    }

    PrivateCredentialPermission(String string, Set set) {
        super(string);
        this.credentialClass = string;
        this.principals = set;
    }

    public PrivateCredentialPermission(String string, String string2) {
        super(string);
        if (!"read".equalsIgnoreCase(string2)) {
            throw new IllegalArgumentException(ResourcesMgr.getString("actions can only be 'read'"));
        }
        this.init(string);
    }

    public String getCredentialClass() {
        return this.credentialClass;
    }

    public String[][] getPrincipals() {
        if (this.principals == null) {
            return new String[0][0];
        }
        String[][] stringArray = new String[this.principals.size()][2];
        Iterator iterator = this.principals.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            CredOwner credOwner = (CredOwner)iterator.next();
            stringArray[n][0] = credOwner.principalClass;
            stringArray[n][1] = credOwner.principalName;
            ++n;
        }
        return stringArray;
    }

    public boolean implies(Permission permission) {
        if (permission == null || !(permission instanceof PrivateCredentialPermission)) {
            return false;
        }
        PrivateCredentialPermission privateCredentialPermission = (PrivateCredentialPermission)permission;
        if (!this.impliesCredentialClass(this.credentialClass, privateCredentialPermission.getCredentialClass())) {
            return false;
        }
        return this.impliesPrincipalSet(this.principals, privateCredentialPermission.getPrincipalSet());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof PrivateCredentialPermission)) {
            return false;
        }
        PrivateCredentialPermission privateCredentialPermission = (PrivateCredentialPermission)object;
        return this.implies(privateCredentialPermission) && privateCredentialPermission.implies(this);
    }

    public int hashCode() {
        return this.getCredentialClass().hashCode();
    }

    public String getActions() {
        return "read";
    }

    public PermissionCollection newPermissionCollection() {
        return null;
    }

    private void init(String string) {
        this.principals = new HashSet();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ", true);
        String string2 = null;
        String string3 = null;
        if (this.testing) {
            System.out.println("whole name = " + string);
        }
        this.credentialClass = stringTokenizer.nextToken();
        if (this.testing) {
            System.out.println("Credential Class = " + this.credentialClass);
        }
        if (!stringTokenizer.hasMoreTokens()) {
            MessageFormat messageFormat = new MessageFormat(ResourcesMgr.getString("permission name [name] syntax invalid: "));
            Object[] objectArray = new Object[]{string};
            throw new IllegalArgumentException(messageFormat.format(objectArray) + ResourcesMgr.getString("Credential Class not followed by a Principal Class and Name"));
        }
        while (stringTokenizer.hasMoreTokens()) {
            Serializable serializable;
            stringTokenizer.nextToken();
            string2 = stringTokenizer.nextToken();
            if (this.testing) {
                System.out.println("    Principal Class = " + string2);
            }
            if (!stringTokenizer.hasMoreTokens()) {
                serializable = new MessageFormat(ResourcesMgr.getString("permission name [name] syntax invalid: "));
                Object[] objectArray = new Object[]{string};
                throw new IllegalArgumentException(((Format)serializable).format(objectArray) + ResourcesMgr.getString("Principal Class not followed by a Principal Name"));
            }
            stringTokenizer.nextToken();
            string3 = stringTokenizer.nextToken();
            if (!string3.startsWith("\"")) {
                serializable = new MessageFormat(ResourcesMgr.getString("permission name [name] syntax invalid: "));
                Object[] objectArray = new Object[]{string};
                throw new IllegalArgumentException(((Format)serializable).format(objectArray) + ResourcesMgr.getString("Principal Name must be surrounded by quotes"));
            }
            if (!string3.endsWith("\"")) {
                while (stringTokenizer.hasMoreTokens() && !(string3 = string3 + stringTokenizer.nextToken()).endsWith("\"")) {
                }
                if (!string3.endsWith("\"")) {
                    serializable = new MessageFormat(ResourcesMgr.getString("permission name [name] syntax invalid: "));
                    Object[] objectArray = new Object[]{string};
                    throw new IllegalArgumentException(((Format)serializable).format(objectArray) + ResourcesMgr.getString("Principal Name missing end quote"));
                }
            }
            if (this.testing) {
                System.out.println("\tprincipalName = '" + string3 + "'");
            }
            string3 = string3.substring(1, string3.length() - 1);
            if (string2.equals("*") && !string3.equals("*")) {
                throw new IllegalArgumentException(ResourcesMgr.getString("PrivateCredentialPermission Principal Class can not be a wildcard (*) value if Principal Name is not a wildcard (*) value"));
            }
            if (this.testing) {
                System.out.println("\tprincipalName = '" + string3 + "'");
            }
            serializable = new CredOwner(string2, string3);
            this.principals.add(serializable);
        }
    }

    private boolean impliesCredentialClass(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        if (this.testing) {
            System.out.println("credential class comparison: " + string + "/" + string2);
        }
        if (string.equals("*")) {
            return true;
        }
        return string.equals(string2);
    }

    private boolean impliesPrincipalSet(Set set, Set set2) {
        Object object;
        Iterator iterator;
        if (set == null || set2 == null) {
            return false;
        }
        if (this.testing) {
            iterator = set.iterator();
            for (int i = 0; i < set.size(); ++i) {
                object = (CredOwner)iterator.next();
                System.out.println("this permission set [" + i + "]= " + ((CredOwner)object).toString());
            }
        }
        if (set2.size() == 0) {
            return true;
        }
        if (set.size() == 0) {
            return false;
        }
        iterator = set.iterator();
        while (iterator.hasNext()) {
            CredOwner credOwner = (CredOwner)iterator.next();
            object = set2.iterator();
            boolean bl = false;
            while (object.hasNext()) {
                CredOwner credOwner2 = (CredOwner)object.next();
                if (!credOwner.implies(credOwner2)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.getName().indexOf(" ") == -1 && this.getName().indexOf("\"") == -1) {
            this.credentialClass = this.getName();
            this.principals = new HashSet();
        } else {
            this.init(this.getName());
        }
    }

    static class CredOwner
    implements Serializable {
        private static final long serialVersionUID = -5607449830436408266L;
        String principalClass;
        String principalName;

        CredOwner(String string, String string2) {
            this.principalClass = string;
            this.principalName = string2;
        }

        public boolean implies(Object object) {
            if (object == null || !(object instanceof CredOwner)) {
                return false;
            }
            CredOwner credOwner = (CredOwner)object;
            return !(!this.principalClass.equals("*") && !this.principalClass.equals(credOwner.principalClass) || !this.principalName.equals("*") && !this.principalName.equals(credOwner.principalName));
        }

        public String toString() {
            MessageFormat messageFormat = new MessageFormat(ResourcesMgr.getString("CredOwner:\n\tPrincipal Class = class\n\tPrincipal Name = name"));
            Object[] objectArray = new Object[]{this.principalClass, this.principalName};
            return messageFormat.format(objectArray);
        }
    }
}

