/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.b2b.scan.singleByte;

import com.ibm.xml.b2b.scan.DTDParams;
import com.ibm.xml.b2b.scan.ExternalSubsetHandler;
import com.ibm.xml.b2b.scan.singleByte.SingleByteMarkupDeclScanner;
import com.ibm.xml.b2b.util.QName;
import com.ibm.xml.b2b.util.SingleByteEncodingSupport;
import com.ibm.xml.b2b.util.XMLName;
import com.ibm.xml.b2b.util.XMLString;
import com.ibm.xml.b2b.util.entity.ParsedEntity;

public final class SingleByteExternalSubsetScanner
extends SingleByteMarkupDeclScanner {
    private static final int ENTITYSTATE_DTD_EXTERNAL_SUBSET = 0;
    private static final int ENTITYSTATE_PE_BETWEEN_MARKUP = 1;
    private static final int ENTITYSTATE_PE_WITHIN_MARKUP = 2;
    private ExternalSubsetHandler fHandler;
    private DTDParams fDTDParams;
    private ParsedEntity fEntityContent;
    private char[] fByteToCharMap;
    private byte[] fData;
    private int fCurrentOffset;
    private int fEntityDepth;
    private DTDParams[] fDTDParamsStack;
    private ParsedEntity[] fEntityContentStack;
    private byte[][] fDataStack;
    private int[] fCurrentOffsetStack;
    private int fEntityState;
    private int fIncludeSectDepth;
    private int fMarkupDepth;
    private int[] fEntityStateStack;

    public SingleByteExternalSubsetScanner(ExternalSubsetHandler externalSubsetHandler) {
        this.fHandler = externalSubsetHandler;
        this.fCurrentOffset = -1;
        this.fEntityState = -1;
        this.fDTDParamsStack = new DTDParams[4];
        this.fEntityContentStack = new ParsedEntity[4];
        this.fDataStack = new byte[4][];
        this.fCurrentOffsetStack = new int[4];
        this.fEntityStateStack = new int[4];
    }

    public void reset(boolean bl) {
        this.fIncludeSectDepth = 0;
        this.fMarkupDepth = 0;
        this.fEntityDepth = 0;
    }

    public boolean scanExternalSubset(DTDParams dTDParams, ParsedEntity parsedEntity) {
        boolean bl = false;
        this.setupContext(dTDParams, parsedEntity, 0);
        bl = this.scanExtSubsetDecl();
        this.endExternalSubset();
        return bl;
    }

    public boolean scanExtSubsetDecl(DTDParams dTDParams, ParsedEntity parsedEntity) {
        boolean bl = false;
        this.setupContext(dTDParams, parsedEntity, 1);
        bl = this.scanExtSubsetDecl();
        this.endPEReferenceBetweenMarkup();
        return bl;
    }

    public boolean scanPEWithinMarkup(DTDParams dTDParams, ParsedEntity parsedEntity) {
        this.setupContext(dTDParams, parsedEntity, 2);
        return true;
    }

    private void setupContext(DTDParams dTDParams, ParsedEntity parsedEntity, int n) {
        SingleByteEncodingSupport singleByteEncodingSupport = (SingleByteEncodingSupport)parsedEntity.encoding;
        if (this.fEntityDepth > 0) {
            int n2 = this.fEntityDepth - 1;
            if (n2 == this.fDTDParamsStack.length) {
                this.growContext();
            }
            if (this.fEntityContent.bytes != this.fData || this.fEntityContent.offset != this.fCurrentOffset) {
                throw new RuntimeException("SingleByteExternalSubsetScanner#setupContext()");
            }
            this.fDTDParamsStack[n2] = this.fDTDParams;
            this.fEntityContentStack[n2] = this.fEntityContent;
            this.fDataStack[n2] = this.fData;
            this.fCurrentOffsetStack[n2] = this.fCurrentOffset;
            this.fEntityStateStack[n2] = this.fEntityState;
        }
        this.fDTDParams = dTDParams;
        this.fEntityContent = parsedEntity;
        this.fByteToCharMap = singleByteEncodingSupport.byteToCharMap;
        this.fData = parsedEntity.bytes;
        this.fCurrentOffset = parsedEntity.offset;
        this.fEntityState = n;
        ++this.fEntityDepth;
    }

    private boolean scanExtSubsetDecl() {
        int n = this.fEntityDepth;
        while (true) {
            char c = this.fByteToCharMap[this.fData[this.fCurrentOffset] & 0xFF];
            while (c == ' ' || c == '\n' || c == '\t' || c == '\r') {
                c = this.fByteToCharMap[this.fData[++this.fCurrentOffset] & 0xFF];
            }
            if (c == '<') {
                ++this.fCurrentOffset;
                ++this.fMarkupDepth;
                if (!this.scanMarkupDecl()) {
                    return false;
                }
                --this.fMarkupDepth;
                continue;
            }
            if (c == '%') {
                XMLName xMLName = this.fDTDParams.getPEName();
                xMLName.offset = ++this.fCurrentOffset;
                while (c != ';') {
                    c = this.fByteToCharMap[this.fData[++this.fCurrentOffset] & 0xFF];
                }
                xMLName.endOffset = this.fCurrentOffset++;
                this.fEntityContent.offset = this.fCurrentOffset;
                this.fHandler.externalSubsetPEReference(xMLName);
                this.fCurrentOffset = this.fEntityContent.offset;
                this.fDTDParams.resetPEName();
                continue;
            }
            if (c == ']') {
                this.fCurrentOffset += 3;
                --this.fIncludeSectDepth;
                continue;
            }
            this.fEntityContent.offset = this.fCurrentOffset;
            if (this.fEntityDepth == n) {
                return true;
            }
            this.endOfContentWithinMarkup();
            this.fDTDParams.resetPEReferenceName();
        }
    }

    private boolean scanMarkupDecl() {
        char c = this.fByteToCharMap[this.fData[this.fCurrentOffset] & 0xFF];
        if (c == '!') {
            if ((c = this.fByteToCharMap[this.fData[++this.fCurrentOffset] & 0xFF]) == 'E' && this.fByteToCharMap[this.fData[this.fCurrentOffset + 1] & 0xFF] == 'L' && this.fByteToCharMap[this.fData[this.fCurrentOffset + 2] & 0xFF] == 'E' && this.fByteToCharMap[this.fData[this.fCurrentOffset + 3] & 0xFF] == 'M' && this.fByteToCharMap[this.fData[this.fCurrentOffset + 4] & 0xFF] == 'E' && this.fByteToCharMap[this.fData[this.fCurrentOffset + 5] & 0xFF] == 'N' && this.fByteToCharMap[this.fData[this.fCurrentOffset + 6] & 0xFF] == 'T') {
                this.fCurrentOffset += 7;
                this.scanElementDecl();
                return true;
            }
            if (c == 'A' && this.fByteToCharMap[this.fData[this.fCurrentOffset + 1] & 0xFF] == 'T' && this.fByteToCharMap[this.fData[this.fCurrentOffset + 2] & 0xFF] == 'T' && this.fByteToCharMap[this.fData[this.fCurrentOffset + 3] & 0xFF] == 'L' && this.fByteToCharMap[this.fData[this.fCurrentOffset + 4] & 0xFF] == 'I' && this.fByteToCharMap[this.fData[this.fCurrentOffset + 5] & 0xFF] == 'S' && this.fByteToCharMap[this.fData[this.fCurrentOffset + 6] & 0xFF] == 'T') {
                this.fCurrentOffset += 7;
                return this.scanAttlistDecl();
            }
            if (c == 'E' && this.fByteToCharMap[this.fData[this.fCurrentOffset + 1] & 0xFF] == 'N' && this.fByteToCharMap[this.fData[this.fCurrentOffset + 2] & 0xFF] == 'T' && this.fByteToCharMap[this.fData[this.fCurrentOffset + 3] & 0xFF] == 'I' && this.fByteToCharMap[this.fData[this.fCurrentOffset + 4] & 0xFF] == 'T' && this.fByteToCharMap[this.fData[this.fCurrentOffset + 5] & 0xFF] == 'Y') {
                this.fCurrentOffset += 6;
                return this.scanEntityDecl();
            }
            if (c == 'N' && this.fByteToCharMap[this.fData[this.fCurrentOffset + 1] & 0xFF] == 'O' && this.fByteToCharMap[this.fData[this.fCurrentOffset + 2] & 0xFF] == 'T' && this.fByteToCharMap[this.fData[this.fCurrentOffset + 3] & 0xFF] == 'A' && this.fByteToCharMap[this.fData[this.fCurrentOffset + 4] & 0xFF] == 'T' && this.fByteToCharMap[this.fData[this.fCurrentOffset + 5] & 0xFF] == 'I' && this.fByteToCharMap[this.fData[this.fCurrentOffset + 6] & 0xFF] == 'O' && this.fByteToCharMap[this.fData[this.fCurrentOffset + 7] & 0xFF] == 'N') {
                this.fCurrentOffset += 8;
                this.scanNotationDecl();
                return true;
            }
            if (c == '-') {
                this.fCurrentOffset += 2;
                this.fEntityContent.offset = this.fCurrentOffset;
                this.fCurrentOffset = SingleByteMarkupDeclScanner.scanComment(this.fHandler, this.fDTDParams, this.fEntityContent);
                return true;
            }
            ++this.fCurrentOffset;
            int n = this.fEntityDepth;
            this.checkForPEReference();
            c = this.fByteToCharMap[this.fData[this.fCurrentOffset] & 0xFF];
            if (c == 'I' && this.fByteToCharMap[this.fData[this.fCurrentOffset + 1] & 0xFF] == 'N' && this.fByteToCharMap[this.fData[this.fCurrentOffset + 2] & 0xFF] == 'C' && this.fByteToCharMap[this.fData[this.fCurrentOffset + 3] & 0xFF] == 'L' && this.fByteToCharMap[this.fData[this.fCurrentOffset + 4] & 0xFF] == 'U' && this.fByteToCharMap[this.fData[this.fCurrentOffset + 5] & 0xFF] == 'D' && this.fByteToCharMap[this.fData[this.fCurrentOffset + 6] & 0xFF] == 'E') {
                this.fCurrentOffset += 7;
                this.checkForPEReference();
                if (this.fEntityDepth != n) {
                    // empty if block
                }
                ++this.fCurrentOffset;
                ++this.fIncludeSectDepth;
                return true;
            }
            this.fCurrentOffset += 6;
            this.checkForPEReference();
            ++this.fCurrentOffset;
            this.scanIgnoreSectContents();
            return true;
        }
        this.fEntityContent.offset = ++this.fCurrentOffset;
        this.fCurrentOffset = SingleByteMarkupDeclScanner.scanPI(this.fHandler, this.fDTDParams, this.fEntityContent);
        return true;
    }

    private void scanIgnoreSectContents() {
        int n = 1;
        while (true) {
            char c;
            if ((c = this.fByteToCharMap[this.fData[this.fCurrentOffset] & 0xFF]) == '<' && this.fByteToCharMap[this.fData[this.fCurrentOffset + 1] & 0xFF] == '!' && this.fByteToCharMap[this.fData[this.fCurrentOffset + 2] & 0xFF] == '[') {
                this.fCurrentOffset += 3;
                ++n;
                continue;
            }
            if (c == ']' && this.fByteToCharMap[this.fData[this.fCurrentOffset + 1] & 0xFF] == ']' && this.fByteToCharMap[this.fData[this.fCurrentOffset + 2] & 0xFF] == '>') {
                this.fCurrentOffset += 3;
                if (--n != 0) continue;
                return;
            }
            ++this.fCurrentOffset;
        }
    }

    private void scanElementDecl() {
        char c;
        this.checkForPEReference();
        QName qName = this.fDTDParams.getElementType();
        qName.offset = this.fCurrentOffset;
        do {
            if ((c = this.fByteToCharMap[this.fData[++this.fCurrentOffset] & 0xFF]) != ':') continue;
            qName.sepOffset = this.fCurrentOffset++;
            c = this.fByteToCharMap[this.fData[this.fCurrentOffset] & 0xFF];
        } while (c != ' ' && c != '\n' && c != '\t' && c != '\r' && c != '%' && c != '\u0000');
        qName.endOffset = this.fCurrentOffset;
        this.fHandler.startElementDecl(qName);
        this.checkForPEReference();
        c = this.fByteToCharMap[this.fData[this.fCurrentOffset] & 0xFF];
        if (c == 'A') {
            this.fCurrentOffset += 3;
            this.fHandler.contentModelANY();
        } else if (c == 'E') {
            this.fCurrentOffset += 5;
            this.fHandler.contentModelEMPTY();
        } else {
            ++this.fCurrentOffset;
            ++this.fMarkupDepth;
            this.fHandler.contentModelStartGroup();
            this.checkForPEReference();
            c = this.fByteToCharMap[this.fData[this.fCurrentOffset] & 0xFF];
            if (c == '#' && this.fByteToCharMap[this.fData[this.fCurrentOffset + 1] & 0xFF] == 'P' && this.fByteToCharMap[this.fData[this.fCurrentOffset + 2] & 0xFF] == 'C' && this.fByteToCharMap[this.fData[this.fCurrentOffset + 3] & 0xFF] == 'D' && this.fByteToCharMap[this.fData[this.fCurrentOffset + 4] & 0xFF] == 'A' && this.fByteToCharMap[this.fData[this.fCurrentOffset + 5] & 0xFF] == 'T' && this.fByteToCharMap[this.fData[this.fCurrentOffset + 6] & 0xFF] == 'A') {
                this.fCurrentOffset += 7;
                this.fHandler.contentModelPCDATA();
                this.scanMixed();
            } else {
                this.scanChildren(1);
            }
        }
        this.checkForPEReference();
        ++this.fCurrentOffset;
        this.fHandler.endElementDecl();
        this.fDTDParams.resetElementType();
    }

    private void scanMixed() {
        while (true) {
            this.checkForPEReference();
            char c = this.fByteToCharMap[this.fData[this.fCurrentOffset] & 0xFF];
            if (c == ')') {
                c = this.fByteToCharMap[this.fData[++this.fCurrentOffset] & 0xFF];
                this.fHandler.contentModelEndGroup();
                --this.fMarkupDepth;
                if (c == '*') {
                    ++this.fCurrentOffset;
                    this.fHandler.contentModelOccurrence(1);
                }
                return;
            }
            this.fHandler.contentModelSeparator(0);
            this.checkForPEReference();
            QName qName = this.fDTDParams.getContentModelElement();
            qName.offset = ++this.fCurrentOffset;
            do {
                if ((c = this.fByteToCharMap[this.fData[++this.fCurrentOffset] & 0xFF]) != ':') continue;
                qName.sepOffset = this.fCurrentOffset++;
                c = this.fByteToCharMap[this.fData[this.fCurrentOffset] & 0xFF];
            } while (c != ' ' && c != '\n' && c != '\t' && c != '\r' && c != '%' && c != '\u0000' && c != '|' && c != ')');
            qName.endOffset = this.fCurrentOffset;
            this.fHandler.contentModelElement(qName);
            this.fDTDParams.resetContentModelElement();
        }
    }

    private void scanChildren(int n) {
        while (true) {
            this.scanCp(n);
            this.checkForPEReference();
            char c = this.fByteToCharMap[this.fData[this.fCurrentOffset] & 0xFF];
            if (c == ')') {
                c = this.fByteToCharMap[this.fData[++this.fCurrentOffset] & 0xFF];
                this.fHandler.contentModelEndGroup();
                --this.fMarkupDepth;
                if (c == '?') {
                    ++this.fCurrentOffset;
                    this.fHandler.contentModelOccurrence(0);
                } else if (c == '*') {
                    ++this.fCurrentOffset;
                    this.fHandler.contentModelOccurrence(1);
                } else if (c == '+') {
                    ++this.fCurrentOffset;
                    this.fHandler.contentModelOccurrence(2);
                }
                return;
            }
            ++this.fCurrentOffset;
            if (c == '|') {
                this.fHandler.contentModelSeparator(0);
            } else {
                this.fHandler.contentModelSeparator(1);
            }
            this.checkForPEReference();
        }
    }

    private void scanCp(int n) {
        char c;
        if (this.fByteToCharMap[this.fData[this.fCurrentOffset] & 0xFF] == '(') {
            ++this.fCurrentOffset;
            ++this.fMarkupDepth;
            this.fHandler.contentModelStartGroup();
            this.checkForPEReference();
            this.scanChildren(n + 1);
            return;
        }
        QName qName = this.fDTDParams.getContentModelElement();
        qName.offset = this.fCurrentOffset;
        do {
            if ((c = this.fByteToCharMap[this.fData[++this.fCurrentOffset] & 0xFF]) != ':') continue;
            qName.sepOffset = this.fCurrentOffset++;
            c = this.fByteToCharMap[this.fData[this.fCurrentOffset] & 0xFF];
        } while (c != ' ' && c != '\n' && c != '\t' && c != '\r' && c != '%' && c != '\u0000' && c != '|' && c != ',' && c != ')' && c != '?' && c != '*' && c != '+');
        qName.endOffset = this.fCurrentOffset++;
        this.fHandler.contentModelElement(qName);
        this.fDTDParams.resetContentModelElement();
        if (c == '?') {
            this.fHandler.contentModelOccurrence(0);
        } else if (c == '*') {
            ++this.fCurrentOffset;
            this.fHandler.contentModelOccurrence(1);
        } else if (c == '+') {
            ++this.fCurrentOffset;
            this.fHandler.contentModelOccurrence(2);
        }
    }

    private boolean scanAttlistDecl() {
        char c;
        DTDParams dTDParams = null;
        DTDParams dTDParams2 = null;
        this.checkForPEReference();
        QName qName = this.fDTDParams.getElementType();
        qName.offset = this.fCurrentOffset;
        do {
            if ((c = this.fByteToCharMap[this.fData[++this.fCurrentOffset] & 0xFF]) != ':') continue;
            qName.sepOffset = this.fCurrentOffset++;
            c = this.fByteToCharMap[this.fData[this.fCurrentOffset] & 0xFF];
        } while (c != ' ' && c != '\n' && c != '\t' && c != '\r' && c != '%' && c != '\u0000');
        qName.endOffset = this.fCurrentOffset;
        this.fHandler.startAttlistDecl(qName);
        while (true) {
            boolean bl;
            XMLString xMLString;
            XMLString xMLString2;
            boolean bl2;
            this.checkForPEReference();
            if (this.fByteToCharMap[this.fData[this.fCurrentOffset] & 0xFF] == '>') break;
            DTDParams dTDParams3 = this.fDTDParams;
            QName qName2 = dTDParams3.getAttributeName();
            qName2.offset = this.fCurrentOffset;
            do {
                if ((c = this.fByteToCharMap[this.fData[++this.fCurrentOffset] & 0xFF]) != ':') continue;
                qName2.sepOffset = this.fCurrentOffset++;
                c = this.fByteToCharMap[this.fData[this.fCurrentOffset] & 0xFF];
            } while (c != ' ' && c != '\n' && c != '\t' && c != '\r' && c != '%' && c != '\u0000');
            qName2.endOffset = this.fCurrentOffset;
            this.checkForPEReference();
            boolean bl3 = bl2 = this.fByteToCharMap[this.fData[this.fCurrentOffset] & 0xFF] == '(';
            if (!bl2) {
                bl2 = this.fByteToCharMap[this.fData[this.fCurrentOffset + 1] & 0xFF] == 'O';
                dTDParams = this.fDTDParams;
                xMLString2 = dTDParams.getAttributeType();
                xMLString2.offset = this.fCurrentOffset;
                while ((c = this.fByteToCharMap[this.fData[++this.fCurrentOffset] & 0xFF]) != ' ' && c != '\n' && c != '\t' && c != '\r' && c != '%' && c != '\u0000') {
                }
                xMLString2.endOffset = this.fCurrentOffset;
                if (bl2) {
                    this.checkForPEReference();
                }
            } else {
                xMLString2 = null;
            }
            this.fHandler.startAttDef(qName2, xMLString2);
            if (bl2) {
                this.fHandler.startEnumerationType();
                do {
                    this.checkForPEReference();
                    XMLString xMLString3 = this.fDTDParams.getEnumerationTypeToken();
                    xMLString3.offset = ++this.fCurrentOffset;
                    while ((c = this.fByteToCharMap[this.fData[++this.fCurrentOffset] & 0xFF]) != ' ' && c != '\n' && c != '\t' && c != '\r' && c != '%' && c != '\u0000' && c != '|' && c != ')') {
                    }
                    xMLString3.endOffset = this.fCurrentOffset;
                    this.fHandler.enumerationType(xMLString3);
                    this.fDTDParams.resetEnumerationTypeToken();
                    this.checkForPEReference();
                } while ((c = this.fByteToCharMap[this.fData[this.fCurrentOffset] & 0xFF]) != ')');
                ++this.fCurrentOffset;
                this.fHandler.endEnumerationType();
            }
            this.checkForPEReference();
            c = this.fByteToCharMap[this.fData[this.fCurrentOffset] & 0xFF];
            if (c == '#') {
                dTDParams2 = this.fDTDParams;
                xMLString = dTDParams2.getAttributeDefaultType();
                xMLString.offset = this.fCurrentOffset++;
                c = this.fByteToCharMap[this.fData[this.fCurrentOffset] & 0xFF];
                if (c == 'F' && this.fByteToCharMap[this.fData[this.fCurrentOffset + 1] & 0xFF] == 'I' && this.fByteToCharMap[this.fData[this.fCurrentOffset + 2] & 0xFF] == 'X' && this.fByteToCharMap[this.fData[this.fCurrentOffset + 3] & 0xFF] == 'E' && this.fByteToCharMap[this.fData[this.fCurrentOffset + 4] & 0xFF] == 'D') {
                    this.fCurrentOffset += 5;
                    xMLString.endOffset = this.fCurrentOffset;
                    this.checkForPEReference();
                    bl = true;
                    c = this.fByteToCharMap[this.fData[this.fCurrentOffset] & 0xFF];
                } else {
                    this.fCurrentOffset = c == 'I' && this.fByteToCharMap[this.fData[this.fCurrentOffset + 1] & 0xFF] == 'M' && this.fByteToCharMap[this.fData[this.fCurrentOffset + 2] & 0xFF] == 'P' && this.fByteToCharMap[this.fData[this.fCurrentOffset + 3] & 0xFF] == 'L' && this.fByteToCharMap[this.fData[this.fCurrentOffset + 4] & 0xFF] == 'I' && this.fByteToCharMap[this.fData[this.fCurrentOffset + 5] & 0xFF] == 'E' && this.fByteToCharMap[this.fData[this.fCurrentOffset + 6] & 0xFF] == 'D' ? (this.fCurrentOffset += 7) : (this.fCurrentOffset += 8);
                    xMLString.endOffset = this.fCurrentOffset;
                    bl = false;
                    c = this.fByteToCharMap[this.fData[this.fCurrentOffset] & 0xFF];
                }
            } else {
                xMLString = null;
                bl = true;
            }
            if (bl) {
                char c2 = c;
                this.fHandler.startDefaultAttValue();
                this.fEntityContent.offset = ++this.fCurrentOffset;
                if (!SingleByteMarkupDeclScanner.scanDefaultAttValue(this.fHandler, this.fDTDParams, this.fEntityContent, c2)) {
                    return false;
                }
                this.fCurrentOffset = this.fEntityContent.offset;
            }
            this.fHandler.endAttDef(xMLString);
            dTDParams3.resetAttributeName();
            if (xMLString2 != null) {
                dTDParams.resetAttributeType();
            }
            if (xMLString == null) continue;
            dTDParams2.resetAttributeDefaultType();
        }
        ++this.fCurrentOffset;
        this.fHandler.endAttlistDecl();
        this.fDTDParams.resetElementType();
        return true;
    }

    private boolean scanEntityDecl() {
        XMLString xMLString;
        char c;
        boolean bl;
        DTDParams dTDParams = null;
        boolean bl2 = false;
        char c2 = this.fByteToCharMap[this.fData[this.fCurrentOffset] & 0xFF];
        if (c2 == ' ' || c2 == '\n' || c2 == '\t' || c2 == '\r') {
            while ((c2 = this.fByteToCharMap[this.fData[++this.fCurrentOffset] & 0xFF]) == ' ' || c2 == '\n' || c2 == '\t' || c2 == '\r') {
            }
            if (c2 != '%') {
                bl = false;
            } else if ((c2 = this.fByteToCharMap[this.fData[++this.fCurrentOffset] & 0xFF]) == ' ' || c2 == '\n' || c2 == '\t' || c2 == '\r') {
                c2 = this.fByteToCharMap[this.fData[++this.fCurrentOffset] & 0xFF];
                this.checkForPEReference();
                bl = true;
            } else if (c2 == '%') {
                this.checkForPEReference();
                bl = true;
            } else {
                bl2 = true;
                bl = false;
            }
        } else {
            c2 = this.fByteToCharMap[this.fData[++this.fCurrentOffset] & 0xFF];
            bl2 = true;
            bl = false;
        }
        if (bl2) {
            while (true) {
                XMLName xMLName = this.fDTDParams.getPEReferenceName();
                xMLName.offset = ++this.fCurrentOffset;
                while (c2 != ';') {
                    c2 = this.fByteToCharMap[this.fData[++this.fCurrentOffset] & 0xFF];
                }
                xMLName.endOffset = this.fCurrentOffset++;
                this.fEntityContent.offset = this.fCurrentOffset;
                this.fHandler.startPEReferenceWithinMarkup(xMLName, this.fMarkupDepth);
                this.fCurrentOffset = this.fEntityContent.offset;
                while (true) {
                    c2 = this.fByteToCharMap[this.fData[this.fCurrentOffset] & 0xFF];
                    while (c2 == ' ' || c2 == '\n' || c2 == '\t' || c2 == '\r') {
                        c2 = this.fByteToCharMap[this.fData[++this.fCurrentOffset] & 0xFF];
                    }
                    this.fEntityContent.offset = this.fCurrentOffset;
                    if (c2 != '\u0000' || this.fCurrentOffset != this.fEntityContent.endOffset) break;
                    this.endOfContentWithinMarkup();
                    this.fDTDParams.resetPEReferenceName();
                }
                if (c2 != '%') break;
                ++this.fCurrentOffset;
                if (bl) continue;
                c2 = this.fByteToCharMap[this.fData[this.fCurrentOffset] & 0xFF];
                if (c2 == ' ' || c2 == '\n' || c2 == '\t' || c2 == '\r') {
                    ++this.fCurrentOffset;
                    this.checkForPEReference();
                    bl = true;
                    break;
                }
                bl = c2 == '%';
                if (!bl) continue;
            }
        }
        DTDParams dTDParams2 = this.fDTDParams;
        XMLName xMLName = dTDParams2.getEntityDeclName();
        xMLName.offset = this.fCurrentOffset;
        while ((c2 = this.fByteToCharMap[this.fData[++this.fCurrentOffset] & 0xFF]) != ' ' && c2 != '\n' && c2 != '\t' && c2 != '\r' && c2 != '%' && c2 != '\u0000') {
        }
        xMLName.endOffset = this.fCurrentOffset;
        this.checkForPEReference();
        c2 = this.fByteToCharMap[this.fData[this.fCurrentOffset] & 0xFF];
        if (c2 == '\"' || c2 == '\'') {
            char c3 = c2;
            ++this.fCurrentOffset;
            this.fHandler.startEntityValue();
            this.fEntityContent.offset = this.fCurrentOffset;
            if (!SingleByteMarkupDeclScanner.scanEntityValue(this.fHandler, this.fDTDParams, this.fEntityContent, c3)) {
                return false;
            }
            this.fCurrentOffset = this.fEntityContent.offset;
            this.checkForPEReference();
            c2 = this.fByteToCharMap[this.fData[this.fCurrentOffset] & 0xFF];
            ++this.fCurrentOffset;
            if (bl) {
                this.fHandler.internalPEDecl(xMLName);
            } else {
                this.fHandler.internalEntityDecl(xMLName);
            }
            dTDParams2.resetEntityDeclName();
            return true;
        }
        if (c2 == 'P' && this.fByteToCharMap[this.fData[this.fCurrentOffset + 1] & 0xFF] == 'U' && this.fByteToCharMap[this.fData[this.fCurrentOffset + 2] & 0xFF] == 'B' && this.fByteToCharMap[this.fData[this.fCurrentOffset + 3] & 0xFF] == 'L' && this.fByteToCharMap[this.fData[this.fCurrentOffset + 4] & 0xFF] == 'I' && this.fByteToCharMap[this.fData[this.fCurrentOffset + 5] & 0xFF] == 'C') {
            this.fCurrentOffset += 6;
            this.checkForPEReference();
            c = this.fByteToCharMap[this.fData[this.fCurrentOffset] & 0xFF];
            c2 = this.fByteToCharMap[this.fData[++this.fCurrentOffset] & 0xFF];
            dTDParams = this.fDTDParams;
            xMLString = dTDParams.getPublicID();
            xMLString.offset = this.fCurrentOffset;
            while (c2 != c) {
                c2 = this.fByteToCharMap[this.fData[++this.fCurrentOffset] & 0xFF];
            }
            xMLString.endOffset = this.fCurrentOffset++;
        } else {
            this.fCurrentOffset += 6;
            xMLString = null;
        }
        this.checkForPEReference();
        c = this.fByteToCharMap[this.fData[this.fCurrentOffset] & 0xFF];
        c2 = this.fByteToCharMap[this.fData[++this.fCurrentOffset] & 0xFF];
        DTDParams dTDParams3 = this.fDTDParams;
        XMLString xMLString2 = dTDParams3.getSystemID();
        xMLString2.offset = this.fCurrentOffset;
        while (c2 != c) {
            c2 = this.fByteToCharMap[this.fData[++this.fCurrentOffset] & 0xFF];
        }
        xMLString2.endOffset = this.fCurrentOffset++;
        this.checkForPEReference();
        c2 = this.fByteToCharMap[this.fData[this.fCurrentOffset] & 0xFF];
        if (c2 == '>') {
            ++this.fCurrentOffset;
            if (bl) {
                this.fHandler.externalPEDecl(xMLName, xMLString, xMLString2);
            } else {
                this.fHandler.externalEntityDecl(xMLName, xMLString, xMLString2);
            }
        } else {
            this.fCurrentOffset += 5;
            this.checkForPEReference();
            DTDParams dTDParams4 = this.fDTDParams;
            XMLName xMLName2 = dTDParams4.getNotationName();
            xMLName2.offset = this.fCurrentOffset;
            while ((c2 = this.fByteToCharMap[this.fData[++this.fCurrentOffset] & 0xFF]) != ' ' && c2 != '\n' && c2 != '\t' && c2 != '\r' && c2 != '%' && c2 != '\u0000' && c2 != '>') {
            }
            xMLName2.endOffset = this.fCurrentOffset++;
            this.checkForPEReference();
            this.fHandler.unparsedEntityDecl(xMLName, xMLString, xMLString2, xMLName2);
            dTDParams4.resetNotationName();
        }
        dTDParams2.resetEntityDeclName();
        if (xMLString != null) {
            dTDParams.resetPublicID();
        }
        dTDParams3.resetSystemID();
        return true;
    }

    private void scanNotationDecl() {
        XMLString xMLString;
        XMLString xMLString2;
        char c;
        char c2;
        DTDParams dTDParams = null;
        DTDParams dTDParams2 = null;
        this.checkForPEReference();
        DTDParams dTDParams3 = this.fDTDParams;
        XMLName xMLName = dTDParams3.getNotationName();
        xMLName.offset = this.fCurrentOffset;
        while ((c2 = this.fByteToCharMap[this.fData[++this.fCurrentOffset] & 0xFF]) != ' ' && c2 != '\n' && c2 != '\t' && c2 != '\r' && c2 != '%' && c2 != '\u0000') {
        }
        xMLName.endOffset = this.fCurrentOffset;
        this.checkForPEReference();
        c2 = this.fByteToCharMap[this.fData[this.fCurrentOffset] & 0xFF];
        if (c2 == 'P' && this.fByteToCharMap[this.fData[this.fCurrentOffset + 1] & 0xFF] == 'U' && this.fByteToCharMap[this.fData[this.fCurrentOffset + 2] & 0xFF] == 'B' && this.fByteToCharMap[this.fData[this.fCurrentOffset + 3] & 0xFF] == 'L' && this.fByteToCharMap[this.fData[this.fCurrentOffset + 4] & 0xFF] == 'I' && this.fByteToCharMap[this.fData[this.fCurrentOffset + 5] & 0xFF] == 'C') {
            this.fCurrentOffset += 6;
            this.checkForPEReference();
            c = this.fByteToCharMap[this.fData[this.fCurrentOffset] & 0xFF];
            c2 = this.fByteToCharMap[this.fData[++this.fCurrentOffset] & 0xFF];
            dTDParams = this.fDTDParams;
            xMLString2 = dTDParams.getPublicID();
            xMLString2.offset = this.fCurrentOffset;
            while (c2 != c) {
                c2 = this.fByteToCharMap[this.fData[++this.fCurrentOffset] & 0xFF];
            }
            xMLString2.endOffset = this.fCurrentOffset++;
        } else {
            this.fCurrentOffset += 6;
            xMLString2 = null;
        }
        c2 = this.fByteToCharMap[this.fData[this.fCurrentOffset] & 0xFF];
        if (c2 == '>') {
            xMLString = null;
        } else {
            this.checkForPEReference();
            c = this.fByteToCharMap[this.fData[this.fCurrentOffset] & 0xFF];
            if (c == '\"' || c == '\'') {
                c2 = this.fByteToCharMap[this.fData[++this.fCurrentOffset] & 0xFF];
                dTDParams2 = this.fDTDParams;
                xMLString = dTDParams2.getSystemID();
                xMLString.offset = this.fCurrentOffset;
                while (c2 != c) {
                    c2 = this.fByteToCharMap[this.fData[++this.fCurrentOffset] & 0xFF];
                }
                xMLString.endOffset = this.fCurrentOffset++;
            } else {
                xMLString = null;
            }
        }
        this.checkForPEReference();
        ++this.fCurrentOffset;
        this.fHandler.notationDecl(xMLName, xMLString2, xMLString);
        dTDParams3.resetNotationName();
        if (xMLString2 != null) {
            dTDParams.resetPublicID();
        }
        if (xMLString != null) {
            dTDParams2.resetSystemID();
        }
    }

    private void checkForPEReference() {
        while (true) {
            char c = this.fByteToCharMap[this.fData[this.fCurrentOffset] & 0xFF];
            while (c == ' ' || c == '\n' || c == '\t' || c == '\r') {
                c = this.fByteToCharMap[this.fData[++this.fCurrentOffset] & 0xFF];
            }
            this.fEntityContent.offset = this.fCurrentOffset;
            if (c == '\u0000' && this.fCurrentOffset == this.fEntityContent.endOffset) {
                this.endOfContentWithinMarkup();
                this.fDTDParams.resetPEReferenceName();
                continue;
            }
            if (c != '%') {
                return;
            }
            XMLName xMLName = this.fDTDParams.getPEReferenceName();
            xMLName.offset = ++this.fCurrentOffset;
            while (c != ';') {
                c = this.fByteToCharMap[this.fData[++this.fCurrentOffset] & 0xFF];
            }
            xMLName.endOffset = this.fCurrentOffset++;
            this.fEntityContent.offset = this.fCurrentOffset;
            this.fHandler.startPEReferenceWithinMarkup(xMLName, this.fMarkupDepth);
        }
    }

    private void endExternalSubset() {
        --this.fEntityDepth;
    }

    private void endPEReferenceBetweenMarkup() {
        --this.fEntityDepth;
        if (this.fEntityDepth > 0) {
            int n = this.fEntityDepth - 1;
            this.fDTDParams = this.fDTDParamsStack[n];
            this.fEntityContent = this.fEntityContentStack[n];
            SingleByteEncodingSupport singleByteEncodingSupport = (SingleByteEncodingSupport)this.fEntityContent.encoding;
            this.fByteToCharMap = singleByteEncodingSupport.byteToCharMap;
            this.fData = this.fDataStack[n];
            this.fCurrentOffset = this.fCurrentOffsetStack[n];
            this.fEntityState = this.fEntityStateStack[n];
        }
    }

    private void endOfContentWithinMarkup() {
        --this.fEntityDepth;
        this.fHandler.endPEReferenceWithinMarkup(this.fMarkupDepth);
        int n = this.fEntityDepth - 1;
        this.fDTDParams = this.fDTDParamsStack[n];
        this.fEntityContent = this.fEntityContentStack[n];
        SingleByteEncodingSupport singleByteEncodingSupport = (SingleByteEncodingSupport)this.fEntityContent.encoding;
        this.fByteToCharMap = singleByteEncodingSupport.byteToCharMap;
        this.fData = this.fDataStack[n];
        this.fCurrentOffset = this.fCurrentOffsetStack[n];
        this.fEntityState = this.fEntityStateStack[n];
    }

    private void growContext() {
        int n = this.fEntityDepth - 1;
        int n2 = n << 1;
        DTDParams[] dTDParamsArray = new DTDParams[n2];
        System.arraycopy(this.fDTDParamsStack, 0, dTDParamsArray, 0, n);
        this.fDTDParamsStack = dTDParamsArray;
        ParsedEntity[] parsedEntityArray = new ParsedEntity[n2];
        System.arraycopy(this.fEntityContentStack, 0, parsedEntityArray, 0, n);
        this.fEntityContentStack = parsedEntityArray;
        byte[][] byArrayArray = new byte[n2][];
        System.arraycopy(this.fDataStack, 0, byArrayArray, 0, n);
        this.fDataStack = byArrayArray;
        int[] nArray = new int[n2];
        System.arraycopy(this.fCurrentOffsetStack, 0, nArray, 0, n);
        this.fCurrentOffsetStack = nArray;
        nArray = new int[n2];
        System.arraycopy(this.fEntityStateStack, 0, nArray, 0, n);
        this.fEntityStateStack = nArray;
    }

    private SingleByteExternalSubsetScanner() {
    }
}

