/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.b2b.util;

import com.ibm.xml.b2b.util.CharConversionError;
import com.ibm.xml.b2b.util.EncodingSupport;
import com.ibm.xml.b2b.util.SingleByteEncodingSupport;

public final class EBCDICEncodingSupport
extends SingleByteEncodingSupport {
    public static final int CP037 = 0;
    public static final int CP273 = 1;
    public static final int CP277 = 2;
    public static final int CP278 = 3;
    public static final int CP280 = 4;
    public static final int CP284 = 5;
    public static final int CP285 = 6;
    public static final int CP297 = 7;
    public static final int CP500 = 8;
    public static final int CP871 = 9;
    public static final int CP1047 = 10;
    public static final int CP1140 = 11;
    public static final int CP1141 = 12;
    public static final int CP1142 = 13;
    public static final int CP1143 = 14;
    public static final int CP1144 = 15;
    public static final int CP1145 = 16;
    public static final int CP1146 = 17;
    public static final int CP1147 = 18;
    public static final int CP1148 = 19;
    public static final int CP1149 = 20;
    private static final int ENCODINGS_COUNT = 21;
    private int fEuroValue;
    private byte[] fByteMap;
    private static EncodingSupport[] fgSingletons;

    public static EncodingSupport getInstance(int n) {
        EncodingSupport encodingSupport;
        if (n < 0 || n > 20) {
            return null;
        }
        if (fgSingletons == null) {
            fgSingletons = new EncodingSupport[21];
        } else if (fgSingletons[n] != null) {
            return fgSingletons[n];
        }
        switch (n) {
            case 0: {
                encodingSupport = CP037Mappings.createEncodingSupport();
                break;
            }
            case 1: {
                encodingSupport = CP273Mappings.createEncodingSupport();
                break;
            }
            case 2: {
                encodingSupport = CP277Mappings.createEncodingSupport();
                break;
            }
            case 3: {
                encodingSupport = CP278Mappings.createEncodingSupport();
                break;
            }
            case 4: {
                encodingSupport = CP280Mappings.createEncodingSupport();
                break;
            }
            case 5: {
                encodingSupport = CP284Mappings.createEncodingSupport();
                break;
            }
            case 6: {
                encodingSupport = CP285Mappings.createEncodingSupport();
                break;
            }
            case 7: {
                encodingSupport = CP297Mappings.createEncodingSupport();
                break;
            }
            case 8: {
                encodingSupport = CP500Mappings.createEncodingSupport();
                break;
            }
            case 9: {
                encodingSupport = CP871Mappings.createEncodingSupport();
                break;
            }
            case 10: {
                encodingSupport = CP1047Mappings.createEncodingSupport();
                break;
            }
            case 11: {
                encodingSupport = CP1140Mappings.createEncodingSupport();
                break;
            }
            case 12: {
                encodingSupport = CP1141Mappings.createEncodingSupport();
                break;
            }
            case 13: {
                encodingSupport = CP1142Mappings.createEncodingSupport();
                break;
            }
            case 14: {
                encodingSupport = CP1143Mappings.createEncodingSupport();
                break;
            }
            case 15: {
                encodingSupport = CP1144Mappings.createEncodingSupport();
                break;
            }
            case 16: {
                encodingSupport = CP1145Mappings.createEncodingSupport();
                break;
            }
            case 17: {
                encodingSupport = CP1146Mappings.createEncodingSupport();
                break;
            }
            case 18: {
                encodingSupport = CP1147Mappings.createEncodingSupport();
                break;
            }
            case 19: {
                encodingSupport = CP1148Mappings.createEncodingSupport();
                break;
            }
            case 20: {
                encodingSupport = CP1149Mappings.createEncodingSupport();
                break;
            }
            default: {
                return null;
            }
        }
        EBCDICEncodingSupport.fgSingletons[n] = encodingSupport;
        return encodingSupport;
    }

    public boolean isASCIITransparent() {
        return false;
    }

    public void convertCharsToBytes(char[] cArray, int n, int n2, byte[][] byArray, int[] nArray) {
        int n3;
        int n4 = nArray[0];
        int n5 = n4 + (n2 - n);
        byte[] byArray2 = byArray[0];
        if (n5 > byArray2.length) {
            n3 = byArray2.length << 1;
            while (n5 > n3) {
                n3 <<= 1;
            }
            byArray2 = new byte[n3];
            System.arraycopy(byArray[0], 0, byArray2, 0, n4);
            byArray[0] = byArray2;
        }
        while (n4 < n5) {
            int n6;
            if ((n3 = cArray[n++]) < 256) {
                n6 = this.fByteMap[n3];
            } else if (n3 == 8364 && this.fEuroValue != -1) {
                n6 = (byte)this.fEuroValue;
            } else {
                CharConversionError.unableToConvertOutOfRangeUnicodeCharacter();
                n6 = -1;
            }
            byArray2[n4++] = n6;
        }
        nArray[0] = n4;
    }

    public int encodeCharacter(int n, byte[][] byArray, int n2) {
        int n3;
        byte[] byArray2 = byArray[0];
        int n4 = n2 + 1;
        if (n2 == byArray2.length) {
            int n5 = byArray2.length << 1;
            byArray2 = new byte[n5];
            System.arraycopy(byArray[0], 0, byArray2, 0, n2);
            byArray[0] = byArray2;
        }
        if (n < 256) {
            n3 = this.fByteMap[n];
        } else if (n == 8364 && this.fEuroValue != -1) {
            n3 = (byte)this.fEuroValue;
        } else {
            CharConversionError.unableToConvertOutOfRangeUnicodeCharacter();
            n3 = -1;
        }
        byArray2[n2++] = n3;
        return n2;
    }

    public int normalizeLineBreaks(byte[] byArray, int n, int n2, boolean[] blArray) {
        char[] cArray = this.byteToCharMap;
        boolean bl = blArray[0];
        int n3 = n;
        while (n3 < n2) {
            block8: {
                char c;
                int n4;
                block7: {
                    n4 = byArray[n3];
                    c = cArray[n4 & 0xFF];
                    if (!bl) break block7;
                    bl = false;
                    if (c == '\n' || c == '\u0085') break block8;
                }
                if (c == '\r') {
                    n4 = 21;
                    bl = true;
                } else if (c == '\u0085') {
                    n4 = 21;
                }
                byArray[n++] = n4;
            }
            ++n3;
        }
        blArray[0] = bl;
        return n;
    }

    protected EBCDICEncodingSupport(char[] cArray, int n, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        super(cArray, byArray2, byArray3);
        this.fEuroValue = n;
        this.fByteMap = byArray;
    }

    static final class CP1149Mappings {
        static final char[] fgCharMap = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u009c', '\t', '\u0086', '\u007f', '\u0097', '\u008d', '\u008e', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u009d', '\n', '\b', '\u0087', '\u0018', '\u0019', '\u0092', '\u008f', '\u001c', '\u001d', '\u001e', '\u001f', '\u0080', '\u0081', '\u0082', '\u0083', '\u0084', '\n', '\u0017', '\u001b', '\u0088', '\u0089', '\u008a', '\u008b', '\u008c', '\u0005', '\u0006', '\u0007', '\u0090', '\u0091', '\u0016', '\u0093', '\u0094', '\u0095', '\u0096', '\u0004', '\u0098', '\u0099', '\u009a', '\u009b', '\u0014', '\u0015', '\u009e', '\u001a', ' ', '\u00a0', '\u00e2', '\u00e4', '\u00e0', '\u00e1', '\u00e3', '\u00e5', '\u00e7', '\u00f1', '\u00de', '.', '<', '(', '+', '!', '&', '\u00e9', '\u00ea', '\u00eb', '\u00e8', '\u00ed', '\u00ee', '\u00ef', '\u00ec', '\u00df', '\u00c6', '$', '*', ')', ';', '\u00d6', '-', '/', '\u00c2', '\u00c4', '\u00c0', '\u00c1', '\u00c3', '\u00c5', '\u00c7', '\u00d1', '\u00a6', ',', '%', '_', '>', '?', '\u00f8', '\u00c9', '\u00ca', '\u00cb', '\u00c8', '\u00cd', '\u00ce', '\u00cf', '\u00cc', '\u00f0', ':', '#', '\u00d0', '\'', '=', '\"', '\u00d8', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', '\u00ab', '\u00bb', '`', '\u00fd', '{', '\u00b1', '\u00b0', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', '\u00aa', '\u00ba', '}', '\u00b8', ']', '\u20ac', '\u00b5', '\u00f6', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '\u00a1', '\u00bf', '@', '\u00dd', '[', '\u00ae', '\u00a2', '\u00a3', '\u00a5', '\u00b7', '\u00a9', '\u00a7', '\u00b6', '\u00bc', '\u00bd', '\u00be', '\u00ac', '|', '\u00af', '\u00a8', '\\', '\u00d7', '\u00fe', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', '\u00ad', '\u00f4', '~', '\u00f2', '\u00f3', '\u00f5', '\u00e6', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', '\u00b9', '\u00fb', '\u00fc', '\u00f9', '\u00fa', '\u00ff', '\u00b4', '\u00f7', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00b2', '\u00d4', '^', '\u00d2', '\u00d3', '\u00d5', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '\u00b3', '\u00db', '\u00dc', '\u00d9', '\u00da', '\u009f'};
        static final int fgEuroValue = 159;
        static final byte[] fgByteMap = new byte[]{0, 1, 2, 3, 55, 45, 46, 47, 22, 5, 21, 11, 12, 13, 14, 15, 16, 17, 18, 19, 60, 61, 50, 38, 24, 25, 63, 39, 28, 29, 30, 31, 64, 79, 127, 123, 91, 108, 80, 125, 77, 93, 92, 78, 107, 96, 75, 97, -16, -15, -14, -13, -12, -11, -10, -9, -8, -7, 122, 94, 76, 126, 110, 111, -84, -63, -62, -61, -60, -59, -58, -57, -56, -55, -47, -46, -45, -44, -43, -42, -41, -40, -39, -30, -29, -28, -27, -26, -25, -24, -23, -82, -66, -98, -20, 109, -116, -127, -126, -125, -124, -123, -122, -121, -120, -119, -111, -110, -109, -108, -107, -106, -105, -104, -103, -94, -93, -92, -91, -90, -89, -88, -87, -114, -69, -100, -52, 7, 32, 33, 34, 35, 36, 21, 6, 23, 40, 41, 42, 43, 44, 9, 10, 27, 48, 49, 26, 51, 52, 53, 54, 8, 56, 57, 58, 59, 4, 20, 62, -1, 65, -86, -80, -79, 63, -78, 106, -75, -67, -76, -102, -118, -70, -54, -81, -68, -112, -113, -22, -6, -32, -96, -74, -77, -99, -38, -101, -117, -73, -72, -71, -85, 100, 101, 98, 102, 99, 103, 90, 104, 116, 113, 114, 115, 120, 117, 118, 119, 124, 105, -19, -18, -21, -17, 95, -65, -128, -3, -2, -5, -4, -83, 74, 89, 68, 69, 66, 70, 67, 71, -48, 72, 84, 81, 82, 83, 88, 85, 86, 87, 121, 73, -51, -50, -53, -49, -95, -31, 112, -35, -34, -37, -36, -115, -64, -33};
        static final byte[] fgContentMap = new byte[]{5, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
        static final byte[] fgNameCharMap = new byte[]{8, 8, 8, 8, 8, 20, 8, 8, 8, 8, 8, 8, 8, 20, 8, 8, 8, 8, 8, 8, 8, 20, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 20, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 20, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 8, 8, 8, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 8, 28, 3, 2, 12, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 8, 3, 16, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 8, 3, 8, 24, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 8, 3, 8, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 8, 8, 8, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 8, 3, 8, 8, 8, 8, 8, 2, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 3, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 3, 3, 3, 3, 3, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 8, 3, 8, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 8, 3, 3, 3, 3, 8};

        CP1149Mappings() {
        }

        static EncodingSupport createEncodingSupport() {
            return new EBCDICEncodingSupport(fgCharMap, 159, fgByteMap, fgContentMap, fgNameCharMap);
        }
    }

    static final class CP1148Mappings {
        static final char[] fgCharMap = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u009c', '\t', '\u0086', '\u007f', '\u0097', '\u008d', '\u008e', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u009d', '\n', '\b', '\u0087', '\u0018', '\u0019', '\u0092', '\u008f', '\u001c', '\u001d', '\u001e', '\u001f', '\u0080', '\u0081', '\u0082', '\u0083', '\u0084', '\n', '\u0017', '\u001b', '\u0088', '\u0089', '\u008a', '\u008b', '\u008c', '\u0005', '\u0006', '\u0007', '\u0090', '\u0091', '\u0016', '\u0093', '\u0094', '\u0095', '\u0096', '\u0004', '\u0098', '\u0099', '\u009a', '\u009b', '\u0014', '\u0015', '\u009e', '\u001a', ' ', '\u00a0', '\u00e2', '\u00e4', '\u00e0', '\u00e1', '\u00e3', '\u00e5', '\u00e7', '\u00f1', '[', '.', '<', '(', '+', '!', '&', '\u00e9', '\u00ea', '\u00eb', '\u00e8', '\u00ed', '\u00ee', '\u00ef', '\u00ec', '\u00df', ']', '$', '*', ')', ';', '^', '-', '/', '\u00c2', '\u00c4', '\u00c0', '\u00c1', '\u00c3', '\u00c5', '\u00c7', '\u00d1', '\u00a6', ',', '%', '_', '>', '?', '\u00f8', '\u00c9', '\u00ca', '\u00cb', '\u00c8', '\u00cd', '\u00ce', '\u00cf', '\u00cc', '`', ':', '#', '@', '\'', '=', '\"', '\u00d8', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', '\u00ab', '\u00bb', '\u00f0', '\u00fd', '\u00fe', '\u00b1', '\u00b0', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', '\u00aa', '\u00ba', '\u00e6', '\u00b8', '\u00c6', '\u20ac', '\u00b5', '~', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '\u00a1', '\u00bf', '\u00d0', '\u00dd', '\u00de', '\u00ae', '\u00a2', '\u00a3', '\u00a5', '\u00b7', '\u00a9', '\u00a7', '\u00b6', '\u00bc', '\u00bd', '\u00be', '\u00ac', '|', '\u00af', '\u00a8', '\u00b4', '\u00d7', '{', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', '\u00ad', '\u00f4', '\u00f6', '\u00f2', '\u00f3', '\u00f5', '}', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', '\u00b9', '\u00fb', '\u00fc', '\u00f9', '\u00fa', '\u00ff', '\\', '\u00f7', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00b2', '\u00d4', '\u00d6', '\u00d2', '\u00d3', '\u00d5', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '\u00b3', '\u00db', '\u00dc', '\u00d9', '\u00da', '\u009f'};
        static final int fgEuroValue = 159;
        static final byte[] fgByteMap = new byte[]{0, 1, 2, 3, 55, 45, 46, 47, 22, 5, 21, 11, 12, 13, 14, 15, 16, 17, 18, 19, 60, 61, 50, 38, 24, 25, 63, 39, 28, 29, 30, 31, 64, 79, 127, 123, 91, 108, 80, 125, 77, 93, 92, 78, 107, 96, 75, 97, -16, -15, -14, -13, -12, -11, -10, -9, -8, -7, 122, 94, 76, 126, 110, 111, 124, -63, -62, -61, -60, -59, -58, -57, -56, -55, -47, -46, -45, -44, -43, -42, -41, -40, -39, -30, -29, -28, -27, -26, -25, -24, -23, 74, -32, 90, 95, 109, 121, -127, -126, -125, -124, -123, -122, -121, -120, -119, -111, -110, -109, -108, -107, -106, -105, -104, -103, -94, -93, -92, -91, -90, -89, -88, -87, -64, -69, -48, -95, 7, 32, 33, 34, 35, 36, 21, 6, 23, 40, 41, 42, 43, 44, 9, 10, 27, 48, 49, 26, 51, 52, 53, 54, 8, 56, 57, 58, 59, 4, 20, 62, -1, 65, -86, -80, -79, 63, -78, 106, -75, -67, -76, -102, -118, -70, -54, -81, -68, -112, -113, -22, -6, -66, -96, -74, -77, -99, -38, -101, -117, -73, -72, -71, -85, 100, 101, 98, 102, 99, 103, -98, 104, 116, 113, 114, 115, 120, 117, 118, 119, -84, 105, -19, -18, -21, -17, -20, -65, -128, -3, -2, -5, -4, -83, -82, 89, 68, 69, 66, 70, 67, 71, -100, 72, 84, 81, 82, 83, 88, 85, 86, 87, -116, 73, -51, -50, -53, -49, -52, -31, 112, -35, -34, -37, -36, -115, -114, -33};
        static final byte[] fgContentMap = new byte[]{5, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
        static final byte[] fgNameCharMap = new byte[]{8, 8, 8, 8, 8, 20, 8, 8, 8, 8, 8, 8, 8, 20, 8, 8, 8, 8, 8, 8, 8, 20, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 20, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 20, 8, 3, 3, 3, 3, 3, 3, 3, 3, 8, 2, 8, 8, 8, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 8, 8, 28, 8, 2, 12, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 8, 3, 16, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 4, 8, 8, 8, 24, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 3, 3, 3, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 3, 8, 3, 8, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 3, 3, 3, 8, 8, 8, 8, 2, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 3, 3, 3, 3, 3, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 3, 3, 3, 3, 3, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 8, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 8, 3, 3, 3, 3, 8};

        CP1148Mappings() {
        }

        static EncodingSupport createEncodingSupport() {
            return new EBCDICEncodingSupport(fgCharMap, 159, fgByteMap, fgContentMap, fgNameCharMap);
        }
    }

    static final class CP1147Mappings {
        static final char[] fgCharMap = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u009c', '\t', '\u0086', '\u007f', '\u0097', '\u008d', '\u008e', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u009d', '\n', '\b', '\u0087', '\u0018', '\u0019', '\u0092', '\u008f', '\u001c', '\u001d', '\u001e', '\u001f', '\u0080', '\u0081', '\u0082', '\u0083', '\u0084', '\n', '\u0017', '\u001b', '\u0088', '\u0089', '\u008a', '\u008b', '\u008c', '\u0005', '\u0006', '\u0007', '\u0090', '\u0091', '\u0016', '\u0093', '\u0094', '\u0095', '\u0096', '\u0004', '\u0098', '\u0099', '\u009a', '\u009b', '\u0014', '\u0015', '\u009e', '\u001a', ' ', '\u00a0', '\u00e2', '\u00e4', '@', '\u00e1', '\u00e3', '\u00e5', '\\', '\u00f1', '\u00b0', '.', '<', '(', '+', '!', '&', '{', '\u00ea', '\u00eb', '}', '\u00ed', '\u00ee', '\u00ef', '\u00ec', '\u00df', '\u00a7', '$', '*', ')', ';', '^', '-', '/', '\u00c2', '\u00c4', '\u00c0', '\u00c1', '\u00c3', '\u00c5', '\u00c7', '\u00d1', '\u00f9', ',', '%', '_', '>', '?', '\u00f8', '\u00c9', '\u00ca', '\u00cb', '\u00c8', '\u00cd', '\u00ce', '\u00cf', '\u00cc', '\u00b5', ':', '\u00a3', '\u00e0', '\'', '=', '\"', '\u00d8', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', '\u00ab', '\u00bb', '\u00f0', '\u00fd', '\u00fe', '\u00b1', '[', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', '\u00aa', '\u00ba', '\u00e6', '\u00b8', '\u00c6', '\u20ac', '`', '\u00a8', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '\u00a1', '\u00bf', '\u00d0', '\u00dd', '\u00de', '\u00ae', '\u00a2', '#', '\u00a5', '\u00b7', '\u00a9', ']', '\u00b6', '\u00bc', '\u00bd', '\u00be', '\u00ac', '|', '\u00af', '~', '\u00b4', '\u00d7', '\u00e9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', '\u00ad', '\u00f4', '\u00f6', '\u00f2', '\u00f3', '\u00f5', '\u00e8', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', '\u00b9', '\u00fb', '\u00fc', '\u00a6', '\u00fa', '\u00ff', '\u00e7', '\u00f7', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00b2', '\u00d4', '\u00d6', '\u00d2', '\u00d3', '\u00d5', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '\u00b3', '\u00db', '\u00dc', '\u00d9', '\u00da', '\u009f'};
        static final int fgEuroValue = 159;
        static final byte[] fgByteMap = new byte[]{0, 1, 2, 3, 55, 45, 46, 47, 22, 5, 21, 11, 12, 13, 14, 15, 16, 17, 18, 19, 60, 61, 50, 38, 24, 25, 63, 39, 28, 29, 30, 31, 64, 79, 127, -79, 91, 108, 80, 125, 77, 93, 92, 78, 107, 96, 75, 97, -16, -15, -14, -13, -12, -11, -10, -9, -8, -7, 122, 94, 76, 126, 110, 111, 68, -63, -62, -61, -60, -59, -58, -57, -56, -55, -47, -46, -45, -44, -43, -42, -41, -40, -39, -30, -29, -28, -27, -26, -25, -24, -23, -112, 72, -75, 95, 109, -96, -127, -126, -125, -124, -123, -122, -121, -120, -119, -111, -110, -109, -108, -107, -106, -105, -104, -103, -94, -93, -92, -91, -90, -89, -88, -87, 81, -69, 84, -67, 7, 32, 33, 34, 35, 36, 21, 6, 23, 40, 41, 42, 43, 44, 9, 10, 27, 48, 49, 26, 51, 52, 53, 54, 8, 56, 57, 58, 59, 4, 20, 62, -1, 65, -86, -80, 123, 63, -78, -35, 90, -95, -76, -102, -118, -70, -54, -81, -68, 74, -113, -22, -6, -66, 121, -74, -77, -99, -38, -101, -117, -73, -72, -71, -85, 100, 101, 98, 102, 99, 103, -98, 104, 116, 113, 114, 115, 120, 117, 118, 119, -84, 105, -19, -18, -21, -17, -20, -65, -128, -3, -2, -5, -4, -83, -82, 89, 124, 69, 66, 70, 67, 71, -100, -32, -48, -64, 82, 83, 88, 85, 86, 87, -116, 73, -51, -50, -53, -49, -52, -31, 112, 106, -34, -37, -36, -115, -114, -33};
        static final byte[] fgContentMap = new byte[]{5, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
        static final byte[] fgNameCharMap = new byte[]{8, 8, 8, 8, 8, 20, 8, 8, 8, 8, 8, 8, 8, 20, 8, 8, 8, 8, 8, 8, 8, 20, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 20, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 20, 8, 3, 3, 8, 3, 3, 3, 8, 3, 8, 2, 8, 8, 8, 8, 8, 8, 3, 3, 8, 3, 3, 3, 3, 3, 8, 8, 8, 8, 28, 8, 2, 12, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 3, 16, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 4, 8, 3, 8, 24, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 3, 3, 3, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 3, 8, 3, 8, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 3, 3, 3, 8, 8, 8, 8, 2, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 3, 3, 8, 3, 3, 3, 8, 3, 3, 3, 3, 3, 3, 3, 3, 8, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 8, 3, 3, 3, 3, 8};

        CP1147Mappings() {
        }

        static EncodingSupport createEncodingSupport() {
            return new EBCDICEncodingSupport(fgCharMap, 159, fgByteMap, fgContentMap, fgNameCharMap);
        }
    }

    static final class CP1146Mappings {
        static final char[] fgCharMap = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u009c', '\t', '\u0086', '\u007f', '\u0097', '\u008d', '\u008e', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u009d', '\n', '\b', '\u0087', '\u0018', '\u0019', '\u0092', '\u008f', '\u001c', '\u001d', '\u001e', '\u001f', '\u0080', '\u0081', '\u0082', '\u0083', '\u0084', '\n', '\u0017', '\u001b', '\u0088', '\u0089', '\u008a', '\u008b', '\u008c', '\u0005', '\u0006', '\u0007', '\u0090', '\u0091', '\u0016', '\u0093', '\u0094', '\u0095', '\u0096', '\u0004', '\u0098', '\u0099', '\u009a', '\u009b', '\u0014', '\u0015', '\u009e', '\u001a', ' ', '\u00a0', '\u00e2', '\u00e4', '\u00e0', '\u00e1', '\u00e3', '\u00e5', '\u00e7', '\u00f1', '$', '.', '<', '(', '+', '|', '&', '\u00e9', '\u00ea', '\u00eb', '\u00e8', '\u00ed', '\u00ee', '\u00ef', '\u00ec', '\u00df', '!', '\u00a3', '*', ')', ';', '\u00ac', '-', '/', '\u00c2', '\u00c4', '\u00c0', '\u00c1', '\u00c3', '\u00c5', '\u00c7', '\u00d1', '\u00a6', ',', '%', '_', '>', '?', '\u00f8', '\u00c9', '\u00ca', '\u00cb', '\u00c8', '\u00cd', '\u00ce', '\u00cf', '\u00cc', '`', ':', '#', '@', '\'', '=', '\"', '\u00d8', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', '\u00ab', '\u00bb', '\u00f0', '\u00fd', '\u00fe', '\u00b1', '\u00b0', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', '\u00aa', '\u00ba', '\u00e6', '\u00b8', '\u00c6', '\u20ac', '\u00b5', '\u00af', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '\u00a1', '\u00bf', '\u00d0', '\u00dd', '\u00de', '\u00ae', '\u00a2', '[', '\u00a5', '\u00b7', '\u00a9', '\u00a7', '\u00b6', '\u00bc', '\u00bd', '\u00be', '^', ']', '~', '\u00a8', '\u00b4', '\u00d7', '{', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', '\u00ad', '\u00f4', '\u00f6', '\u00f2', '\u00f3', '\u00f5', '}', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', '\u00b9', '\u00fb', '\u00fc', '\u00f9', '\u00fa', '\u00ff', '\\', '\u00f7', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00b2', '\u00d4', '\u00d6', '\u00d2', '\u00d3', '\u00d5', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '\u00b3', '\u00db', '\u00dc', '\u00d9', '\u00da', '\u009f'};
        static final int fgEuroValue = 159;
        static final byte[] fgByteMap = new byte[]{0, 1, 2, 3, 55, 45, 46, 47, 22, 5, 21, 11, 12, 13, 14, 15, 16, 17, 18, 19, 60, 61, 50, 38, 24, 25, 63, 39, 28, 29, 30, 31, 64, 90, 127, 123, 74, 108, 80, 125, 77, 93, 92, 78, 107, 96, 75, 97, -16, -15, -14, -13, -12, -11, -10, -9, -8, -7, 122, 94, 76, 126, 110, 111, 124, -63, -62, -61, -60, -59, -58, -57, -56, -55, -47, -46, -45, -44, -43, -42, -41, -40, -39, -30, -29, -28, -27, -26, -25, -24, -23, -79, -32, -69, -70, 109, 121, -127, -126, -125, -124, -123, -122, -121, -120, -119, -111, -110, -109, -108, -107, -106, -105, -104, -103, -94, -93, -92, -91, -90, -89, -88, -87, -64, 79, -48, -68, 7, 32, 33, 34, 35, 36, 21, 6, 23, 40, 41, 42, 43, 44, 9, 10, 27, 48, 49, 26, 51, 52, 53, 54, 8, 56, 57, 58, 59, 4, 20, 62, -1, 65, -86, -80, 91, 63, -78, 106, -75, -67, -76, -102, -118, 95, -54, -81, -95, -112, -113, -22, -6, -66, -96, -74, -77, -99, -38, -101, -117, -73, -72, -71, -85, 100, 101, 98, 102, 99, 103, -98, 104, 116, 113, 114, 115, 120, 117, 118, 119, -84, 105, -19, -18, -21, -17, -20, -65, -128, -3, -2, -5, -4, -83, -82, 89, 68, 69, 66, 70, 67, 71, -100, 72, 84, 81, 82, 83, 88, 85, 86, 87, -116, 73, -51, -50, -53, -49, -52, -31, 112, -35, -34, -37, -36, -115, -114, -33};
        static final byte[] fgContentMap = new byte[]{5, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
        static final byte[] fgNameCharMap = new byte[]{8, 8, 8, 8, 8, 20, 8, 8, 8, 8, 8, 8, 8, 20, 8, 8, 8, 8, 8, 8, 8, 20, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 20, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 20, 8, 3, 3, 3, 3, 3, 3, 3, 3, 8, 2, 8, 8, 8, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 8, 8, 28, 8, 2, 12, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 8, 3, 16, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 4, 8, 8, 8, 24, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 3, 3, 3, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 3, 8, 3, 8, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 3, 3, 3, 8, 8, 8, 8, 2, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 3, 3, 3, 3, 3, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 3, 3, 3, 3, 3, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 8, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 8, 3, 3, 3, 3, 8};

        CP1146Mappings() {
        }

        static EncodingSupport createEncodingSupport() {
            return new EBCDICEncodingSupport(fgCharMap, 159, fgByteMap, fgContentMap, fgNameCharMap);
        }
    }

    static final class CP1145Mappings {
        static final char[] fgCharMap = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u009c', '\t', '\u0086', '\u007f', '\u0097', '\u008d', '\u008e', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u009d', '\n', '\b', '\u0087', '\u0018', '\u0019', '\u0092', '\u008f', '\u001c', '\u001d', '\u001e', '\u001f', '\u0080', '\u0081', '\u0082', '\u0083', '\u0084', '\n', '\u0017', '\u001b', '\u0088', '\u0089', '\u008a', '\u008b', '\u008c', '\u0005', '\u0006', '\u0007', '\u0090', '\u0091', '\u0016', '\u0093', '\u0094', '\u0095', '\u0096', '\u0004', '\u0098', '\u0099', '\u009a', '\u009b', '\u0014', '\u0015', '\u009e', '\u001a', ' ', '\u00a0', '\u00e2', '\u00e4', '\u00e0', '\u00e1', '\u00e3', '\u00e5', '\u00e7', '\u00a6', '[', '.', '<', '(', '+', '|', '&', '\u00e9', '\u00ea', '\u00eb', '\u00e8', '\u00ed', '\u00ee', '\u00ef', '\u00ec', '\u00df', ']', '$', '*', ')', ';', '\u00ac', '-', '/', '\u00c2', '\u00c4', '\u00c0', '\u00c1', '\u00c3', '\u00c5', '\u00c7', '#', '\u00f1', ',', '%', '_', '>', '?', '\u00f8', '\u00c9', '\u00ca', '\u00cb', '\u00c8', '\u00cd', '\u00ce', '\u00cf', '\u00cc', '`', ':', '\u00d1', '@', '\'', '=', '\"', '\u00d8', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', '\u00ab', '\u00bb', '\u00f0', '\u00fd', '\u00fe', '\u00b1', '\u00b0', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', '\u00aa', '\u00ba', '\u00e6', '\u00b8', '\u00c6', '\u20ac', '\u00b5', '\u00a8', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '\u00a1', '\u00bf', '\u00d0', '\u00dd', '\u00de', '\u00ae', '\u00a2', '\u00a3', '\u00a5', '\u00b7', '\u00a9', '\u00a7', '\u00b6', '\u00bc', '\u00bd', '\u00be', '^', '!', '\u00af', '~', '\u00b4', '\u00d7', '{', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', '\u00ad', '\u00f4', '\u00f6', '\u00f2', '\u00f3', '\u00f5', '}', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', '\u00b9', '\u00fb', '\u00fc', '\u00f9', '\u00fa', '\u00ff', '\\', '\u00f7', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00b2', '\u00d4', '\u00d6', '\u00d2', '\u00d3', '\u00d5', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '\u00b3', '\u00db', '\u00dc', '\u00d9', '\u00da', '\u009f'};
        static final int fgEuroValue = 159;
        static final byte[] fgByteMap = new byte[]{0, 1, 2, 3, 55, 45, 46, 47, 22, 5, 21, 11, 12, 13, 14, 15, 16, 17, 18, 19, 60, 61, 50, 38, 24, 25, 63, 39, 28, 29, 30, 31, 64, -69, 127, 105, 91, 108, 80, 125, 77, 93, 92, 78, 107, 96, 75, 97, -16, -15, -14, -13, -12, -11, -10, -9, -8, -7, 122, 94, 76, 126, 110, 111, 124, -63, -62, -61, -60, -59, -58, -57, -56, -55, -47, -46, -45, -44, -43, -42, -41, -40, -39, -30, -29, -28, -27, -26, -25, -24, -23, 74, -32, 90, -70, 109, 121, -127, -126, -125, -124, -123, -122, -121, -120, -119, -111, -110, -109, -108, -107, -106, -105, -104, -103, -94, -93, -92, -91, -90, -89, -88, -87, -64, 79, -48, -67, 7, 32, 33, 34, 35, 36, 21, 6, 23, 40, 41, 42, 43, 44, 9, 10, 27, 48, 49, 26, 51, 52, 53, 54, 8, 56, 57, 58, 59, 4, 20, 62, -1, 65, -86, -80, -79, 63, -78, 73, -75, -95, -76, -102, -118, 95, -54, -81, -68, -112, -113, -22, -6, -66, -96, -74, -77, -99, -38, -101, -117, -73, -72, -71, -85, 100, 101, 98, 102, 99, 103, -98, 104, 116, 113, 114, 115, 120, 117, 118, 119, -84, 123, -19, -18, -21, -17, -20, -65, -128, -3, -2, -5, -4, -83, -82, 89, 68, 69, 66, 70, 67, 71, -100, 72, 84, 81, 82, 83, 88, 85, 86, 87, -116, 106, -51, -50, -53, -49, -52, -31, 112, -35, -34, -37, -36, -115, -114, -33};
        static final byte[] fgContentMap = new byte[]{5, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
        static final byte[] fgNameCharMap = new byte[]{8, 8, 8, 8, 8, 20, 8, 8, 8, 8, 8, 8, 8, 20, 8, 8, 8, 8, 8, 8, 8, 20, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 20, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 20, 8, 3, 3, 3, 3, 3, 3, 3, 8, 8, 2, 8, 8, 8, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 8, 8, 28, 8, 2, 12, 3, 3, 3, 3, 3, 3, 3, 8, 3, 8, 8, 3, 16, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 4, 3, 8, 8, 24, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 3, 3, 3, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 3, 8, 3, 8, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 3, 3, 3, 8, 8, 8, 8, 2, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 3, 3, 3, 3, 3, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 3, 3, 3, 3, 3, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 8, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 8, 3, 3, 3, 3, 8};

        CP1145Mappings() {
        }

        static EncodingSupport createEncodingSupport() {
            return new EBCDICEncodingSupport(fgCharMap, 159, fgByteMap, fgContentMap, fgNameCharMap);
        }
    }

    static final class CP1144Mappings {
        static final char[] fgCharMap = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u009c', '\t', '\u0086', '\u007f', '\u0097', '\u008d', '\u008e', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u009d', '\n', '\b', '\u0087', '\u0018', '\u0019', '\u0092', '\u008f', '\u001c', '\u001d', '\u001e', '\u001f', '\u0080', '\u0081', '\u0082', '\u0083', '\u0084', '\n', '\u0017', '\u001b', '\u0088', '\u0089', '\u008a', '\u008b', '\u008c', '\u0005', '\u0006', '\u0007', '\u0090', '\u0091', '\u0016', '\u0093', '\u0094', '\u0095', '\u0096', '\u0004', '\u0098', '\u0099', '\u009a', '\u009b', '\u0014', '\u0015', '\u009e', '\u001a', ' ', '\u00a0', '\u00e2', '\u00e4', '{', '\u00e1', '\u00e3', '\u00e5', '\\', '\u00f1', '\u00b0', '.', '<', '(', '+', '!', '&', ']', '\u00ea', '\u00eb', '}', '\u00ed', '\u00ee', '\u00ef', '~', '\u00df', '\u00e9', '$', '*', ')', ';', '^', '-', '/', '\u00c2', '\u00c4', '\u00c0', '\u00c1', '\u00c3', '\u00c5', '\u00c7', '\u00d1', '\u00f2', ',', '%', '_', '>', '?', '\u00f8', '\u00c9', '\u00ca', '\u00cb', '\u00c8', '\u00cd', '\u00ce', '\u00cf', '\u00cc', '\u00f9', ':', '\u00a3', '\u00a7', '\'', '=', '\"', '\u00d8', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', '\u00ab', '\u00bb', '\u00f0', '\u00fd', '\u00fe', '\u00b1', '[', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', '\u00aa', '\u00ba', '\u00e6', '\u00b8', '\u00c6', '\u20ac', '\u00b5', '\u00ec', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '\u00a1', '\u00bf', '\u00d0', '\u00dd', '\u00de', '\u00ae', '\u00a2', '#', '\u00a5', '\u00b7', '\u00a9', '@', '\u00b6', '\u00bc', '\u00bd', '\u00be', '\u00ac', '|', '\u00af', '\u00a8', '\u00b4', '\u00d7', '\u00e0', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', '\u00ad', '\u00f4', '\u00f6', '\u00a6', '\u00f3', '\u00f5', '\u00e8', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', '\u00b9', '\u00fb', '\u00fc', '`', '\u00fa', '\u00ff', '\u00e7', '\u00f7', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00b2', '\u00d4', '\u00d6', '\u00d2', '\u00d3', '\u00d5', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '\u00b3', '\u00db', '\u00dc', '\u00d9', '\u00da', '\u009f'};
        static final int fgEuroValue = 159;
        static final byte[] fgByteMap = new byte[]{0, 1, 2, 3, 55, 45, 46, 47, 22, 5, 21, 11, 12, 13, 14, 15, 16, 17, 18, 19, 60, 61, 50, 38, 24, 25, 63, 39, 28, 29, 30, 31, 64, 79, 127, -79, 91, 108, 80, 125, 77, 93, 92, 78, 107, 96, 75, 97, -16, -15, -14, -13, -12, -11, -10, -9, -8, -7, 122, 94, 76, 126, 110, 111, -75, -63, -62, -61, -60, -59, -58, -57, -56, -55, -47, -46, -45, -44, -43, -42, -41, -40, -39, -30, -29, -28, -27, -26, -25, -24, -23, -112, 72, 81, 95, 109, -35, -127, -126, -125, -124, -123, -122, -121, -120, -119, -111, -110, -109, -108, -107, -106, -105, -104, -103, -94, -93, -92, -91, -90, -89, -88, -87, 68, -69, 84, 88, 7, 32, 33, 34, 35, 36, 21, 6, 23, 40, 41, 42, 43, 44, 9, 10, 27, 48, 49, 26, 51, 52, 53, 54, 8, 56, 57, 58, 59, 4, 20, 62, -1, 65, -86, -80, 123, 63, -78, -51, 124, -67, -76, -102, -118, -70, -54, -81, -68, 74, -113, -22, -6, -66, -96, -74, -77, -99, -38, -101, -117, -73, -72, -71, -85, 100, 101, 98, 102, 99, 103, -98, 104, 116, 113, 114, 115, 120, 117, 118, 119, -84, 105, -19, -18, -21, -17, -20, -65, -128, -3, -2, -5, -4, -83, -82, 89, -64, 69, 66, 70, 67, 71, -100, -32, -48, 90, 82, 83, -95, 85, 86, 87, -116, 73, 106, -50, -53, -49, -52, -31, 112, 121, -34, -37, -36, -115, -114, -33};
        static final byte[] fgContentMap = new byte[]{5, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 3, 4, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
        static final byte[] fgNameCharMap = new byte[]{8, 8, 8, 8, 8, 20, 8, 8, 8, 8, 8, 8, 8, 20, 8, 8, 8, 8, 8, 8, 8, 20, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 20, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 20, 8, 3, 3, 8, 3, 3, 3, 8, 3, 8, 2, 8, 8, 8, 8, 8, 8, 3, 3, 8, 3, 3, 3, 8, 3, 3, 8, 8, 8, 28, 8, 2, 12, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 3, 16, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 8, 8, 8, 24, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 3, 3, 3, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 3, 8, 3, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 3, 3, 3, 8, 8, 8, 8, 2, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 3, 3, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 3, 3, 8, 3, 3, 3, 8, 3, 3, 3, 3, 3, 3, 3, 3, 8, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 8, 3, 3, 3, 3, 8};

        CP1144Mappings() {
        }

        static EncodingSupport createEncodingSupport() {
            return new EBCDICEncodingSupport(fgCharMap, 159, fgByteMap, fgContentMap, fgNameCharMap);
        }
    }

    static final class CP1143Mappings {
        static final char[] fgCharMap = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u009c', '\t', '\u0086', '\u007f', '\u0097', '\u008d', '\u008e', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u009d', '\n', '\b', '\u0087', '\u0018', '\u0019', '\u0092', '\u008f', '\u001c', '\u001d', '\u001e', '\u001f', '\u0080', '\u0081', '\u0082', '\u0083', '\u0084', '\n', '\u0017', '\u001b', '\u0088', '\u0089', '\u008a', '\u008b', '\u008c', '\u0005', '\u0006', '\u0007', '\u0090', '\u0091', '\u0016', '\u0093', '\u0094', '\u0095', '\u0096', '\u0004', '\u0098', '\u0099', '\u009a', '\u009b', '\u0014', '\u0015', '\u009e', '\u001a', ' ', '\u00a0', '\u00e2', '{', '\u00e0', '\u00e1', '\u00e3', '}', '\u00e7', '\u00f1', '\u00a7', '.', '<', '(', '+', '!', '&', '`', '\u00ea', '\u00eb', '\u00e8', '\u00ed', '\u00ee', '\u00ef', '\u00ec', '\u00df', '\u20ac', '\u00c5', '*', ')', ';', '^', '-', '/', '\u00c2', '#', '\u00c0', '\u00c1', '\u00c3', '$', '\u00c7', '\u00d1', '\u00f6', ',', '%', '_', '>', '?', '\u00f8', '\\', '\u00ca', '\u00cb', '\u00c8', '\u00cd', '\u00ce', '\u00cf', '\u00cc', '\u00e9', ':', '\u00c4', '\u00d6', '\'', '=', '\"', '\u00d8', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', '\u00ab', '\u00bb', '\u00f0', '\u00fd', '\u00fe', '\u00b1', '\u00b0', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', '\u00aa', '\u00ba', '\u00e6', '\u00b8', '\u00c6', ']', '\u00b5', '\u00fc', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '\u00a1', '\u00bf', '\u00d0', '\u00dd', '\u00de', '\u00ae', '\u00a2', '\u00a3', '\u00a5', '\u00b7', '\u00a9', '[', '\u00b6', '\u00bc', '\u00bd', '\u00be', '\u00ac', '|', '\u00af', '\u00a8', '\u00b4', '\u00d7', '\u00e4', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', '\u00ad', '\u00f4', '\u00a6', '\u00f2', '\u00f3', '\u00f5', '\u00e5', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', '\u00b9', '\u00fb', '~', '\u00f9', '\u00fa', '\u00ff', '\u00c9', '\u00f7', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00b2', '\u00d4', '@', '\u00d2', '\u00d3', '\u00d5', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '\u00b3', '\u00db', '\u00dc', '\u00d9', '\u00da', '\u009f'};
        static final int fgEuroValue = 90;
        static final byte[] fgByteMap = new byte[]{0, 1, 2, 3, 55, 45, 46, 47, 22, 5, 21, 11, 12, 13, 14, 15, 16, 17, 18, 19, 60, 61, 50, 38, 24, 25, 63, 39, 28, 29, 30, 31, 64, 79, 127, 99, 103, 108, 80, 125, 77, 93, 92, 78, 107, 96, 75, 97, -16, -15, -14, -13, -12, -11, -10, -9, -8, -7, 122, 94, 76, 126, 110, 111, -20, -63, -62, -61, -60, -59, -58, -57, -56, -55, -47, -46, -45, -44, -43, -42, -41, -40, -39, -30, -29, -28, -27, -26, -25, -24, -23, -75, 113, -97, 95, 109, 81, -127, -126, -125, -124, -123, -122, -121, -120, -119, -111, -110, -109, -108, -107, -106, -105, -104, -103, -94, -93, -92, -91, -90, -89, -88, -87, 67, -69, 71, -36, 7, 32, 33, 34, 35, 36, 21, 6, 23, 40, 41, 42, 43, 44, 9, 10, 27, 48, 49, 26, 51, 52, 53, 54, 8, 56, 57, 58, 59, 4, 20, 62, -1, 65, -86, -80, -79, 63, -78, -52, 74, -67, -76, -102, -118, -70, -54, -81, -68, -112, -113, -22, -6, -66, -96, -74, -77, -99, -38, -101, -117, -73, -72, -71, -85, 100, 101, 98, 102, 123, 91, -98, 104, 116, -32, 114, 115, 120, 117, 118, 119, -84, 105, -19, -18, -21, -17, 124, -65, -128, -3, -2, -5, -4, -83, -82, 89, 68, 69, 66, 70, -64, -48, -100, 72, 84, 121, 82, 83, 88, 85, 86, 87, -116, 73, -51, -50, -53, -49, 106, -31, 112, -35, -34, -37, -95, -115, -114, -33};
        static final byte[] fgContentMap = new byte[]{5, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
        static final byte[] fgNameCharMap = new byte[]{8, 8, 8, 8, 8, 20, 8, 8, 8, 8, 8, 8, 8, 20, 8, 8, 8, 8, 8, 8, 8, 20, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 20, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 20, 8, 3, 8, 3, 3, 3, 8, 3, 3, 8, 2, 8, 8, 8, 8, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 8, 3, 8, 8, 28, 8, 2, 12, 3, 8, 3, 3, 3, 8, 3, 3, 3, 8, 8, 3, 16, 8, 3, 8, 3, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 8, 24, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 3, 3, 3, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 3, 8, 3, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 3, 3, 3, 8, 8, 8, 8, 2, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 3, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 3, 8, 3, 3, 3, 3, 8, 3, 3, 3, 3, 3, 3, 3, 3, 8, 3, 8, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 8, 3, 3, 3, 3, 8};

        CP1143Mappings() {
        }

        static EncodingSupport createEncodingSupport() {
            return new EBCDICEncodingSupport(fgCharMap, 90, fgByteMap, fgContentMap, fgNameCharMap);
        }
    }

    static final class CP1142Mappings {
        static final char[] fgCharMap = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u009c', '\t', '\u0086', '\u007f', '\u0097', '\u008d', '\u008e', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u009d', '\n', '\b', '\u0087', '\u0018', '\u0019', '\u0092', '\u008f', '\u001c', '\u001d', '\u001e', '\u001f', '\u0080', '\u0081', '\u0082', '\u0083', '\u0084', '\n', '\u0017', '\u001b', '\u0088', '\u0089', '\u008a', '\u008b', '\u008c', '\u0005', '\u0006', '\u0007', '\u0090', '\u0091', '\u0016', '\u0093', '\u0094', '\u0095', '\u0096', '\u0004', '\u0098', '\u0099', '\u009a', '\u009b', '\u0014', '\u0015', '\u009e', '\u001a', ' ', '\u00a0', '\u00e2', '\u00e4', '\u00e0', '\u00e1', '\u00e3', '}', '\u00e7', '\u00f1', '#', '.', '<', '(', '+', '!', '&', '\u00e9', '\u00ea', '\u00eb', '\u00e8', '\u00ed', '\u00ee', '\u00ef', '\u00ec', '\u00df', '\u20ac', '\u00c5', '*', ')', ';', '^', '-', '/', '\u00c2', '\u00c4', '\u00c0', '\u00c1', '\u00c3', '$', '\u00c7', '\u00d1', '\u00f8', ',', '%', '_', '>', '?', '\u00a6', '\u00c9', '\u00ca', '\u00cb', '\u00c8', '\u00cd', '\u00ce', '\u00cf', '\u00cc', '`', ':', '\u00c6', '\u00d8', '\'', '=', '\"', '@', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', '\u00ab', '\u00bb', '\u00f0', '\u00fd', '\u00fe', '\u00b1', '\u00b0', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', '\u00aa', '\u00ba', '{', '\u00b8', '[', ']', '\u00b5', '\u00fc', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '\u00a1', '\u00bf', '\u00d0', '\u00dd', '\u00de', '\u00ae', '\u00a2', '\u00a3', '\u00a5', '\u00b7', '\u00a9', '\u00a7', '\u00b6', '\u00bc', '\u00bd', '\u00be', '\u00ac', '|', '\u00af', '\u00a8', '\u00b4', '\u00d7', '\u00e6', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', '\u00ad', '\u00f4', '\u00f6', '\u00f2', '\u00f3', '\u00f5', '\u00e5', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', '\u00b9', '\u00fb', '~', '\u00f9', '\u00fa', '\u00ff', '\\', '\u00f7', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00b2', '\u00d4', '\u00d6', '\u00d2', '\u00d3', '\u00d5', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '\u00b3', '\u00db', '\u00dc', '\u00d9', '\u00da', '\u009f'};
        static final int fgEuroValue = 90;
        static final byte[] fgByteMap = new byte[]{0, 1, 2, 3, 55, 45, 46, 47, 22, 5, 21, 11, 12, 13, 14, 15, 16, 17, 18, 19, 60, 61, 50, 38, 24, 25, 63, 39, 28, 29, 30, 31, 64, 79, 127, 74, 103, 108, 80, 125, 77, 93, 92, 78, 107, 96, 75, 97, -16, -15, -14, -13, -12, -11, -10, -9, -8, -7, 122, 94, 76, 126, 110, 111, -128, -63, -62, -61, -60, -59, -58, -57, -56, -55, -47, -46, -45, -44, -43, -42, -41, -40, -39, -30, -29, -28, -27, -26, -25, -24, -23, -98, -32, -97, 95, 109, 121, -127, -126, -125, -124, -123, -122, -121, -120, -119, -111, -110, -109, -108, -107, -106, -105, -104, -103, -94, -93, -92, -91, -90, -89, -88, -87, -100, -69, 71, -36, 7, 32, 33, 34, 35, 36, 21, 6, 23, 40, 41, 42, 43, 44, 9, 10, 27, 48, 49, 26, 51, 52, 53, 54, 8, 56, 57, 58, 59, 4, 20, 62, -1, 65, -86, -80, -79, 63, -78, 112, -75, -67, -76, -102, -118, -70, -54, -81, -68, -112, -113, -22, -6, -66, -96, -74, -77, -99, -38, -101, -117, -73, -72, -71, -85, 100, 101, 98, 102, 99, 91, 123, 104, 116, 113, 114, 115, 120, 117, 118, 119, -84, 105, -19, -18, -21, -17, -20, -65, 124, -3, -2, -5, -4, -83, -82, 89, 68, 69, 66, 70, 67, -48, -64, 72, 84, 81, 82, 83, 88, 85, 86, 87, -116, 73, -51, -50, -53, -49, -52, -31, 106, -35, -34, -37, -95, -115, -114, -33};
        static final byte[] fgContentMap = new byte[]{5, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
        static final byte[] fgNameCharMap = new byte[]{8, 8, 8, 8, 8, 20, 8, 8, 8, 8, 8, 8, 8, 20, 8, 8, 8, 8, 8, 8, 8, 20, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 20, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 20, 8, 3, 3, 3, 3, 3, 8, 3, 3, 8, 2, 8, 8, 8, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 3, 8, 8, 28, 8, 2, 12, 3, 3, 3, 3, 3, 8, 3, 3, 3, 8, 8, 3, 16, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 8, 4, 3, 3, 8, 24, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 3, 3, 3, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 8, 8, 8, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 3, 3, 3, 8, 8, 8, 8, 2, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 3, 8, 3, 3, 3, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 8, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 8, 3, 3, 3, 3, 8};

        CP1142Mappings() {
        }

        static EncodingSupport createEncodingSupport() {
            return new EBCDICEncodingSupport(fgCharMap, 90, fgByteMap, fgContentMap, fgNameCharMap);
        }
    }

    static final class CP1141Mappings {
        static final char[] fgCharMap = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u009c', '\t', '\u0086', '\u007f', '\u0097', '\u008d', '\u008e', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u009d', '\n', '\b', '\u0087', '\u0018', '\u0019', '\u0092', '\u008f', '\u001c', '\u001d', '\u001e', '\u001f', '\u0080', '\u0081', '\u0082', '\u0083', '\u0084', '\n', '\u0017', '\u001b', '\u0088', '\u0089', '\u008a', '\u008b', '\u008c', '\u0005', '\u0006', '\u0007', '\u0090', '\u0091', '\u0016', '\u0093', '\u0094', '\u0095', '\u0096', '\u0004', '\u0098', '\u0099', '\u009a', '\u009b', '\u0014', '\u0015', '\u009e', '\u001a', ' ', '\u00a0', '\u00e2', '{', '\u00e0', '\u00e1', '\u00e3', '\u00e5', '\u00e7', '\u00f1', '\u00c4', '.', '<', '(', '+', '!', '&', '\u00e9', '\u00ea', '\u00eb', '\u00e8', '\u00ed', '\u00ee', '\u00ef', '\u00ec', '~', '\u00dc', '$', '*', ')', ';', '^', '-', '/', '\u00c2', '[', '\u00c0', '\u00c1', '\u00c3', '\u00c5', '\u00c7', '\u00d1', '\u00f6', ',', '%', '_', '>', '?', '\u00f8', '\u00c9', '\u00ca', '\u00cb', '\u00c8', '\u00cd', '\u00ce', '\u00cf', '\u00cc', '`', ':', '#', '\u00a7', '\'', '=', '\"', '\u00d8', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', '\u00ab', '\u00bb', '\u00f0', '\u00fd', '\u00fe', '\u00b1', '\u00b0', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', '\u00aa', '\u00ba', '\u00e6', '\u00b8', '\u00c6', '\u20ac', '\u00b5', '\u00df', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '\u00a1', '\u00bf', '\u00d0', '\u00dd', '\u00de', '\u00ae', '\u00a2', '\u00a3', '\u00a5', '\u00b7', '\u00a9', '@', '\u00b6', '\u00bc', '\u00bd', '\u00be', '\u00ac', '|', '\u00af', '\u00a8', '\u00b4', '\u00d7', '\u00e4', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', '\u00ad', '\u00f4', '\u00a6', '\u00f2', '\u00f3', '\u00f5', '\u00fc', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', '\u00b9', '\u00fb', '}', '\u00f9', '\u00fa', '\u00ff', '\u00d6', '\u00f7', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00b2', '\u00d4', '\\', '\u00d2', '\u00d3', '\u00d5', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '\u00b3', '\u00db', ']', '\u00d9', '\u00da', '\u009f'};
        static final int fgEuroValue = 159;
        static final byte[] fgByteMap = new byte[]{0, 1, 2, 3, 55, 45, 46, 47, 22, 5, 21, 11, 12, 13, 14, 15, 16, 17, 18, 19, 60, 61, 50, 38, 24, 25, 63, 39, 28, 29, 30, 31, 64, 79, 127, 123, 91, 108, 80, 125, 77, 93, 92, 78, 107, 96, 75, 97, -16, -15, -14, -13, -12, -11, -10, -9, -8, -7, 122, 94, 76, 126, 110, 111, -75, -63, -62, -61, -60, -59, -58, -57, -56, -55, -47, -46, -45, -44, -43, -42, -41, -40, -39, -30, -29, -28, -27, -26, -25, -24, -23, 99, -20, -4, 95, 109, 121, -127, -126, -125, -124, -123, -122, -121, -120, -119, -111, -110, -109, -108, -107, -106, -105, -104, -103, -94, -93, -92, -91, -90, -89, -88, -87, 67, -69, -36, 89, 7, 32, 33, 34, 35, 36, 21, 6, 23, 40, 41, 42, 43, 44, 9, 10, 27, 48, 49, 26, 51, 52, 53, 54, 8, 56, 57, 58, 59, 4, 20, 62, -1, 65, -86, -80, -79, 63, -78, -52, 124, -67, -76, -102, -118, -70, -54, -81, -68, -112, -113, -22, -6, -66, -96, -74, -77, -99, -38, -101, -117, -73, -72, -71, -85, 100, 101, 98, 102, 74, 103, -98, 104, 116, 113, 114, 115, 120, 117, 118, 119, -84, 105, -19, -18, -21, -17, -32, -65, -128, -3, -2, -5, 90, -83, -82, -95, 68, 69, 66, 70, -64, 71, -100, 72, 84, 81, 82, 83, 88, 85, 86, 87, -116, 73, -51, -50, -53, -49, 106, -31, 112, -35, -34, -37, -48, -115, -114, -33};
        static final byte[] fgContentMap = new byte[]{5, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 1, 1, 1};
        static final byte[] fgNameCharMap = new byte[]{8, 8, 8, 8, 8, 20, 8, 8, 8, 8, 8, 8, 8, 20, 8, 8, 8, 8, 8, 8, 8, 20, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 20, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 20, 8, 3, 8, 3, 3, 3, 3, 3, 3, 3, 2, 8, 8, 8, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 8, 3, 8, 8, 8, 28, 8, 2, 12, 3, 8, 3, 3, 3, 3, 3, 3, 3, 8, 8, 3, 16, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 4, 8, 8, 8, 24, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 3, 3, 3, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 3, 8, 3, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 3, 3, 3, 8, 8, 8, 8, 2, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 3, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 3, 8, 3, 3, 3, 3, 8, 3, 3, 3, 3, 3, 3, 3, 3, 8, 3, 8, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 8, 3, 8, 3, 3, 8};

        CP1141Mappings() {
        }

        static EncodingSupport createEncodingSupport() {
            return new EBCDICEncodingSupport(fgCharMap, 159, fgByteMap, fgContentMap, fgNameCharMap);
        }
    }

    static final class CP1140Mappings {
        static final char[] fgCharMap = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u009c', '\t', '\u0086', '\u007f', '\u0097', '\u008d', '\u008e', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u009d', '\n', '\b', '\u0087', '\u0018', '\u0019', '\u0092', '\u008f', '\u001c', '\u001d', '\u001e', '\u001f', '\u0080', '\u0081', '\u0082', '\u0083', '\u0084', '\n', '\u0017', '\u001b', '\u0088', '\u0089', '\u008a', '\u008b', '\u008c', '\u0005', '\u0006', '\u0007', '\u0090', '\u0091', '\u0016', '\u0093', '\u0094', '\u0095', '\u0096', '\u0004', '\u0098', '\u0099', '\u009a', '\u009b', '\u0014', '\u0015', '\u009e', '\u001a', ' ', '\u00a0', '\u00e2', '\u00e4', '\u00e0', '\u00e1', '\u00e3', '\u00e5', '\u00e7', '\u00f1', '\u00a2', '.', '<', '(', '+', '|', '&', '\u00e9', '\u00ea', '\u00eb', '\u00e8', '\u00ed', '\u00ee', '\u00ef', '\u00ec', '\u00df', '!', '$', '*', ')', ';', '\u00ac', '-', '/', '\u00c2', '\u00c4', '\u00c0', '\u00c1', '\u00c3', '\u00c5', '\u00c7', '\u00d1', '\u00a6', ',', '%', '_', '>', '?', '\u00f8', '\u00c9', '\u00ca', '\u00cb', '\u00c8', '\u00cd', '\u00ce', '\u00cf', '\u00cc', '`', ':', '#', '@', '\'', '=', '\"', '\u00d8', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', '\u00ab', '\u00bb', '\u00f0', '\u00fd', '\u00fe', '\u00b1', '\u00b0', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', '\u00aa', '\u00ba', '\u00e6', '\u00b8', '\u00c6', '\u20ac', '\u00b5', '~', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '\u00a1', '\u00bf', '\u00d0', '\u00dd', '\u00de', '\u00ae', '^', '\u00a3', '\u00a5', '\u00b7', '\u00a9', '\u00a7', '\u00b6', '\u00bc', '\u00bd', '\u00be', '[', ']', '\u00af', '\u00a8', '\u00b4', '\u00d7', '{', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', '\u00ad', '\u00f4', '\u00f6', '\u00f2', '\u00f3', '\u00f5', '}', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', '\u00b9', '\u00fb', '\u00fc', '\u00f9', '\u00fa', '\u00ff', '\\', '\u00f7', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00b2', '\u00d4', '\u00d6', '\u00d2', '\u00d3', '\u00d5', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '\u00b3', '\u00db', '\u00dc', '\u00d9', '\u00da', '\u009f'};
        static final int fgEuroValue = 159;
        static final byte[] fgByteMap = new byte[]{0, 1, 2, 3, 55, 45, 46, 47, 22, 5, 21, 11, 12, 13, 14, 15, 16, 17, 18, 19, 60, 61, 50, 38, 24, 25, 63, 39, 28, 29, 30, 31, 64, 90, 127, 123, 91, 108, 80, 125, 77, 93, 92, 78, 107, 96, 75, 97, -16, -15, -14, -13, -12, -11, -10, -9, -8, -7, 122, 94, 76, 126, 110, 111, 124, -63, -62, -61, -60, -59, -58, -57, -56, -55, -47, -46, -45, -44, -43, -42, -41, -40, -39, -30, -29, -28, -27, -26, -25, -24, -23, -70, -32, -69, -80, 109, 121, -127, -126, -125, -124, -123, -122, -121, -120, -119, -111, -110, -109, -108, -107, -106, -105, -104, -103, -94, -93, -92, -91, -90, -89, -88, -87, -64, 79, -48, -95, 7, 32, 33, 34, 35, 36, 21, 6, 23, 40, 41, 42, 43, 44, 9, 10, 27, 48, 49, 26, 51, 52, 53, 54, 8, 56, 57, 58, 59, 4, 20, 62, -1, 65, -86, 74, -79, 63, -78, 106, -75, -67, -76, -102, -118, 95, -54, -81, -68, -112, -113, -22, -6, -66, -96, -74, -77, -99, -38, -101, -117, -73, -72, -71, -85, 100, 101, 98, 102, 99, 103, -98, 104, 116, 113, 114, 115, 120, 117, 118, 119, -84, 105, -19, -18, -21, -17, -20, -65, -128, -3, -2, -5, -4, -83, -82, 89, 68, 69, 66, 70, 67, 71, -100, 72, 84, 81, 82, 83, 88, 85, 86, 87, -116, 73, -51, -50, -53, -49, -52, -31, 112, -35, -34, -37, -36, -115, -114, -33};
        static final byte[] fgContentMap = new byte[]{5, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
        static final byte[] fgNameCharMap = new byte[]{8, 8, 8, 8, 8, 20, 8, 8, 8, 8, 8, 8, 8, 20, 8, 8, 8, 8, 8, 8, 8, 20, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 20, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 20, 8, 3, 3, 3, 3, 3, 3, 3, 3, 8, 2, 8, 8, 8, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 8, 8, 28, 8, 2, 12, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 8, 3, 16, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 4, 8, 8, 8, 24, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 3, 3, 3, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 3, 8, 3, 8, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 3, 3, 3, 8, 8, 8, 8, 2, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 3, 3, 3, 3, 3, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 3, 3, 3, 3, 3, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 8, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 8, 3, 3, 3, 3, 8};

        CP1140Mappings() {
        }

        static EncodingSupport createEncodingSupport() {
            return new EBCDICEncodingSupport(fgCharMap, 159, fgByteMap, fgContentMap, fgNameCharMap);
        }
    }

    static final class CP1047Mappings {
        static final char[] fgCharMap = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u009c', '\t', '\u0086', '\u007f', '\u0097', '\u008d', '\u008e', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u009d', '\n', '\b', '\u0087', '\u0018', '\u0019', '\u0092', '\u008f', '\u001c', '\u001d', '\u001e', '\u001f', '\u0080', '\u0081', '\u0082', '\u0083', '\u0084', '\u0085', '\u0017', '\u001b', '\u0088', '\u0089', '\u008a', '\u008b', '\u008c', '\u0005', '\u0006', '\u0007', '\u0090', '\u0091', '\u0016', '\u0093', '\u0094', '\u0095', '\u0096', '\u0004', '\u0098', '\u0099', '\u009a', '\u009b', '\u0014', '\u0015', '\u009e', '\u001a', ' ', '\u00a0', '\u00e2', '\u00e4', '\u00e0', '\u00e1', '\u00e3', '\u00e5', '\u00e7', '\u00f1', '\u00a2', '.', '<', '(', '+', '|', '&', '\u00e9', '\u00ea', '\u00eb', '\u00e8', '\u00ed', '\u00ee', '\u00ef', '\u00ec', '\u00df', '!', '$', '*', ')', ';', '^', '-', '/', '\u00c2', '\u00c4', '\u00c0', '\u00c1', '\u00c3', '\u00c5', '\u00c7', '\u00d1', '\u00a6', ',', '%', '_', '>', '?', '\u00f8', '\u00c9', '\u00ca', '\u00cb', '\u00c8', '\u00cd', '\u00ce', '\u00cf', '\u00cc', '`', ':', '#', '@', '\'', '=', '\"', '\u00d8', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', '\u00ab', '\u00bb', '\u00f0', '\u00fd', '\u00fe', '\u00b1', '\u00b0', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', '\u00aa', '\u00ba', '\u00e6', '\u00b8', '\u00c6', '\u00a4', '\u00b5', '~', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '\u00a1', '\u00bf', '\u00d0', '[', '\u00de', '\u00ae', '\u00ac', '\u00a3', '\u00a5', '\u00b7', '\u00a9', '\u00a7', '\u00b6', '\u00bc', '\u00bd', '\u00be', '\u00dd', '\u00a8', '\u00af', ']', '\u00b4', '\u00d7', '{', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', '\u00ad', '\u00f4', '\u00f6', '\u00f2', '\u00f3', '\u00f5', '}', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', '\u00b9', '\u00fb', '\u00fc', '\u00f9', '\u00fa', '\u00ff', '\\', '\u00f7', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00b2', '\u00d4', '\u00d6', '\u00d2', '\u00d3', '\u00d5', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '\u00b3', '\u00db', '\u00dc', '\u00d9', '\u00da', '\u009f'};
        static final int fgEuroValue = -1;
        static final byte[] fgByteMap = new byte[]{0, 1, 2, 3, 55, 45, 46, 47, 22, 5, 21, 11, 12, 13, 14, 15, 16, 17, 18, 19, 60, 61, 50, 38, 24, 25, 63, 39, 28, 29, 30, 31, 64, 90, 127, 123, 91, 108, 80, 125, 77, 93, 92, 78, 107, 96, 75, 97, -16, -15, -14, -13, -12, -11, -10, -9, -8, -7, 122, 94, 76, 126, 110, 111, 124, -63, -62, -61, -60, -59, -58, -57, -56, -55, -47, -46, -45, -44, -43, -42, -41, -40, -39, -30, -29, -28, -27, -26, -25, -24, -23, -83, -32, -67, 95, 109, 121, -127, -126, -125, -124, -123, -122, -121, -120, -119, -111, -110, -109, -108, -107, -106, -105, -104, -103, -94, -93, -92, -91, -90, -89, -88, -87, -64, 79, -48, -95, 7, 32, 33, 34, 35, 36, 37, 6, 23, 40, 41, 42, 43, 44, 9, 10, 27, 48, 49, 26, 51, 52, 53, 54, 8, 56, 57, 58, 59, 4, 20, 62, -1, 65, -86, 74, -79, -97, -78, 106, -75, -69, -76, -102, -118, -80, -54, -81, -68, -112, -113, -22, -6, -66, -96, -74, -77, -99, -38, -101, -117, -73, -72, -71, -85, 100, 101, 98, 102, 99, 103, -98, 104, 116, 113, 114, 115, 120, 117, 118, 119, -84, 105, -19, -18, -21, -17, -20, -65, -128, -3, -2, -5, -4, -70, -82, 89, 68, 69, 66, 70, 67, 71, -100, 72, 84, 81, 82, 83, 88, 85, 86, 87, -116, 73, -51, -50, -53, -49, -52, -31, 112, -35, -34, -37, -36, -115, -114, -33};
        static final byte[] fgContentMap = new byte[]{5, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
        static final byte[] fgNameCharMap = new byte[]{8, 8, 8, 8, 8, 20, 8, 8, 8, 8, 8, 8, 8, 20, 8, 8, 8, 8, 8, 8, 8, 20, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 20, 8, 3, 3, 3, 3, 3, 3, 3, 3, 8, 2, 8, 8, 8, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 8, 8, 28, 8, 2, 12, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 8, 3, 16, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 4, 8, 8, 8, 24, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 3, 3, 3, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 3, 8, 3, 8, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 3, 8, 3, 8, 8, 8, 8, 2, 8, 8, 8, 8, 8, 8, 3, 8, 8, 8, 8, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 3, 3, 3, 3, 3, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 3, 3, 3, 3, 3, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 8, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 8, 3, 3, 3, 3, 8};

        CP1047Mappings() {
        }

        static EncodingSupport createEncodingSupport() {
            return new EBCDICEncodingSupport(fgCharMap, -1, fgByteMap, fgContentMap, fgNameCharMap);
        }
    }

    static final class CP871Mappings {
        static final char[] fgCharMap = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u009c', '\t', '\u0086', '\u007f', '\u0097', '\u008d', '\u008e', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u009d', '\n', '\b', '\u0087', '\u0018', '\u0019', '\u0092', '\u008f', '\u001c', '\u001d', '\u001e', '\u001f', '\u0080', '\u0081', '\u0082', '\u0083', '\u0084', '\n', '\u0017', '\u001b', '\u0088', '\u0089', '\u008a', '\u008b', '\u008c', '\u0005', '\u0006', '\u0007', '\u0090', '\u0091', '\u0016', '\u0093', '\u0094', '\u0095', '\u0096', '\u0004', '\u0098', '\u0099', '\u009a', '\u009b', '\u0014', '\u0015', '\u009e', '\u001a', ' ', '\u00a0', '\u00e2', '\u00e4', '\u00e0', '\u00e1', '\u00e3', '\u00e5', '\u00e7', '\u00f1', '\u00de', '.', '<', '(', '+', '!', '&', '\u00e9', '\u00ea', '\u00eb', '\u00e8', '\u00ed', '\u00ee', '\u00ef', '\u00ec', '\u00df', '\u00c6', '$', '*', ')', ';', '\u00d6', '-', '/', '\u00c2', '\u00c4', '\u00c0', '\u00c1', '\u00c3', '\u00c5', '\u00c7', '\u00d1', '\u00a6', ',', '%', '_', '>', '?', '\u00f8', '\u00c9', '\u00ca', '\u00cb', '\u00c8', '\u00cd', '\u00ce', '\u00cf', '\u00cc', '\u00f0', ':', '#', '\u00d0', '\'', '=', '\"', '\u00d8', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', '\u00ab', '\u00bb', '`', '\u00fd', '{', '\u00b1', '\u00b0', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', '\u00aa', '\u00ba', '}', '\u00b8', ']', '\u00a4', '\u00b5', '\u00f6', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '\u00a1', '\u00bf', '@', '\u00dd', '[', '\u00ae', '\u00a2', '\u00a3', '\u00a5', '\u00b7', '\u00a9', '\u00a7', '\u00b6', '\u00bc', '\u00bd', '\u00be', '\u00ac', '|', '\u00af', '\u00a8', '\\', '\u00d7', '\u00fe', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', '\u00ad', '\u00f4', '~', '\u00f2', '\u00f3', '\u00f5', '\u00e6', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', '\u00b9', '\u00fb', '\u00fc', '\u00f9', '\u00fa', '\u00ff', '\u00b4', '\u00f7', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00b2', '\u00d4', '^', '\u00d2', '\u00d3', '\u00d5', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '\u00b3', '\u00db', '\u00dc', '\u00d9', '\u00da', '\u009f'};
        static final int fgEuroValue = -1;
        static final byte[] fgByteMap = new byte[]{0, 1, 2, 3, 55, 45, 46, 47, 22, 5, 21, 11, 12, 13, 14, 15, 16, 17, 18, 19, 60, 61, 50, 38, 24, 25, 63, 39, 28, 29, 30, 31, 64, 79, 127, 123, 91, 108, 80, 125, 77, 93, 92, 78, 107, 96, 75, 97, -16, -15, -14, -13, -12, -11, -10, -9, -8, -7, 122, 94, 76, 126, 110, 111, -84, -63, -62, -61, -60, -59, -58, -57, -56, -55, -47, -46, -45, -44, -43, -42, -41, -40, -39, -30, -29, -28, -27, -26, -25, -24, -23, -82, -66, -98, -20, 109, -116, -127, -126, -125, -124, -123, -122, -121, -120, -119, -111, -110, -109, -108, -107, -106, -105, -104, -103, -94, -93, -92, -91, -90, -89, -88, -87, -114, -69, -100, -52, 7, 32, 33, 34, 35, 36, 21, 6, 23, 40, 41, 42, 43, 44, 9, 10, 27, 48, 49, 26, 51, 52, 53, 54, 8, 56, 57, 58, 59, 4, 20, 62, -1, 65, -86, -80, -79, -97, -78, 106, -75, -67, -76, -102, -118, -70, -54, -81, -68, -112, -113, -22, -6, -32, -96, -74, -77, -99, -38, -101, -117, -73, -72, -71, -85, 100, 101, 98, 102, 99, 103, 90, 104, 116, 113, 114, 115, 120, 117, 118, 119, 124, 105, -19, -18, -21, -17, 95, -65, -128, -3, -2, -5, -4, -83, 74, 89, 68, 69, 66, 70, 67, 71, -48, 72, 84, 81, 82, 83, 88, 85, 86, 87, 121, 73, -51, -50, -53, -49, -95, -31, 112, -35, -34, -37, -36, -115, -64, -33};
        static final byte[] fgContentMap = new byte[]{5, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
        static final byte[] fgNameCharMap = new byte[]{8, 8, 8, 8, 8, 20, 8, 8, 8, 8, 8, 8, 8, 20, 8, 8, 8, 8, 8, 8, 8, 20, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 20, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 20, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 8, 8, 8, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 8, 28, 3, 2, 12, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 8, 3, 16, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 8, 3, 8, 24, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 8, 3, 8, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 8, 8, 8, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 8, 3, 8, 8, 8, 8, 8, 2, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 3, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 3, 3, 3, 3, 3, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 8, 3, 8, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 8, 3, 3, 3, 3, 8};

        CP871Mappings() {
        }

        static EncodingSupport createEncodingSupport() {
            return new EBCDICEncodingSupport(fgCharMap, -1, fgByteMap, fgContentMap, fgNameCharMap);
        }
    }

    static final class CP500Mappings {
        static final char[] fgCharMap = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u009c', '\t', '\u0086', '\u007f', '\u0097', '\u008d', '\u008e', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u009d', '\n', '\b', '\u0087', '\u0018', '\u0019', '\u0092', '\u008f', '\u001c', '\u001d', '\u001e', '\u001f', '\u0080', '\u0081', '\u0082', '\u0083', '\u0084', '\n', '\u0017', '\u001b', '\u0088', '\u0089', '\u008a', '\u008b', '\u008c', '\u0005', '\u0006', '\u0007', '\u0090', '\u0091', '\u0016', '\u0093', '\u0094', '\u0095', '\u0096', '\u0004', '\u0098', '\u0099', '\u009a', '\u009b', '\u0014', '\u0015', '\u009e', '\u001a', ' ', '\u00a0', '\u00e2', '\u00e4', '\u00e0', '\u00e1', '\u00e3', '\u00e5', '\u00e7', '\u00f1', '[', '.', '<', '(', '+', '!', '&', '\u00e9', '\u00ea', '\u00eb', '\u00e8', '\u00ed', '\u00ee', '\u00ef', '\u00ec', '\u00df', ']', '$', '*', ')', ';', '^', '-', '/', '\u00c2', '\u00c4', '\u00c0', '\u00c1', '\u00c3', '\u00c5', '\u00c7', '\u00d1', '\u00a6', ',', '%', '_', '>', '?', '\u00f8', '\u00c9', '\u00ca', '\u00cb', '\u00c8', '\u00cd', '\u00ce', '\u00cf', '\u00cc', '`', ':', '#', '@', '\'', '=', '\"', '\u00d8', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', '\u00ab', '\u00bb', '\u00f0', '\u00fd', '\u00fe', '\u00b1', '\u00b0', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', '\u00aa', '\u00ba', '\u00e6', '\u00b8', '\u00c6', '\u00a4', '\u00b5', '~', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '\u00a1', '\u00bf', '\u00d0', '\u00dd', '\u00de', '\u00ae', '\u00a2', '\u00a3', '\u00a5', '\u00b7', '\u00a9', '\u00a7', '\u00b6', '\u00bc', '\u00bd', '\u00be', '\u00ac', '|', '\u00af', '\u00a8', '\u00b4', '\u00d7', '{', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', '\u00ad', '\u00f4', '\u00f6', '\u00f2', '\u00f3', '\u00f5', '}', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', '\u00b9', '\u00fb', '\u00fc', '\u00f9', '\u00fa', '\u00ff', '\\', '\u00f7', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00b2', '\u00d4', '\u00d6', '\u00d2', '\u00d3', '\u00d5', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '\u00b3', '\u00db', '\u00dc', '\u00d9', '\u00da', '\u009f'};
        static final int fgEuroValue = -1;
        static final byte[] fgByteMap = new byte[]{0, 1, 2, 3, 55, 45, 46, 47, 22, 5, 21, 11, 12, 13, 14, 15, 16, 17, 18, 19, 60, 61, 50, 38, 24, 25, 63, 39, 28, 29, 30, 31, 64, 79, 127, 123, 91, 108, 80, 125, 77, 93, 92, 78, 107, 96, 75, 97, -16, -15, -14, -13, -12, -11, -10, -9, -8, -7, 122, 94, 76, 126, 110, 111, 124, -63, -62, -61, -60, -59, -58, -57, -56, -55, -47, -46, -45, -44, -43, -42, -41, -40, -39, -30, -29, -28, -27, -26, -25, -24, -23, 74, -32, 90, 95, 109, 121, -127, -126, -125, -124, -123, -122, -121, -120, -119, -111, -110, -109, -108, -107, -106, -105, -104, -103, -94, -93, -92, -91, -90, -89, -88, -87, -64, -69, -48, -95, 7, 32, 33, 34, 35, 36, 21, 6, 23, 40, 41, 42, 43, 44, 9, 10, 27, 48, 49, 26, 51, 52, 53, 54, 8, 56, 57, 58, 59, 4, 20, 62, -1, 65, -86, -80, -79, -97, -78, 106, -75, -67, -76, -102, -118, -70, -54, -81, -68, -112, -113, -22, -6, -66, -96, -74, -77, -99, -38, -101, -117, -73, -72, -71, -85, 100, 101, 98, 102, 99, 103, -98, 104, 116, 113, 114, 115, 120, 117, 118, 119, -84, 105, -19, -18, -21, -17, -20, -65, -128, -3, -2, -5, -4, -83, -82, 89, 68, 69, 66, 70, 67, 71, -100, 72, 84, 81, 82, 83, 88, 85, 86, 87, -116, 73, -51, -50, -53, -49, -52, -31, 112, -35, -34, -37, -36, -115, -114, -33};
        static final byte[] fgContentMap = new byte[]{5, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
        static final byte[] fgNameCharMap = new byte[]{8, 8, 8, 8, 8, 20, 8, 8, 8, 8, 8, 8, 8, 20, 8, 8, 8, 8, 8, 8, 8, 20, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 20, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 20, 8, 3, 3, 3, 3, 3, 3, 3, 3, 8, 2, 8, 8, 8, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 8, 8, 28, 8, 2, 12, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 8, 3, 16, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 4, 8, 8, 8, 24, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 3, 3, 3, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 3, 8, 3, 8, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 3, 3, 3, 8, 8, 8, 8, 2, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 3, 3, 3, 3, 3, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 3, 3, 3, 3, 3, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 8, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 8, 3, 3, 3, 3, 8};

        CP500Mappings() {
        }

        static EncodingSupport createEncodingSupport() {
            return new EBCDICEncodingSupport(fgCharMap, -1, fgByteMap, fgContentMap, fgNameCharMap);
        }
    }

    static final class CP297Mappings {
        static final char[] fgCharMap = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u009c', '\t', '\u0086', '\u007f', '\u0097', '\u008d', '\u008e', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u009d', '\n', '\b', '\u0087', '\u0018', '\u0019', '\u0092', '\u008f', '\u001c', '\u001d', '\u001e', '\u001f', '\u0080', '\u0081', '\u0082', '\u0083', '\u0084', '\n', '\u0017', '\u001b', '\u0088', '\u0089', '\u008a', '\u008b', '\u008c', '\u0005', '\u0006', '\u0007', '\u0090', '\u0091', '\u0016', '\u0093', '\u0094', '\u0095', '\u0096', '\u0004', '\u0098', '\u0099', '\u009a', '\u009b', '\u0014', '\u0015', '\u009e', '\u001a', ' ', '\u00a0', '\u00e2', '\u00e4', '@', '\u00e1', '\u00e3', '\u00e5', '\\', '\u00f1', '\u00b0', '.', '<', '(', '+', '!', '&', '{', '\u00ea', '\u00eb', '}', '\u00ed', '\u00ee', '\u00ef', '\u00ec', '\u00df', '\u00a7', '$', '*', ')', ';', '^', '-', '/', '\u00c2', '\u00c4', '\u00c0', '\u00c1', '\u00c3', '\u00c5', '\u00c7', '\u00d1', '\u00f9', ',', '%', '_', '>', '?', '\u00f8', '\u00c9', '\u00ca', '\u00cb', '\u00c8', '\u00cd', '\u00ce', '\u00cf', '\u00cc', '\u00b5', ':', '\u00a3', '\u00e0', '\'', '=', '\"', '\u00d8', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', '\u00ab', '\u00bb', '\u00f0', '\u00fd', '\u00fe', '\u00b1', '[', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', '\u00aa', '\u00ba', '\u00e6', '\u00b8', '\u00c6', '\u00a4', '`', '\u00a8', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '\u00a1', '\u00bf', '\u00d0', '\u00dd', '\u00de', '\u00ae', '\u00a2', '#', '\u00a5', '\u00b7', '\u00a9', ']', '\u00b6', '\u00bc', '\u00bd', '\u00be', '\u00ac', '|', '\u00af', '~', '\u00b4', '\u00d7', '\u00e9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', '\u00ad', '\u00f4', '\u00f6', '\u00f2', '\u00f3', '\u00f5', '\u00e8', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', '\u00b9', '\u00fb', '\u00fc', '\u00a6', '\u00fa', '\u00ff', '\u00e7', '\u00f7', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00b2', '\u00d4', '\u00d6', '\u00d2', '\u00d3', '\u00d5', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '\u00b3', '\u00db', '\u00dc', '\u00d9', '\u00da', '\u009f'};
        static final int fgEuroValue = -1;
        static final byte[] fgByteMap = new byte[]{0, 1, 2, 3, 55, 45, 46, 47, 22, 5, 21, 11, 12, 13, 14, 15, 16, 17, 18, 19, 60, 61, 50, 38, 24, 25, 63, 39, 28, 29, 30, 31, 64, 79, 127, -79, 91, 108, 80, 125, 77, 93, 92, 78, 107, 96, 75, 97, -16, -15, -14, -13, -12, -11, -10, -9, -8, -7, 122, 94, 76, 126, 110, 111, 68, -63, -62, -61, -60, -59, -58, -57, -56, -55, -47, -46, -45, -44, -43, -42, -41, -40, -39, -30, -29, -28, -27, -26, -25, -24, -23, -112, 72, -75, 95, 109, -96, -127, -126, -125, -124, -123, -122, -121, -120, -119, -111, -110, -109, -108, -107, -106, -105, -104, -103, -94, -93, -92, -91, -90, -89, -88, -87, 81, -69, 84, -67, 7, 32, 33, 34, 35, 36, 21, 6, 23, 40, 41, 42, 43, 44, 9, 10, 27, 48, 49, 26, 51, 52, 53, 54, 8, 56, 57, 58, 59, 4, 20, 62, -1, 65, -86, -80, 123, -97, -78, -35, 90, -95, -76, -102, -118, -70, -54, -81, -68, 74, -113, -22, -6, -66, 121, -74, -77, -99, -38, -101, -117, -73, -72, -71, -85, 100, 101, 98, 102, 99, 103, -98, 104, 116, 113, 114, 115, 120, 117, 118, 119, -84, 105, -19, -18, -21, -17, -20, -65, -128, -3, -2, -5, -4, -83, -82, 89, 124, 69, 66, 70, 67, 71, -100, -32, -48, -64, 82, 83, 88, 85, 86, 87, -116, 73, -51, -50, -53, -49, -52, -31, 112, 106, -34, -37, -36, -115, -114, -33};
        static final byte[] fgContentMap = new byte[]{5, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
        static final byte[] fgNameCharMap = new byte[]{8, 8, 8, 8, 8, 20, 8, 8, 8, 8, 8, 8, 8, 20, 8, 8, 8, 8, 8, 8, 8, 20, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 20, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 20, 8, 3, 3, 8, 3, 3, 3, 8, 3, 8, 2, 8, 8, 8, 8, 8, 8, 3, 3, 8, 3, 3, 3, 3, 3, 8, 8, 8, 8, 28, 8, 2, 12, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 3, 16, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 4, 8, 3, 8, 24, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 3, 3, 3, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 3, 8, 3, 8, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 3, 3, 3, 8, 8, 8, 8, 2, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 3, 3, 8, 3, 3, 3, 8, 3, 3, 3, 3, 3, 3, 3, 3, 8, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 8, 3, 3, 3, 3, 8};

        CP297Mappings() {
        }

        static EncodingSupport createEncodingSupport() {
            return new EBCDICEncodingSupport(fgCharMap, -1, fgByteMap, fgContentMap, fgNameCharMap);
        }
    }

    static final class CP285Mappings {
        static final char[] fgCharMap = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u009c', '\t', '\u0086', '\u007f', '\u0097', '\u008d', '\u008e', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u009d', '\n', '\b', '\u0087', '\u0018', '\u0019', '\u0092', '\u008f', '\u001c', '\u001d', '\u001e', '\u001f', '\u0080', '\u0081', '\u0082', '\u0083', '\u0084', '\n', '\u0017', '\u001b', '\u0088', '\u0089', '\u008a', '\u008b', '\u008c', '\u0005', '\u0006', '\u0007', '\u0090', '\u0091', '\u0016', '\u0093', '\u0094', '\u0095', '\u0096', '\u0004', '\u0098', '\u0099', '\u009a', '\u009b', '\u0014', '\u0015', '\u009e', '\u001a', ' ', '\u00a0', '\u00e2', '\u00e4', '\u00e0', '\u00e1', '\u00e3', '\u00e5', '\u00e7', '\u00f1', '$', '.', '<', '(', '+', '|', '&', '\u00e9', '\u00ea', '\u00eb', '\u00e8', '\u00ed', '\u00ee', '\u00ef', '\u00ec', '\u00df', '!', '\u00a3', '*', ')', ';', '\u00ac', '-', '/', '\u00c2', '\u00c4', '\u00c0', '\u00c1', '\u00c3', '\u00c5', '\u00c7', '\u00d1', '\u00a6', ',', '%', '_', '>', '?', '\u00f8', '\u00c9', '\u00ca', '\u00cb', '\u00c8', '\u00cd', '\u00ce', '\u00cf', '\u00cc', '`', ':', '#', '@', '\'', '=', '\"', '\u00d8', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', '\u00ab', '\u00bb', '\u00f0', '\u00fd', '\u00fe', '\u00b1', '\u00b0', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', '\u00aa', '\u00ba', '\u00e6', '\u00b8', '\u00c6', '\u00a4', '\u00b5', '\u00af', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '\u00a1', '\u00bf', '\u00d0', '\u00dd', '\u00de', '\u00ae', '\u00a2', '[', '\u00a5', '\u00b7', '\u00a9', '\u00a7', '\u00b6', '\u00bc', '\u00bd', '\u00be', '^', ']', '~', '\u00a8', '\u00b4', '\u00d7', '{', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', '\u00ad', '\u00f4', '\u00f6', '\u00f2', '\u00f3', '\u00f5', '}', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', '\u00b9', '\u00fb', '\u00fc', '\u00f9', '\u00fa', '\u00ff', '\\', '\u00f7', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00b2', '\u00d4', '\u00d6', '\u00d2', '\u00d3', '\u00d5', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '\u00b3', '\u00db', '\u00dc', '\u00d9', '\u00da', '\u009f'};
        static final int fgEuroValue = -1;
        static final byte[] fgByteMap = new byte[]{0, 1, 2, 3, 55, 45, 46, 47, 22, 5, 21, 11, 12, 13, 14, 15, 16, 17, 18, 19, 60, 61, 50, 38, 24, 25, 63, 39, 28, 29, 30, 31, 64, 90, 127, 123, 74, 108, 80, 125, 77, 93, 92, 78, 107, 96, 75, 97, -16, -15, -14, -13, -12, -11, -10, -9, -8, -7, 122, 94, 76, 126, 110, 111, 124, -63, -62, -61, -60, -59, -58, -57, -56, -55, -47, -46, -45, -44, -43, -42, -41, -40, -39, -30, -29, -28, -27, -26, -25, -24, -23, -79, -32, -69, -70, 109, 121, -127, -126, -125, -124, -123, -122, -121, -120, -119, -111, -110, -109, -108, -107, -106, -105, -104, -103, -94, -93, -92, -91, -90, -89, -88, -87, -64, 79, -48, -68, 7, 32, 33, 34, 35, 36, 21, 6, 23, 40, 41, 42, 43, 44, 9, 10, 27, 48, 49, 26, 51, 52, 53, 54, 8, 56, 57, 58, 59, 4, 20, 62, -1, 65, -86, -80, 91, -97, -78, 106, -75, -67, -76, -102, -118, 95, -54, -81, -95, -112, -113, -22, -6, -66, -96, -74, -77, -99, -38, -101, -117, -73, -72, -71, -85, 100, 101, 98, 102, 99, 103, -98, 104, 116, 113, 114, 115, 120, 117, 118, 119, -84, 105, -19, -18, -21, -17, -20, -65, -128, -3, -2, -5, -4, -83, -82, 89, 68, 69, 66, 70, 67, 71, -100, 72, 84, 81, 82, 83, 88, 85, 86, 87, -116, 73, -51, -50, -53, -49, -52, -31, 112, -35, -34, -37, -36, -115, -114, -33};
        static final byte[] fgContentMap = new byte[]{5, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
        static final byte[] fgNameCharMap = new byte[]{8, 8, 8, 8, 8, 20, 8, 8, 8, 8, 8, 8, 8, 20, 8, 8, 8, 8, 8, 8, 8, 20, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 20, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 20, 8, 3, 3, 3, 3, 3, 3, 3, 3, 8, 2, 8, 8, 8, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 8, 8, 28, 8, 2, 12, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 8, 3, 16, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 4, 8, 8, 8, 24, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 3, 3, 3, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 3, 8, 3, 8, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 3, 3, 3, 8, 8, 8, 8, 2, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 3, 3, 3, 3, 3, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 3, 3, 3, 3, 3, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 8, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 8, 3, 3, 3, 3, 8};

        CP285Mappings() {
        }

        static EncodingSupport createEncodingSupport() {
            return new EBCDICEncodingSupport(fgCharMap, -1, fgByteMap, fgContentMap, fgNameCharMap);
        }
    }

    static final class CP284Mappings {
        static final char[] fgCharMap = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u009c', '\t', '\u0086', '\u007f', '\u0097', '\u008d', '\u008e', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u009d', '\n', '\b', '\u0087', '\u0018', '\u0019', '\u0092', '\u008f', '\u001c', '\u001d', '\u001e', '\u001f', '\u0080', '\u0081', '\u0082', '\u0083', '\u0084', '\n', '\u0017', '\u001b', '\u0088', '\u0089', '\u008a', '\u008b', '\u008c', '\u0005', '\u0006', '\u0007', '\u0090', '\u0091', '\u0016', '\u0093', '\u0094', '\u0095', '\u0096', '\u0004', '\u0098', '\u0099', '\u009a', '\u009b', '\u0014', '\u0015', '\u009e', '\u001a', ' ', '\u00a0', '\u00e2', '\u00e4', '\u00e0', '\u00e1', '\u00e3', '\u00e5', '\u00e7', '\u00a6', '[', '.', '<', '(', '+', '|', '&', '\u00e9', '\u00ea', '\u00eb', '\u00e8', '\u00ed', '\u00ee', '\u00ef', '\u00ec', '\u00df', ']', '$', '*', ')', ';', '\u00ac', '-', '/', '\u00c2', '\u00c4', '\u00c0', '\u00c1', '\u00c3', '\u00c5', '\u00c7', '#', '\u00f1', ',', '%', '_', '>', '?', '\u00f8', '\u00c9', '\u00ca', '\u00cb', '\u00c8', '\u00cd', '\u00ce', '\u00cf', '\u00cc', '`', ':', '\u00d1', '@', '\'', '=', '\"', '\u00d8', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', '\u00ab', '\u00bb', '\u00f0', '\u00fd', '\u00fe', '\u00b1', '\u00b0', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', '\u00aa', '\u00ba', '\u00e6', '\u00b8', '\u00c6', '\u00a4', '\u00b5', '\u00a8', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '\u00a1', '\u00bf', '\u00d0', '\u00dd', '\u00de', '\u00ae', '\u00a2', '\u00a3', '\u00a5', '\u00b7', '\u00a9', '\u00a7', '\u00b6', '\u00bc', '\u00bd', '\u00be', '^', '!', '\u00af', '~', '\u00b4', '\u00d7', '{', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', '\u00ad', '\u00f4', '\u00f6', '\u00f2', '\u00f3', '\u00f5', '}', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', '\u00b9', '\u00fb', '\u00fc', '\u00f9', '\u00fa', '\u00ff', '\\', '\u00f7', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00b2', '\u00d4', '\u00d6', '\u00d2', '\u00d3', '\u00d5', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '\u00b3', '\u00db', '\u00dc', '\u00d9', '\u00da', '\u009f'};
        static final int fgEuroValue = -1;
        static final byte[] fgByteMap = new byte[]{0, 1, 2, 3, 55, 45, 46, 47, 22, 5, 21, 11, 12, 13, 14, 15, 16, 17, 18, 19, 60, 61, 50, 38, 24, 25, 63, 39, 28, 29, 30, 31, 64, -69, 127, 105, 91, 108, 80, 125, 77, 93, 92, 78, 107, 96, 75, 97, -16, -15, -14, -13, -12, -11, -10, -9, -8, -7, 122, 94, 76, 126, 110, 111, 124, -63, -62, -61, -60, -59, -58, -57, -56, -55, -47, -46, -45, -44, -43, -42, -41, -40, -39, -30, -29, -28, -27, -26, -25, -24, -23, 74, -32, 90, -70, 109, 121, -127, -126, -125, -124, -123, -122, -121, -120, -119, -111, -110, -109, -108, -107, -106, -105, -104, -103, -94, -93, -92, -91, -90, -89, -88, -87, -64, 79, -48, -67, 7, 32, 33, 34, 35, 36, 21, 6, 23, 40, 41, 42, 43, 44, 9, 10, 27, 48, 49, 26, 51, 52, 53, 54, 8, 56, 57, 58, 59, 4, 20, 62, -1, 65, -86, -80, -79, -97, -78, 73, -75, -95, -76, -102, -118, 95, -54, -81, -68, -112, -113, -22, -6, -66, -96, -74, -77, -99, -38, -101, -117, -73, -72, -71, -85, 100, 101, 98, 102, 99, 103, -98, 104, 116, 113, 114, 115, 120, 117, 118, 119, -84, 123, -19, -18, -21, -17, -20, -65, -128, -3, -2, -5, -4, -83, -82, 89, 68, 69, 66, 70, 67, 71, -100, 72, 84, 81, 82, 83, 88, 85, 86, 87, -116, 106, -51, -50, -53, -49, -52, -31, 112, -35, -34, -37, -36, -115, -114, -33};
        static final byte[] fgContentMap = new byte[]{5, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
        static final byte[] fgNameCharMap = new byte[]{8, 8, 8, 8, 8, 20, 8, 8, 8, 8, 8, 8, 8, 20, 8, 8, 8, 8, 8, 8, 8, 20, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 20, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 20, 8, 3, 3, 3, 3, 3, 3, 3, 8, 8, 2, 8, 8, 8, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 8, 8, 28, 8, 2, 12, 3, 3, 3, 3, 3, 3, 3, 8, 3, 8, 8, 3, 16, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 4, 3, 8, 8, 24, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 3, 3, 3, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 3, 8, 3, 8, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 3, 3, 3, 8, 8, 8, 8, 2, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 3, 3, 3, 3, 3, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 3, 3, 3, 3, 3, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 8, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 8, 3, 3, 3, 3, 8};

        CP284Mappings() {
        }

        static EncodingSupport createEncodingSupport() {
            return new EBCDICEncodingSupport(fgCharMap, -1, fgByteMap, fgContentMap, fgNameCharMap);
        }
    }

    static final class CP280Mappings {
        static final char[] fgCharMap = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u009c', '\t', '\u0086', '\u007f', '\u0097', '\u008d', '\u008e', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u009d', '\n', '\b', '\u0087', '\u0018', '\u0019', '\u0092', '\u008f', '\u001c', '\u001d', '\u001e', '\u001f', '\u0080', '\u0081', '\u0082', '\u0083', '\u0084', '\n', '\u0017', '\u001b', '\u0088', '\u0089', '\u008a', '\u008b', '\u008c', '\u0005', '\u0006', '\u0007', '\u0090', '\u0091', '\u0016', '\u0093', '\u0094', '\u0095', '\u0096', '\u0004', '\u0098', '\u0099', '\u009a', '\u009b', '\u0014', '\u0015', '\u009e', '\u001a', ' ', '\u00a0', '\u00e2', '\u00e4', '{', '\u00e1', '\u00e3', '\u00e5', '\\', '\u00f1', '\u00b0', '.', '<', '(', '+', '!', '&', ']', '\u00ea', '\u00eb', '}', '\u00ed', '\u00ee', '\u00ef', '~', '\u00df', '\u00e9', '$', '*', ')', ';', '^', '-', '/', '\u00c2', '\u00c4', '\u00c0', '\u00c1', '\u00c3', '\u00c5', '\u00c7', '\u00d1', '\u00f2', ',', '%', '_', '>', '?', '\u00f8', '\u00c9', '\u00ca', '\u00cb', '\u00c8', '\u00cd', '\u00ce', '\u00cf', '\u00cc', '\u00f9', ':', '\u00a3', '\u00a7', '\'', '=', '\"', '\u00d8', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', '\u00ab', '\u00bb', '\u00f0', '\u00fd', '\u00fe', '\u00b1', '[', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', '\u00aa', '\u00ba', '\u00e6', '\u00b8', '\u00c6', '\u00a4', '\u00b5', '\u00ec', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '\u00a1', '\u00bf', '\u00d0', '\u00dd', '\u00de', '\u00ae', '\u00a2', '#', '\u00a5', '\u00b7', '\u00a9', '@', '\u00b6', '\u00bc', '\u00bd', '\u00be', '\u00ac', '|', '\u00af', '\u00a8', '\u00b4', '\u00d7', '\u00e0', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', '\u00ad', '\u00f4', '\u00f6', '\u00a6', '\u00f3', '\u00f5', '\u00e8', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', '\u00b9', '\u00fb', '\u00fc', '`', '\u00fa', '\u00ff', '\u00e7', '\u00f7', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00b2', '\u00d4', '\u00d6', '\u00d2', '\u00d3', '\u00d5', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '\u00b3', '\u00db', '\u00dc', '\u00d9', '\u00da', '\u009f'};
        static final int fgEuroValue = -1;
        static final byte[] fgByteMap = new byte[]{0, 1, 2, 3, 55, 45, 46, 47, 22, 5, 21, 11, 12, 13, 14, 15, 16, 17, 18, 19, 60, 61, 50, 38, 24, 25, 63, 39, 28, 29, 30, 31, 64, 79, 127, -79, 91, 108, 80, 125, 77, 93, 92, 78, 107, 96, 75, 97, -16, -15, -14, -13, -12, -11, -10, -9, -8, -7, 122, 94, 76, 126, 110, 111, -75, -63, -62, -61, -60, -59, -58, -57, -56, -55, -47, -46, -45, -44, -43, -42, -41, -40, -39, -30, -29, -28, -27, -26, -25, -24, -23, -112, 72, 81, 95, 109, -35, -127, -126, -125, -124, -123, -122, -121, -120, -119, -111, -110, -109, -108, -107, -106, -105, -104, -103, -94, -93, -92, -91, -90, -89, -88, -87, 68, -69, 84, 88, 7, 32, 33, 34, 35, 36, 21, 6, 23, 40, 41, 42, 43, 44, 9, 10, 27, 48, 49, 26, 51, 52, 53, 54, 8, 56, 57, 58, 59, 4, 20, 62, -1, 65, -86, -80, 123, -97, -78, -51, 124, -67, -76, -102, -118, -70, -54, -81, -68, 74, -113, -22, -6, -66, -96, -74, -77, -99, -38, -101, -117, -73, -72, -71, -85, 100, 101, 98, 102, 99, 103, -98, 104, 116, 113, 114, 115, 120, 117, 118, 119, -84, 105, -19, -18, -21, -17, -20, -65, -128, -3, -2, -5, -4, -83, -82, 89, -64, 69, 66, 70, 67, 71, -100, -32, -48, 90, 82, 83, -95, 85, 86, 87, -116, 73, 106, -50, -53, -49, -52, -31, 112, 121, -34, -37, -36, -115, -114, -33};
        static final byte[] fgContentMap = new byte[]{5, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 3, 4, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
        static final byte[] fgNameCharMap = new byte[]{8, 8, 8, 8, 8, 20, 8, 8, 8, 8, 8, 8, 8, 20, 8, 8, 8, 8, 8, 8, 8, 20, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 20, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 20, 8, 3, 3, 8, 3, 3, 3, 8, 3, 8, 2, 8, 8, 8, 8, 8, 8, 3, 3, 8, 3, 3, 3, 8, 3, 3, 8, 8, 8, 28, 8, 2, 12, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 3, 16, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 8, 8, 8, 24, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 3, 3, 3, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 3, 8, 3, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 3, 3, 3, 8, 8, 8, 8, 2, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 3, 3, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 3, 3, 8, 3, 3, 3, 8, 3, 3, 3, 3, 3, 3, 3, 3, 8, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 8, 3, 3, 3, 3, 8};

        CP280Mappings() {
        }

        static EncodingSupport createEncodingSupport() {
            return new EBCDICEncodingSupport(fgCharMap, -1, fgByteMap, fgContentMap, fgNameCharMap);
        }
    }

    static final class CP278Mappings {
        static final char[] fgCharMap = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u009c', '\t', '\u0086', '\u007f', '\u0097', '\u008d', '\u008e', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u009d', '\n', '\b', '\u0087', '\u0018', '\u0019', '\u0092', '\u008f', '\u001c', '\u001d', '\u001e', '\u001f', '\u0080', '\u0081', '\u0082', '\u0083', '\u0084', '\n', '\u0017', '\u001b', '\u0088', '\u0089', '\u008a', '\u008b', '\u008c', '\u0005', '\u0006', '\u0007', '\u0090', '\u0091', '\u0016', '\u0093', '\u0094', '\u0095', '\u0096', '\u0004', '\u0098', '\u0099', '\u009a', '\u009b', '\u0014', '\u0015', '\u009e', '\u001a', ' ', '\u00a0', '\u00e2', '{', '\u00e0', '\u00e1', '\u00e3', '}', '\u00e7', '\u00f1', '\u00a7', '.', '<', '(', '+', '!', '&', '`', '\u00ea', '\u00eb', '\u00e8', '\u00ed', '\u00ee', '\u00ef', '\u00ec', '\u00df', '\u00a4', '\u00c5', '*', ')', ';', '^', '-', '/', '\u00c2', '#', '\u00c0', '\u00c1', '\u00c3', '$', '\u00c7', '\u00d1', '\u00f6', ',', '%', '_', '>', '?', '\u00f8', '\\', '\u00ca', '\u00cb', '\u00c8', '\u00cd', '\u00ce', '\u00cf', '\u00cc', '\u00e9', ':', '\u00c4', '\u00d6', '\'', '=', '\"', '\u00d8', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', '\u00ab', '\u00bb', '\u00f0', '\u00fd', '\u00fe', '\u00b1', '\u00b0', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', '\u00aa', '\u00ba', '\u00e6', '\u00b8', '\u00c6', ']', '\u00b5', '\u00fc', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '\u00a1', '\u00bf', '\u00d0', '\u00dd', '\u00de', '\u00ae', '\u00a2', '\u00a3', '\u00a5', '\u00b7', '\u00a9', '[', '\u00b6', '\u00bc', '\u00bd', '\u00be', '\u00ac', '|', '\u00af', '\u00a8', '\u00b4', '\u00d7', '\u00e4', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', '\u00ad', '\u00f4', '\u00a6', '\u00f2', '\u00f3', '\u00f5', '\u00e5', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', '\u00b9', '\u00fb', '~', '\u00f9', '\u00fa', '\u00ff', '\u00c9', '\u00f7', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00b2', '\u00d4', '@', '\u00d2', '\u00d3', '\u00d5', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '\u00b3', '\u00db', '\u00dc', '\u00d9', '\u00da', '\u009f'};
        static final int fgEuroValue = -1;
        static final byte[] fgByteMap = new byte[]{0, 1, 2, 3, 55, 45, 46, 47, 22, 5, 21, 11, 12, 13, 14, 15, 16, 17, 18, 19, 60, 61, 50, 38, 24, 25, 63, 39, 28, 29, 30, 31, 64, 79, 127, 99, 103, 108, 80, 125, 77, 93, 92, 78, 107, 96, 75, 97, -16, -15, -14, -13, -12, -11, -10, -9, -8, -7, 122, 94, 76, 126, 110, 111, -20, -63, -62, -61, -60, -59, -58, -57, -56, -55, -47, -46, -45, -44, -43, -42, -41, -40, -39, -30, -29, -28, -27, -26, -25, -24, -23, -75, 113, -97, 95, 109, 81, -127, -126, -125, -124, -123, -122, -121, -120, -119, -111, -110, -109, -108, -107, -106, -105, -104, -103, -94, -93, -92, -91, -90, -89, -88, -87, 67, -69, 71, -36, 7, 32, 33, 34, 35, 36, 21, 6, 23, 40, 41, 42, 43, 44, 9, 10, 27, 48, 49, 26, 51, 52, 53, 54, 8, 56, 57, 58, 59, 4, 20, 62, -1, 65, -86, -80, -79, 90, -78, -52, 74, -67, -76, -102, -118, -70, -54, -81, -68, -112, -113, -22, -6, -66, -96, -74, -77, -99, -38, -101, -117, -73, -72, -71, -85, 100, 101, 98, 102, 123, 91, -98, 104, 116, -32, 114, 115, 120, 117, 118, 119, -84, 105, -19, -18, -21, -17, 124, -65, -128, -3, -2, -5, -4, -83, -82, 89, 68, 69, 66, 70, -64, -48, -100, 72, 84, 121, 82, 83, 88, 85, 86, 87, -116, 73, -51, -50, -53, -49, 106, -31, 112, -35, -34, -37, -95, -115, -114, -33};
        static final byte[] fgContentMap = new byte[]{5, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
        static final byte[] fgNameCharMap = new byte[]{8, 8, 8, 8, 8, 20, 8, 8, 8, 8, 8, 8, 8, 20, 8, 8, 8, 8, 8, 8, 8, 20, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 20, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 20, 8, 3, 8, 3, 3, 3, 8, 3, 3, 8, 2, 8, 8, 8, 8, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 8, 3, 8, 8, 28, 8, 2, 12, 3, 8, 3, 3, 3, 8, 3, 3, 3, 8, 8, 3, 16, 8, 3, 8, 3, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 8, 24, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 3, 3, 3, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 3, 8, 3, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 3, 3, 3, 8, 8, 8, 8, 2, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 3, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 3, 8, 3, 3, 3, 3, 8, 3, 3, 3, 3, 3, 3, 3, 3, 8, 3, 8, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 8, 3, 3, 3, 3, 8};

        CP278Mappings() {
        }

        static EncodingSupport createEncodingSupport() {
            return new EBCDICEncodingSupport(fgCharMap, -1, fgByteMap, fgContentMap, fgNameCharMap);
        }
    }

    static final class CP277Mappings {
        static final char[] fgCharMap = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u009c', '\t', '\u0086', '\u007f', '\u0097', '\u008d', '\u008e', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u009d', '\n', '\b', '\u0087', '\u0018', '\u0019', '\u0092', '\u008f', '\u001c', '\u001d', '\u001e', '\u001f', '\u0080', '\u0081', '\u0082', '\u0083', '\u0084', '\n', '\u0017', '\u001b', '\u0088', '\u0089', '\u008a', '\u008b', '\u008c', '\u0005', '\u0006', '\u0007', '\u0090', '\u0091', '\u0016', '\u0093', '\u0094', '\u0095', '\u0096', '\u0004', '\u0098', '\u0099', '\u009a', '\u009b', '\u0014', '\u0015', '\u009e', '\u001a', ' ', '\u00a0', '\u00e2', '\u00e4', '\u00e0', '\u00e1', '\u00e3', '}', '\u00e7', '\u00f1', '#', '.', '<', '(', '+', '!', '&', '\u00e9', '\u00ea', '\u00eb', '\u00e8', '\u00ed', '\u00ee', '\u00ef', '\u00ec', '\u00df', '\u00a4', '\u00c5', '*', ')', ';', '^', '-', '/', '\u00c2', '\u00c4', '\u00c0', '\u00c1', '\u00c3', '$', '\u00c7', '\u00d1', '\u00f8', ',', '%', '_', '>', '?', '\u00a6', '\u00c9', '\u00ca', '\u00cb', '\u00c8', '\u00cd', '\u00ce', '\u00cf', '\u00cc', '`', ':', '\u00c6', '\u00d8', '\'', '=', '\"', '@', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', '\u00ab', '\u00bb', '\u00f0', '\u00fd', '\u00fe', '\u00b1', '\u00b0', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', '\u00aa', '\u00ba', '{', '\u00b8', '[', ']', '\u00b5', '\u00fc', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '\u00a1', '\u00bf', '\u00d0', '\u00dd', '\u00de', '\u00ae', '\u00a2', '\u00a3', '\u00a5', '\u00b7', '\u00a9', '\u00a7', '\u00b6', '\u00bc', '\u00bd', '\u00be', '\u00ac', '|', '\u00af', '\u00a8', '\u00b4', '\u00d7', '\u00e6', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', '\u00ad', '\u00f4', '\u00f6', '\u00f2', '\u00f3', '\u00f5', '\u00e5', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', '\u00b9', '\u00fb', '~', '\u00f9', '\u00fa', '\u00ff', '\\', '\u00f7', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00b2', '\u00d4', '\u00d6', '\u00d2', '\u00d3', '\u00d5', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '\u00b3', '\u00db', '\u00dc', '\u00d9', '\u00da', '\u009f'};
        static final int fgEuroValue = -1;
        static final byte[] fgByteMap = new byte[]{0, 1, 2, 3, 55, 45, 46, 47, 22, 5, 21, 11, 12, 13, 14, 15, 16, 17, 18, 19, 60, 61, 50, 38, 24, 25, 63, 39, 28, 29, 30, 31, 64, 79, 127, 74, 103, 108, 80, 125, 77, 93, 92, 78, 107, 96, 75, 97, -16, -15, -14, -13, -12, -11, -10, -9, -8, -7, 122, 94, 76, 126, 110, 111, -128, -63, -62, -61, -60, -59, -58, -57, -56, -55, -47, -46, -45, -44, -43, -42, -41, -40, -39, -30, -29, -28, -27, -26, -25, -24, -23, -98, -32, -97, 95, 109, 121, -127, -126, -125, -124, -123, -122, -121, -120, -119, -111, -110, -109, -108, -107, -106, -105, -104, -103, -94, -93, -92, -91, -90, -89, -88, -87, -100, -69, 71, -36, 7, 32, 33, 34, 35, 36, 21, 6, 23, 40, 41, 42, 43, 44, 9, 10, 27, 48, 49, 26, 51, 52, 53, 54, 8, 56, 57, 58, 59, 4, 20, 62, -1, 65, -86, -80, -79, 90, -78, 112, -75, -67, -76, -102, -118, -70, -54, -81, -68, -112, -113, -22, -6, -66, -96, -74, -77, -99, -38, -101, -117, -73, -72, -71, -85, 100, 101, 98, 102, 99, 91, 123, 104, 116, 113, 114, 115, 120, 117, 118, 119, -84, 105, -19, -18, -21, -17, -20, -65, 124, -3, -2, -5, -4, -83, -82, 89, 68, 69, 66, 70, 67, -48, -64, 72, 84, 81, 82, 83, 88, 85, 86, 87, -116, 73, -51, -50, -53, -49, -52, -31, 106, -35, -34, -37, -95, -115, -114, -33};
        static final byte[] fgContentMap = new byte[]{5, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
        static final byte[] fgNameCharMap = new byte[]{8, 8, 8, 8, 8, 20, 8, 8, 8, 8, 8, 8, 8, 20, 8, 8, 8, 8, 8, 8, 8, 20, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 20, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 20, 8, 3, 3, 3, 3, 3, 8, 3, 3, 8, 2, 8, 8, 8, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 3, 8, 8, 28, 8, 2, 12, 3, 3, 3, 3, 3, 8, 3, 3, 3, 8, 8, 3, 16, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 8, 4, 3, 3, 8, 24, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 3, 3, 3, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 8, 8, 8, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 3, 3, 3, 8, 8, 8, 8, 2, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 3, 8, 3, 3, 3, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 8, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 8, 3, 3, 3, 3, 8};

        CP277Mappings() {
        }

        static EncodingSupport createEncodingSupport() {
            return new EBCDICEncodingSupport(fgCharMap, -1, fgByteMap, fgContentMap, fgNameCharMap);
        }
    }

    static final class CP273Mappings {
        static final char[] fgCharMap = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u009c', '\t', '\u0086', '\u007f', '\u0097', '\u008d', '\u008e', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u009d', '\n', '\b', '\u0087', '\u0018', '\u0019', '\u0092', '\u008f', '\u001c', '\u001d', '\u001e', '\u001f', '\u0080', '\u0081', '\u0082', '\u0083', '\u0084', '\n', '\u0017', '\u001b', '\u0088', '\u0089', '\u008a', '\u008b', '\u008c', '\u0005', '\u0006', '\u0007', '\u0090', '\u0091', '\u0016', '\u0093', '\u0094', '\u0095', '\u0096', '\u0004', '\u0098', '\u0099', '\u009a', '\u009b', '\u0014', '\u0015', '\u009e', '\u001a', ' ', '\u00a0', '\u00e2', '{', '\u00e0', '\u00e1', '\u00e3', '\u00e5', '\u00e7', '\u00f1', '\u00c4', '.', '<', '(', '+', '!', '&', '\u00e9', '\u00ea', '\u00eb', '\u00e8', '\u00ed', '\u00ee', '\u00ef', '\u00ec', '~', '\u00dc', '$', '*', ')', ';', '^', '-', '/', '\u00c2', '[', '\u00c0', '\u00c1', '\u00c3', '\u00c5', '\u00c7', '\u00d1', '\u00f6', ',', '%', '_', '>', '?', '\u00f8', '\u00c9', '\u00ca', '\u00cb', '\u00c8', '\u00cd', '\u00ce', '\u00cf', '\u00cc', '`', ':', '#', '\u00a7', '\'', '=', '\"', '\u00d8', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', '\u00ab', '\u00bb', '\u00f0', '\u00fd', '\u00fe', '\u00b1', '\u00b0', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', '\u00aa', '\u00ba', '\u00e6', '\u00b8', '\u00c6', '\u00a4', '\u00b5', '\u00df', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '\u00a1', '\u00bf', '\u00d0', '\u00dd', '\u00de', '\u00ae', '\u00a2', '\u00a3', '\u00a5', '\u00b7', '\u00a9', '@', '\u00b6', '\u00bc', '\u00bd', '\u00be', '\u00ac', '|', '\u00af', '\u00a8', '\u00b4', '\u00d7', '\u00e4', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', '\u00ad', '\u00f4', '\u00a6', '\u00f2', '\u00f3', '\u00f5', '\u00fc', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', '\u00b9', '\u00fb', '}', '\u00f9', '\u00fa', '\u00ff', '\u00d6', '\u00f7', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00b2', '\u00d4', '\\', '\u00d2', '\u00d3', '\u00d5', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '\u00b3', '\u00db', ']', '\u00d9', '\u00da', '\u009f'};
        static final int fgEuroValue = -1;
        static final byte[] fgByteMap = new byte[]{0, 1, 2, 3, 55, 45, 46, 47, 22, 5, 21, 11, 12, 13, 14, 15, 16, 17, 18, 19, 60, 61, 50, 38, 24, 25, 63, 39, 28, 29, 30, 31, 64, 79, 127, 123, 91, 108, 80, 125, 77, 93, 92, 78, 107, 96, 75, 97, -16, -15, -14, -13, -12, -11, -10, -9, -8, -7, 122, 94, 76, 126, 110, 111, -75, -63, -62, -61, -60, -59, -58, -57, -56, -55, -47, -46, -45, -44, -43, -42, -41, -40, -39, -30, -29, -28, -27, -26, -25, -24, -23, 99, -20, -4, 95, 109, 121, -127, -126, -125, -124, -123, -122, -121, -120, -119, -111, -110, -109, -108, -107, -106, -105, -104, -103, -94, -93, -92, -91, -90, -89, -88, -87, 67, -69, -36, 89, 7, 32, 33, 34, 35, 36, 21, 6, 23, 40, 41, 42, 43, 44, 9, 10, 27, 48, 49, 26, 51, 52, 53, 54, 8, 56, 57, 58, 59, 4, 20, 62, -1, 65, -86, -80, -79, -97, -78, -52, 124, -67, -76, -102, -118, -70, -54, -81, -68, -112, -113, -22, -6, -66, -96, -74, -77, -99, -38, -101, -117, -73, -72, -71, -85, 100, 101, 98, 102, 74, 103, -98, 104, 116, 113, 114, 115, 120, 117, 118, 119, -84, 105, -19, -18, -21, -17, -32, -65, -128, -3, -2, -5, 90, -83, -82, -95, 68, 69, 66, 70, -64, 71, -100, 72, 84, 81, 82, 83, 88, 85, 86, 87, -116, 73, -51, -50, -53, -49, 106, -31, 112, -35, -34, -37, -48, -115, -114, -33};
        static final byte[] fgContentMap = new byte[]{5, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 1, 1, 1};
        static final byte[] fgNameCharMap = new byte[]{8, 8, 8, 8, 8, 20, 8, 8, 8, 8, 8, 8, 8, 20, 8, 8, 8, 8, 8, 8, 8, 20, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 20, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 20, 8, 3, 8, 3, 3, 3, 3, 3, 3, 3, 2, 8, 8, 8, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 8, 3, 8, 8, 8, 28, 8, 2, 12, 3, 8, 3, 3, 3, 3, 3, 3, 3, 8, 8, 3, 16, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 4, 8, 8, 8, 24, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 3, 3, 3, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 3, 8, 3, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 3, 3, 3, 8, 8, 8, 8, 2, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 3, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 3, 8, 3, 3, 3, 3, 8, 3, 3, 3, 3, 3, 3, 3, 3, 8, 3, 8, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 8, 3, 8, 3, 3, 8};

        CP273Mappings() {
        }

        static EncodingSupport createEncodingSupport() {
            return new EBCDICEncodingSupport(fgCharMap, -1, fgByteMap, fgContentMap, fgNameCharMap);
        }
    }

    static final class CP037Mappings {
        static final char[] fgCharMap = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u009c', '\t', '\u0086', '\u007f', '\u0097', '\u008d', '\u008e', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u009d', '\n', '\b', '\u0087', '\u0018', '\u0019', '\u0092', '\u008f', '\u001c', '\u001d', '\u001e', '\u001f', '\u0080', '\u0081', '\u0082', '\u0083', '\u0084', '\n', '\u0017', '\u001b', '\u0088', '\u0089', '\u008a', '\u008b', '\u008c', '\u0005', '\u0006', '\u0007', '\u0090', '\u0091', '\u0016', '\u0093', '\u0094', '\u0095', '\u0096', '\u0004', '\u0098', '\u0099', '\u009a', '\u009b', '\u0014', '\u0015', '\u009e', '\u001a', ' ', '\u00a0', '\u00e2', '\u00e4', '\u00e0', '\u00e1', '\u00e3', '\u00e5', '\u00e7', '\u00f1', '\u00a2', '.', '<', '(', '+', '|', '&', '\u00e9', '\u00ea', '\u00eb', '\u00e8', '\u00ed', '\u00ee', '\u00ef', '\u00ec', '\u00df', '!', '$', '*', ')', ';', '\u00ac', '-', '/', '\u00c2', '\u00c4', '\u00c0', '\u00c1', '\u00c3', '\u00c5', '\u00c7', '\u00d1', '\u00a6', ',', '%', '_', '>', '?', '\u00f8', '\u00c9', '\u00ca', '\u00cb', '\u00c8', '\u00cd', '\u00ce', '\u00cf', '\u00cc', '`', ':', '#', '@', '\'', '=', '\"', '\u00d8', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', '\u00ab', '\u00bb', '\u00f0', '\u00fd', '\u00fe', '\u00b1', '\u00b0', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', '\u00aa', '\u00ba', '\u00e6', '\u00b8', '\u00c6', '\u00a4', '\u00b5', '~', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '\u00a1', '\u00bf', '\u00d0', '\u00dd', '\u00de', '\u00ae', '^', '\u00a3', '\u00a5', '\u00b7', '\u00a9', '\u00a7', '\u00b6', '\u00bc', '\u00bd', '\u00be', '[', ']', '\u00af', '\u00a8', '\u00b4', '\u00d7', '{', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', '\u00ad', '\u00f4', '\u00f6', '\u00f2', '\u00f3', '\u00f5', '}', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', '\u00b9', '\u00fb', '\u00fc', '\u00f9', '\u00fa', '\u00ff', '\\', '\u00f7', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00b2', '\u00d4', '\u00d6', '\u00d2', '\u00d3', '\u00d5', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '\u00b3', '\u00db', '\u00dc', '\u00d9', '\u00da', '\u009f'};
        static final int fgEuroValue = -1;
        static final byte[] fgByteMap = new byte[]{0, 1, 2, 3, 55, 45, 46, 47, 22, 5, 21, 11, 12, 13, 14, 15, 16, 17, 18, 19, 60, 61, 50, 38, 24, 25, 63, 39, 28, 29, 30, 31, 64, 90, 127, 123, 91, 108, 80, 125, 77, 93, 92, 78, 107, 96, 75, 97, -16, -15, -14, -13, -12, -11, -10, -9, -8, -7, 122, 94, 76, 126, 110, 111, 124, -63, -62, -61, -60, -59, -58, -57, -56, -55, -47, -46, -45, -44, -43, -42, -41, -40, -39, -30, -29, -28, -27, -26, -25, -24, -23, -70, -32, -69, -80, 109, 121, -127, -126, -125, -124, -123, -122, -121, -120, -119, -111, -110, -109, -108, -107, -106, -105, -104, -103, -94, -93, -92, -91, -90, -89, -88, -87, -64, 79, -48, -95, 7, 32, 33, 34, 35, 36, 21, 6, 23, 40, 41, 42, 43, 44, 9, 10, 27, 48, 49, 26, 51, 52, 53, 54, 8, 56, 57, 58, 59, 4, 20, 62, -1, 65, -86, 74, -79, -97, -78, 106, -75, -67, -76, -102, -118, 95, -54, -81, -68, -112, -113, -22, -6, -66, -96, -74, -77, -99, -38, -101, -117, -73, -72, -71, -85, 100, 101, 98, 102, 99, 103, -98, 104, 116, 113, 114, 115, 120, 117, 118, 119, -84, 105, -19, -18, -21, -17, -20, -65, -128, -3, -2, -5, -4, -83, -82, 89, 68, 69, 66, 70, 67, 71, -100, 72, 84, 81, 82, 83, 88, 85, 86, 87, -116, 73, -51, -50, -53, -49, -52, -31, 112, -35, -34, -37, -36, -115, -114, -33};
        static final byte[] fgContentMap = new byte[]{5, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
        static final byte[] fgNameCharMap = new byte[]{8, 8, 8, 8, 8, 20, 8, 8, 8, 8, 8, 8, 8, 20, 8, 8, 8, 8, 8, 8, 8, 20, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 20, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 20, 8, 3, 3, 3, 3, 3, 3, 3, 3, 8, 2, 8, 8, 8, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 8, 8, 28, 8, 2, 12, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 8, 3, 16, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 4, 8, 8, 8, 24, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 3, 3, 3, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 3, 8, 3, 8, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 3, 3, 3, 8, 8, 8, 8, 2, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 3, 3, 3, 3, 3, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 3, 3, 3, 3, 3, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 8, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 8, 3, 3, 3, 3, 8};

        CP037Mappings() {
        }

        static EncodingSupport createEncodingSupport() {
            return new EBCDICEncodingSupport(fgCharMap, -1, fgByteMap, fgContentMap, fgNameCharMap);
        }
    }
}

