/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.b2b.util;

import com.ibm.xml.b2b.util.CharConversionError;
import com.ibm.xml.b2b.util.EncodingSupport;
import com.ibm.xml.b2b.util.SingleByteEncodingSupport;
import com.ibm.xml.b2b.util.XMLString;
import com.ibm.xml.b2b.util.XMLStringBuffer;

public final class SingleByteStringBuffer
implements XMLStringBuffer {
    private SingleByteEncodingSupport fEncoding;
    private final char[] fByteToCharMap;
    private byte[] fData;
    private int fOffset;
    private byte[][] fDataPointer;
    private int[] fIntPointer;
    private byte fSpaceByteValue;

    public SingleByteStringBuffer(SingleByteEncodingSupport singleByteEncodingSupport) {
        this.fEncoding = singleByteEncodingSupport;
        this.fByteToCharMap = singleByteEncodingSupport.byteToCharMap;
        this.fData = new byte[256];
        this.fDataPointer = new byte[1][];
        this.fIntPointer = new int[1];
        this.fData[0] = 0;
        this.fOffset = 1;
        this.fDataPointer[0] = this.fData;
        this.fEncoding.encodeCharacter(32, this.fDataPointer, this.fOffset);
        this.fSpaceByteValue = this.fData[1];
    }

    public void reset(boolean bl) {
        this.fOffset = 1;
    }

    public void setOffset(int n) {
        this.fOffset = n;
    }

    public int getOffset() {
        return this.fOffset;
    }

    public void append(int n) {
        this.fOffset = this.fEncoding.encodeCharacter(n, this.fDataPointer, this.fOffset);
        this.fData = this.fDataPointer[0];
    }

    public void append(String string) {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            int n3 = string.charAt(n2);
            if (n3 >= 55296) {
                if (n3 < 56320) {
                    char c;
                    if (++n2 == n) {
                        CharConversionError.missingSecondHalfOfSurrogatePair();
                    }
                    if ((c = string.charAt(n2)) < '\udc00' || c >= '\ue000') {
                        CharConversionError.invalidSecondHalfOfSurrogatePair();
                    }
                    n3 = 65536 + (n3 - 55296 << 10) + (c - 56320);
                } else if (n3 < 57344) {
                    CharConversionError.invalidFirstHalfOfSurrogatePair();
                }
            }
            this.append(n3);
            ++n2;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void append(byte[] var1_1, int var2_2, int var3_3, EncodingSupport var4_4) {
        block2: {
            if (var4_4 != this.fEncoding) ** GOTO lbl12
            var5_5 = var3_3 - var2_2;
            if (this.fOffset + var5_5 > this.fData.length) {
                this.grow(var5_5);
            }
            System.arraycopy(var1_1, var2_2, this.fData, this.fOffset, var5_5);
            this.fOffset += var5_5;
            break block2;
lbl-1000:
            // 1 sources

            {
                var5_6 = var4_4.decodeCharacter(var1_1, var2_2, var3_3, this.fIntPointer);
                var6_7 = this.fIntPointer[0];
                var2_2 += var6_7;
                this.append(var5_6);
lbl12:
                // 2 sources

                ** while (var2_2 < var3_3)
            }
        }
    }

    private void append(char[] cArray, int n, int n2) {
        while (n < n2) {
            int n3;
            if ((n3 = cArray[n++]) >= 55296) {
                if (n3 < 56320) {
                    char c;
                    if (n == n2) {
                        CharConversionError.missingSecondHalfOfSurrogatePair();
                    }
                    if ((c = cArray[n++]) < '\udc00' || c >= '\ue000') {
                        CharConversionError.invalidSecondHalfOfSurrogatePair();
                    }
                    n3 = 65536 + (n3 - 55296 << 10) + (c - 56320);
                } else if (n3 < 57344) {
                    CharConversionError.invalidFirstHalfOfSurrogatePair();
                }
            }
            this.append(n3);
        }
    }

    public void append(XMLString xMLString) {
        if (xMLString.bytes != null) {
            this.append(xMLString.bytes, xMLString.offset, xMLString.endOffset, xMLString.encoding);
        } else {
            this.append(xMLString.chars, xMLString.offset, xMLString.endOffset);
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean normalizeTextValue(XMLString var1_1, XMLString var2_2) {
        var3_3 = this.fOffset;
        var4_4 = 0;
        var5_5 = true;
        this.append(var1_1);
        var6_6 = this.fOffset - var3_3;
        while (var5_5 && var4_4 < var6_6) {
            var7_7 = this.fByteToCharMap[this.fData[var3_3 + var4_4] & 255];
            if (var7_7 > 32) ** GOTO lbl12
            var5_5 = false;
            continue;
lbl-1000:
            // 1 sources

            {
                var7_7 = this.fByteToCharMap[this.fData[var3_3 + var4_4] & 255];
lbl12:
                // 2 sources

                ** while (var7_7 > 32 && ++var4_4 < var6_6)
            }
lbl13:
            // 1 sources

            if (var4_4 >= var6_6 || var7_7 >= 32 && ++var4_4 < var6_6) continue;
            var5_5 = false;
        }
        if (var5_5) {
            this.fOffset = var3_3;
            return false;
        }
        var7_7 = var3_3;
        var8_8 = this.fOffset;
        var11_9 = true;
        var4_4 = 0;
        block2: while (true) {
            if (var4_4 < var6_6) {
                var10_11 = this.fByteToCharMap[this.fData[var3_3 + var4_4] & 255];
                if (var10_11 <= ' ') {
                    ++var4_4;
                    continue;
                }
            }
            if (var4_4 == var6_6) break;
            if (!var11_9) {
                this.fData[var7_7++] = this.fSpaceByteValue;
            }
            var11_9 = false;
            while (true) {
                if (var4_4 >= var6_6) continue block2;
                var9_10 = this.fData[var3_3 + var4_4];
                var10_11 = this.fByteToCharMap[var9_10 & 255];
                if (var10_11 != ' ') ** break;
                continue block2;
                this.fData[var7_7++] = var9_10;
                ++var4_4;
            }
            break;
        }
        if (this.fOffset == var8_8) {
            this.fOffset = var7_7;
        }
        if (var2_2 != null) {
            var2_2.setValues(var1_1);
        }
        var1_1.setValues(this.fData, var3_3, var7_7, this.fEncoding);
        return true;
    }

    public void normalizedAppend(XMLString xMLString) {
        int n = this.fOffset;
        this.append(xMLString);
        int n2 = this.fOffset;
        int n3 = n;
        while (n3 < n2) {
            char c = this.fByteToCharMap[this.fData[n3] & 0xFF];
            if (c == '\n' || c == '\t' || c == '\r') {
                this.fData[n3] = this.fSpaceByteValue;
            }
            ++n3;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void normalizePublicID(XMLString var1_1) {
        block20: {
            block21: {
                var2_2 = var1_1.offset;
                var3_3 = var1_1.endOffset;
                var4_4 = null;
                if (var2_2 == var3_3) {
                    return;
                }
                if (var1_1.bytes != null && !var1_1.encoding.isASCIITransparent()) {
                    var11_5 = var1_1.charLength();
                    var12_8 = new char[1][var11_5];
                    var13_9 = new int[1];
                    var1_1.getChars(var12_8, var13_9);
                    var4_4 = var1_1;
                    var1_1 = new XMLString();
                    var1_1.setValues(var12_8[0], 0, var13_9[0]);
                    var2_2 = var1_1.offset;
                    var3_3 = var1_1.endOffset;
                }
                var5_10 = var2_2;
                var6_11 = true;
                if (var1_1.bytes == null) break block21;
                var11_6 = var1_1.bytes;
                while (var6_11 && var2_2 < var3_3) {
                    var7_12 = var11_6[var2_2];
                    if (var7_12 > 32) ** GOTO lbl26
                    var6_11 = false;
                    continue;
lbl-1000:
                    // 1 sources

                    {
                        var7_12 = var11_6[var2_2];
lbl26:
                        // 2 sources

                        ** while (var7_12 > 32 && ++var2_2 < var3_3)
                    }
lbl27:
                    // 1 sources

                    if (var2_2 >= var3_3 || var7_12 >= 32 && ++var2_2 != var3_3) continue;
                    var6_11 = false;
                }
                if (var6_11) {
                    return;
                }
                var2_2 = var5_10;
                var8_14 = true;
                var9_16 = this.getOffset();
                block2: while (true) {
                    if (var2_2 < var3_3) {
                        var7_12 = var11_6[var2_2];
                        if (var7_12 <= 32) {
                            ++var2_2;
                            continue;
                        }
                    }
                    if (var2_2 != var3_3) {
                        if (!var8_14) {
                            this.append(32);
                        }
                        var8_14 = false;
                        while (true) {
                            if (var2_2 >= var3_3) continue block2;
                            var7_12 = var11_6[var2_2];
                            if (var7_12 > 32) ** break;
                            continue block2;
                            this.append(var7_12);
                            ++var2_2;
                        }
                    }
                    break block20;
                    break;
                }
            }
            var11_7 = var1_1.chars;
            while (var6_11 && var2_2 < var3_3) {
                var7_13 = var11_7[var2_2];
                if (var7_13 > ' ') ** GOTO lbl62
                var6_11 = false;
                continue;
lbl-1000:
                // 1 sources

                {
                    var7_13 = var11_7[var2_2];
lbl62:
                    // 2 sources

                    ** while (var7_13 > ' ' && ++var2_2 < var3_3)
                }
lbl63:
                // 1 sources

                if (var2_2 >= var3_3 || var7_13 >= ' ' && ++var2_2 != var3_3) continue;
                var6_11 = false;
            }
            if (var6_11) {
                return;
            }
            var2_2 = var5_10;
            var8_15 = true;
            var9_16 = this.getOffset();
            block6: while (true) {
                if (var2_2 < var3_3) {
                    var7_13 = var11_7[var2_2];
                    if (var7_13 <= ' ') {
                        ++var2_2;
                        continue;
                    }
                }
                if (var2_2 == var3_3) break;
                if (!var8_15) {
                    this.append(32);
                }
                var8_15 = false;
                while (true) {
                    if (var2_2 >= var3_3) continue block6;
                    var7_13 = var11_7[var2_2];
                    if (var7_13 > ' ') ** break;
                    continue block6;
                    this.append(var7_13);
                    ++var2_2;
                }
                break;
            }
            if (var4_4 != null) {
                var1_1 = var4_4;
            }
        }
        var10_17 = this.getOffset();
        this.setStringValues(var9_16, var10_17, var1_1);
    }

    public void setStringValues(int n, int n2, XMLString xMLString) {
        xMLString.setValues(this.fData, n, n2, this.fEncoding);
    }

    private void grow(int n) {
        int n2 = this.fData.length << 1;
        while (this.fOffset + n > n2) {
            n2 <<= 1;
        }
        this.fDataPointer[0] = new byte[n2];
        System.arraycopy(this.fData, 0, this.fDataPointer[0], 0, this.fData.length);
        this.fData = this.fDataPointer[0];
    }
}

