/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.b2b.util.entity;

import com.ibm.xml.b2b.util.CharConversionError;
import com.ibm.xml.b2b.util.EncodingSupport;
import com.ibm.xml.b2b.util.IANACharset;
import com.ibm.xml.b2b.util.IOExceptionWrapper;
import com.ibm.xml.b2b.util.ReusableByteArrayInputStream;
import com.ibm.xml.b2b.util.RewindableInputStream;
import com.ibm.xml.b2b.util.UCSEncodingSupport;
import com.ibm.xml.b2b.util.URI;
import com.ibm.xml.b2b.util.UTF8EncodingSupport;
import com.ibm.xml.b2b.util.XMLString;
import com.ibm.xml.b2b.util.entity.EBCDICEncodingDeclReader;
import com.ibm.xml.b2b.util.entity.EntityInputSource;
import com.ibm.xml.b2b.util.entity.LatinEncodingDeclReader;
import com.ibm.xml.b2b.util.entity.UCSEncodingDeclReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

abstract class ParsedEntityRecognizer {
    public static final boolean ALLOW_JAVA_ENCODINGS = true;
    protected static final int ENCODING_UNKNOWN = 0;
    protected static final int ENCODING_UTF8N = 1;
    protected static final int ENCODING_UTF16BE = 2;
    protected static final int ENCODING_UTF16LE = 3;
    protected static final int ENCODING_UTF32BE = 4;
    protected static final int ENCODING_UTF32LE = 5;
    protected static final int ENCODING_LATIN = 6;
    protected static final int ENCODING_EBCDIC = 7;
    protected static final int ENCODING_UCS2BE = 8;
    protected static final int ENCODING_UCS2LE = 9;
    protected static final int ENCODING_UCS4BE = 10;
    protected static final int ENCODING_UCS4LE = 11;
    protected boolean fIsDocumentEntity;
    protected boolean fIsExternalEntity;
    private static final boolean CLEAR_TO_END_OF_BUFFER = false;
    private static final int INITIAL_BUFFER_LENGTH = 32768;
    private boolean[] fSkipLF;
    private byte[] fByteIOBuffer;
    private char[] fCharIOBuffer;
    private int fFreeBytesPointerCount;
    private int fInUseBytesPointerCount;
    private byte[][] fBytesPointer;
    private int fFreeCharsPointerCount;
    private int fInUseCharsPointerCount;
    private char[][] fCharsPointer;
    private int[] fOffsetPointer;
    private int[] fSurrogate;
    private EncodingSupport fUTF8EncodingSupport;
    private ReusableByteArrayInputStream fByteArrayStream;
    private RewindableInputStream fStreamWrapper;
    private LatinEncodingDeclReader fLatinEncodingDeclReader;
    private EBCDICEncodingDeclReader fEBCDICEncodingDeclReader;
    private UCSEncodingDeclReader fUCSEncodingDeclReader;

    protected abstract XMLString getEntityContent();

    protected abstract boolean setCharacterStreamSource(Reader var1);

    protected abstract boolean setByteStreamSource(InputStream var1, EncodingSupport var2);

    protected abstract boolean setByteArraySource(byte[] var1, int var2, int var3, EncodingSupport var4);

    protected abstract boolean setCharArraySource(char[] var1, int var2, int var3);

    protected abstract boolean setStringSource(String var1);

    protected abstract boolean readUTF8ByteStream(InputStream var1, EncodingSupport var2);

    protected abstract boolean readUCSByteStreamWithBOM(InputStream var1, EncodingSupport var2);

    protected abstract boolean readLatinByteStream(InputStream var1, EncodingSupport var2);

    protected abstract boolean readEBCDICByteStream(InputStream var1, EncodingSupport var2);

    protected abstract boolean readUCSByteStream(InputStream var1, EncodingSupport var2);

    protected ParsedEntityRecognizer(boolean bl) {
        if (bl) {
            this.fSkipLF = new boolean[1];
        }
        this.fBytesPointer = new byte[4][];
        this.fCharsPointer = new char[4][];
        this.fOffsetPointer = new int[1];
        this.fSurrogate = new int[1];
        this.fUTF8EncodingSupport = UTF8EncodingSupport.getInstance();
    }

    protected void reset(boolean bl) {
        if (!bl) {
            int n = 0;
            while (n < this.fBytesPointer.length) {
                if (this.fBytesPointer[n] != null) {
                    this.fBytesPointer[n] = null;
                }
                ++n;
            }
            n = 0;
            while (n < this.fCharsPointer.length) {
                if (this.fCharsPointer[n] != null) {
                    this.fCharsPointer[n] = null;
                }
                ++n;
            }
            if (this.fByteIOBuffer != null) {
                this.fByteIOBuffer = null;
            }
            if (this.fCharIOBuffer != null) {
                this.fCharIOBuffer = null;
            }
        }
    }

    protected final boolean setSource(EntityInputSource entityInputSource, boolean bl, boolean bl2) {
        this.fIsDocumentEntity = bl;
        this.fIsExternalEntity = bl2;
        XMLString xMLString = entityInputSource.getContent();
        if (xMLString == null) {
            EncodingSupport encodingSupport;
            boolean bl3;
            String string;
            Reader reader = entityInputSource.getCharacterStream();
            if (reader != null) {
                return this.setCharacterStreamSource(reader);
            }
            InputStream inputStream = entityInputSource.getByteStream();
            String string2 = entityInputSource.getEncoding();
            if (inputStream == null) {
                string = entityInputSource.getSystemId();
                try {
                    inputStream = URI.openStream(string);
                }
                catch (IOException iOException) {
                    throw new IOExceptionWrapper(iOException);
                }
                bl3 = true;
            } else {
                bl3 = false;
            }
            boolean bl4 = string2 == null ? this.detectEncodingSetSource(inputStream) : ((encodingSupport = IANACharset.getEncodingSupport(string = string2.toUpperCase())) != null ? this.setByteStreamSource(inputStream, encodingSupport) : this.convertByteStreamWithUnknownEncoding(inputStream, string2));
            if (bl3) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    throw new IOExceptionWrapper(iOException);
                }
            }
            return bl4;
        }
        if (xMLString.bytes != null) {
            if (xMLString.encoding == null) {
                if (!this.fIsExternalEntity) {
                    throw new RuntimeException("ParsedEntityRecognizer#setSource()");
                }
                if (this.fByteArrayStream == null) {
                    this.fByteArrayStream = new ReusableByteArrayInputStream(xMLString.bytes, xMLString.offset, xMLString.endOffset - xMLString.offset);
                } else {
                    this.fByteArrayStream.setBuffer(xMLString.bytes, xMLString.offset, xMLString.endOffset - xMLString.offset);
                }
                return this.detectEncodingSetSource(this.fByteArrayStream);
            }
            return this.setByteArraySource(xMLString.bytes, xMLString.offset, xMLString.endOffset, xMLString.encoding);
        }
        if (xMLString.chars != null) {
            return this.setCharArraySource(xMLString.chars, xMLString.offset, xMLString.endOffset);
        }
        if (xMLString.str != null) {
            return this.setStringSource(xMLString.str);
        }
        throw new IllegalArgumentException("ParsedEntityRecognizer#setSource()");
    }

    private boolean detectEncodingSetSource(InputStream inputStream) {
        String string;
        EncodingSupport encodingSupport;
        RewindableInputStream rewindableInputStream = this.fStreamWrapper;
        if (rewindableInputStream == null) {
            rewindableInputStream = this.fStreamWrapper = new RewindableInputStream();
        }
        rewindableInputStream.setStream(inputStream);
        int n = ParsedEntityRecognizer.detectEncoding(rewindableInputStream);
        switch (n) {
            default: {
                return this.readUTF8ByteStream(rewindableInputStream, this.fUTF8EncodingSupport);
            }
            case 2: {
                return this.readUCSByteStreamWithBOM(rewindableInputStream, UCSEncodingSupport.getInstance(0));
            }
            case 3: {
                return this.readUCSByteStreamWithBOM(rewindableInputStream, UCSEncodingSupport.getInstance(1));
            }
            case 4: {
                return this.readUCSByteStreamWithBOM(rewindableInputStream, UCSEncodingSupport.getInstance(2));
            }
            case 5: {
                return this.readUCSByteStreamWithBOM(rewindableInputStream, UCSEncodingSupport.getInstance(3));
            }
            case 6: {
                String string2;
                EncodingSupport encodingSupport2;
                if (this.fLatinEncodingDeclReader == null) {
                    this.fLatinEncodingDeclReader = new LatinEncodingDeclReader();
                }
                String string3 = this.fLatinEncodingDeclReader.getEncoding(rewindableInputStream, this.fIsDocumentEntity);
                rewindableInputStream.rewind();
                boolean bl = string3 == null ? this.readUTF8ByteStream(rewindableInputStream, this.fUTF8EncodingSupport) : ((encodingSupport2 = IANACharset.getEncodingSupport(string2 = string3.toUpperCase())) == null ? this.convertByteStreamWithUnknownEncoding(rewindableInputStream, string3) : this.readLatinByteStream(rewindableInputStream, encodingSupport2));
                return bl;
            }
            case 7: {
                String string4;
                EncodingSupport encodingSupport3;
                if (this.fEBCDICEncodingDeclReader == null) {
                    this.fEBCDICEncodingDeclReader = new EBCDICEncodingDeclReader();
                }
                String string5 = this.fEBCDICEncodingDeclReader.getEncoding(rewindableInputStream, this.fIsDocumentEntity);
                rewindableInputStream.rewind();
                boolean bl = string5 == null ? this.readUTF8ByteStream(rewindableInputStream, this.fUTF8EncodingSupport) : ((encodingSupport3 = IANACharset.getEncodingSupport(string4 = string5.toUpperCase())) == null ? this.convertByteStreamWithUnknownEncoding(rewindableInputStream, string5) : this.readEBCDICByteStream(rewindableInputStream, encodingSupport3));
                return bl;
            }
            case 8: {
                String string6;
                EncodingSupport encodingSupport4;
                if (this.fUCSEncodingDeclReader == null) {
                    this.fUCSEncodingDeclReader = new UCSEncodingDeclReader();
                }
                this.fUCSEncodingDeclReader.setState(2, true);
                String string7 = this.fUCSEncodingDeclReader.getEncoding(rewindableInputStream, this.fIsDocumentEntity);
                rewindableInputStream.rewind();
                boolean bl = string7 == null ? this.readUTF8ByteStream(rewindableInputStream, this.fUTF8EncodingSupport) : ((encodingSupport4 = IANACharset.getEncodingSupport(string6 = string7.toUpperCase())) == null ? this.convertByteStreamWithUnknownEncoding(rewindableInputStream, string7) : this.readUCSByteStream(rewindableInputStream, encodingSupport4));
                return bl;
            }
            case 9: {
                String string8;
                EncodingSupport encodingSupport5;
                if (this.fUCSEncodingDeclReader == null) {
                    this.fUCSEncodingDeclReader = new UCSEncodingDeclReader();
                }
                this.fUCSEncodingDeclReader.setState(2, false);
                String string9 = this.fUCSEncodingDeclReader.getEncoding(rewindableInputStream, this.fIsDocumentEntity);
                rewindableInputStream.rewind();
                boolean bl = string9 == null ? this.readUTF8ByteStream(rewindableInputStream, this.fUTF8EncodingSupport) : ((encodingSupport5 = IANACharset.getEncodingSupport(string8 = string9.toUpperCase())) == null ? this.convertByteStreamWithUnknownEncoding(rewindableInputStream, string9) : this.readUCSByteStream(rewindableInputStream, encodingSupport5));
                return bl;
            }
            case 10: {
                String string10;
                EncodingSupport encodingSupport6;
                if (this.fUCSEncodingDeclReader == null) {
                    this.fUCSEncodingDeclReader = new UCSEncodingDeclReader();
                }
                this.fUCSEncodingDeclReader.setState(4, true);
                String string11 = this.fUCSEncodingDeclReader.getEncoding(rewindableInputStream, this.fIsDocumentEntity);
                rewindableInputStream.rewind();
                boolean bl = string11 == null ? this.readUTF8ByteStream(rewindableInputStream, this.fUTF8EncodingSupport) : ((encodingSupport6 = IANACharset.getEncodingSupport(string10 = string11.toUpperCase())) == null ? this.convertByteStreamWithUnknownEncoding(rewindableInputStream, string11) : this.readUCSByteStream(rewindableInputStream, encodingSupport6));
                return bl;
            }
            case 11: 
        }
        if (this.fUCSEncodingDeclReader == null) {
            this.fUCSEncodingDeclReader = new UCSEncodingDeclReader();
        }
        this.fUCSEncodingDeclReader.setState(4, false);
        String string12 = this.fUCSEncodingDeclReader.getEncoding(rewindableInputStream, this.fIsDocumentEntity);
        rewindableInputStream.rewind();
        boolean bl = string12 == null ? this.readUTF8ByteStream(rewindableInputStream, this.fUTF8EncodingSupport) : ((encodingSupport = IANACharset.getEncodingSupport(string = string12.toUpperCase())) == null ? this.convertByteStreamWithUnknownEncoding(rewindableInputStream, string12) : this.readUCSByteStream(rewindableInputStream, encodingSupport));
        return bl;
    }

    private static final int detectEncoding(RewindableInputStream rewindableInputStream) {
        int n = 0;
        try {
            int n2 = rewindableInputStream.read();
            switch (n2) {
                case 239: {
                    int n3;
                    int n4 = rewindableInputStream.read();
                    if (n4 != 187 || (n3 = rewindableInputStream.read()) != 191) break;
                    rewindableInputStream.setStartOffset(3);
                    n = 1;
                    break;
                }
                case 60: {
                    int n5;
                    int n6;
                    int n7 = rewindableInputStream.read();
                    if (n7 == 0) {
                        int n8;
                        int n9 = rewindableInputStream.read();
                        if (n9 == 0) {
                            int n10 = rewindableInputStream.read();
                            if (n10 != 0) break;
                            n = 11;
                            break;
                        }
                        if (n9 != 63 || (n8 = rewindableInputStream.read()) != 0) break;
                        n = 9;
                        break;
                    }
                    if (n7 != 63 || (n6 = rewindableInputStream.read()) != 120 || (n5 = rewindableInputStream.read()) != 109) break;
                    n = 6;
                    break;
                }
                case 76: {
                    int n11;
                    int n12;
                    int n13 = rewindableInputStream.read();
                    if (n13 != 111 || (n12 = rewindableInputStream.read()) != 167 || (n11 = rewindableInputStream.read()) != 148) break;
                    n = 7;
                    break;
                }
                case 0: {
                    int n14;
                    int n15;
                    int n16 = rewindableInputStream.read();
                    if (n16 == 0) {
                        int n17;
                        int n18 = rewindableInputStream.read();
                        if (n18 == 0) {
                            int n19 = rewindableInputStream.read();
                            if (n19 != 60) break;
                            n = 10;
                            break;
                        }
                        if (n18 != 254 || (n17 = rewindableInputStream.read()) != 255) break;
                        rewindableInputStream.setStartOffset(4);
                        n = 4;
                        break;
                    }
                    if (n16 != 60 || (n15 = rewindableInputStream.read()) != 0 || (n14 = rewindableInputStream.read()) != 63) break;
                    n = 8;
                    break;
                }
                case 254: {
                    int n20 = rewindableInputStream.read();
                    if (n20 != 255) break;
                    rewindableInputStream.setStartOffset(2);
                    n = 2;
                    break;
                }
                case 255: {
                    int n21;
                    int n22 = rewindableInputStream.read();
                    if (n22 != 254) break;
                    rewindableInputStream.setStartOffset(2);
                    n = 3;
                    int n23 = rewindableInputStream.read();
                    if (n23 != 0 || (n21 = rewindableInputStream.read()) != 0) break;
                    rewindableInputStream.setStartOffset(4);
                    n = 5;
                }
            }
        }
        catch (IOException iOException) {
            throw new IOExceptionWrapper(iOException);
        }
        rewindableInputStream.rewind();
        return n;
    }

    protected final boolean convertByteStreamWithUnknownEncoding(InputStream inputStream, String string) {
        InputStreamReader inputStreamReader;
        try {
            inputStreamReader = new InputStreamReader(inputStream, string);
        }
        catch (IOException iOException) {
            throw new IOExceptionWrapper(iOException);
        }
        return this.readCharacterStream(inputStreamReader);
    }

    private static int checkUTF8BOM(InputStream inputStream, byte[] byArray) throws IOException {
        int n = 0;
        int n2 = inputStream.read();
        if (n2 == 239) {
            n2 = inputStream.read();
            if (n2 == 187) {
                n2 = inputStream.read();
                if (n2 == 191) {
                    return 0;
                }
                byArray[n++] = -17;
                byArray[n++] = -69;
                if (n2 != -1) {
                    byArray[n++] = (byte)n2;
                    return n;
                }
            } else {
                byArray[n++] = -17;
                if (n2 != -1) {
                    byArray[n++] = (byte)n2;
                    return n;
                }
            }
        } else if (n2 != -1) {
            byArray[n++] = (byte)n2;
            return n;
        }
        return n - 3;
    }

    protected final boolean readByteStream(InputStream inputStream, EncodingSupport encodingSupport, boolean bl) {
        byte[] byArray;
        boolean bl2;
        boolean bl3 = encodingSupport.isASCIITransparent();
        boolean bl4 = bl2 = this.fSkipLF != null;
        if (bl2) {
            this.fSkipLF[0] = false;
        }
        if ((byArray = this.fBytesPointer[0]) == null) {
            this.fBytesPointer[0] = new byte[32768];
            byArray = this.fBytesPointer[0];
        }
        int n = byArray.length;
        int n2 = 0;
        try {
            int n3 = 0;
            if (bl && encodingSupport == this.fUTF8EncodingSupport) {
                n2 = ParsedEntityRecognizer.checkUTF8BOM(inputStream, byArray);
                if (n2 < 0) {
                    n2 += 3;
                    n3 = -1;
                }
                if (n2 > 0 && bl3 && bl2) {
                    n2 = encodingSupport.normalizeLineBreaks(byArray, 0, n2, this.fSkipLF);
                }
            }
            while (n3 >= 0) {
                int n4 = n - n2;
                if (n4 == 0) {
                    n4 = n2;
                    this.fBytesPointer[0] = new byte[n4 << 1];
                    System.arraycopy(byArray, 0, this.fBytesPointer[0], 0, n4);
                    byArray = this.fBytesPointer[0];
                    n = byArray.length;
                }
                if ((n3 = inputStream.read(byArray, n2, n4)) < 0) continue;
                if (bl3 && bl2) {
                    n2 = encodingSupport.normalizeLineBreaks(byArray, n2, n2 + n3, this.fSkipLF);
                    continue;
                }
                n2 += n3;
            }
        }
        catch (IOException iOException) {
            throw new IOExceptionWrapper(iOException);
        }
        this.orphanBytes();
        if (!bl3 && bl2) {
            n2 = encodingSupport.normalizeLineBreaks(byArray, 0, n2, this.fSkipLF);
        }
        byArray[n2] = 0;
        XMLString xMLString = this.getEntityContent();
        xMLString.setValues(byArray, 0, n2, encodingSupport);
        return true;
    }

    private final void prepareForConvertToBytes() {
        if (this.fBytesPointer[0] == null) {
            this.fBytesPointer[0] = new byte[32768];
        }
        this.fOffsetPointer[0] = 0;
        if (this.fSkipLF != null) {
            this.fSkipLF[0] = false;
        }
    }

    private final void checkAfterConvertToBytes(EncodingSupport encodingSupport) {
        int n = this.fOffsetPointer[0];
        byte[] byArray = this.fBytesPointer[0];
        if (n == byArray.length) {
            byArray = new byte[n << 1];
            System.arraycopy(this.fBytesPointer[0], 0, byArray, 0, n);
            this.fBytesPointer[0] = byArray;
        }
        this.orphanBytes();
        byArray[n] = 0;
        XMLString xMLString = this.getEntityContent();
        xMLString.setValues(byArray, 0, n, encodingSupport);
    }

    protected final boolean convertByteStreamToUTF8(InputStream inputStream, EncodingSupport encodingSupport, boolean bl) {
        if (this.fByteIOBuffer == null) {
            this.fByteIOBuffer = new byte[32768];
        }
        if (this.fCharsPointer[0] == null) {
            this.fCharsPointer[0] = new char[32768];
        }
        this.prepareForConvertToBytes();
        encodingSupport.readCharacters(inputStream, this.fCharsPointer, this.fOffsetPointer, this.fSkipLF, this.fByteIOBuffer, bl);
        int n = this.fOffsetPointer[0];
        this.fOffsetPointer[0] = 0;
        this.fUTF8EncodingSupport.convertCharsToBytes(this.fCharsPointer[0], 0, n, this.fBytesPointer, this.fOffsetPointer);
        this.checkAfterConvertToBytes(this.fUTF8EncodingSupport);
        return true;
    }

    protected final boolean convertByteStream(InputStream inputStream, EncodingSupport encodingSupport, EncodingSupport encodingSupport2, boolean bl) {
        if (this.fByteIOBuffer == null) {
            this.fByteIOBuffer = new byte[32768];
        }
        if (this.fCharsPointer[0] == null) {
            this.fCharsPointer[0] = new char[32768];
        }
        this.prepareForConvertToBytes();
        encodingSupport.readCharacters(inputStream, this.fCharsPointer, this.fOffsetPointer, this.fSkipLF, this.fByteIOBuffer, bl);
        int n = this.fOffsetPointer[0];
        this.fOffsetPointer[0] = 0;
        encodingSupport2.convertCharsToBytes(this.fCharsPointer[0], 0, n, this.fBytesPointer, this.fOffsetPointer);
        this.checkAfterConvertToBytes(encodingSupport2);
        return true;
    }

    protected final boolean convertCharacterStreamToUTF8(Reader reader) {
        if (this.fCharIOBuffer == null) {
            this.fCharIOBuffer = new char[32768];
        }
        this.prepareForConvertToBytes();
        this.fSurrogate[0] = -1;
        try {
            int n;
            while ((n = reader.read(this.fCharIOBuffer, 0, 32768)) != -1) {
                UTF8EncodingSupport.normalizeCharsToBytes(this.fCharIOBuffer, 0, n, this.fBytesPointer, this.fOffsetPointer, this.fSurrogate, this.fSkipLF);
            }
        }
        catch (IOException iOException) {
            throw new IOExceptionWrapper(iOException);
        }
        if (this.fSurrogate[0] != -1) {
            CharConversionError.partialMultiPartCharacterSequence();
        }
        this.checkAfterConvertToBytes(this.fUTF8EncodingSupport);
        return true;
    }

    protected final boolean convertCharacterStream(Reader reader, EncodingSupport encodingSupport) {
        if (this.fCharIOBuffer == null) {
            this.fCharIOBuffer = new char[32768];
        }
        this.prepareForConvertToBytes();
        try {
            int n;
            while ((n = reader.read(this.fCharIOBuffer, 0, 32768)) != -1) {
                if (this.fSkipLF != null) {
                    n = this.normalizeLineBreaks(this.fCharIOBuffer, 0, n);
                }
                encodingSupport.convertCharsToBytes(this.fCharIOBuffer, 0, n, this.fBytesPointer, this.fOffsetPointer);
            }
        }
        catch (IOException iOException) {
            throw new IOExceptionWrapper(iOException);
        }
        this.checkAfterConvertToBytes(encodingSupport);
        return true;
    }

    protected final boolean convertBytesToUTF8(byte[] byArray, int n, int n2, EncodingSupport encodingSupport) {
        if (this.fCharsPointer[0] == null) {
            this.fCharsPointer[0] = new char[32768];
        }
        this.fOffsetPointer[0] = 0;
        encodingSupport.convertBytesToChars(byArray, n, n2, this.fCharsPointer, this.fOffsetPointer);
        int n3 = this.fOffsetPointer[0];
        this.prepareForConvertToBytes();
        this.fSurrogate[0] = -1;
        UTF8EncodingSupport.normalizeCharsToBytes(this.fCharsPointer[0], 0, n3, this.fBytesPointer, this.fOffsetPointer, this.fSurrogate, this.fSkipLF);
        if (this.fSurrogate[0] != -1) {
            CharConversionError.partialMultiPartCharacterSequence();
        }
        this.checkAfterConvertToBytes(this.fUTF8EncodingSupport);
        return true;
    }

    protected final boolean convertBytes(byte[] byArray, int n, int n2, EncodingSupport encodingSupport, EncodingSupport encodingSupport2) {
        if (this.fCharsPointer[0] == null) {
            this.fCharsPointer[0] = new char[32768];
        }
        this.fOffsetPointer[0] = 0;
        encodingSupport.convertBytesToChars(byArray, n, n2, this.fCharsPointer, this.fOffsetPointer);
        int n3 = this.fOffsetPointer[0];
        this.prepareForConvertToBytes();
        encodingSupport2.convertCharsToBytes(this.fCharsPointer[0], 0, n3, this.fBytesPointer, this.fOffsetPointer);
        this.checkAfterConvertToBytes(encodingSupport2);
        return true;
    }

    protected final boolean convertCharactersToUTF8(char[] cArray, int n, int n2) {
        this.prepareForConvertToBytes();
        this.fUTF8EncodingSupport.convertCharsToBytes(cArray, n, n2, this.fBytesPointer, this.fOffsetPointer);
        this.checkAfterConvertToBytes(this.fUTF8EncodingSupport);
        return true;
    }

    protected final boolean convertCharacters(char[] cArray, int n, int n2, EncodingSupport encodingSupport) {
        this.prepareForConvertToBytes();
        encodingSupport.convertCharsToBytes(cArray, n, n2, this.fBytesPointer, this.fOffsetPointer);
        this.checkAfterConvertToBytes(encodingSupport);
        return true;
    }

    protected final boolean convertStringToUTF8(String string) {
        char[] cArray;
        int n = string.length();
        if (this.fCharsPointer[0] == null) {
            this.fCharsPointer[0] = new char[32768];
        }
        if (n + 1 > (cArray = this.fCharsPointer[0]).length) {
            int n2 = cArray.length << 1;
            while (n + 1 > n2) {
                n2 <<= 1;
            }
            cArray = new char[n2];
            this.fCharsPointer[0] = cArray;
        }
        string.getChars(0, n, cArray, 0);
        if (this.fSkipLF != null) {
            n = this.normalizeLineBreaks(cArray, 0, n);
        }
        this.prepareForConvertToBytes();
        this.fUTF8EncodingSupport.convertCharsToBytes(cArray, 0, n, this.fBytesPointer, this.fOffsetPointer);
        this.checkAfterConvertToBytes(this.fUTF8EncodingSupport);
        return true;
    }

    protected final boolean convertString(String string, EncodingSupport encodingSupport) {
        char[] cArray;
        int n = string.length();
        if (this.fCharsPointer[0] == null) {
            this.fCharsPointer[0] = new char[32768];
        }
        if (n + 1 > (cArray = this.fCharsPointer[0]).length) {
            int n2 = cArray.length << 1;
            while (n + 1 > n2) {
                n2 <<= 1;
            }
            cArray = new char[n2];
            this.fCharsPointer[0] = cArray;
        }
        string.getChars(0, n, cArray, 0);
        if (this.fSkipLF != null) {
            n = this.normalizeLineBreaks(cArray, 0, n);
        }
        this.prepareForConvertToBytes();
        encodingSupport.convertCharsToBytes(cArray, 0, n, this.fBytesPointer, this.fOffsetPointer);
        this.checkAfterConvertToBytes(encodingSupport);
        return true;
    }

    protected boolean readCharacterStream(Reader reader) {
        char[] cArray = this.fCharsPointer[0];
        int n = 0;
        if (cArray == null) {
            this.fCharsPointer[0] = new char[32768];
            cArray = this.fCharsPointer[0];
        }
        int n2 = cArray.length;
        if (this.fSkipLF != null) {
            this.fSkipLF[0] = false;
        }
        try {
            while (true) {
                int n3;
                int n4;
                if ((n4 = n2 - n) == 0) {
                    n4 = n;
                    this.fCharsPointer[0] = new char[n4 << 1];
                    System.arraycopy(cArray, 0, this.fCharsPointer[0], 0, n4);
                    cArray = this.fCharsPointer[0];
                    n2 = cArray.length;
                }
                if ((n3 = reader.read(cArray, n, n4)) != -1) {
                    if (this.fSkipLF != null) {
                        n = this.normalizeLineBreaks(cArray, n, n + n3);
                        continue;
                    }
                    n += n3;
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            throw new IOExceptionWrapper(iOException);
        }
        this.orphanCharacters();
        cArray[n] = '\u0000';
        XMLString xMLString = this.getEntityContent();
        xMLString.setValues(cArray, 0, n);
        return true;
    }

    private final void prepareForConvertToCharacters() {
        if (this.fCharsPointer[0] == null) {
            this.fCharsPointer[0] = new char[32768];
        }
        this.fOffsetPointer[0] = 0;
        if (this.fSkipLF != null) {
            this.fSkipLF[0] = false;
        }
    }

    private final void checkAfterConvertToCharacters() {
        int n = this.fOffsetPointer[0];
        char[] cArray = this.fCharsPointer[0];
        if (n == cArray.length) {
            cArray = new char[n << 1];
            System.arraycopy(this.fCharsPointer[0], 0, cArray, 0, n);
            this.fCharsPointer[0] = cArray;
        }
        this.orphanCharacters();
        cArray[n] = '\u0000';
        XMLString xMLString = this.getEntityContent();
        xMLString.setValues(cArray, 0, n);
    }

    protected final boolean convertByteStreamToUTF16(InputStream inputStream, EncodingSupport encodingSupport, boolean bl) {
        if (this.fByteIOBuffer == null) {
            this.fByteIOBuffer = new byte[32768];
        }
        this.prepareForConvertToCharacters();
        encodingSupport.readCharacters(inputStream, this.fCharsPointer, this.fOffsetPointer, this.fSkipLF, this.fByteIOBuffer, bl);
        this.checkAfterConvertToCharacters();
        return true;
    }

    protected final boolean convertBytesToUTF16(byte[] byArray, int n, int n2, EncodingSupport encodingSupport) {
        this.prepareForConvertToCharacters();
        encodingSupport.convertBytesToChars(byArray, n, n2, this.fCharsPointer, this.fOffsetPointer);
        this.checkAfterConvertToCharacters();
        return true;
    }

    protected final boolean convertStringToUTF16(String string) {
        this.prepareForConvertToCharacters();
        char[] cArray = this.fCharsPointer[0];
        int n = string.length();
        if (n + 1 > cArray.length) {
            int n2 = cArray.length << 1;
            while (n + 1 > n2) {
                n2 <<= 1;
            }
            cArray = new char[n2];
            this.fCharsPointer[0] = cArray;
        }
        this.orphanCharacters();
        string.getChars(0, n, cArray, 0);
        if (this.fSkipLF != null) {
            n = this.normalizeLineBreaks(cArray, 0, n);
        }
        cArray[n] = '\u0000';
        XMLString xMLString = this.getEntityContent();
        xMLString.setValues(cArray, 0, n);
        return true;
    }

    private final void orphanBytes() {
        byte[] byArray = this.fBytesPointer[0];
        int n = 1 + this.fFreeBytesPointerCount;
        int n2 = n + this.fInUseBytesPointerCount;
        if (n > 1) {
            --this.fFreeBytesPointerCount;
            this.fBytesPointer[0] = this.fBytesPointer[--n];
            this.fBytesPointer[n] = byArray;
        } else {
            this.fBytesPointer[0] = null;
            if (n2 == this.fBytesPointer.length) {
                byte[][] byArrayArray = new byte[n2 << 1][];
                System.arraycopy(this.fBytesPointer, 0, byArrayArray, 0, n2);
                this.fBytesPointer = byArrayArray;
            }
            this.fBytesPointer[n2] = byArray;
        }
        ++this.fInUseBytesPointerCount;
    }

    private final void orphanCharacters() {
        char[] cArray = this.fCharsPointer[0];
        int n = 1 + this.fFreeCharsPointerCount;
        int n2 = n + this.fInUseCharsPointerCount;
        if (n > 1) {
            --this.fFreeCharsPointerCount;
            this.fCharsPointer[0] = this.fCharsPointer[--n];
            this.fCharsPointer[n] = cArray;
        } else {
            this.fCharsPointer[0] = null;
            if (n2 == this.fCharsPointer.length) {
                char[][] cArrayArray = new char[n2 << 1][];
                System.arraycopy(this.fCharsPointer, 0, cArrayArray, 0, n2);
                this.fCharsPointer = cArrayArray;
            }
            this.fCharsPointer[n2] = cArray;
        }
        ++this.fInUseCharsPointerCount;
    }

    protected final void releaseBytes(byte[] byArray) {
        int n = 1 + this.fFreeBytesPointerCount;
        int n2 = n + this.fInUseBytesPointerCount;
        int n3 = 0;
        int n4 = n;
        while (n4 < n2) {
            if (this.fBytesPointer[n4] == byArray) {
                n3 = n4;
                break;
            }
            ++n4;
        }
        if (n3 == 0) {
            return;
        }
        if (n3 < --n2) {
            this.fBytesPointer[n3] = this.fBytesPointer[n2];
        }
        --this.fInUseBytesPointerCount;
        if (this.fBytesPointer[0] == null) {
            this.fBytesPointer[0] = byArray;
            this.fBytesPointer[n2] = null;
        } else {
            this.fBytesPointer[n2] = this.fBytesPointer[n];
            this.fBytesPointer[n] = byArray;
            ++this.fFreeBytesPointerCount;
        }
    }

    protected final void releaseCharacters(char[] cArray) {
        int n = 1 + this.fFreeCharsPointerCount;
        int n2 = n + this.fInUseCharsPointerCount;
        int n3 = 0;
        int n4 = n;
        while (n4 < n2) {
            if (this.fCharsPointer[n4] == cArray) {
                n3 = n4;
                break;
            }
            ++n4;
        }
        if (n3 == 0) {
            return;
        }
        if (n3 < --n2) {
            this.fCharsPointer[n3] = this.fCharsPointer[n2];
        }
        --this.fInUseCharsPointerCount;
        if (this.fCharsPointer[0] == null) {
            this.fCharsPointer[0] = cArray;
            this.fCharsPointer[n2] = null;
        } else {
            this.fCharsPointer[n2] = this.fCharsPointer[n];
            this.fCharsPointer[n] = cArray;
            ++this.fFreeCharsPointerCount;
        }
    }

    private final int normalizeLineBreaks(char[] cArray, int n, int n2) {
        boolean bl = this.fSkipLF[0];
        int n3 = n;
        while (n3 < n2) {
            block6: {
                int n4;
                block5: {
                    n4 = cArray[n3];
                    if (!bl) break block5;
                    bl = false;
                    if (n4 == 10) break block6;
                }
                if (n4 == 13) {
                    n4 = 10;
                    bl = true;
                }
                cArray[n++] = n4;
            }
            ++n3;
        }
        this.fSkipLF[0] = bl;
        return n;
    }
}

