/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.b2b.util.entity;

import com.ibm.xml.b2b.util.EncodingSupport;
import com.ibm.xml.b2b.util.SingleByteEncodingSupport;
import com.ibm.xml.b2b.util.SingleByteStringBuffer;
import com.ibm.xml.b2b.util.XMLString;
import com.ibm.xml.b2b.util.XMLStringBuffer;
import com.ibm.xml.b2b.util.entity.ByteArrayParsedEntity;
import com.ibm.xml.b2b.util.entity.EntityInputSource;
import com.ibm.xml.b2b.util.entity.ParsedEntity;
import com.ibm.xml.b2b.util.entity.ParsedEntityFactory;
import com.ibm.xml.b2b.util.entity.ParsedEntityRecognizer;
import java.io.InputStream;
import java.io.Reader;

public final class SingleByteParsedEntityFactory
extends ParsedEntityRecognizer
implements ParsedEntityFactory {
    private static final int FREE_ENTITY_COUNT = 8;
    private SingleByteEncodingSupport fEncoding;
    private int fFreeEntityCount;
    private ParsedEntity[] fFreeEntities;
    private ParsedEntity fEntityContent;
    private EntityInputSource fStringSource;

    public SingleByteParsedEntityFactory(boolean bl, SingleByteEncodingSupport singleByteEncodingSupport) {
        super(bl);
        this.fEncoding = singleByteEncodingSupport;
        this.fFreeEntities = new ParsedEntity[8];
    }

    public void reset(boolean bl) {
        super.reset(bl);
        if (!bl) {
            while (this.fFreeEntityCount > 0) {
                --this.fFreeEntityCount;
                this.fFreeEntities[this.fFreeEntityCount] = null;
            }
            if (this.fStringSource != null) {
                this.fStringSource = null;
            }
        }
    }

    public ParsedEntity createParsedEntity(EntityInputSource entityInputSource, boolean bl) {
        this.fEntityContent = this.fFreeEntityCount > 0 ? this.fFreeEntities[--this.fFreeEntityCount] : new ByteArrayParsedEntity(this);
        this.fEntityContent.clear();
        if (!super.setSource(entityInputSource, bl, true)) {
            return null;
        }
        return this.fEntityContent;
    }

    public ParsedEntity createParsedEntity(XMLString xMLString) {
        if (this.fStringSource == null) {
            this.fStringSource = new EntityInputSource();
        }
        this.fStringSource.setContent(xMLString);
        this.fEntityContent = this.fFreeEntityCount > 0 ? this.fFreeEntities[--this.fFreeEntityCount] : new ByteArrayParsedEntity(this);
        this.fEntityContent.clear();
        if (!super.setSource(this.fStringSource, false, false)) {
            return null;
        }
        return this.fEntityContent;
    }

    public void releaseParsedEntity(ParsedEntity parsedEntity) {
        super.releaseBytes(parsedEntity.bytes);
        if (this.fFreeEntityCount < 8) {
            this.fFreeEntities[this.fFreeEntityCount++] = parsedEntity;
        }
    }

    public XMLStringBuffer createStringBuffer() {
        return new SingleByteStringBuffer(this.fEncoding);
    }

    protected XMLString getEntityContent() {
        return this.fEntityContent;
    }

    protected boolean setCharacterStreamSource(Reader reader) {
        return super.convertCharacterStream(reader, this.fEncoding);
    }

    protected boolean setByteStreamSource(InputStream inputStream, EncodingSupport encodingSupport) {
        if (encodingSupport == this.fEncoding) {
            return super.readByteStream(inputStream, encodingSupport, true);
        }
        return super.convertByteStream(inputStream, encodingSupport, this.fEncoding, true);
    }

    protected boolean setByteArraySource(byte[] byArray, int n, int n2, EncodingSupport encodingSupport) {
        if (encodingSupport == this.fEncoding) {
            this.fEntityContent.setValues(byArray, n, n2, encodingSupport);
            return true;
        }
        return super.convertBytes(byArray, n, n2, encodingSupport, this.fEncoding);
    }

    protected boolean setCharArraySource(char[] cArray, int n, int n2) {
        return super.convertCharacters(cArray, n, n2, this.fEncoding);
    }

    protected boolean setStringSource(String string) {
        return super.convertString(string, this.fEncoding);
    }

    protected boolean readUTF8ByteStream(InputStream inputStream, EncodingSupport encodingSupport) {
        return super.convertByteStream(inputStream, encodingSupport, this.fEncoding, false);
    }

    protected boolean readUCSByteStreamWithBOM(InputStream inputStream, EncodingSupport encodingSupport) {
        return super.convertByteStream(inputStream, encodingSupport, this.fEncoding, false);
    }

    protected boolean readLatinByteStream(InputStream inputStream, EncodingSupport encodingSupport) {
        if (encodingSupport == this.fEncoding) {
            return super.readByteStream(inputStream, encodingSupport, false);
        }
        return super.convertByteStream(inputStream, encodingSupport, this.fEncoding, false);
    }

    protected boolean readEBCDICByteStream(InputStream inputStream, EncodingSupport encodingSupport) {
        if (encodingSupport == this.fEncoding) {
            return super.readByteStream(inputStream, encodingSupport, false);
        }
        return super.convertByteStream(inputStream, encodingSupport, this.fEncoding, false);
    }

    protected boolean readUCSByteStream(InputStream inputStream, EncodingSupport encodingSupport) {
        return super.convertByteStream(inputStream, encodingSupport, this.fEncoding, true);
    }

    protected boolean readCharacterStream(Reader reader) {
        return super.convertCharacterStream(reader, this.fEncoding);
    }
}

