/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.proxy;

import com.sun.javaws.ConfigProperties;
import com.sun.javaws.proxy.InternetProxyFactory;
import com.sun.javaws.proxy.InternetProxyInfo;
import com.sun.javaws.proxy.NSRegistry;
import java.io.File;
import java.util.List;

public abstract class InternetProxy {
    private static InternetProxy _internetProxy = null;

    public static synchronized InternetProxy getInstance() {
        if (_internetProxy == null) {
            _internetProxy = InternetProxyFactory.newInstance();
        }
        return _internetProxy;
    }

    private static String getNS6PrefsDirFromReg(File file) {
        NSRegistry nSRegistry = new NSRegistry().open(file);
        if (nSRegistry == null) {
            return null;
        }
        String string = nSRegistry.get("Common/Profiles/CurrentProfile");
        String string2 = null;
        if (nSRegistry != null) {
            string2 = nSRegistry.get("Common/Profiles/" + string + "/directory");
        }
        if (string2 == null) {
            string2 = nSRegistry.get("Common/Profiles/default/directory");
        }
        nSRegistry.close();
        return string2;
    }

    static File getNS6PrefsFile(File file) {
        String string = InternetProxy.getNS6PrefsDirFromReg(file);
        return string != null ? new File(string, "prefs.js") : null;
    }

    public InternetProxyInfo getDefaultInfo() {
        InternetProxyInfo internetProxyInfo = new InternetProxyInfo();
        ConfigProperties configProperties = ConfigProperties.getInstance();
        int n = configProperties.getProxyType();
        if (n == 1) {
            try {
                int n2 = Integer.parseInt(configProperties.getHTTPProxyPort());
                String string = configProperties.getHTTPProxy();
                List list = configProperties.getProxyOverrideList();
                if (string != null && string.length() > 0 && n2 != 0) {
                    internetProxyInfo.setHTTPPort(n2);
                    internetProxyInfo.setHTTPHost(string);
                    internetProxyInfo.setOverrides(list);
                    internetProxyInfo.setType(n);
                }
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (n == 2) {
            internetProxyInfo = this.getBrowserInfo();
        }
        return internetProxyInfo;
    }

    public InternetProxyInfo getBrowserInfo() {
        return new InternetProxyInfo();
    }

    File getNS6RegFile() {
        return null;
    }

    public String getNS6PrefsDir() {
        File file = this.getNS6RegFile();
        if (file != null) {
            return InternetProxy.getNS6PrefsDirFromReg(file);
        }
        return null;
    }
}

