/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.ui.player;

import com.sun.javaws.ConfigProperties;
import com.sun.javaws.LocalApplicationProperties;
import com.sun.javaws.Resources;
import com.sun.javaws.cache.InstallCache;
import com.sun.javaws.debug.Debug;
import com.sun.javaws.debug.Globals;
import com.sun.javaws.jnl.InformationDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.LaunchDescFactory;
import com.sun.javaws.ui.player.EntryManager;
import com.sun.javaws.ui.player.JNLEntry;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.SwingUtilities;

public class FavoriteEntryManager
extends EntryManager {
    private ArrayList _entries = new ArrayList();
    private RemoteLoader _loader;

    public void refresh() {
        JNLEntry jNLEntry = this.getSelectedEntry();
        URL uRL = jNLEntry != null ? jNLEntry.getCodebase() : null;
        this.setSelectedIndex(-1);
        this._entries.clear();
        Iterator iterator = ConfigProperties.getInstance().getFavorites();
        if (iterator != null) {
            while (iterator.hasNext()) {
                try {
                    URL uRL2 = new URL((String)iterator.next());
                    LaunchDesc launchDesc = InstallCache.getCache().getLaunchDesc(uRL2, null);
                    if (launchDesc != null) {
                        LocalApplicationProperties localApplicationProperties = InstallCache.getCache().getLocalApplicationProperties(uRL2, launchDesc);
                        InformationDesc informationDesc = launchDesc.getInformation();
                        if (informationDesc == null || localApplicationProperties == null || launchDesc.getLaunchType() != 1 && launchDesc.getLaunchType() != 2) continue;
                        this._entries.add(new JNLEntry(launchDesc, informationDesc, localApplicationProperties, uRL2, 0L));
                        continue;
                    }
                    if (this._loader == null) {
                        this._loader = new RemoteLoader();
                    }
                    this._loader.loadJNLEntry(uRL2);
                }
                catch (Exception exception) {}
            }
            Collections.sort(this._entries);
        }
        this.fireStateChanged();
        if (uRL != null) {
            this.selectEntryWithCodebase(uRL);
        }
        if (this.getSelectedIndex() == -1 && this.size() > 0) {
            this.setSelectedIndex(0);
        }
    }

    public JNLEntry get(int n) {
        return (JNLEntry)this._entries.get(n);
    }

    public int size() {
        return this._entries.size();
    }

    public boolean canAdd() {
        return true;
    }

    public void add(int n, JNLEntry jNLEntry) {
        if (!this._entries.contains(jNLEntry)) {
            this._entries.add(n, jNLEntry);
            Collections.sort(this._entries);
            this.save();
        }
    }

    public boolean canRemove() {
        return true;
    }

    public String getRemoveString() {
        return Resources.getString("player.FavoriteEntryManager.remove");
    }

    public void remove(int n) {
        this._entries.remove(n);
        super.remove(n);
        this.save();
    }

    public void remove(URL uRL) {
        if (uRL != null) {
            String string = uRL.toExternalForm();
            for (int i = this.size() - 1; i >= 0; --i) {
                JNLEntry jNLEntry = this.get(i);
                if (jNLEntry == null || jNLEntry.getCodebase() == null || !jNLEntry.getCodebase().toExternalForm().equals(string)) continue;
                this.remove(i);
                break;
            }
        }
    }

    public void save() {
        int n = this._entries.size();
        ArrayList<String> arrayList = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(this.get(i).getCodebase().toString());
        }
        ConfigProperties.getInstance().refreshIfNecessary();
        ConfigProperties.getInstance().setFavorites(arrayList.iterator());
    }

    void addEntry(final JNLEntry jNLEntry) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                FavoriteEntryManager.this._entries.add(jNLEntry);
                JNLEntry jNLEntry2 = FavoriteEntryManager.this.getSelectedEntry();
                Collections.sort(FavoriteEntryManager.this._entries);
                FavoriteEntryManager.this.fireStateChanged();
                if (jNLEntry2 != null) {
                    FavoriteEntryManager.this.setSelectedIndex(FavoriteEntryManager.this._entries.indexOf(jNLEntry2));
                } else if (FavoriteEntryManager.this.getSelectedIndex() == -1 && FavoriteEntryManager.this.size() > 0) {
                    FavoriteEntryManager.this.setSelectedIndex(0);
                }
            }
        });
    }

    private class RemoteLoader
    implements Runnable {
        private boolean _running;
        private ArrayList _toLoad = new ArrayList();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void loadJNLEntry(URL uRL) {
            boolean bl = false;
            RemoteLoader remoteLoader = this;
            synchronized (remoteLoader) {
                this._toLoad.add(uRL);
                if (!this._running) {
                    this._running = true;
                    bl = true;
                }
            }
            if (bl) {
                new Thread(this).start();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            boolean bl = false;
            while (!bl) {
                URL uRL = null;
                RemoteLoader remoteLoader = this;
                synchronized (remoteLoader) {
                    if (this._toLoad.size() > 0) {
                        uRL = (URL)this._toLoad.remove(0);
                    } else {
                        bl = true;
                        this._running = false;
                    }
                }
                if (bl) continue;
                this.handleLoadJNLEntry(uRL);
            }
        }

        private void handleLoadJNLEntry(URL uRL) {
            block4: {
                try {
                    LaunchDesc launchDesc = LaunchDescFactory.buildDescriptor(uRL);
                    if (launchDesc != null && launchDesc.getCanonicalHome() != null && (launchDesc.getLaunchType() == 1 || launchDesc.getLaunchType() == 2)) {
                        InformationDesc informationDesc = launchDesc.getInformation();
                        LocalApplicationProperties localApplicationProperties = InstallCache.getCache().getLocalApplicationProperties(launchDesc.getCanonicalHome(), launchDesc);
                        if (informationDesc != null && localApplicationProperties != null) {
                            JNLEntry jNLEntry = new JNLEntry(launchDesc, informationDesc, localApplicationProperties, null, 0L, false, uRL);
                            FavoriteEntryManager.this.addEntry(jNLEntry);
                        }
                    }
                }
                catch (Exception exception) {
                    if (!Globals.TraceHTMLEntryParsing) break block4;
                    Debug.println("Error loading JNL file from " + uRL + " error " + exception);
                    exception.printStackTrace();
                }
            }
        }
    }
}

