/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.ui.prefs;

import com.sun.javaws.ConfigProperties;
import com.sun.javaws.Resources;
import com.sun.javaws.ui.prefs.GeneralPanel;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;

public class UnixGeneralPanel
extends GeneralPanel {
    private JCheckBox _netscapeBrowserCB;
    private JTextField _browserCommandTF;

    protected void createPropertyControls() {
        this.setLayout(new GridBagLayout());
        this.addGridBagComponent(this, Box.createVerticalGlue(), 0, 0, 1, 1, 1.0, 0.33, 10, 1, null, 0, 0);
        this.addGridBagComponent(this, this.createProxyPanel(), 0, 1, 1, 1, 1.0, 0.0, 10, 2, null, 0, 0);
        this.addGridBagComponent(this, Box.createVerticalGlue(), 0, 2, 1, 1, 1.0, 0.33, 10, 1, null, 0, 0);
        this.addGridBagComponent(this, this.createBrowserPanel(), 0, 3, 1, 1, 1.0, 0.0, 10, 2, null, 0, 0);
        this.addGridBagComponent(this, Box.createVerticalGlue(), 0, 4, 1, 1, 1.0, 0.33, 10, 1, null, 0, 0);
        this.revert();
    }

    private Component createBrowserPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        Insets insets = new Insets(0, 2, 5, 8);
        JLabel jLabel = new JLabel(Resources.getString("controlpanel.general.browserCommand"));
        jLabel.setDisplayedMnemonic(Resources.getVKCode("controlpanel.general.browserCommandMnemonic"));
        this.addGridBagComponent(jPanel, jLabel, 0, 0, 1, 1, 0.0, 0.0, 10, 0, insets, 0, 0);
        insets.right = 2;
        this._browserCommandTF = new JTextField();
        jLabel.setLabelFor(this._browserCommandTF);
        this.addGridBagComponent(jPanel, this._browserCommandTF, 1, 0, 1, 1, 1.0, 0.0, 10, 2, insets, 0, 0);
        this._netscapeBrowserCB = new JCheckBox(Resources.getString("controlpanel.general.isNetscapeBrowser"));
        this._netscapeBrowserCB.setRequestFocusEnabled(false);
        this._netscapeBrowserCB.setMnemonic(Resources.getVKCode("controlpanel.general.isNetscapeMnemonic"));
        this.addGridBagComponent(jPanel, this._netscapeBrowserCB, 0, 2, 2, 1, 0.0, 0.0, 10, 0, insets, 0, 0);
        jPanel.setBorder(new TitledBorder(LineBorder.createBlackLineBorder(), Resources.getString("controlpanel.general.browserTitle"), 1, 2));
        return jPanel;
    }

    public void apply() {
        if (this._netscapeBrowserCB != null) {
            ConfigProperties configProperties = ConfigProperties.getInstance();
            boolean bl = this._netscapeBrowserCB.isSelected();
            configProperties.put("deployment.javaws.netscapeBrowser", String.valueOf(bl));
            configProperties.put("deployment.javaws.browserPath", this._browserCommandTF.getText());
        }
        super.apply();
    }

    public void revert() {
        ConfigProperties configProperties = this.getConfigProperties();
        String string = configProperties.get("deployment.javaws.netscapeBrowser");
        if (this._netscapeBrowserCB != null && this._browserCommandTF != null) {
            this._netscapeBrowserCB.setSelected(string != null ? Boolean.valueOf(string) : true);
            this._browserCommandTF.setText(configProperties.get("deployment.javaws.browserPath"));
        }
        super.revert();
    }
}

