/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pkcs11;

import com.ibm.pkcs11.PKCS11;

public class PKCS11SlotInfo {
    public static final int TOKEN_PRESENT = 1;
    public static final int REMOVABLE_DEVICE = 2;
    public static final int HW_SLOT = 4;
    static int[] flagList = new int[]{1, 2, 4};
    static String[] flagNames = new String[]{PKCS11SlotInfo.a("/d[aj${Baw>eD"), PKCS11SlotInfo.a(")n]kr:i\\a{?nFmg>"), PKCS11SlotInfo.a("3|Owh4\u007f")};
    private String description;
    private String manufacturer;
    private int flags;
    private int hardwareVersion;
    private int firmwareVersion;

    public PKCS11SlotInfo(String string, String string2, int n2, int n3, int n4) {
        this.description = string;
        this.manufacturer = string2;
        this.flags = n2;
        this.hardwareVersion = n3;
        this.firmwareVersion = n4;
    }

    public String description() {
        return this.description;
    }

    public String manufacturer() {
        return this.manufacturer;
    }

    public int flags() {
        return this.flags;
    }

    public int hardwareVersion() {
        return this.hardwareVersion;
    }

    public int firmwareVersion() {
        return this.firmwareVersion;
    }

    public boolean tokenPresent() {
        return (this.flags & 1) != 0;
    }

    public boolean removableDevice() {
        return (this.flags & 2) != 0;
    }

    public boolean hardwareSlot() {
        return (this.flags & 4) != 0;
    }

    public String toString() {
        return PKCS11SlotInfo.a("+`Sw\u0015Jx|KP2EvK\u001eq\u000b0\u0004\u0004?NcGV\u0012[dMK\u0015\u00110\u0004\u0004[\u000b0\u0004") + this.description + PKCS11SlotInfo.a("q\u000b0\u0004\u00046J~QB\u001aHdQV\u001eY*\u0004\u0004[\u000b0\u0004") + this.manufacturer + PKCS11SlotInfo.a("q\u000b0\u0004\u0004=GqCWA\u000b0\u0004\u0004[\u000b0\u0004\u0004[\u000b0\u0004") + this.flagsToString(PKCS11SlotInfo.a("[W0")) + PKCS11SlotInfo.a("q\u000b0\u0004\u00043Jb@S\u001aYu\u0004R\u001eYcMK\u0015\u00110\u0004") + PKCS11.versionString(this.hardwareVersion) + PKCS11SlotInfo.a("q\u000b0\u0004\u0004=BbIS\u001aYu\u0004R\u001eYcMK\u0015\u00110\u0004") + PKCS11.versionString(this.firmwareVersion);
    }

    public String flagsToString(String string) {
        return PKCS11.flagsToString(this.flags, flagList, flagNames, string);
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    private static String a(String string) {
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        int n3 = 0;
        boolean bl2 = true;
        block6: do {
            if (bl2 && !(bl2 = false) && n2 > 1) continue;
            char[] cArray2 = cArray;
            int n4 = n3;
            while (true) {
                int n5;
                char c2 = cArray2[n4];
                switch (n3 % 5) {
                    case 0: {
                        n5 = 123;
                        break;
                    }
                    case 1: {
                        n5 = 43;
                        break;
                    }
                    case 2: {
                        n5 = 16;
                        break;
                    }
                    case 3: {
                        n5 = 36;
                        break;
                    }
                    default: {
                        n5 = 36;
                    }
                }
                cArray2[n4] = (char)(c2 ^ n5);
                ++n3;
                if (n2 != 0) continue block6;
                cArray2 = cArray;
                n4 = n2;
            }
        } while (n3 < n2);
        return new String(cArray);
    }
}

