/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.extract;

import com.ibm.jvm.dump.extract.AIXProcess;
import com.ibm.jvm.dump.extract.AIXThread;
import com.ibm.jvm.dump.extract.ExProcess;
import com.ibm.jvm.dump.extract.ExThread;
import com.ibm.jvm.dump.extract.Extract;
import com.ibm.jvm.dump.extract.HPIModule;
import com.ibm.jvm.dump.format.DvJavaFrame;
import com.ibm.jvm.dump.format.DvNativeFrame;
import com.ibm.jvm.dump.format.DvUtils;
import com.ibm.jvm.dump.frame.FrameTraverser;
import com.ibm.jvm.dump.frame.JavaFrame;
import com.ibm.jvm.dump.frame.LoadMap;
import com.ibm.jvm.dump.frame.NativeFrame;
import com.ibm.jvm.dump.frame.ThreadContext;
import com.ibm.jvm.dump.sdff.DvFileReader;
import com.ibm.jvm.dump.sdff.Segment;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;

class AIXHPIModule
extends HPIModule {
    long stackBaseOffset;
    long stackSizeOffset;
    LoadMap[] maps;

    AIXHPIModule() {
    }

    AIXHPIModule(Segment segment, long l, LoadMap[] loadMapArray) {
        super(segment, l);
        this.maps = loadMapArray;
    }

    boolean populate() throws IOException {
        DvUtils.trace("populate HPIModule", 0, false);
        ((DvFileReader)this.reader).setPos(this.fileOffset);
        this.threadQueue = ((DvFileReader)this.reader).readAddress();
        this.threadNext = ((DvFileReader)this.reader).readAddress();
        this.execEnvOffset = ((DvFileReader)this.reader).readAddressOffset();
        this.pidOffset = -1L;
        this.tidOffset = -1L;
        this.pfmData = -1L;
        this.stackBaseOffset = ((DvFileReader)this.reader).readAddressOffset();
        this.stackSizeOffset = ((DvFileReader)this.reader).readAddressOffset();
        this.spOffset = ((DvFileReader)this.reader).readAddressOffset();
        DvUtils.trace("threadQueue=" + Long.toHexString(this.threadQueue), 2, false);
        DvUtils.trace("threadNext=" + Long.toHexString(this.threadNext), 2, false);
        DvUtils.trace("execEnvOffset=" + Long.toHexString(this.execEnvOffset), 2, false);
        DvUtils.trace("stackBaseOffset=" + Long.toHexString(this.stackBaseOffset), 2, false);
        DvUtils.trace("stackSizeOffset=" + Long.toHexString(this.stackSizeOffset), 2, false);
        DvUtils.trace("spOffset=" + Long.toHexString(this.spOffset), 2, false);
        DvUtils.trace("tidOffset=" + Long.toHexString(this.tidOffset), 2, false);
        DvUtils.trace("pfmData=" + Long.toHexString(this.pfmData), 2, false);
        return true;
    }

    boolean populateThread(ExProcess exProcess, HashMap hashMap) throws IOException {
        AIXProcess aIXProcess = (AIXProcess)exProcess;
        DvUtils.trace("populateThread: process=" + exProcess + " reader=" + this.reader, 0, false);
        ((DvFileReader)this.reader).setAddress(this.threadQueue);
        long l = ((DvFileReader)this.reader).readAddress();
        DvUtils.trace("Thread: " + Long.toHexString(l), 2, false);
        HPIModule.ExReader exReader = new HPIModule.ExReader((DvFileReader)this.reader);
        FrameTraverser frameTraverser = new FrameTraverser(exReader, exProcess.jvmData.jvmRas, this.maps, Extract.getExeName(), null);
        while (l != 0L) {
            long l2 = l + this.execEnvOffset;
            DvUtils.trace("thread=" + l + " execEnvOffset=" + this.execEnvOffset + " execEnv=" + l2, 1, false);
            DvUtils.trace("execEnv : " + Long.toHexString(l2), 2, false);
            ((DvFileReader)this.reader).setAddress(l + this.stackBaseOffset);
            long l3 = ((DvFileReader)this.reader).readAddress();
            ((DvFileReader)this.reader).setAddress(l + this.stackSizeOffset);
            long l4 = ((DvFileReader)this.reader).readAddress();
            DvUtils.trace("stackbase address: " + Long.toHexString(l) + " value = " + Long.toHexString(l3), 2, false);
            DvUtils.trace("Thread: " + Long.toHexString(l), 2, false);
            AIXThread aIXThread = aIXProcess.getNativeThread(l3, l4 += 1000L);
            if (aIXThread == null) {
                DvUtils.trace("No native thread found", 2, false);
                aIXThread = new AIXThread();
                aIXThread.context.setEE(l2);
                exProcess.thread.add(aIXThread);
            }
            aIXThread.attach(l2);
            ((DvFileReader)this.reader).setAddress(l + this.threadNext);
            l = ((DvFileReader)this.reader).readAddress();
            DvUtils.trace("Thread: " + Long.toHexString(l), 2, false);
        }
        Enumeration enumeration = exProcess.thread.elements();
        while (enumeration.hasMoreElements()) {
            NativeFrame[] nativeFrameArray;
            ExThread exThread = (ExThread)enumeration.nextElement();
            ThreadContext threadContext = exThread.getFrameContext();
            DvUtils.trace("Getting stacks for thread0x" + Long.toHexString(exThread.tid), 2, false);
            threadContext.dump();
            JavaFrame[] javaFrameArray = frameTraverser.getJavaFrames(threadContext);
            if (javaFrameArray != null) {
                DvUtils.trace("Got " + javaFrameArray.length + " java frames", 2, false);
                exThread.javaFrames = new DvJavaFrame[javaFrameArray.length];
                for (int i = 0; i < javaFrameArray.length; ++i) {
                    exThread.javaFrames[i] = new DvJavaFrame(javaFrameArray[i]);
                }
            } else {
                DvUtils.trace("No java frames", 2, false);
                exThread.javaFrames = null;
            }
            if ((nativeFrameArray = frameTraverser.getNativeFrames(threadContext)) != null) {
                DvUtils.trace("Got " + nativeFrameArray.length + " native frames", 2, false);
                exThread.nativeFrames = new DvNativeFrame[nativeFrameArray.length];
                for (int i = 0; i < nativeFrameArray.length; ++i) {
                    exThread.nativeFrames[i] = new DvNativeFrame(nativeFrameArray[i]);
                }
                continue;
            }
            DvUtils.trace("No native frames", 2, false);
            exThread.nativeFrames = null;
        }
        return true;
    }
}

