/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.extract;

import com.ibm.jvm.dump.extract.ExEnvData;
import com.ibm.jvm.dump.extract.ExLoaded;
import com.ibm.jvm.dump.extract.ExThread;
import com.ibm.jvm.dump.extract.HPIModule;
import com.ibm.jvm.dump.extract.JVMModule;
import com.ibm.jvm.dump.extract.MemoryMap;
import com.ibm.jvm.dump.format.DvModule;
import com.ibm.jvm.dump.format.DvUtils;
import com.ibm.jvm.dump.sdff.Sdff;
import com.ibm.jvm.dump.sdff.Segment;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;

class ExProcess {
    static final String[] sigName = new String[]{"        ", "SIGHUP  ", "SIGINT  ", "SIGQUIT ", "SIGILL  ", "SIGTRAP ", "SIGABRT ", "SIGBUS  ", "SIGFPE  ", "SIGKILL ", "SIGUSR1 ", "SIGSEGV ", "SIGUSR2 ", "SIGPIPE ", "SIGALRM ", "SIGTERM ", "SIGSTKFL", "SIGCHLD ", "SIGCONT ", "SIGSTOP ", "SIGTSTP ", "SIGTTIN ", "SIGTTOU ", "SIGURG  ", "SIGXCPU ", "SIGXFSZ ", "SIGVTALR", "SIGPROF ", "SIGWINCH", "SIGIO   ", "SIGPWR  ", "SIGSYS  "};
    Vector thread = new Vector();
    HashMap threadIndex = new HashMap();
    Vector module = new Vector();
    HPIModule hpiData;
    JVMModule jvmData;
    DvModule hpiText;
    long signalNumber = 0L;
    long pid = 0L;
    String commandLine;
    String command;
    String executable;
    ExEnvData environment;
    ExLoaded loaded;
    MemoryMap map;

    ExProcess() {
    }

    void generateExecutable(String string, String string2) {
        DvUtils.trace("commandLine=<" + string2 + ">", 3, false);
        this.command = string;
        this.commandLine = string2;
        StringTokenizer stringTokenizer = new StringTokenizer(string2, " ");
        if (stringTokenizer.hasMoreTokens()) {
            this.executable = stringTokenizer.nextToken();
        }
    }

    ExProcess(ExEnvData exEnvData, ExLoaded exLoaded, ExThread[] exThreadArray) {
    }

    void setMemoryMap(MemoryMap memoryMap) {
        this.map = memoryMap;
    }

    void addThreadIndex(ExThread exThread) {
        try {
            Segment segment = this.map.getSegmentContaining(exThread.context.getSp());
            DvUtils.trace("Index segment " + segment + " for address " + exThread.context.getSp(), 2, false);
            this.threadIndex.put(segment, exThread);
        }
        catch (RuntimeException runtimeException) {
            System.err.println("JVMRAS029: Unable to match stack pointer 0x" + Long.toHexString(exThread.context.getSp()) + " to a data segment - continuing the extract process.");
        }
    }

    ExThread getNativeThread(long l) {
        DvUtils.trace("getNativeThread " + l, 2, false);
        Segment segment = this.map.getSegmentContaining(l);
        ExThread exThread = (ExThread)this.threadIndex.get(segment);
        DvUtils.trace("segment " + segment + " found - native thread " + exThread, 2, false);
        return exThread;
    }

    boolean populate(HashMap hashMap) throws IOException {
        return this.hpiData.populateThread(this, hashMap);
    }

    void printSdff(Sdff sdff, MemoryMap memoryMap) throws IOException {
        DvUtils.trace("Printing Process", 2, false);
        long l = sdff.getFilePointer();
        sdff.writeLong(0L);
        sdff.writeBytes("PROCESS ");
        sdff.writeLong(this.pid);
        sdff.writeLong(this.thread.size());
        sdff.writeLong(-1L);
        sdff.writeLong(this.signalNumber);
        DvUtils.trace("Signal " + this.signalNumber, 2, false);
        sdff.writeBytes(sigName[(int)this.signalNumber]);
        long l2 = sdff.getFilePointer();
        this.loaded.printSdff(sdff);
        sdff.printLength(l2);
        Enumeration enumeration = this.thread.elements();
        while (enumeration.hasMoreElements()) {
            ExThread exThread = (ExThread)enumeration.nextElement();
            exThread.printSdff(sdff);
        }
        sdff.writeLong(-1L);
        sdff.printLength(l);
    }
}

