/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.plugins;

import com.ibm.jvm.dump.format.ClassDetails;
import com.ibm.jvm.dump.format.DvAddress;
import com.ibm.jvm.dump.format.DvAddressException;
import com.ibm.jvm.dump.format.DvAddressSpace;
import com.ibm.jvm.dump.format.DvConsole;
import com.ibm.jvm.dump.format.DvDump;
import com.ibm.jvm.dump.format.DvUtils;
import com.ibm.jvm.dump.plugins.CommandPlugin;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class DvClassCommands
extends CommandPlugin {
    private static String thisName = "com.ibm.jvm.dump.plugins.DvClassCommands";
    private static CommandPlugin getInstanceValuesCp;
    private static Method getInstanceValuesMethod;
    private static CommandPlugin showClassCp;
    private static Method showClassMethod;
    private static CommandPlugin showStaticsCp;
    private static Method showStaticsMethod;
    private static CommandPlugin showFieldsCp;
    private static Method showFieldsMethod;
    private static CommandPlugin showMethodsCp;
    private static Method showMethodsMethod;
    private static String prevVerb;
    private static String prevModifier;
    private static String prevParms;
    private static String prevSeperator;
    private static Vector theClasses;
    public static Hashtable classHashByAddr;
    public static Hashtable classHashByName;
    public static Hashtable fieldsHashByName;
    private static Vector theFields;
    private boolean bWildCards = false;
    private static final String badString = "Unable to get Instance Values";
    private boolean bSummary;
    private static String[] commandsSupported;
    public static DvClassCommands that;

    public DvClassCommands() {
        that = this;
    }

    public String pluginName() {
        return "Class commands (DvClassCommands)";
    }

    public String[] getSyntax() {
        return commandsSupported;
    }

    public static Object getGenericHelp() {
        Vector vector = DvUtils.getMultiplePropertyValues("GeneralHelp", "DvClassCommands.properties");
        return vector;
    }

    public void doClassHelp() {
        Vector vector = DvUtils.getMultiplePropertyValues("CLSHelp", "DvClassCommands.properties");
        this.cpr.output(vector);
        this.forcedEnd = true;
    }

    public String help() {
        return null;
    }

    public String help(String string) {
        return null;
    }

    public String[] guiPopupSyntax() {
        return null;
    }

    public void displayHelp() {
        String string = null == this.verbModifier ? "GeneralHelp" : this.verbModifier;
        this.cpr.output(DvUtils.getMultiplePropertyValues(string, "DvBaseCommands.properties"));
        this.forcedEnd = true;
    }

    public void displayCS() {
        DvUtils.writetoTrace("DvClassCommands:displayCS entry");
        this.bSummary = true;
        Vector<String> vector = new Vector<String>();
        vector.add("\n Classes Summary\n ===============\n");
        this.getClasses(vector);
        this.displayClasses(vector);
        this.bSummary = false;
        this.cpr.output(vector);
        this.forcedEnd = true;
        DvUtils.writetoTrace("DvClassCommands:displayCS exit");
    }

    public void displayClasses() {
        Vector vector = new Vector();
        this.displayClasses(vector);
        this.cpr.output(vector);
        this.forcedEnd = true;
    }

    public void displayClasses(Vector vector) {
        DvUtils.writetoTrace("DvClassCommands:displayClasses(Vector) entry");
        Vector vector2 = new Vector();
        DvDump dvDump = DvConsole.theDump;
        if (this.paramString != null) {
            vector2 = this.setupFiltersVector(this.paramString);
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (null == this.paramString) {
            this.bSummary = true;
        }
        if (null != this.enhancers) {
            String[] stringArray = new String[]{"me", "st", "fld", "nof"};
            if (this.enhancersCheck(stringArray)) {
                bl = this.enhancerIsPresent("me");
                bl2 = this.enhancerIsPresent("st");
                bl3 = this.enhancerIsPresent("fld");
                bl4 = this.enhancerIsPresent("nof");
            } else {
                vector.add("Invalid enhancer detected: " + this.enhancersCheck(stringArray));
            }
        }
        this.getClasses(vector);
        if (vector2.size() > 0 && !this.bWildCards) {
            for (int i = 0; i < vector2.size(); ++i) {
                String string = (String)vector2.get(i);
                Integer n = (Integer)classHashByName.get(string.toUpperCase());
                if (null == n) continue;
                ClassDetails classDetails = (ClassDetails)theClasses.get(n);
                if (!bl4) {
                    DvClassCommands.showClass(classDetails, vector, this.bSummary, dvDump);
                }
                if (bl) {
                    DvClassCommands.showMethods(classDetails, vector, this.bSummary);
                }
                if (bl2) {
                    DvClassCommands.showStatics(classDetails, vector, this.bSummary);
                }
                if (!bl3) continue;
                DvClassCommands.showFields(classDetails, vector, this.bSummary, dvDump);
            }
        } else {
            for (int i = 0; i < theClasses.size(); ++i) {
                ClassDetails classDetails = (ClassDetails)theClasses.get(i);
                boolean bl5 = true;
                if (0 != vector2.size()) {
                    bl5 = DvUtils.filtrate(classDetails.name, vector2);
                }
                if (!bl5) continue;
                if (!bl4) {
                    DvClassCommands.showClass(classDetails, vector, this.bSummary, dvDump);
                }
                if (bl) {
                    DvClassCommands.showMethods(classDetails, vector, this.bSummary);
                }
                if (bl2) {
                    DvClassCommands.showStatics(classDetails, vector, this.bSummary);
                }
                if (!bl3) continue;
                DvClassCommands.showFields(classDetails, vector, this.bSummary, dvDump);
            }
        }
        DvUtils.writetoTrace("DvClassCommands:displayClasses(Vector) exit");
    }

    public static String getClassName(long l) {
        String string = null;
        Integer n = (Integer)classHashByAddr.get(new Long(l));
        if (n != null) {
            ClassDetails classDetails = (ClassDetails)theClasses.get(n);
            string = new String(classDetails.name);
        }
        return string;
    }

    private void doMethodHelp(Vector vector) {
        Vector vector2 = DvUtils.getMultiplePropertyValues("MethodHelp", "DvClassCommands.properties");
        if (vector2.size() != 0) {
            for (int i = 0; i < vector2.size(); ++i) {
                vector.add(vector2.elementAt(i));
            }
        }
    }

    public static String fieldValue(long l, String string, DvAddressSpace dvAddressSpace, boolean bl) {
        String string2 = "!!! unable to read value from memory at " + Long.toHexString(l);
        String string3 = " instance offset is " + l + " (0x" + Long.toHexString(l) + ")";
        boolean bl2 = false;
        String string4 = " !!!! Field Value could not be established";
        boolean bl3 = false;
        boolean bl4 = false;
        char c = string.charAt(0);
        switch (c) {
            case 'I': {
                if (bl) {
                    string4 = " integer:" + string3;
                    break;
                }
                try {
                    int n = dvAddressSpace.readInt(dvAddressSpace.createAddress(l));
                    string4 = " integer: " + n + " (0x" + Integer.toHexString(n) + ")";
                }
                catch (DvAddressException dvAddressException) {
                    string4 = " integer: " + string2;
                }
                break;
            }
            case 'J': {
                if (bl) {
                    string4 = " long:" + string3;
                    break;
                }
                try {
                    long l2 = dvAddressSpace.readLong(dvAddressSpace.createAddress(l));
                    string4 = " long: " + l2 + " (0x" + Long.toHexString(l2) + ")";
                }
                catch (DvAddressException dvAddressException) {
                    string4 = " long: " + string2;
                }
                break;
            }
            case 'C': {
                if (bl) {
                    string4 = " char:" + string3;
                    break;
                }
                try {
                    int n = dvAddressSpace.readInt(dvAddressSpace.createAddress(l));
                    Character c2 = new Character((char)n);
                    string4 = " char: " + c2 + " (0x" + Long.toHexString(n) + ")";
                }
                catch (DvAddressException dvAddressException) {
                    string4 = " char: " + string2;
                }
                break;
            }
            case '[': {
                int n = DvConsole.theDump.getArchitecture();
                boolean bl5 = DvUtils.is64BitSystem(n);
                char c3 = string.charAt(1);
                String string5 = "";
                switch (c3) {
                    case 'I': {
                        string5 = "integer";
                        break;
                    }
                    case 'J': {
                        string5 = "long";
                        break;
                    }
                    case 'L': {
                        string5 = string.substring(2);
                        break;
                    }
                    case 'C': {
                        string5 = "char";
                        break;
                    }
                    case 'B': {
                        string5 = "byte";
                        break;
                    }
                    case 'E': {
                        string5 = "enum";
                        break;
                    }
                    case 'F': {
                        string5 = "float";
                        break;
                    }
                    case 'D': {
                        string5 = "double";
                        break;
                    }
                    case 'S': {
                        string5 = "short";
                        break;
                    }
                    case 'V': {
                        string5 = "void";
                        break;
                    }
                    case 'Z': {
                        string5 = "boolean";
                        break;
                    }
                    case 'A': {
                        string5 = "any";
                        break;
                    }
                    case '[': {
                        string5 = "array";
                        break;
                    }
                    default: {
                        string5 = " !!! Not known (" + c3 + ")";
                    }
                }
                if (bl) {
                    string4 = " array of " + string5 + " :" + string3;
                    break;
                }
                try {
                    DvAddress dvAddress = dvAddressSpace.readPointer(dvAddressSpace.createAddress(l));
                    string4 = " Array of " + string5 + " @ 0x" + Long.toHexString(dvAddress.getAddressAsLong());
                    if (string5.equals("char")) {
                        string4 = string4 + "\n\t<<" + DvClassCommands.interpretValue(string, l, dvAddressSpace, false) + ">>";
                        break;
                    }
                    string4 = string4 + "\t" + DvClassCommands.interpretValue(string, l, dvAddressSpace, false);
                }
                catch (DvAddressException dvAddressException) {
                    string4 = " Array of " + string5 + " @ !!! unable to read memory from " + Long.toHexString(l);
                }
                break;
            }
            case 'L': {
                if (bl) {
                    string4 = " class:" + string3;
                    break;
                }
                string4 = " instance of " + string + " @ 0x";
                try {
                    DvAddress dvAddress = dvAddressSpace.readPointer(dvAddressSpace.createAddress(l));
                    string4 = null == dvAddress ? string4 + string2 : string4 + Long.toHexString(dvAddress.getAddressAsLong());
                    if (!string.equals("Ljava/lang/String;") || null == dvAddress) break;
                    try {
                        long l3 = dvAddress.getAddressAsLong();
                        if (l3 != 0L) {
                            long l4 = DvUtils.getFieldAddress(l3, new String[]{"Hjava_lang_Object", "obj"}, dvAddressSpace);
                            string4 = string4 + "\n\t\t  <<" + DvClassCommands.interpretValue("[C", l4, dvAddressSpace, false) + ">>";
                            break;
                        }
                        string4 = string4 + "\n\t\t  Null String <<>>";
                    }
                    catch (DvAddressException dvAddressException) {
                        string4 = string4 + "\n\t\t  Unable to evaluate String value";
                    }
                }
                catch (DvAddressException dvAddressException) {
                    string4 = string4 + " !!! unable to read memory from " + Long.toHexString(l);
                }
                break;
            }
            case 'F': {
                if (bl) {
                    string4 = " float:" + string3;
                    break;
                }
                try {
                    float f = dvAddressSpace.readLong(dvAddressSpace.createAddress(l));
                    string4 = " float: " + f + " (0x" + Long.toHexString((long)f) + ")";
                }
                catch (DvAddressException dvAddressException) {
                    string4 = " float: " + string2;
                }
                break;
            }
            case 'D': {
                if (bl) {
                    string4 = " double:" + string3;
                    break;
                }
                try {
                    double d = dvAddressSpace.readLong(dvAddressSpace.createAddress(l));
                    string4 = " double: " + d + " (0x" + Long.toHexString((long)d) + ")";
                }
                catch (DvAddressException dvAddressException) {
                    string4 = " double: " + string2;
                }
                break;
            }
            case 'Z': {
                if (bl) {
                    string4 = " boolean:" + string3;
                    break;
                }
                try {
                    int n = dvAddressSpace.readInt(dvAddressSpace.createAddress(l));
                    if (0 == n) {
                        string4 = " boolean: false (0x" + Integer.toHexString(n) + ")";
                        break;
                    }
                    string4 = " boolean: true (0x" + Integer.toHexString(n) + ")";
                }
                catch (DvAddressException dvAddressException) {
                    string4 = " boolean: " + string2;
                }
                break;
            }
            case 'B': {
                if (bl) {
                    string4 = " byte:" + string3;
                    break;
                }
                try {
                    int n = dvAddressSpace.readInt(dvAddressSpace.createAddress(l));
                    string4 = " byte: 0x" + Integer.toHexString(n);
                }
                catch (DvAddressException dvAddressException) {
                    string4 = " byte: " + string2;
                }
                break;
            }
            case 'S': {
                if (bl) {
                    string4 = " short:" + string3;
                    break;
                }
                try {
                    int n = dvAddressSpace.readInt(dvAddressSpace.createAddress(l));
                    short s = (short)n;
                    String string6 = Integer.toHexString(s);
                    if (string6.length() > 4) {
                        string6 = string6.substring(4);
                    }
                    string4 = " short: " + s + " (0x" + string6 + ")";
                }
                catch (DvAddressException dvAddressException) {
                    string4 = " short: " + string2;
                }
                break;
            }
            default: {
                string4 = string4 + "( signature: " + string + ")";
            }
        }
        return string4;
    }

    public void reset() {
        prevVerb = null;
        prevModifier = null;
        prevParms = null;
        prevSeperator = null;
        theClasses.clear();
        classHashByAddr.clear();
        classHashByName.clear();
        fieldsHashByName.clear();
    }

    protected static DvClassCommands getCurrentInstance() {
        DvUtils.writetoTrace("Entry/Exit:DvClassCommands.getCurrentInstance()");
        return that;
    }

    public static String interpretValue(String string, long l, DvAddressSpace dvAddressSpace, boolean bl) {
        String string2 = null;
        boolean bl2 = false;
        if (string.startsWith("[")) {
            char c = string.charAt(1);
            bl2 = true;
            String string3 = null;
            int n = 0;
            DvAddress dvAddress = null;
            int n2 = DvConsole.theDump.getArchitecture();
            boolean bl3 = DvUtils.is64BitSystem(n2);
            try {
                dvAddress = false == bl ? dvAddressSpace.readPointer(dvAddressSpace.createAddress(l)) : dvAddressSpace.createAddress(l);
                if (null != dvAddress && 0L != dvAddress.getAddressAsLong()) {
                    n = bl3 ? (int)dvAddressSpace.readLong(dvAddress) : dvAddressSpace.readInt(dvAddress);
                } else if (0L != dvAddress.getAddressAsLong()) {
                    return " !!! Unavailable memory " + Long.toHexString(l);
                }
            }
            catch (DvAddressException dvAddressException) {
                DvUtils.trace(" !!! " + Long.toHexString(l), 0, true);
            }
            try {
                switch (c) {
                    case 'C': {
                        int n3 = n;
                        if (n > 91) {
                            n3 = 80;
                        }
                        if (n > 0) {
                            char[] cArray = new char[n3];
                            if (bl3) {
                                dvAddress.offsetBy(16L);
                            } else {
                                dvAddress.offsetBy(8L);
                            }
                            for (int i = 0; i < n3; ++i) {
                                cArray[i] = (char)dvAddressSpace.readShort(dvAddress);
                                dvAddress.offsetBy(2L);
                            }
                            string3 = new String(cArray);
                            if (n > 91) {
                                string3 = string3 + " (" + (n - 80) + " bytes not displayed.)";
                            }
                        } else {
                            string3 = "... Null String (length 0) ...";
                        }
                        return string3;
                    }
                    case 'B': {
                        if (n > 0) {
                            string3 = "  Array Size:" + n + " \n\t{";
                            dvAddress.offsetBy(8L);
                            int n4 = 10;
                            for (int i = 0; i < n && i < 10; ++i) {
                                int n5 = dvAddressSpace.readByte(dvAddress);
                                int n6 = n5;
                                if (n6 < 0) {
                                    n6 += 256;
                                }
                                string3 = string3 + DvUtils.byteToHex.substring(2 * n6, 2 * n6 + 2);
                                dvAddress.offsetBy(1L);
                                if (n4 - 1 == i || i == n - 1) continue;
                                string3 = string3 + ",";
                            }
                            string3 = n <= n4 ? string3 + "}" : string3 + ", ........";
                            if (n > n4) {
                                string3 = string3 + "\n\t" + (n - n4) + " values not shown";
                            }
                            return string3;
                        }
                        string3 = "... Null Array (length 0) ...";
                        return string3;
                    }
                    case 'D': 
                    case 'F': 
                    case 'I': 
                    case 'J': 
                    case 'S': {
                        if (n > 0) {
                            string3 = "  Array Size:" + n + " \n\t{";
                            dvAddress.offsetBy(8L);
                            int n7 = 10;
                            for (int i = 0; i < n && i < 10; ++i) {
                                if ('I' == c) {
                                    string3 = string3 + dvAddressSpace.readInt(dvAddress);
                                    dvAddress.offsetBy(4L);
                                }
                                if ('J' == c || 'D' == c || 'F' == c) {
                                    if ('J' == c) {
                                        string3 = string3 + dvAddressSpace.readLong(dvAddress);
                                    }
                                    if ('D' == c) {
                                        n7 = 4;
                                        string3 = string3 + (double)dvAddressSpace.readLong(dvAddress);
                                    }
                                    if ('F' == c) {
                                        n7 = 4;
                                        string3 = string3 + (float)dvAddressSpace.readLong(dvAddress);
                                    }
                                    dvAddress.offsetBy(8L);
                                }
                                if ('S' == c) {
                                    string3 = string3 + dvAddressSpace.readShort(dvAddress);
                                    dvAddress.offsetBy(2L);
                                }
                                if (n7 - 1 == i || i == n - 1) continue;
                                string3 = string3 + ",";
                            }
                            string3 = n <= n7 ? string3 + "}" : string3 + ", ........";
                            if (n > n7) {
                                string3 = string3 + "\n\t" + (n - n7) + " values not shown";
                            }
                            return string3;
                        }
                        string3 = "... Null Array (length 0) ...";
                        return string3;
                    }
                }
                string3 = " Array Size:" + n;
                return string3;
            }
            catch (DvAddressException dvAddressException) {
                return "\n !!!!! DvAddressException in DvClassCommands:interpretValue sig:" + string + "  where:" + Long.toHexString(l) + "  !!!!!\n";
            }
        }
        if (!bl2) {
            string2 = "Unable to interpret field (sig=" + string + ", where=" + l + ")";
        }
        return string2;
    }

    private Vector setupFiltersVector(String string) {
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (string2.startsWith("*") || string2.endsWith("*") || string2.startsWith("!")) {
                this.bWildCards = true;
            }
            DvUtils.writetoTrace("... adding Filter:" + string2);
            vector.add(string2);
        }
        return vector;
    }

    public static String[] classAddressList() {
        int n = theClasses.size();
        Vector vector = new Vector();
        if (0 == n) {
            that.getClasses(vector);
            n = theClasses.size();
        }
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            ClassDetails classDetails = (ClassDetails)theClasses.get(i);
            stringArray[i] = "0x" + Long.toHexString(classDetails.address);
        }
        return stringArray;
    }

    public static int[] getClassRefOfsets(String string, DvDump dvDump) {
        int n;
        Object object;
        int[] nArray = null;
        Vector vector = new Vector();
        boolean bl = false;
        boolean bl2 = false;
        String string2 = "";
        DvAddressSpace dvAddressSpace = (DvAddressSpace)DvUtils.getAPT(dvDump, "A");
        FieldInfo fieldInfo = null;
        if (0 == theClasses.size()) {
            object = new DvClassCommands();
            ((DvClassCommands)object).verb = "dis";
            ((DvClassCommands)object).verbModifier = "cls";
            ((DvClassCommands)object).displayCS();
        }
        if (null == (fieldInfo = (FieldInfo)fieldsHashByName.get(string)) && null != (object = (Integer)classHashByName.get(string.toUpperCase()))) {
            ClassDetails classDetails = (ClassDetails)theClasses.get((Integer)object);
            fieldInfo = DvClassCommands.showFields(classDetails, null, true, dvDump);
        }
        if (null != fieldInfo && (n = fieldInfo.referenceOffsets.size()) > 0) {
            nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = (Integer)fieldInfo.referenceOffsets.get(i);
            }
        }
        return nArray;
    }

    public static Vector getTheClassesVector() {
        return theClasses;
    }

    public void getClasses(Vector vector) {
        CommandPlugin commandPlugin = null;
        Method method = null;
        Vector vector2 = DvUtils.findMethodForCurrentSuffix("getClasses", new Class[]{Vector.class});
        if (vector2 != null) {
            commandPlugin = (CommandPlugin)vector2.get(0);
            method = (Method)vector2.get(1);
        }
        if (null != commandPlugin && null != method) {
            try {
                method.invoke((Object)commandPlugin, vector);
            }
            catch (Exception exception) {
                DvUtils.trace("*** Exception trying to find getClasses supporting " + DvUtils.getSuffix(), 0, true);
                String string = exception.toString();
                DvUtils.trace(string, 0, true);
            }
        } else {
            DvUtils.trace("*** Unable to find getClasses supporting " + DvUtils.getSuffix(), 0, true);
        }
    }

    public static String getInstanceValues(long l, String string, DvDump dvDump, Vector vector) {
        Vector vector2;
        String string2 = null;
        Long l2 = new Long(l);
        if (null == getInstanceValuesCp && (vector2 = DvUtils.findMethodForCurrentSuffix("getInstanceValues", new Class[]{Long.class, String.class, DvDump.class, Vector.class})) != null) {
            getInstanceValuesCp = (CommandPlugin)vector2.get(0);
            getInstanceValuesMethod = (Method)vector2.get(1);
        }
        if (null != getInstanceValuesCp && null != getInstanceValuesMethod) {
            try {
                string2 = (String)getInstanceValuesMethod.invoke((Object)getInstanceValuesCp, l2, string, dvDump, vector);
            }
            catch (Exception exception) {
                DvUtils.trace("*** Exception trying to find getInstanceValues supporting " + DvUtils.getSuffix(), 0, true);
                String string3 = exception.toString();
                DvUtils.trace(string3, 0, true);
            }
        } else {
            DvUtils.trace("*** Unable to find getInstanceValues supporting " + DvUtils.getSuffix(), 0, true);
        }
        return string2;
    }

    public static void showClass(ClassDetails classDetails, Vector vector, boolean bl, DvDump dvDump) {
        Vector vector2;
        Boolean bl2 = new Boolean(bl);
        if (null == showClassCp && (vector2 = DvUtils.findMethodForCurrentSuffix("showClass", new Class[]{ClassDetails.class, Vector.class, Boolean.class, DvDump.class})) != null) {
            showClassCp = (CommandPlugin)vector2.get(0);
            showClassMethod = (Method)vector2.get(1);
        }
        if (null != showClassCp && null != showClassMethod) {
            try {
                showClassMethod.invoke((Object)showClassCp, classDetails, vector, bl2, dvDump);
            }
            catch (Exception exception) {
                DvUtils.trace("*** Exception trying to find showClass supporting " + DvUtils.getSuffix(), 0, true);
                String string = exception.toString();
                DvUtils.trace(string, 0, true);
            }
        } else {
            DvUtils.trace("*** Unable to find showClass supporting " + DvUtils.getSuffix(), 0, true);
        }
    }

    public static FieldInfo showFields(ClassDetails classDetails, Vector vector, boolean bl, DvDump dvDump) {
        Vector vector2;
        FieldInfo fieldInfo = null;
        Boolean bl2 = new Boolean(bl);
        if (null == showFieldsCp && (vector2 = DvUtils.findMethodForCurrentSuffix("showFields", new Class[]{ClassDetails.class, Vector.class, Boolean.class, DvDump.class})) != null) {
            showFieldsCp = (CommandPlugin)vector2.get(0);
            showFieldsMethod = (Method)vector2.get(1);
        }
        if (null != showFieldsCp && null != showFieldsMethod) {
            try {
                fieldInfo = (FieldInfo)showFieldsMethod.invoke((Object)showFieldsCp, classDetails, vector, bl2, dvDump);
            }
            catch (Exception exception) {
                DvUtils.trace("*** Exception trying to find showFields supporting " + DvUtils.getSuffix(), 0, true);
                String string = exception.toString();
                DvUtils.trace(string, 0, true);
            }
        } else {
            DvUtils.trace("*** Unable to find showFields supporting " + DvUtils.getSuffix(), 0, true);
        }
        return fieldInfo;
    }

    public static void showMethods(ClassDetails classDetails, Vector vector, boolean bl) {
        Vector vector2;
        Boolean bl2 = new Boolean(bl);
        if (null == showMethodsCp && (vector2 = DvUtils.findMethodForCurrentSuffix("showMethods", new Class[]{ClassDetails.class, Vector.class, Boolean.class})) != null) {
            showMethodsCp = (CommandPlugin)vector2.get(0);
            showMethodsMethod = (Method)vector2.get(1);
        }
        if (null != showMethodsCp && null != showMethodsMethod) {
            try {
                showMethodsMethod.invoke((Object)showMethodsCp, classDetails, vector, bl2);
            }
            catch (Exception exception) {
                DvUtils.trace("*** Exception trying to find showMethods supporting " + DvUtils.getSuffix(), 0, true);
                String string = exception.toString();
                DvUtils.trace(string, 0, true);
            }
        } else {
            DvUtils.trace("*** Unable to find showMethods supporting " + DvUtils.getSuffix(), 0, true);
        }
    }

    public static void showStatics(ClassDetails classDetails, Vector vector, boolean bl) {
        Vector vector2;
        Boolean bl2 = new Boolean(bl);
        if (null == showStaticsCp && (vector2 = DvUtils.findMethodForCurrentSuffix("showStatics", new Class[]{ClassDetails.class, Vector.class, Boolean.class})) != null) {
            showStaticsCp = (CommandPlugin)vector2.get(0);
            showStaticsMethod = (Method)vector2.get(1);
        }
        if (null != showStaticsCp && null != showStaticsMethod) {
            try {
                showStaticsMethod.invoke((Object)showStaticsCp, classDetails, vector, bl2);
            }
            catch (Exception exception) {
                DvUtils.trace("*** Exception trying to find showStatics supporting " + DvUtils.getSuffix(), 0, true);
                String string = exception.toString();
                DvUtils.trace(string, 0, true);
            }
        } else {
            DvUtils.trace("*** Unable to find showStatics supporting " + DvUtils.getSuffix(), 0, true);
        }
    }

    static {
        prevVerb = null;
        prevModifier = null;
        prevParms = null;
        prevSeperator = null;
        theClasses = new Vector();
        classHashByAddr = new Hashtable();
        classHashByName = new Hashtable();
        fieldsHashByName = new Hashtable();
        theFields = new Vector();
        commandsSupported = new String[]{"DISPLAY,DIS,CLASSSUMMARY,CLS,displayCS,Y,N", "DISP,D,CLASSSUMMARY,CLS,displayCS,Y,N", "DISPLAY,DIS,CLASS,CL,displayClasses,Y,N", "DISP,D,CLASS,CL,displayClasses,Y,N", "DISPLAY,DIS,CLASS,C,displayClasses,Y,N", "DISP,D,CLASS,C,displayClasses,Y,N", "HELP,?,CLASS,CL,doClassHelp,N,N", "HELP,?,CLASSES,CLA,doClassHelp,N,N", "HELP,?,CLS,C,doClassHelp,N,N", "CL,CLS,?,?,doClassHelp,N,N", "CLASS,C,?,?,doClassHelp,N,N"};
    }

    static class FieldInfo {
        public Vector name = new Vector();
        public Vector signature = new Vector();
        public Vector offset = new Vector();
        public Vector access = new Vector();
        public Vector referenceOffsets = new Vector();

        FieldInfo() {
        }

        public void addField(String string, String string2, long l, short s) {
            this.name.add(string);
            this.signature.add(string2);
            if (string2.startsWith("[") || string2.startsWith("L")) {
                this.referenceOffsets.add(new Integer((int)l));
            }
            this.offset.add(new Long(l));
            this.access.add(new Short(s));
        }

        public String toString() {
            String string = "";
            int n = this.name.size();
            string = string + "Field count = " + n;
            for (int i = 0; i < n; ++i) {
                string = string + "\n name: " + (String)this.name.get(i);
                string = string + "\n signature: " + (String)this.signature.get(i);
                string = string + "\n offset: " + (Long)this.offset.get(i);
                string = string + "\n access: " + (Short)this.access.get(i);
            }
            return string;
        }
    }
}

