/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.plugins;

import com.ibm.jvm.dump.format.CTypeObject;
import com.ibm.jvm.dump.format.DvAddressSpace;
import com.ibm.jvm.dump.format.DvConsole;
import com.ibm.jvm.dump.format.DvDump;
import com.ibm.jvm.dump.format.DvDumpReader;
import com.ibm.jvm.dump.format.DvJavaFrame;
import com.ibm.jvm.dump.format.DvLoaded;
import com.ibm.jvm.dump.format.DvModule;
import com.ibm.jvm.dump.format.DvNativeFrame;
import com.ibm.jvm.dump.format.DvProcess;
import com.ibm.jvm.dump.format.DvThread;
import com.ibm.jvm.dump.format.DvUtils;
import com.ibm.jvm.dump.frame.FrameTraverser;
import com.ibm.jvm.dump.frame.JavaFrame;
import com.ibm.jvm.dump.frame.LoadMap;
import com.ibm.jvm.dump.frame.NativeFrame;
import com.ibm.jvm.dump.frame.ThreadContext;
import com.ibm.jvm.dump.plugins.CommandPlugin;
import com.ibm.jvm.dump.plugins.DumpContext;
import java.io.File;
import java.lang.reflect.Method;
import java.util.StringTokenizer;
import java.util.Vector;

public class DvXeCommands
extends CommandPlugin {
    private static CommandPlugin showJavaFrameDetailsCP = null;
    private static Method showJavaFrameDetailsMethod = null;
    private static CommandPlugin findAvlTreeRootCP = null;
    private static Method findAvlTreeRootMethod = null;
    private static CommandPlugin displayCCCP = null;
    private static Method displayCCMethod = null;
    private static String thisName = "com.ibm.jvm.dump.plugins.DvXeCommands";
    private static Vector theOutput = new Vector();
    private static String[] commandsSupported = new String[]{"DISPLAY,DIS,JAVASTACK,js,displayJavaStack", "DISPLAY,DIS,NATIVESTACK,ns,displayNativeStack", "DISPLAY,DIS,JITMETHODS,jitm,displayJitMethods", "FRAME,FR,JAVA,js,runJavaFrameTraverser", "FRAME,FR,NATIVE,ns,runNativeFrameTraverser", "DISPLAY,dis,INSTR,ins,disassemble", "DISP,D,JAVASTACK,js,displayJavaStack", "DISP,D,NATIVESTACK,ns,displayNativeStack", "DISP,D,JITMETHODS,jitm,displayJitMethods", "FRAME,FR,JAVA,j,runJavaFrameTraverser", "FRAME,FR,NATIVE,n,runNativeFrameTraverser", "DISP,d,INSTR,ins,disassemble", "HELP,?,ns,js,doXeHelp,N,N", "HELP,?,Frame,ins,doXeHelp,N,N", "HELP,?,xe,jitm,doXeHelp,N,N", "ns,disns,?,help,doXeHelp,N,N", "js,disjs,?,help,doXeHelp,N,N", "jitm,disjitm,?,help,doXeHelp,N,N", "frame,fr,?,help,doXeHelp,N,N", "ins,ins,?,help,doXeHelp,N,N"};
    public static DvXeCommands selfRef;
    private static DvAddressSpace as;
    protected static Vector filter;
    protected static boolean showDetail;
    static FrameTraverser frameTraverser;

    public DvXeCommands() {
        selfRef = this;
    }

    public String[] getSyntax() {
        return commandsSupported;
    }

    public String pluginName() {
        return "XE commands Plugin";
    }

    public static Object getGenericHelp() {
        Vector vector = DvUtils.getMultiplePropertyValues("GeneralHelp", "DvXeCommands.properties");
        return vector;
    }

    public void doXeHelp() {
        Vector vector = DvUtils.getMultiplePropertyValues("XEHelp", "DvXeCommands.properties");
        this.cpr.output(vector);
        this.forcedEnd = true;
    }

    public String help() {
        return null;
    }

    public void displayJavaStack() {
        Vector vector = new Vector();
        DvDump dvDump = DvConsole.theDump;
        DvAddressSpace[] dvAddressSpaceArray = dvDump.getAddressSpaces();
        Vector vector2 = this.parseParams(this.paramString, true);
        if (this.paramString == null) {
            DvThread dvThread = (DvThread)DvUtils.getAPT(dvDump, "T");
            this.showJavaStack(dvThread, vector);
        } else {
            for (int i = 0; i < dvAddressSpaceArray.length; ++i) {
                DvProcess[] dvProcessArray = dvAddressSpaceArray[i].getProcesses();
                for (int j = 0; j < dvProcessArray.length; ++j) {
                    DvThread[] dvThreadArray = dvProcessArray[j].getThreads();
                    for (int k = 0; k < dvThreadArray.length; ++k) {
                        if (!DvUtils.filtrate(dvThreadArray[k].id(), vector2)) continue;
                        this.showJavaStack(dvThreadArray[k], vector);
                    }
                }
            }
        }
        this.cpr.output(vector);
        this.forcedEnd = true;
    }

    private void showJavaStack(DvThread dvThread, Vector vector) {
        DvDump dvDump = DvConsole.theDump;
        if (dvDump != null && dvThread != null && dvThread.getJavaStack() != null) {
            DvAddressSpace dvAddressSpace = (DvAddressSpace)DvUtils.getAPT(dvDump, "A");
            vector.add("\n Java stack for thread " + dvThread.id() + " - " + dvThread.getThreadName(dvAddressSpace) + "\n ==========================\n");
            int n = 0;
            while ((long)n < dvThread.getJavaStack().getNumFrames()) {
                if (!dvThread.getJavaStack().getFrame(n).isPseudo()) {
                    vector.add("\tat " + dvThread.getJavaStack().getFrame(n).getName());
                    this.showJavaFrameDetails(vector, dvAddressSpace, dvThread.getJavaStack().getFrame(n));
                }
                ++n;
            }
        } else {
            vector.add("No java stack.");
        }
    }

    public void displayNativeStack() {
        Vector vector = new Vector();
        DvDump dvDump = DvConsole.theDump;
        DvAddressSpace[] dvAddressSpaceArray = dvDump.getAddressSpaces();
        Vector vector2 = this.parseParams(this.paramString, true);
        if (this.paramString == null) {
            DvThread dvThread = (DvThread)DvUtils.getAPT(dvDump, "T");
            this.showNativeStack(dvThread, vector);
        } else {
            for (int i = 0; i < dvAddressSpaceArray.length; ++i) {
                DvProcess[] dvProcessArray = dvAddressSpaceArray[i].getProcesses();
                for (int j = 0; j < dvProcessArray.length; ++j) {
                    DvThread[] dvThreadArray = dvProcessArray[j].getThreads();
                    for (int k = 0; k < dvThreadArray.length; ++k) {
                        if (!DvUtils.filtrate(dvThreadArray[k].id(), vector2)) continue;
                        this.showNativeStack(dvThreadArray[k], vector);
                    }
                }
            }
        }
        this.cpr.output(vector);
        this.forcedEnd = true;
    }

    private void showNativeStack(DvThread dvThread, Vector vector) {
        DvDump dvDump = DvConsole.theDump;
        if (dvDump != null && dvThread != null && dvThread.getNativeStack() != null) {
            DvAddressSpace dvAddressSpace = (DvAddressSpace)DvUtils.getAPT(dvDump, "A");
            vector.add("\n Native stack for thread " + dvThread.id() + " - " + dvThread.getThreadName(dvAddressSpace) + "\n ============================\n");
            int n = 0;
            while ((long)n < dvThread.getNativeStack().getNumFrames()) {
                DvNativeFrame dvNativeFrame = dvThread.getNativeStack().getFrame(n);
                if (dvAddressSpace.pointerSize() == 4) {
                    vector.add("\tat 0x" + Integer.toHexString((int)dvNativeFrame.getPc()) + " in " + dvNativeFrame.getName());
                } else {
                    vector.add("\tat 0x" + Long.toHexString(dvNativeFrame.getPc()) + " in " + dvNativeFrame.getName());
                }
                this.showNativeFrameDetails(vector, dvAddressSpace, dvNativeFrame);
                ++n;
            }
        } else {
            vector.add("Native stack not available.");
        }
    }

    private void showJavaFrameDetails(Vector vector, DvAddressSpace dvAddressSpace, DvJavaFrame dvJavaFrame) {
        Vector vector2;
        if (null == showJavaFrameDetailsCP && null != (vector2 = DvUtils.findMethodForCurrentSuffix("showJavaFrameDetails", new Class[]{Vector.class, DvAddressSpace.class, DvJavaFrame.class})) && vector2.size() == 2) {
            showJavaFrameDetailsCP = (CommandPlugin)vector2.get(0);
            showJavaFrameDetailsMethod = (Method)vector2.get(1);
        }
        if (null != showJavaFrameDetailsCP) {
            try {
                showJavaFrameDetailsMethod.invoke((Object)showJavaFrameDetailsCP, vector, dvAddressSpace, dvJavaFrame);
            }
            catch (Exception exception) {
                DvUtils.trace("*** Exception trying to utilise \" showJavaFrameDetails \" supporting " + DvUtils.getSuffix(), 0, true);
                String string = exception.toString();
                DvUtils.trace(string, 0, true);
            }
        } else {
            DvUtils.trace("*** Error trying to find \" +showJavaFrameDetails \" supporting " + DvUtils.getSuffix(), 0, true);
        }
    }

    private void showNativeFrameDetails(Vector vector, DvAddressSpace dvAddressSpace, DvNativeFrame dvNativeFrame) {
        if (!showDetail || dvNativeFrame.getSp() == 0L) {
            return;
        }
        if (dvAddressSpace.pointerSize() == 4) {
            vector.add("\t\tstackpointer = 0x" + Integer.toHexString((int)dvNativeFrame.getSp()));
        } else {
            vector.add("\t\tstackpointer = 0x" + Long.toHexString(dvNativeFrame.getSp()));
        }
    }

    private CTypeObject findAvlTreeRoot(DvAddressSpace dvAddressSpace, DvDump dvDump) {
        Vector vector;
        CTypeObject cTypeObject = null;
        if (null == findAvlTreeRootCP && null != (vector = DvUtils.findMethodForCurrentSuffix("findAvlTreeRoot", new Class[]{DvAddressSpace.class, DvDump.class})) && vector.size() == 2) {
            findAvlTreeRootCP = (CommandPlugin)vector.get(0);
            findAvlTreeRootMethod = (Method)vector.get(1);
        }
        if (null != findAvlTreeRootCP) {
            try {
                cTypeObject = (CTypeObject)findAvlTreeRootMethod.invoke((Object)findAvlTreeRootCP, dvAddressSpace, dvDump);
            }
            catch (Exception exception) {
                DvUtils.trace("*** Exception trying to utilise \" findAvlTreeRoot \" supporting " + DvUtils.getSuffix(), 0, true);
                String string = exception.toString();
                DvUtils.trace(string, 0, true);
            }
        } else {
            DvUtils.trace("*** Error trying to find \" +findAvlTreeRoot \" supporting " + DvUtils.getSuffix(), 0, true);
        }
        return cTypeObject;
    }

    public void displayJitMethods() {
        Vector<String> vector = new Vector<String>();
        DvDump dvDump = DvConsole.theDump;
        filter = this.parseParams(this.paramString, false);
        try {
            DvAddressSpace dvAddressSpace = (DvAddressSpace)DvUtils.getAPT(dvDump, "A");
            CTypeObject cTypeObject = this.findAvlTreeRoot(dvAddressSpace, dvDump);
            if (null == cTypeObject) {
                vector.add("No jitted methods.");
            } else {
                this.displayCC(cTypeObject, dvAddressSpace, vector);
            }
        }
        catch (Exception exception) {
            vector.add("No jitted methods.");
        }
        this.cpr.output(vector);
        this.forcedEnd = true;
    }

    private void displayCC(CTypeObject cTypeObject, DvAddressSpace dvAddressSpace, Vector vector) {
        Vector vector2;
        if (null == displayCCCP && null != (vector2 = DvUtils.findMethodForCurrentSuffix("displayCC", new Class[]{CTypeObject.class, DvAddressSpace.class, Vector.class})) && vector2.size() == 2) {
            displayCCCP = (CommandPlugin)vector2.get(0);
            displayCCMethod = (Method)vector2.get(1);
        }
        if (null != findAvlTreeRootCP) {
            try {
                displayCCMethod.invoke((Object)findAvlTreeRootCP, cTypeObject, dvAddressSpace, vector);
            }
            catch (Exception exception) {
                DvUtils.trace("*** Exception trying to utilise \" displayCC \" supporting " + DvUtils.getSuffix(), 0, true);
                String string = exception.toString();
                DvUtils.trace(string, 0, true);
            }
        } else {
            DvUtils.trace("*** Error trying to find \" +displayCC \" supporting " + DvUtils.getSuffix(), 0, true);
        }
    }

    private Vector parseParams(String string, boolean bl) {
        filter = new Vector();
        if (string != null && string.startsWith("-detail")) {
            showDetail = true;
            string = string.substring(7, string.length());
        }
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken().trim();
                filter.add(string2);
            }
        }
        if (filter.size() == 0) {
            if (bl) {
                filter.add(((DvThread)DvUtils.getAPT(DvConsole.theDump, "T")).id());
            } else {
                filter.add("*");
            }
        }
        return filter;
    }

    public String[] guiPopupSyntax() {
        return null;
    }

    public void runJavaFrameTraverser() {
        this.runFrameTraverser("java");
    }

    public void runNativeFrameTraverser() {
        this.runFrameTraverser("native");
    }

    private void runFrameTraverser(String string) {
        Vector<String> vector = new Vector<String>();
        if (this.paramString != null && this.paramString.startsWith("context=")) {
            String string2 = this.paramString.substring(8, this.paramString.length());
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            if (stringTokenizer.countTokens() != 5) {
                vector.add("Usage: frame " + string + " context=ee,pc,lr,sp,bp");
            } else {
                long l = DvUtils.hexToLong(stringTokenizer.nextToken());
                long l2 = DvUtils.hexToLong(stringTokenizer.nextToken());
                long l3 = DvUtils.hexToLong(stringTokenizer.nextToken());
                long l4 = DvUtils.hexToLong(stringTokenizer.nextToken());
                long l5 = DvUtils.hexToLong(stringTokenizer.nextToken());
                ThreadContext threadContext = new ThreadContext(l, l2, l3, l4, l5);
                this.runFrameTraverser(string, "user", null, threadContext, vector);
            }
        } else {
            this.runFrameTraverser(string, "hpi", vector);
            this.runFrameTraverser(string, "dump", vector);
        }
        this.cpr.output(vector);
        this.forcedEnd = true;
    }

    private void runFrameTraverser(String string, String string2, Vector vector) {
        DvDump dvDump = DvConsole.theDump;
        DvAddressSpace[] dvAddressSpaceArray = dvDump.getAddressSpaces();
        Vector vector2 = this.parseParams(this.paramString, true);
        if (this.paramString == null) {
            DvThread dvThread = (DvThread)DvUtils.getAPT(dvDump, "T");
            this.runFrameTraverser(string, string2, dvThread, null, vector);
        } else {
            for (int i = 0; i < dvAddressSpaceArray.length; ++i) {
                DvProcess[] dvProcessArray = dvAddressSpaceArray[i].getProcesses();
                for (int j = 0; j < dvProcessArray.length; ++j) {
                    DvThread[] dvThreadArray = dvProcessArray[j].getThreads();
                    for (int k = 0; k < dvThreadArray.length; ++k) {
                        if (!DvUtils.filtrate(dvThreadArray[k].id(), vector2)) continue;
                        this.runFrameTraverser(string, string2, dvThreadArray[k], null, vector);
                    }
                }
            }
        }
    }

    private LoadMap[] getLoadMaps(DvAddressSpace dvAddressSpace) {
        DvProcess[] dvProcessArray = dvAddressSpace.getProcesses();
        int n = 0;
        int n2 = 0;
        LoadMap[] loadMapArray = null;
        for (int i = 0; i < dvProcessArray.length; ++i) {
            DvLoaded dvLoaded = null;
            try {
                LoadMap[] loadMapArray2;
                DvModule[] dvModuleArray;
                dvLoaded = dvProcessArray[i].getLoaded();
                if (dvLoaded == null || (dvModuleArray = dvLoaded.getModules()) == null) continue;
                loadMapArray = loadMapArray2 = new LoadMap[n2 + dvModuleArray.length];
                n2 += dvModuleArray.length;
                int n3 = 0;
                while (n3 < dvModuleArray.length) {
                    loadMapArray[n] = new LoadMap(dvModuleArray[n3].name(), dvModuleArray[n3].address().getAddressAsLong(), dvModuleArray[n3].size());
                    ++n3;
                    ++n;
                }
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return loadMapArray;
    }

    private void setupFrameTraverser() {
        if (frameTraverser == null) {
            DvDump dvDump = DvConsole.theDump;
            DvAddressSpace dvAddressSpace = (DvAddressSpace)DvUtils.getAPT(dvDump, "A");
            DvDumpReader dvDumpReader = new DvDumpReader(dvAddressSpace);
            LoadMap[] loadMapArray = this.getLoadMaps(dvAddressSpace);
            File file = DumpContext.getJvmMapFile(loadMapArray);
            String string = file == null ? null : file.getPath();
            frameTraverser = new FrameTraverser(dvDumpReader, dvDump.getRas().jvmRas, loadMapArray, null, string);
            if (file != null) {
                file.delete();
            }
        }
    }

    private ThreadContext getContext(String string, DvThread dvThread, DvAddressSpace dvAddressSpace) {
        Object var4_4 = null;
        if (string.equals("hpi")) {
            return DumpContext.getHpiContext(dvThread, dvAddressSpace);
        }
        if (string.equals("dump")) {
            return DumpContext.getDumpContext(dvThread);
        }
        if (string.equals("null")) {
            return new ThreadContext(dvThread.eeAddress().getAddressAsLong(), 0L, 0L, 0L, 0L);
        }
        return null;
    }

    private Object runFrameTraverser(String string, String string2, DvDump dvDump, ThreadContext threadContext) {
        this.setupFrameTraverser();
        if (string.equals("java")) {
            return frameTraverser.getJavaFrames(threadContext);
        }
        if (string.equals("native")) {
            return frameTraverser.getNativeFrames(threadContext);
        }
        return null;
    }

    private void runFrameTraverser(String string, String string2, DvThread dvThread, ThreadContext threadContext, Vector vector) {
        DvDump dvDump = DvConsole.theDump;
        if (dvDump == null || dvThread == null && threadContext == null) {
            vector.add("No stack.");
            return;
        }
        DvAddressSpace dvAddressSpace = (DvAddressSpace)DvUtils.getAPT(dvDump, "A");
        if (threadContext == null) {
            threadContext = this.getContext(string2, dvThread, dvAddressSpace);
        }
        if (threadContext == null) {
            return;
        }
        String string3 = threadContext.getSp() == 0L && threadContext.getPc() == 0L ? "" : (string2.equals("dump") ? "  (Context obtained from dump)" : (string2.equals("hpi") ? "  (Context obtained from HPI)" : (string2.equals("user") ? "  (Context provided by user)" : "")));
        if (string.equals("java")) {
            if (dvThread != null) {
                vector.add("\n Java stack for thread " + dvThread.id() + " - " + dvThread.getThreadName(dvAddressSpace) + string3 + "\n ==========================\n");
            } else {
                vector.add("\n Java stack for given context\n ===========================\n");
            }
            JavaFrame[] javaFrameArray = (JavaFrame[])this.runFrameTraverser(string, string2, dvDump, threadContext);
            for (int i = 0; javaFrameArray != null && i < javaFrameArray.length; ++i) {
                if (javaFrameArray[i].isPseudo()) continue;
                vector.add("\tat " + javaFrameArray[i].getName());
                this.showJavaFrameDetails(vector, dvAddressSpace, new DvJavaFrame(javaFrameArray[i]));
            }
        } else if (string.equals("native")) {
            if (dvThread != null) {
                vector.add("\n Native stack for thread " + dvThread.id() + " - " + dvThread.getThreadName(dvAddressSpace) + string3 + "\n ============================\n");
            } else {
                vector.add("\n Native stack for given context\n ===========================\n");
            }
            NativeFrame[] nativeFrameArray = (NativeFrame[])this.runFrameTraverser("native", string2, dvDump, threadContext);
            for (int i = 0; nativeFrameArray != null && i < nativeFrameArray.length; ++i) {
                NativeFrame nativeFrame = nativeFrameArray[i];
                if (dvAddressSpace.pointerSize() == 4) {
                    vector.add("\tat 0x" + Integer.toHexString((int)nativeFrame.getPc()) + " in " + nativeFrame.getName());
                } else {
                    vector.add("\tat 0x" + Long.toHexString(nativeFrame.getPc()) + " in " + nativeFrame.getName());
                }
                this.showNativeFrameDetails(vector, dvAddressSpace, new DvNativeFrame(nativeFrame));
            }
        } else {
            vector.add("Illegal frame traverser type");
        }
    }

    public void disassemble() {
        Vector<String> vector = new Vector<String>();
        String string = null;
        String string2 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(this.paramString, ",");
        if (stringTokenizer.countTokens() > 2 || stringTokenizer.countTokens() <= 0) {
            vector.add("Incorrect command format. Use dis instr start [,end]");
            this.cpr.output(vector);
            this.forcedEnd = true;
            return;
        }
        string = stringTokenizer.nextToken();
        if (stringTokenizer.countTokens() == 1) {
            string2 = stringTokenizer.nextToken();
        }
        try {
            long l = DvUtils.hexToLong(string);
            long l2 = 0L;
            if (string2 != null) {
                l2 = DvUtils.hexToLong(string2);
            }
            this.setupFrameTraverser();
            vector.add(frameTraverser.getDisassembly(l, l2));
        }
        catch (Exception exception) {
            vector.add("No disassembly");
        }
        this.cpr.output(vector);
        this.forcedEnd = true;
    }
}

